/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.Ec1LineUpdate;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds1.Ds1PmPane;
import cerent.cms.ui.ds1e1.Ds1E1PmPane;
import cerent.cms.ui.ds3e.Ds3ePerformancePane;
import cerent.cms.ui.e13.E13PmPane;
import cerent.cms.ui.ec1.Ec1PmPane;
import cerent.cms.ui.sonet.TdmPmPane;
import cerent.util.SDebug;
import java.awt.Component;

public class ComboCardPmPane
extends AbstractSubTabbedPane
implements ITabName {
    protected Ds123LineModel[] ds3Lines;
    protected TdmLineModel[] ec1Lines;
    protected TdmLineModel[] ocnLines;
    protected Ds123LineModel[] e3Lines;
    protected Ds123LineModel[] ds1Lines;
    protected Ds123LineModel[] e1Lines;
    protected static final int HAS_DS1 = 1;
    protected static final int HAS_DS3 = 2;
    protected static final int HAS_EC1 = 3;
    protected static final int HAS_OCN = 4;
    protected static final int HAS_E1 = 5;
    protected static final int HAS_E3 = 6;
    protected int myIfs;
    private static final SDebug dbg = new SDebug("ComboCardPmPane");

    public ComboCardPmPane(String string, CardTabbedView cardTabbedView, TdmLineModel[] tdmLineModelArray) {
        this(string, cardTabbedView, null, null, null, tdmLineModelArray, null, null);
    }

    public ComboCardPmPane(String string, CardTabbedView cardTabbedView, Ds123LineModel[] ds123LineModelArray, Ds123LineModel[] ds123LineModelArray2, TdmLineModel[] tdmLineModelArray) {
        this(string, cardTabbedView, ds123LineModelArray, ds123LineModelArray2, tdmLineModelArray, null, null, null);
    }

    public ComboCardPmPane(String string, CardTabbedView cardTabbedView, Ds123LineModel[] ds123LineModelArray, Ds123LineModel[] ds123LineModelArray2, Ds123LineModel[] ds123LineModelArray3) {
        this(string, cardTabbedView, null, ds123LineModelArray3, null, null, ds123LineModelArray, ds123LineModelArray2);
        this.myIfs = 100;
    }

    public ComboCardPmPane(String string, CardTabbedView cardTabbedView, Ds123LineModel[] ds123LineModelArray, TdmLineModel[] tdmLineModelArray) {
        this(string, cardTabbedView, null, ds123LineModelArray, tdmLineModelArray, null, null, null);
    }

    public ComboCardPmPane(String string, CardTabbedView cardTabbedView, Ds123LineModel[] ds123LineModelArray, Ds123LineModel[] ds123LineModelArray2, TdmLineModel[] tdmLineModelArray, TdmLineModel[] tdmLineModelArray2) {
        this(string, cardTabbedView, ds123LineModelArray, ds123LineModelArray2, tdmLineModelArray, tdmLineModelArray2, null, null);
    }

    public ComboCardPmPane(String string, CardTabbedView cardTabbedView, Ds123LineModel[] ds123LineModelArray, Ds123LineModel[] ds123LineModelArray2, TdmLineModel[] tdmLineModelArray, TdmLineModel[] tdmLineModelArray2, Ds123LineModel[] ds123LineModelArray3, Ds123LineModel[] ds123LineModelArray4) {
        super(string, cardTabbedView);
        this.ds1Lines = ds123LineModelArray;
        this.ds3Lines = ds123LineModelArray2;
        this.ec1Lines = tdmLineModelArray;
        this.ocnLines = tdmLineModelArray2;
        this.e1Lines = ds123LineModelArray3;
        this.e3Lines = ds123LineModelArray4;
        if (ds123LineModelArray != null) {
            this.myIfs |= 2;
        }
        if (ds123LineModelArray2 != null) {
            this.myIfs |= 4;
        }
        if (tdmLineModelArray != null) {
            this.myIfs |= 8;
        }
        if (tdmLineModelArray2 != null) {
            this.myIfs |= 0x10;
        }
        if (ds123LineModelArray3 != null) {
            this.myIfs |= 0x20;
        }
        if (ds123LineModelArray4 != null) {
            this.myIfs |= 0x40;
        }
        this.registerWithModel();
    }

    protected void createSubTabs() {
        if (dbg.on()) {
            dbg.info("Creating SubTabs");
        }
        ModuleModel moduleModel = (ModuleModel)this.getUiModel();
        if (this.hasDS1()) {
            this.subTabs.addTab("DS1", (Component)this.getDs1Tab(this.subTabs, moduleModel, this.ds1Lines));
        }
        if (this.hasE1()) {
            this.subTabs.addTab("E1", (Component)this.getE1Tab(this.subTabs, moduleModel, this.e1Lines));
        }
        if (this.hasE3()) {
            this.subTabs.addTab("E3", (Component)this.getE3Tab(this.subTabs, moduleModel, this.e3Lines));
        }
        if (this.hasDS3()) {
            String string;
            block14: {
                string = "DS3/E3";
                boolean bl = true;
                try {
                    bl = moduleModel.getNodeModelDelegate().getTdmProtocolTypeObj().isSonet();
                    if (bl) {
                        string = "DS3";
                    } else {
                        switch (moduleModel.getEqType()) {
                            case 233: 
                            case 234: {
                                string = "DS3";
                                break;
                            }
                            default: {
                                string = "E3";
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    dbg.println("Could not determine terminology for ComboCardPmPane!");
                    if (!dbg.on()) break block14;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            this.subTabs.addTab(string, (Component)this.getDs3Tab(this.subTabs, moduleModel, this.ds3Lines));
        }
        if (this.hasEC1()) {
            this.subTabs.addTab("EC1", (Component)this.getEc1Tab(this.subTabs, moduleModel, this.ec1Lines));
        }
        if (this.hasOCN()) {
            this.subTabs.addTab("Optical", (Component)this.getOpticalTab(this.subTabs, moduleModel, this.ocnLines));
        }
    }

    private Pane getDs1Tab(TabbedView tabbedView, ModuleModel moduleModel, Ds123LineModel[] ds123LineModelArray) {
        AbstractPane abstractPane = null;
        switch (moduleModel.getEqType()) {
            case 233: 
            case 234: {
                abstractPane = new Ds1E1PmPane("DS1", tabbedView, ds123LineModelArray);
                break;
            }
            default: {
                abstractPane = new Ds1PmPane("DS1", tabbedView, ds123LineModelArray);
            }
        }
        return new ProtCardDualPane(tabbedView, moduleModel, abstractPane);
    }

    private Pane getDs3Tab(TabbedView tabbedView, ModuleModel moduleModel, Ds123LineModel[] ds123LineModelArray) {
        return new ProtCardDualPane(tabbedView, moduleModel, new Ds3ePerformancePane("DS3", tabbedView, ds123LineModelArray));
    }

    private Pane getE3Tab(TabbedView tabbedView, ModuleModel moduleModel, Ds123LineModel[] ds123LineModelArray) {
        return new ProtCardDualPane(tabbedView, moduleModel, new E13PmPane("DS3", tabbedView, ds123LineModelArray));
    }

    private Pane getE1Tab(TabbedView tabbedView, ModuleModel moduleModel, Ds123LineModel[] ds123LineModelArray) {
        return new ProtCardDualPane(tabbedView, moduleModel, new E13PmPane("DS3", tabbedView, ds123LineModelArray));
    }

    private Pane getEc1Tab(TabbedView tabbedView, ModuleModel moduleModel, TdmLineModel[] tdmLineModelArray) {
        return new ProtCardDualPane(tabbedView, moduleModel, new Ec1PmPane("EC1", tabbedView, tdmLineModelArray));
    }

    private Pane getOpticalTab(TabbedView tabbedView, ModuleModel moduleModel, TdmLineModel[] tdmLineModelArray) {
        return new TdmPmPane("Optical", tabbedView, tdmLineModelArray);
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof Ds3LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received Ds3LineUpdate..");
            }
            this.ds3Lines = (Ds123LineModel[])((Ds3LineUpdate)object).getModels();
        } else if (object instanceof Ec1LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received Ec1LineUpdate...");
            }
            this.ec1Lines = (TdmLineModel[])((Ec1LineUpdate)object).getModels();
        } else if (object instanceof OcnLineUpdate) {
            if (dbg.on()) {
                dbg.info("Received OcnLineUpdate...");
            }
            this.ocnLines = (TdmLineModel[])((OcnLineUpdate)object).getModels();
        } else if (dbg.on()) {
            dbg.println("refreshMyLines received " + object);
        }
    }

    private boolean hasIf(int n) {
        return (this.myIfs & 1 << n) != 0;
    }

    protected boolean hasDS1() {
        return this.hasIf(1);
    }

    protected boolean hasE1() {
        return this.hasIf(5);
    }

    protected boolean hasE3() {
        return this.hasIf(6);
    }

    protected boolean hasDS3() {
        return this.hasIf(2);
    }

    protected boolean hasEC1() {
        return this.hasIf(3);
    }

    protected boolean hasOCN() {
        return this.hasIf(4);
    }
}

