/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISecurityModel;
import cerent.cms.model.SlotModel;
import cerent.cms.ui.AbstractInvalidViewException;
import cerent.cms.ui.AbstractProvPane;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.CardViewController;
import cerent.cms.ui.DefaultViewControllerLayout;
import cerent.cms.ui.EleViewController;
import cerent.cms.ui.FunctionalViewButton;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.IViewController;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.event.ShelfEventPanelController;
import cerent.cms.ui.functional.FunctionalEditDialog;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardPanel;
import cerent.cms.ui.shelf.ShelfTabbedView;
import cerent.cms.ui.shelf.ShelfViewPanel;
import cerent.cms.ui.shelf.ShelfVitalStatsPane;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ShelfViewController
extends EleViewController {
    private AbstractShelfLayout ssl = null;
    private static final SDebug db = new SDebug("SVC");

    public ShelfViewController(IViewController iViewController, IChassisModel iChassisModel, IUiToolkit iUiToolkit, boolean bl) {
        super(iViewController, new ViewName(new int[]{iChassisModel.getNodeModel().getNodeId(), bl ? iChassisModel.getShelfId(bl) : 0}), iUiToolkit, db, iChassisModel.getNodeModelDelegate(), bl, iChassisModel);
        db.fine("<init> " + this.getViewName());
        iChassisModel.addObserver(this);
        this.nmd.addObserver(this);
        this.cn = this.nmd.getConnectionNotifier();
        this.cn.addObserver((Observer)this);
        ISecurityModel iSecurityModel = this.nmd.getSecurityModel();
        iSecurityModel.addObserver((Observer)this);
    }

    protected ViewName localGetSelectedView(ViewName viewName) {
        CardPanel cardPanel = this.ssl.getSelectedCard();
        db.fine("localGetSelectedView destView is " + viewName + " (selected card is " + cardPanel + ")");
        if (cardPanel != null) {
            EntityModel entityModel = cardPanel.getEntityModel();
            int n = entityModel.getEqType();
            if (entityModel != null && n != 2 && n != 48 && n != 3 && n != 43) {
                ViewName viewName2 = new ViewName(new int[]{this.nmd.getNodeId(), this.viewName.getShelfId(), entityModel.getPositionInParent()});
                db.fine("\t\tReturning " + viewName2);
                return viewName2;
            }
        }
        return null;
    }

    protected void localDispose() {
        db.fine(this.getViewName() + " localDispose");
        if (this.sv != null) {
            this.sv.remove(this.ssl);
        }
        this.releaseShelfLayout();
        super.localDispose();
    }

    protected void localDestroy() {
        try {
            ISecurityModel iSecurityModel;
            if (this.chassis != null) {
                this.chassis.deleteObserver(this);
            }
            if (this.nmd != null && (iSecurityModel = this.nmd.getSecurityModel()) != null) {
                iSecurityModel.deleteObserver((Observer)this);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        super.localDestroy();
    }

    protected JPanel createPanel(ViewName viewName) throws AbstractInvalidViewException {
        db.fine("createPanel destView is " + viewName);
        try {
            this.getShelfLayout();
            this.sv = new ShelfViewPanel(this);
            this.fvButton = FunctionalViewButton.getInstance((INodeModel)this.nmd);
            if (this.fvButton != null) {
                this.fvButton.initFvButton((ActionListener)((ShelfViewPanel)this.sv));
                FunctionalEditDialog.storeButton(this.nmd.getNodeModel().getName(), this.fvButton);
            }
            if (this.stv == null) {
                this.stv = new ShelfTabbedView(this.chassis, new ShelfEventPanelController(this), (IGuestPaneFactory)this.uiToolkit);
                this.stv.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
            }
            this.nvsp = new ShelfVitalStatsPane(this.chassis);
            this.sv.add(this.ssl);
            JPanel jPanel = new JPanel();
            this.svcl = new DefaultViewControllerLayout(jPanel, "shelf");
            this.svcl.setComponents((JComponent)new UScrollPane((Component)this.sv), (JComponent)((Object)this.stv), this.nvsp, this.uiToolkit.getGuestPane(13));
            return jPanel;
        }
        catch (Exception exception) {
            db.fine("createPanel failed: " + exception);
            SDebug.printStackTrace((Throwable)exception);
            this.localFlushViewPanel(null);
            this.throwInvalidViewException(exception.getMessage(), 1);
            return null;
        }
    }

    private AbstractShelfLayout getShelfLayout() throws Exception {
        if (!this.nmd.isInited() || !this.nmd.getConnectionState()) {
            db.println("NMD.isInited( ) -> " + this.nmd.isInited() + "\n\tNMD.getConnectionState( ) -> " + this.nmd.getConnectionState());
            throw new Exception("The node is disconnected.");
        }
        if (this.ssl == null) {
            this.ssl = this.chassis.getPlatform().getShelfLayout(this.chassis, this);
        }
        return this.ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseShelfLayout() {
        if (this.ssl != null) {
            db.fine(this.getViewName() + " releaseShelfLayout");
            if (this.svcl != null) {
                this.svcl.dispose();
            }
            try {
                this.ssl.destroy();
            }
            finally {
                this.ssl = null;
            }
        }
    }

    public AbstractViewController createChildContainerVC(ViewName viewName) throws AbstractInvalidViewException {
        int n = viewName.getSlotId();
        db.fine("Creating CVC for slot " + n);
        if (!this.nmd.isInited()) {
            this.throwInvalidViewException("The node is not ready yet for the view " + viewName + ".", 1);
        }
        List list = ((EntityModel)((Object)this.chassis)).getChildrenOfType(eClass.BACKPLANE);
        EntityModel entityModel = (EntityModel)list.get(0);
        List list2 = entityModel.getChildren();
        try {
            EntityModel entityModel2 = (EntityModel)list2.get(n - 1);
            if (entityModel2 == null) {
                this.throwInvalidViewException("The NodeModel for " + viewName + " cannot be found.", 1);
            }
            CardViewController cardViewController = new CardViewController(this, this.chassis, this.uiToolkit, this.viewName.getNodeId(), this.viewName.getShelfId(), n, this.isMultishelf);
            return cardViewController;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.throwInvalidViewException("The slot for " + viewName + " is invalid.", 3);
            return null;
        }
    }

    protected void checkForInvalidView(ViewName viewName) throws AbstractInvalidViewException {
        int n = viewName.getSlotId();
        if (n != 0) {
            block5: {
                EntityTableModel entityTableModel = this.nmd.getEntityTableModel();
                if (entityTableModel != null) {
                    try {
                        EntityModel entityModel = (EntityModel)entityTableModel.getEntityModelBySlot(this.chassis, n);
                        if (entityModel != null && entityModel instanceof SlotModel && this.nmd.getSlotPolicy().slotHasCardView((SlotModel)entityModel)) {
                            return;
                        }
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!db.on()) break block5;
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
            }
            this.throwInvalidViewException(viewName + " does not exist.", 3);
        }
    }

    protected String getName() {
        String string;
        block2: {
            string = this.name;
            try {
                string = this.isMultishelf ? this.nmd.getName() + " Shelf " + this.chassis.getShelfId(this.isMultishelf) : this.nmd.getName();
            }
            catch (Exception exception) {
                db.println("Caught exception in getName");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public void execFv() {
        AbstractProvPane abstractProvPane = (AbstractProvPane)((ShelfTabbedView)this.stv).getProvisioningTab();
        abstractProvPane.setCursor(3);
        this.fed = FunctionalEditDialog.instance((JPanel)((Object)abstractProvPane), this.nmd);
        if (this.fed != null) {
            this.fed.setVisible(true);
        }
        abstractProvPane.setCursor(0);
    }
}

