/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.aic;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.ui.aic.AicOhTermPane;
import cerent.cms.ui.aic.AicOhTermRowObject;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.ComparisonUtil;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public class AicOhTermColumnRenderer
extends AbstractColumnRenderer {
    public static final int AICI_PORT = 0;
    public static final int CHANNEL_TYPE = 1;
    public static final int OPTICAL_SLOT = 2;
    public static final int OPTICAL_PORT = 3;
    public static final int CIRCUIT_NAME = 4;
    public static final int CIRCUIT_TYPE = 5;
    public static final int PCM = 6;
    protected static String[] columnNames = new String[]{"Port", "Channel Type", "Optical Slot", "Optical Port", "Circuit Name", "Circuit Type", "PCM"};
    protected static final int numColumns = columnNames.length;
    protected static final int[] columnWidths = new int[]{85, 95, 75, 75, 140, 130, 60};
    private static final EmptyBorder emptyBorder = new EmptyBorder(0, 5, 0, 2);
    private JLabel label;
    private int mode;
    private static final SDebug db = new SDebug((KDebug)AicOhTermPane.db, "AicOhTermColumnRenderer");

    public AicOhTermColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(this.alignment);
        this.label.setOpaque(true);
        this.label.setBorder(emptyBorder);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.label.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
        this.label.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
        AicOhTermRowObject aicOhTermRowObject = (AicOhTermRowObject)object;
        if (aicOhTermRowObject == null) {
            this.label.setText("<null info>");
            return this.label;
        }
        String string = "";
        try {
            switch (this.mode) {
                case 0: {
                    string = aicOhTermRowObject.getAicPort();
                    break;
                }
                case 1: {
                    string = aicOhTermRowObject.getChannelType();
                    break;
                }
                case 2: {
                    string = new Integer(aicOhTermRowObject.getOpticalSlot()).toString();
                    break;
                }
                case 3: {
                    string = PortHelper.getConcatenatedString((int[])aicOhTermRowObject.getOpticalPortNum());
                    break;
                }
                case 4: {
                    string = aicOhTermRowObject.getName();
                    break;
                }
                case 5: {
                    string = aicOhTermRowObject.getCircuitType();
                    break;
                }
                case 6: {
                    string = aicOhTermRowObject.getPCM();
                }
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (db.on()) {
                db.warning("Caught exception in AicOhTermColumnRenderer.getTableCellRendererComponent()");
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            // empty catch block
        }
        this.label.setText(string);
        return this.label;
    }

    public static ColumnRenderer[] createColumnRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            columnRendererArray[i] = new AicOhTermColumnRenderer(i, columnNames[i], columnWidths[i], true, 2);
        }
        return columnRendererArray;
    }

    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        AicOhTermRowObject aicOhTermRowObject = (AicOhTermRowObject)object;
        AicOhTermRowObject aicOhTermRowObject2 = (AicOhTermRowObject)object2;
        try {
            switch (n) {
                case 0: {
                    n2 = aicOhTermRowObject.getAicPort().compareTo(aicOhTermRowObject2.getAicPort());
                    break;
                }
                case 1: {
                    n2 = aicOhTermRowObject.getChannelType().compareTo(aicOhTermRowObject2.getChannelType());
                    break;
                }
                case 2: {
                    n2 = aicOhTermRowObject.getOpticalSlot() - aicOhTermRowObject2.getOpticalSlot();
                    break;
                }
                case 3: {
                    n2 = ComparisonUtil.compare((int[])aicOhTermRowObject.getOpticalPortNum(), (int[])aicOhTermRowObject2.getOpticalPortNum());
                    break;
                }
                case 4: {
                    n2 = aicOhTermRowObject.getName().compareTo(aicOhTermRowObject2.getName());
                    break;
                }
                case 5: {
                    n2 = aicOhTermRowObject.getCircuitType().compareTo(aicOhTermRowObject2.getCircuitType());
                    break;
                }
                case 6: {
                    n2 = aicOhTermRowObject.getPCM().compareTo(aicOhTermRowObject2.getPCM());
                }
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (db.on()) {
                db.warning("Caught exception in AicOhTermColumnRenderer.compareColumn()");
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            // empty catch block
        }
        return n2;
    }
}

