/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.aic;

import cerent.cms.idl.Equipment.sOrderwireConfig;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.OrderwireModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractDataSourceControl;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.EntityComparator;
import cerent.cms.ui.ObserverProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;

public class AicProvOrderwirePane
extends ObserverProvPane
implements MouseListener {
    protected static final String OW_4W_TITLE = "4-Wire Level";
    protected static final String OW_2W_TITLE = "2-Wire Level";
    protected static final String OW_GAIN_TX = "TX :";
    protected static final String OW_GAIN_RX = "RX :";
    protected static final String OW_GAIN_UNIT = "dBm";
    protected static final String SLIDER_TOOLTIP = "Slide cursor or use arrow keys to modify gain value, double-click value to change slider orientation";
    protected int sliderOrientation = 0;
    protected OrderwireModel model;
    private JPanel panel;
    private static final int MAX_SELECTION_COUNT = 4;
    private ElementModelsDelegate eltModels;
    protected sOrderwireConfig settings;
    private static final EntityCellRenderer modelRenderer = new EntityCellRenderer("slot ");
    protected static final int L2RX = 0;
    protected static final int L2TX = 1;
    protected static final int L4RX = 2;
    protected static final int L4TX = 3;
    protected static final int NUM_SLIDERS = 4;
    protected JSlider[] sliders;
    private int[] sliderInitValues;
    protected JLabel[] sliderValueLabels;
    protected int[] minSliderValues = new int[]{0, -10, -16, -16};
    private static final int[] rawValuesL4RX = new int[]{189, 168, 150, 134, 119, 106, 95, 84, 75, 67, 60, 53, 47, 42, 38, 34, 30, 27, 24, 21, 19, 17, 15, 13};
    private static final int[] rawValuesL4TX = new int[]{14, 16, 17, 20, 22, 25, 28, 31, 35, 39, 44, 49, 55, 62, 69, 78, 87, 98, 110, 123, 139, 155, 174, 196};
    private static final int[] rawValuesL2RX = new int[]{233, 208, 185, 165, 147, 131, 117, 104, 93, 83, 74};
    private static final int[] rawValuesL2TX = new int[]{72, 81, 91, 102, 115, 129, 145, 162, 182, 204, 229};
    protected int[][] rawValues = new int[][]{rawValuesL2RX, rawValuesL2TX, rawValuesL4RX, rawValuesL4TX};
    protected JPanel lev4Panel;
    protected JPanel lev2Panel;
    protected static final Dimension owgDimension = new Dimension(290, 290);
    private static final SDebug db = new SDebug("Orderwire");

    public AicProvOrderwirePane(String string, TabbedView tabbedView, OrderwireModel orderwireModel, String string2) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.initSliders();
        this.init();
        this.setDataSourceControl(new InnerDsc());
        this.model = orderwireModel;
        this.setDataSourceControl(new InnerDsc());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = this.getOrderwireBuzzerPanel();
        if (jPanel2 != null) {
            jPanel.add((Component)jPanel2, "North");
        }
        jPanel.add((Component)this.getOrderwireGainPanel(), "Center");
        this.add(jPanel);
        if (this.isUserAuthorized()) {
            this.addButtonPanel();
        }
        this.eltModels = orderwireModel.getNodeModelDelegate().getElementModelsDelegate();
        this.getObservableManager().addObservable((Observable)((Object)this.eltModels));
    }

    public boolean hasSubTabs() {
        return true;
    }

    protected JPanel getOrderwireBuzzerPanel() {
        return null;
    }

    protected void initSliders() {
        int n = this.getNumSliders();
        this.sliders = new JSlider[n];
        this.sliderInitValues = new int[n];
        this.sliderValueLabels = new JLabel[n];
    }

    protected JPanel getOrderwireGainPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 2, 4));
        jPanel.setPreferredSize(owgDimension);
        this.lev4Panel = new JPanel();
        this.lev2Panel = new JPanel();
        this.lev4Panel.setBorder(BorderFactory.createTitledBorder(OW_4W_TITLE));
        this.lev2Panel.setBorder(BorderFactory.createTitledBorder(OW_2W_TITLE));
        this.lev4Panel.add(this.getGainSliderPanel(2, OW_GAIN_RX));
        this.lev4Panel.add(this.getGainSliderPanel(3, OW_GAIN_TX));
        this.lev2Panel.add(this.getGainSliderPanel(0, OW_GAIN_RX));
        this.lev2Panel.add(this.getGainSliderPanel(1, OW_GAIN_TX));
        jPanel.add(this.lev4Panel);
        jPanel.add(this.lev2Panel);
        this.setOrientation();
        return jPanel;
    }

    protected void setOrientation() {
        int n;
        int n2;
        if (this.sliderOrientation == 1) {
            n2 = 1;
            n = 2;
        } else {
            n2 = 2;
            n = 1;
        }
        this.lev4Panel.setLayout(new GridLayout(n2, n, 4, 4));
        this.lev2Panel.setLayout(new GridLayout(n2, n, 4, 4));
        for (int i = 0; i < this.sliders.length; ++i) {
            this.sliders[i].setOrientation(this.sliderOrientation);
        }
        this.lev4Panel.invalidate();
        this.lev2Panel.invalidate();
        this.repaint();
    }

    protected JPanel getGainSliderPanel(int n, String string) {
        int n2 = this.minSliderValues[n];
        int n3 = n2 + this.rawValues[n].length - 1;
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        JLabel jLabel = new JLabel();
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        this.sliderValueLabels[n] = jLabel;
        jPanel2.add(new JLabel(string));
        jPanel2.add(jLabel);
        jPanel2.add(new JLabel(OW_GAIN_UNIT));
        jPanel2.setToolTipText(SLIDER_TOOLTIP);
        jPanel2.addMouseListener(this);
        JSlider jSlider = this.createSlider(this.sliderOrientation, n);
        this.enableComponent(jSlider);
        this.sliders[n] = jSlider;
        jSlider.setPaintLabels(true);
        jSlider.setPaintTicks(true);
        jSlider.setPaintTrack(true);
        jSlider.setSnapToTicks(true);
        jSlider.setMajorTickSpacing(5);
        jSlider.setMinorTickSpacing(1);
        jSlider.setToolTipText(SLIDER_TOOLTIP);
        jSlider.addChangeListener(new SliderListener(this, n));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 3.0;
        jPanel.add((Component)jSlider, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        return jPanel;
    }

    protected boolean getBuzzerValue() {
        return true;
    }

    protected void setBuzzerValue(boolean bl) {
    }

    protected short getSliderRawValue(int n) {
        int n2 = this.sliders[n].getValue();
        int n3 = n2 - this.minSliderValues[n];
        return (short)this.rawValues[n][n3];
    }

    protected void setSliderFromRawValue(int n, int n2) {
        int[] nArray = this.rawValues[n];
        int n3 = 0;
        try {
            while (true) {
                int n4 = nArray[n3];
                int n5 = nArray[n3 + 1];
                if (!(n4 <= n2 && n2 < n5 || n5 < n2 && n2 <= n4)) {
                    ++n3;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            db.finest("exception in setSliderFromRawValue() " + exception);
        }
        int n6 = this.minSliderValues[n] + n3;
        this.setSliderValueLabel(n, n6);
        this.sliders[n].setValue(n6);
        this.sliderInitValues[n] = n6;
        this.sliderValueLabels[n].repaint();
        this.sliders[n].repaint();
    }

    protected void init() {
    }

    protected int getNumSliders() {
        return 4;
    }

    protected JSlider createSlider(int n, int n2) {
        int n3 = this.minSliderValues[n2];
        int n4 = n3 + this.rawValues[n2].length - 1;
        JSlider jSlider = new JSlider(n, n3, n4, n3);
        return jSlider;
    }

    void sliderChanged(int n) {
        int n2 = this.sliders[n].getValue();
        this.setSliderValueLabel(n, n2);
        if (n2 != this.sliderInitValues[n]) {
            this.setDirty();
        }
    }

    protected void setSliderValueLabel(int n, int n2) {
        JLabel jLabel = this.sliderValueLabels[n];
        if (n2 >= 0) {
            jLabel.setText("+" + Integer.toString(n2));
        } else {
            jLabel.setText(Integer.toString(n2));
        }
        jLabel.repaint();
    }

    protected void refreshFromNe() {
        this.settings = this.model.settings();
        this.setSliderFromRawValue(2, this.settings.level4wRcv);
        this.setSliderFromRawValue(3, this.settings.level4wXmt);
        this.setSliderFromRawValue(0, this.settings.level2wRcv);
        this.setSliderFromRawValue(1, this.settings.level2wXmt);
        this.setBuzzerValue(this.settings.buzzer);
    }

    public void updateSettings() {
        this.settings.level4wRcv = this.getSliderRawValue(2);
        this.settings.level4wXmt = this.getSliderRawValue(3);
        this.settings.level2wRcv = this.getSliderRawValue(0);
        this.settings.level2wXmt = this.getSliderRawValue(1);
        this.settings.buzzer = this.getBuzzerValue();
    }

    private void printSettings(String string) {
        if (db.on()) {
            db.println(string + ":L4RX=" + this.settings.level4wRcv + " L4TX=" + this.settings.level4wXmt + " L2RX=" + this.settings.level2wRcv + " L2TX=" + this.settings.level2wXmt);
        }
    }

    protected ArrayList getEligiblePortModels() {
        TreeSet treeSet = new TreeSet(new EntityComparator());
        if (db.on()) {
            db.println("Retrieved " + treeSet.size() + " ports");
        }
        return new ArrayList(treeSet);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.setDirty();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.setDirty();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.setDirty();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.sliderOrientation = this.sliderOrientation == 1 ? 0 : 1;
            this.setOrientation();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.AicProvOrderwirePane;
    }

    public class InnerDsc
    extends AbstractDataSourceControl {
        public void applyToModel() throws Exception {
            try {
                AicProvOrderwirePane.this.updateSettings();
                AicProvOrderwirePane.this.model.settings(AicProvOrderwirePane.this.settings);
                AicProvOrderwirePane.this.printSettings("to NE");
            }
            catch (ProvisionError provisionError) {
                String string;
                try {
                    string = AicProvOrderwirePane.this.model.getNodeModelDelegate().getTDMTerminology().getRingTerms(1);
                }
                catch (Exception exception) {
                    string = "BLSR";
                }
                ErrorMsg.displayError(null, (EID)EMC.EID_E2_IN_USE_PARAM_1, (Object)string);
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Error in applying changes to model in ProvPane " + exception.toString());
                }
                throw exception;
            }
        }

        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("Refreshing from model...");
            }
            AicProvOrderwirePane.this.refreshFromNe();
            AicProvOrderwirePane.this.resetDirty();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)AicProvOrderwirePane.this), true);
            }
            return this.dscObservableManager;
        }
    }

    class SliderListener
    implements ChangeListener {
        private int index;
        private AicProvOrderwirePane pane;

        SliderListener(AicProvOrderwirePane aicProvOrderwirePane2, int n) {
            this.pane = aicProvOrderwirePane2;
            this.index = n;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.pane.sliderChanged(this.index);
        }
    }
}

