/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.OpticalTableModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class ParametersProvPane
extends NodeProvPane
implements TableModelListener {
    protected OpticalTableModel dataModel;
    protected OpticsModuleModel eqpmtModel;
    protected AbstractOpticsLineModel[] lineModels;
    protected int numLines;
    protected boolean notInited = true;

    public ParametersProvPane(String string, TabbedView tabbedView, AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(string, tabbedView);
        this.lineModels = abstractOpticsLineModelArray;
    }

    protected JTable getTable(TableModel tableModel) {
        return new UTable(tableModel);
    }

    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    protected void init() {
        this.eqpmtModel = (OpticsModuleModel)this.getUiModel();
        this.numLines = this.lineModels.length;
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        boolean bl = AdminState.isANSI(this.getUiModel().getNodeModel().getTdmProtocolType());
        this.table = this.getTable(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.prepareColumns();
        this.registerWithModel();
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.table.setAutoResizeMode(0);
        this.notInited = false;
    }

    protected void prepareColumns() {
        TableColumn tableColumn = this.table.getColumn(this.getColumnName(2));
        tableColumn.sizeWidthToFit();
        tableColumn.setPreferredWidth(tableColumn.getWidth());
        tableColumn = this.table.getColumn(this.getColumnName(0));
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        tableColumn = this.table.getColumn(this.getColumnName(1));
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(this.getColumnName(3));
        tableColumn.sizeWidthToFit();
        tableColumn.setPreferredWidth(tableColumn.getWidth());
    }

    protected String getColumnName(int n) {
        return this.dataModel.otmColumnNames[n];
    }

    protected void setAttrCellEditor(int n, String string) {
        this.setAttrCellEditor(n, string, -1);
    }

    protected void setAttrCellEditor(int n, String string, int n2) {
        TableColumn tableColumn = this.table.getColumn(this.getColumnName(n));
        try {
            Attribute[] attributeArray = this.getAttributeArray(string);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
            if (n2 == -1) {
                tableColumn.setPreferredWidth(tableColumn.getWidth());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            db.println("WARNING: cannot find attributes for " + string + "\nPlease edit ElementDefaults.java");
            this.table.removeColumn(tableColumn);
        }
    }

    protected void removeColumn(int n) {
        block2: {
            String string = this.dataModel.otmColumnNames[n];
            try {
                TableColumn tableColumn = this.getTable().getColumn(string);
                this.getTable().removeColumn(tableColumn);
            }
            catch (Exception exception) {
                if (!ParametersProvPane.db.on) break block2;
                db.fine("Caught " + exception + " in removeColumn");
            }
        }
    }

    private JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected Attribute[] getAttributeArray(String string) throws NoSuchElementException {
        Attribute[] attributeArray = ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeArray(string);
        if (attributeArray == null) {
            throw new NoSuchElementException();
        }
        return attributeArray;
    }

    protected OpticalTableModel getDataModel() {
        return this.dataModel;
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.lineModels)) {
            stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            bl2 = true;
        }
        if (bl || bl2) {
            boolean bl3 = true;
            if (bl2) {
                String string = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, bl);
                bl3 = false;
                stringBuffer.append(string).append("\n");
            }
            stringBuffer.append("\n");
            if (!bl3) {
                stringBuffer.append(this.getApplyString(bl3));
            } else {
                stringBuffer.append(this.getApplyString());
            }
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                return;
            }
        }
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                ParametersProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In AmpliParametersTableModel changeMessage cannot find Model " + observable);
        }
    }

    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.lineModels[i] == null) continue;
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    public void destroy() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.lineModels[i] != null) {
                this.lineModels[i].deleteObserver((Observer)((Object)this));
            }
            this.lineModels[i] = null;
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public abstract CSHelpID getHelpID();
}

