/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.ui.Wavelength;
import cerent.cms.ui.ampli.WlPowerDataSource;
import cerent.util.ComparisonUtil;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class WlPowerColumnRenderer
extends AbstractColumnRenderer {
    public static final int WL_INDEX = 0;
    public static final int POWER_INDEX = 1;
    public static final int STATUS_INDEX = 2;
    private static final int COLUMN_COUNT = 3;
    private JLabel label = new JLabel();

    public WlPowerColumnRenderer(String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.label.setHorizontalAlignment(n2);
        this.label.setOpaque(true);
        this.label.setForeground(Color.BLACK);
        this.label.setBackground(Color.WHITE);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = " ";
        JLabel jLabel = this.label;
        switch (n2) {
            case 0: {
                string = Wavelength.getWavelengthStringFromWavelength(((WlPowerDataSource.OchInfo)object).lambda.value());
                break;
            }
            case 1: {
                string = Float.toString((float)((WlPowerDataSource.OchInfo)object).power / 10.0f);
                break;
            }
            case 2: {
                string = ((WlPowerDataSource.OchInfo)object).ochStatus;
            }
        }
        this.label.setText(string);
        return jLabel;
    }

    static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[3];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = WlPowerColumnRenderer.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(int n) {
        int n2;
        int n3;
        String string;
        boolean bl = true;
        switch (n) {
            case 0: {
                string = "Wavelength";
                n3 = 100;
                n2 = 2;
                break;
            }
            case 1: {
                string = "Measured Power";
                n3 = 100;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Status";
                n3 = 100;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                n2 = 2;
            }
        }
        return new WlPowerColumnRenderer(string, n3, bl, n2);
    }

    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                int n3 = ((WlPowerDataSource.OchInfo)object).lambda.value();
                int n4 = ((WlPowerDataSource.OchInfo)object2).lambda.value();
                n2 = ComparisonUtil.compare((int)n3, (int)n4);
                break;
            }
            case 1: {
                int n5 = ((WlPowerDataSource.OchInfo)object).power;
                int n6 = ((WlPowerDataSource.OchInfo)object2).power;
                n2 = ComparisonUtil.compare((int)n5, (int)n6);
                break;
            }
            case 2: {
                String string = ((WlPowerDataSource.OchInfo)object).ochStatus;
                String string2 = ((WlPowerDataSource.OchInfo)object2).ochStatus;
                n2 = string.compareTo(string2);
            }
        }
        return n2;
    }
}

