/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.ui.ans.NumberDocument;
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class FloatNumberField
extends JTextField {
    private NumberFormat floatFormatter;

    public FloatNumberField(int n) {
        super(n);
        this.floatFormatter = NumberFormat.getNumberInstance(Locale.US);
        this.floatFormatter.setMaximumFractionDigits(2);
    }

    public FloatNumberField(int n, float f, float f2) {
        super(n);
        NumberDocument numberDocument = (NumberDocument)this.createDefaultModel();
        numberDocument.setRangeValue(f, f2);
        this.floatFormatter = NumberFormat.getNumberInstance(Locale.US);
        this.floatFormatter.setMaximumFractionDigits(2);
        this.setDocument(numberDocument);
    }

    public float getValue() {
        float f = 0.0f;
        try {
            f = this.floatFormatter.parse(this.getText()).floatValue() * 10.0f;
        }
        catch (ParseException parseException) {
            Toolkit.getDefaultToolkit().beep();
        }
        return f;
    }

    public int getIntValue() {
        return (int)this.getValue();
    }

    public void setValue(int n) {
        if (n == -1000000) {
            this.setText("");
        } else {
            this.setText(Float.toString(n));
        }
    }

    protected Document createDefaultModel() {
        return new NumberDocument();
    }
}

