/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds123;

import cerent.cms.idl.Ds123Media.eClockSource;
import cerent.cms.idl.Ds123Media.eLineCoding;
import cerent.cms.idl.Ds123Media.eLineType;
import cerent.cms.idl.Ds123Media.eSignalMode;
import cerent.cms.idl.Ds123Media.sConfig;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds1LineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ds123.Ds123LineTableModel;
import cerent.util.AnnotatedException;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.SoakTimeCellEditor;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class Ds123LineProvPane
extends NodeProvPane
implements TableModelListener,
PropertyChangeListener {
    protected INodeModel node;
    protected Ds123LineTableModel dataModel = null;
    protected Ds123LineModel[] lineModels = null;
    protected int numLines = 0;
    private ObservableManager _obsMgr;
    private CSHelpID helpID = null;
    protected static final SDebug db = new SDebug("Ds123LineProv");

    public Ds123LineProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, CSHelpID cSHelpID) {
        super(string, tabbedView);
        this.node = tabbedView.getUiModel().getNodeModel();
        this.helpID = cSHelpID;
        TableColumn tableColumn = null;
        Attribute[] attributeArray = null;
        this.lineModels = ds123LineModelArray;
        if (this.lineModels != null) {
            this.numLines = this.lineModels.length;
        }
        this.dataModel = this.getDataModel(this.lineModels);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        tableColumn = this.table.getColumn(Ds123LineTableModel.columnNames[0]);
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        tableColumn = this.table.getColumn(Ds123LineTableModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(Ds123LineTableModel.columnNames[4]);
        try {
            attributeArray = this.getAttributeArray(eClockSource.class);
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        tableColumn = this.table.getColumn(Ds123LineTableModel.columnNames[6]);
        try {
            attributeArray = this.getBerLevelAttributeArray(6);
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
        tableColumn = this.table.getColumn(Ds123LineTableModel.columnNames[5]);
        try {
            attributeArray = this.getBerLevelAttributeArray(5);
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
        this.setLineTypeColumn();
        tableColumn = this.table.getColumn(Ds123LineTableModel.columnNames[8]);
        try {
            if (this.needToRemoveDetectedLineType()) {
                attributeArray = null;
                this.table.removeColumn(tableColumn);
            } else {
                attributeArray = this.getDetectedAttributeArray(eLineType.class);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
            tableColumn.sizeWidthToFit();
        }
        tableColumn = this.table.getColumn(Ds123LineTableModel.columnNames[9]);
        try {
            attributeArray = this.getAttributeArray(eLineCoding.class);
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
        tableColumn = this.table.getColumn(Ds123LineTableModel.columnNames[10]);
        try {
            attributeArray = this.getAttributeArray(eSignalMode.class);
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
        tableColumn = this.table.getColumn(Ds123LineTableModel.columnNames[11]);
        try {
            attributeArray = this.getAttributeArray("Line Length");
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
        tableColumn = this.table.getColumn(Ds123LineTableModel.columnNames[2]);
        AdminState[] adminStateArray = AdminState.getDefaultAdminStates(AdminState.isANSI(this.node.getTDMTerminology()));
        JComboBox<AdminState> jComboBox = new JComboBox<AdminState>(adminStateArray);
        jComboBox.setEditable(false);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(Ds123LineTableModel.columnNames[13]);
        try {
            attributeArray = this.getAttributeArray("FdlModeMask");
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
        ModuleModel moduleModel = (ModuleModel)tabbedView.getUiModel();
        if (this.lineModels != null && this.lineModels.length > 0 && !(this.lineModels[0] instanceof Ds1LineModel)) {
            tableColumn = this.table.getColumn(Ds123LineTableModel.columnNames[14]);
            this.table.removeColumn(tableColumn);
        }
        if (this.lineModels != null && this.lineModels.length > 0 && !(this.lineModels[0] instanceof Ds1LineModel)) {
            tableColumn = this.table.getColumn(Ds123LineTableModel.columnNames[15]);
            this.table.removeColumn(tableColumn);
        }
        SoakTimeCellEditor soakTimeCellEditor = new SoakTimeCellEditor(this);
        tableColumn = this.table.getColumn(Ds123LineTableModel.columnNames[12]);
        tableColumn.setCellEditor(soakTimeCellEditor);
        tableColumn.setMinWidth(soakTimeCellEditor.getPreferredWidth() + 10);
        this.table.setRowHeight(soakTimeCellEditor.getPreferredHeight());
        this.add((Component)uScrollPane);
        this.registerWithModel();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    protected boolean needToRemoveAutoProvision() {
        return false;
    }

    protected boolean needToRemoveDetectedLineType() {
        return false;
    }

    protected void setLineTypeColumn() {
        Attribute[] attributeArray = null;
        Attribute[] attributeArray2 = null;
        TableColumn tableColumn = this.table.getColumn(Ds123LineTableModel.columnNames[7]);
        try {
            if (this.needToRemoveAutoProvision()) {
                attributeArray2 = this.getAttributeArray(eLineType.class);
                attributeArray = new Attribute[attributeArray2.length - 1];
                int n = 0;
                for (int i = 0; i < attributeArray2.length; ++i) {
                    if (attributeArray2[i].getKey().compareTo("AUTO PROVISION FMT") == 0) continue;
                    attributeArray[n++] = attributeArray2[i];
                }
            } else {
                attributeArray = this.getAttributeArray(eLineType.class);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
    }

    Attribute[] getBerLevelAttributeArray(int n) {
        if (n == 6) {
            return this.getAttributeMap().getAttributeArray("declareSdBerLevel");
        }
        if (n == 5) {
            return this.getAttributeMap().getAttributeArray("declareSfBerLevel");
        }
        return null;
    }

    protected Ds123LineTableModel getDataModel(Ds123LineModel[] ds123LineModelArray) {
        return new Ds123LineTableModel(this.node, ds123LineModelArray);
    }

    protected void registerWithModel() {
        super.registerWithModel();
        this.getObsMgr().addObservable((Observable[])this.lineModels);
    }

    protected ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    public void dispose() {
        db.info("Called dispose");
        if (this._obsMgr != null) {
            this._obsMgr.removeObservable((Observable[])this.lineModels);
        }
        super.dispose();
    }

    protected void changeMessage(Observable observable, Object object) {
        db.info("Got an Update Message for " + observable);
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                Ds123LineProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            db.info("Refreshing Line " + n);
            this.dataModel.refreshLineFromModel(n);
        } else {
            db.info("In Ds123LineProvPane changeMessage cannot find Model " + observable);
        }
    }

    protected JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap((IModel)this.node);
    }

    protected Attribute[] getAttributeArray(Class clazz) {
        return this.getAttributeMap().getAttributeArray("DS123." + clazz.getName());
    }

    protected Attribute[] getDetectedAttributeArray(Class clazz) {
        return this.getAttributeMap().getAttributeArray("DS123." + clazz.getName() + ".detected");
    }

    protected Attribute[] getAttributeArray(String string) {
        return this.getAttributeMap().getAttributeArray("DS123." + string);
    }

    protected Attribute[] getDetectedAttributeArray(String string) {
        return this.getAttributeMap().getAttributeArray("DS123." + string + ".detected");
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    protected boolean autoProvisionFmtDestructive() {
        return false;
    }

    public void applyChangesToModel() throws Exception {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.lineModels)) {
            stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            bl2 = true;
        }
        if (AdminState.needRemoveLoopback(this.dataModel, this.lineModels)) {
            stringBuffer.append("Some lines will be removed from loopback since their new state does not allow loopback.").append('\n');
            bl = true;
        }
        if (this.autoProvisionFmtDestructive()) {
            boolean bl4 = false;
            for (n = 0; !bl3 && n < this.numLines; ++n) {
                if (this.lineModels[n].getConfig().lineType == eLineType.AUTO_PROVISION_FMT || this.dataModel.getConfig((int)n).lineType != eLineType.AUTO_PROVISION_FMT) continue;
                if (AdminState.isFormOfIS(this.lineModels[n].getAdminStateEnum()) && AdminState.isFormOfIS(this.dataModel.getAdminState(n).getAdminStateEnum())) {
                    stringBuffer.append("Changing LineType to AUTO FRAME while a\n");
                    stringBuffer.append("port is INSERVICE will cause a service disruption.\n");
                    stringBuffer.append("The Line Coding value will be set to the value that \n");
                    stringBuffer.append("was provisioned on the Provisioning tab.\n\n");
                    stringBuffer.append("Are you sure you want to continue?\n");
                    bl3 = true;
                    continue;
                }
                bl4 = true;
            }
            if (bl4 && !bl3) {
                stringBuffer.append("The Line Coding value will be set to the value that \n");
                stringBuffer.append("was provisioned on the Provisioning tab.\n\n");
                stringBuffer.append("Are you sure you want to continue?\n");
                bl3 = true;
            }
        }
        if (bl || bl2 || bl3) {
            if (bl2) {
                String string = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, bl);
                stringBuffer.append(string).append("\n\n").append(this.getApplyString(false));
            } else if (bl) {
                stringBuffer.append(this.getApplyString());
            }
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                return;
            }
        }
        n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (db.on()) {
                    db.fine("setting at iteration " + n);
                }
                if (this.dataModel.isRowDirty(n)) {
                    this.applyToLine(n);
                    continue;
                }
                db.fine("Row " + n + " is not dirty: adminState is " + this.dataModel.getAdminState(n).toString());
            }
            this.dataModel.resetDirtyBits();
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }

    protected void applyToLine(int n) throws Exception {
        if (db.on()) {
            this.printConfig(this.dataModel.getConfig(n));
        }
        this.lineModels[n].setAlias(this.dataModel.getPortName(n));
        this.lineModels[n].setConfig(this.dataModel.getConfig(n));
        if (db.on()) {
            db.fine("setting line adminState" + n + " to " + this.dataModel.getAdminState(n).toString());
        }
        Attribute attribute = this.dataModel.getSdBerLevelIndex(n);
        Attribute attribute2 = this.dataModel.getSfBerLevelIndex(n);
        if (attribute != null && attribute2 != null) {
            this.lineModels[n].setSdBerLevel((short)attribute.getValue().intValue());
            this.lineModels[n].setSfBerLevel((short)attribute2.getValue().intValue());
        }
        if (this.topLevelLineModel()) {
            this.lineModels[n].setSoakTime(this.dataModel.getSoakTime(n));
            this.lineModels[n].setAdminStateNoLpbk(this.dataModel.getAdminStateFor(n));
        }
        if (this.dataModel.isDirty(n, 14)) {
            ((Ds1LineModel)this.lineModels[n]).setSndAISVForDs1AISEnabled(this.dataModel.getSndAISVForDefects(n));
        }
        if (this.dataModel.isDirty(n, 15)) {
            ((Ds1LineModel)this.lineModels[n]).setRaiseDs1AISForLOFEnabled(this.dataModel.getTreatLOFAsDefect(n));
        }
    }

    protected boolean topLevelLineModel() {
        return true;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    public void refreshFromModel() throws Exception {
        db.info("refreshing ");
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        this.getObsMgr().setPassing(true);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    private void printConfig(sConfig sConfig2) {
        if (db.on()) {
            db.fine("===============================================");
            db.fine("Clock Source " + sConfig2.clockSource.value());
            db.fine("Line Type " + sConfig2.lineType.value());
            db.fine("Line Coding " + sConfig2.lineCoding.value());
            db.fine("Signal Mode " + sConfig2.signalMode.value());
            db.fine("Signal Mode " + sConfig2.lineLength);
            db.fine("Signal Mode " + sConfig2.fdlModeMask);
            db.fine("===============================================");
        }
    }

    public CSHelpID getHelpID() {
        if (this.helpID == null) {
            return CSHelpConst.Introduction;
        }
        return this.helpID;
    }
}

