/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds3i;

import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds3e.Ds3eSonetPmThresholdsPane;
import cerent.cms.ui.ds3i.Ds3iLinePmThresholdsPane;
import cerent.cms.ui.ds3i.Ds3iLineProvPane;
import cerent.cms.ui.ds3i.Ds3iPathPmThresholdsPane;
import cerent.cms.ui.e3.E3SdhPmThresholdsPane;
import cerent.cms.ui.sonet.TdmHoProvPane;
import cerent.util.TDMTerminology;
import java.awt.Component;

public class Ds3iProvPane
extends NodeProvPane {
    private INodeModel node;
    private Ds123LineModel[] lineModels = null;

    public Ds3iProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        super(string, tabbedView);
        this.node = tabbedView.getUiModel().getNodeModel();
        TDMTerminology tDMTerminology = this.node.getTDMTerminology();
        this.lineModels = ds123LineModelArray;
        this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
        this.subTabs.addTab("Line", (Component)this.getLineProvTab());
        this.subTabs.addTab("Line Thresholds", (Component)this.getLineThreshold());
        this.subTabs.addTab("Elect Path Thresholds", (Component)this.getElecPathThreshold());
        String string2 = tDMTerminology.getGeneralTerms(4) + " Thrshold";
        boolean bl = this.node.getTdmProtocolTypeObj().isSonet();
        if (bl) {
            this.subTabs.addTab("SONET Thresholds", (Component)this.getSonetThreshold());
        } else {
            this.subTabs.addTab("SDH Thresholds", (Component)this.getSonetThreshold());
        }
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, true));
        this.add((Component)this.subTabs);
    }

    public Ds3iProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, boolean bl) {
        super(string, tabbedView);
        this.node = tabbedView.getUiModel().getNodeModel();
        TDMTerminology tDMTerminology = this.node.getTDMTerminology();
        this.lineModels = ds123LineModelArray;
        this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
        this.subTabs.addTab("Line", (Component)this.getLineProvTab());
        this.subTabs.addTab("Line Thresholds", (Component)this.getLineThreshold());
        this.subTabs.addTab("Elect Path Thresholds", (Component)this.getElecPathThreshold());
        String string2 = tDMTerminology.getGeneralTerms(4) + " Thrshold";
        boolean bl2 = this.node.getTdmProtocolTypeObj().isSonet();
        if (bl2) {
            this.subTabs.addTab("SONET Thresholds", (Component)this.getSonetThreshold());
        } else {
            this.subTabs.addTab("SDH Thresholds", (Component)this.getSonetThreshold());
        }
        if (bl) {
            this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, true));
        }
        this.add((Component)this.subTabs);
    }

    private Pane getLineProvTab() {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds3iLineProvPane("DS3 Line", this.getParentView(), this.lineModels));
    }

    private Pane getLineThreshold() {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds3iLinePmThresholdsPane("Line Thresholds", this.getParentView(), this.lineModels));
    }

    private Pane getSonetThreshold() {
        if (this.node.getTdmProtocolTypeObj().isSonet()) {
            return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds3eSonetPmThresholdsPane("SONET Thresholds", this.getParentView(), this.lineModels));
        }
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new E3SdhPmThresholdsPane("SDH Thresholds", this.getParentView(), this.lineModels));
    }

    private Pane getElecPathThreshold() {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds3iPathPmThresholdsPane("DS3 Electric Path Threshold", this.getParentView(), this.lineModels));
    }

    private Pane getStsProvTab() {
        return new TdmHoProvPane("SONET STS", this.getParentView(), this.lineModels, 1);
    }

    public boolean hasSubTabs() {
        return true;
    }
}

