/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds3xm;

import cerent.cms.idl.Ds123Media.eSendCode;
import cerent.cms.idl.Ds123Media.sConfig;
import cerent.cms.model.Attribute;
import cerent.cms.model.Busy;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds123.Ds123LineMaintTableModel;
import cerent.cms.ui.ds3xm.Ds3xmDs1MaintenanceTableModel;
import cerent.cms.ui.ds3xm.Ds3xmLineMaintenancePane;
import cerent.util.SDebug;
import cerent.util.gui.UTable;
import javax.swing.DefaultCellEditor;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class Ds3xmDs1LineMaintenancePane
extends Ds3xmLineMaintenancePane {
    private DefaultCellEditor emptyEditor;
    private DefaultCellEditor feacEditor;
    private DefaultCellEditor payloadEditor;
    private DefaultCellEditor lineEditor;
    private DefaultCellEditor payloadLineEditor;
    private DefaultCellEditor feacPayloadEditor;
    private DefaultCellEditor feacLineEditor;
    private DefaultCellEditor defSendCodeEditor;
    private Attribute[] sendCodeAttrs;
    private static final int SEND_CODE_OPTION_COUNT = 4;
    private static final SDebug db = new SDebug("Ds3xmDs1LineMaintenance");

    public Ds3xmDs1LineMaintenancePane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        super(string, tabbedView, ds123LineModelArray);
        if (((ModuleModel)this.getUiModel()).getEqType() == 8) {
            TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(6));
            this.table.removeColumn(tableColumn);
        }
    }

    protected Ds123LineMaintTableModel getDataModel() {
        if (this.dataModel == null) {
            return new Ds3xmDs1MaintenanceTableModel(this.node, this.lineModels);
        }
        return this.dataModel;
    }

    protected void createTable() {
        if (this.sendCodeAttrs == null) {
            this.sendCodeAttrs = this.getAttributeArray(eSendCode.class);
        }
        if (this.sendCodeAttrs.length == 4) {
            this.table = new UTableExt((Ds3xmDs1MaintenanceTableModel)this.dataModel);
        } else {
            this.sendCodeAttrs = null;
            super.createTable();
        }
    }

    protected void setSendCodeColumnEditor() {
        if (this.sendCodeAttrs == null || this.sendCodeAttrs.length != 4) {
            super.setSendCodeColumnEditor();
            return;
        }
        Attribute attribute = this.sendCodeAttrs[0];
        Attribute attribute2 = this.sendCodeAttrs[1];
        Attribute attribute3 = this.sendCodeAttrs[2];
        Attribute attribute4 = this.sendCodeAttrs[3];
        this.emptyEditor = new DefaultCellEditor(this.getComboBoxFor(new Attribute[]{attribute}));
        this.feacEditor = new DefaultCellEditor(this.getComboBoxFor(new Attribute[]{attribute, attribute2}));
        this.payloadEditor = new DefaultCellEditor(this.getComboBoxFor(new Attribute[]{attribute, attribute3}));
        this.lineEditor = new DefaultCellEditor(this.getComboBoxFor(new Attribute[]{attribute, attribute4}));
        this.payloadLineEditor = new DefaultCellEditor(this.getComboBoxFor(new Attribute[]{attribute, attribute3, attribute4}));
        this.feacPayloadEditor = new DefaultCellEditor(this.getComboBoxFor(new Attribute[]{attribute, attribute2, attribute3}));
        this.feacLineEditor = new DefaultCellEditor(this.getComboBoxFor(new Attribute[]{attribute, attribute2, attribute4}));
        this.defSendCodeEditor = new DefaultCellEditor(this.getComboBoxFor(new Attribute[]{attribute, attribute2, attribute3, attribute4}));
    }

    protected void applyInterdependentChangesToModel(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, SyncProvError, InvalidState, Busy, LoopbackActive {
        db.info("Setting Loopback for " + (n + 1) + " To " + this.dataModel.getLoopbackValFor(n).value());
        this.applyLoopbackAisChanges(n);
        this.lineModels[n].setLoopback(this.dataModel.getLoopbackValFor(n));
    }

    protected void applyDerivativeChangesToModel(int n) throws WrongInterfaceType, NoSuchInterface, UnsupportedOperation, InvalidState, Busy, EMCProvisionError {
        db.info("Setting SendCode for " + (n + 1) + " To " + this.dataModel.getSendCodeValFor(n).value());
        this.lineModels[n].setSendCode(this.dataModel.getSendCodeValFor(n));
    }

    protected Attribute[] getAttributeArray(Class clazz) {
        return this.getAttributeMap().getAttributeArray("DS3XMDS1." + clazz.getName());
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.Ds3xmDs1LineMaintenancePane;
    }

    class UTableExt
    extends UTable {
        public UTableExt(Ds3xmDs1MaintenanceTableModel ds3xmDs1MaintenanceTableModel) {
            super((TableModel)ds3xmDs1MaintenanceTableModel);
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            if (this.convertColumnIndexToModel(n2) != 4) {
                return super.getCellEditor(n, n2);
            }
            try {
                Ds123LineModel ds123LineModel = (Ds123LineModel)Ds3xmDs1LineMaintenancePane.this.lineModels[n].getFirstLowerLayerModels();
                int n3 = ds123LineModel.getConfig().lineType.value();
                sConfig sConfig2 = Ds3xmDs1LineMaintenancePane.this.lineModels[n].getConfig();
                int n4 = sConfig2.lineType.value();
                db.fine("ds3 line type = " + n3 + ", ds1 line type = " + n4 + ", ds1 FDL Mode = " + sConfig2.fdlModeMask);
                if (n3 == 10) {
                    if (sConfig2.fdlModeMask == 1) {
                        if (n4 == 1) {
                            return Ds3xmDs1LineMaintenancePane.this.feacLineEditor;
                        }
                        if (n4 == 0) {
                            return Ds3xmDs1LineMaintenancePane.this.feacPayloadEditor;
                        }
                    } else if (n4 == 1) {
                        return Ds3xmDs1LineMaintenancePane.this.feacEditor;
                    }
                } else if (n3 == 8) {
                    if (sConfig2.fdlModeMask == 1) {
                        if (n4 == 1) {
                            return Ds3xmDs1LineMaintenancePane.this.lineEditor;
                        }
                        if (n4 == 0) {
                            return Ds3xmDs1LineMaintenancePane.this.payloadEditor;
                        }
                    } else if (n4 == 1) {
                        return Ds3xmDs1LineMaintenancePane.this.emptyEditor;
                    }
                    return Ds3xmDs1LineMaintenancePane.this.payloadLineEditor;
                }
            }
            catch (Exception exception) {
                db;
                SDebug.printStackTrace((Throwable)exception);
            }
            return Ds3xmDs1LineMaintenancePane.this.defSendCodeEditor;
        }
    }
}

