/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Dwdm.eAisSquelchMode;
import cerent.cms.idl.Dwdm.eDwdmOduTransparency;
import cerent.cms.idl.Dwdm.eTermMode;
import cerent.cms.idl.Dwdm.sDwdmLineConfig;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OTU2XpModuleModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.DwdmCardProvPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.FixedLengthField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class Otu2xpCardProvPane
extends DwdmCardProvPane
implements ActionListener {
    private AbstractDwdmLineModel[] lineModels = this.eqpmtModel.getDwdmLineModels();
    private JComboBox cardMode;
    private OTU2XpModuleModel otu2xpModel = (OTU2XpModuleModel)this.eqpmtModel;
    private JComboBox portMode1to3;
    private JComboBox portMode2to4;
    private JComboBox termMode1to3;
    private JComboBox termMode2to4;
    private JComboBox portMode3to4;
    private JComboBox termMode3to4;
    private FixedLengthField framingType1to3;
    private FixedLengthField framingType2to4;
    private FixedLengthField framingType3to4;
    private JComboBox aisSquelch1to3;
    private FixedLengthField regenLineName1to3;
    private JComboBox aisSquelch2to4;
    private FixedLengthField regenLineName2to4;
    private JComboBox aisSquelch3to4;
    private FixedLengthField regenLineName3to4;
    private JComboBox oduTransparency1to3;
    private JComboBox oduTransparency2to4;
    private JComboBox oduTransparency3to4;
    private static final int LANTOWAN_PORT = 2;
    private static final String SPLITTER_MODE_STRING = "Splitter";
    private int otu2xpCardMode = 1;
    private int port1To3ModeVal = 1;
    private int port2To4ModeVal = 1;
    private int port3To4ModeVal = 1;
    private sDwdmLineConfig lineConfig1to3;
    private sDwdmLineConfig lineConfig2to4;
    private sDwdmLineConfig lineConfig3to4;
    private JPanel cardConfigPanel;
    private JPanel port1to3ConfigPanel;
    private JPanel port2to4ConfigPanel;
    private JPanel port3to4ConfigPanel;
    private JPanel splitterConfigPanel;
    private JComboBox termModeSplitter;
    private FixedLengthField framingTypeSplitter;
    private JComboBox aisSquelchSplitter;
    private JComboBox oduTransparencySplitter;

    public Otu2xpCardProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    protected JPanel createCardInfoPanel() {
        JPanel jPanel = Otu2xpCardProvPane.createVerticalPanel("Card Provisioning");
        this.cardMode = this.addComboBox(jPanel, "Card Configuration: ", this.getAttributeFor("Otu2xpCardModes"));
        this.cardConfigPanel = Otu2xpCardProvPane.createVerticalPanel(null);
        jPanel.add("PortLevel Config", this.cardConfigPanel);
        this.createPort1to3ConfigPanel();
        this.createPort2to4ConfigPanel();
        this.createPort3to4ConfigPanel();
        this.createSplitterConfigPanel();
        return jPanel;
    }

    private void createPort1to3ConfigPanel() {
        String string = "Port(1-3) Config";
        this.port1to3ConfigPanel = Otu2xpCardProvPane.createVerticalPanel(string);
        this.portMode1to3 = this.addComboBox(this.port1to3ConfigPanel, "Port 1-3 Mode: ", this.getAttributeFor("Otu2xpCardModes"));
        this.portMode1to3.removeItem(this.getAttributeValFor("Otu2xpCardModes", 2));
        this.portMode1to3.removeItem(this.getAttributeValFor("Otu2xpCardModes", 3));
        this.portMode1to3.setEnabled(false);
        this.termMode1to3 = this.addComboBox(this.port1to3ConfigPanel, "Termination Mode:  ", this.getAttributeFor("declTermModeFullSet"));
        this.termMode1to3.setEnabled(false);
        this.framingType1to3 = this.addTextPanel(this.port1to3ConfigPanel, "Framing Type:", 20);
        this.framingType1to3.setEditable(false);
        this.aisSquelch1to3 = this.addComboBox(this.port1to3ConfigPanel, "AIS/Squelch:", this.getAttributeFor("aisSquelch"));
        this.regenLineName1to3 = this.addTextPanel(this.port1to3ConfigPanel, "Regen Line Name:", 32);
        this.oduTransparency1to3 = this.addComboBox(this.port1to3ConfigPanel, "ODU Transparency:", this.getAttributeFor("OduTransparencyValue"));
    }

    private void createPort2to4ConfigPanel() {
        String string = "Port(2-4) Config";
        this.port2to4ConfigPanel = Otu2xpCardProvPane.createVerticalPanel(string);
        this.portMode2to4 = this.addComboBox(this.port2to4ConfigPanel, "Port 2-4 Mode: ", this.getAttributeFor("Otu2xpCardModes"));
        this.portMode2to4.removeItem(this.getAttributeValFor("Otu2xpCardModes", 2));
        this.portMode2to4.removeItem(this.getAttributeValFor("Otu2xpCardModes", 3));
        this.portMode2to4.removeItem(this.getAttributeValFor("Otu2xpCardModes", 4));
        this.portMode2to4.setEnabled(false);
        this.termMode2to4 = this.addComboBox(this.port2to4ConfigPanel, "Termination Mode: ", this.getAttributeFor("declTermModeFullSet"));
        this.termMode2to4.setEnabled(false);
        this.framingType2to4 = this.addTextPanel(this.port2to4ConfigPanel, "Framing Type:", 20);
        this.framingType2to4.setEditable(false);
        this.aisSquelch2to4 = this.addComboBox(this.port2to4ConfigPanel, "AIS/Squelch:", this.getAttributeFor("aisSquelch"));
        this.regenLineName2to4 = this.addTextPanel(this.port2to4ConfigPanel, "Regen Line Name:", 32);
        this.oduTransparency2to4 = this.addComboBox(this.port2to4ConfigPanel, "ODU Transparency:", this.getAttributeFor("OduTransparencyValue"));
    }

    private void createPort3to4ConfigPanel() {
        String string = "Port(3-4) Config";
        this.port3to4ConfigPanel = Otu2xpCardProvPane.createVerticalPanel(string);
        this.portMode3to4 = this.addComboBox(this.port3to4ConfigPanel, "Port 3-4 Mode: ", this.getAttributeFor("Otu2xpCardModes"));
        this.portMode3to4.removeItem(this.getAttributeValFor("Otu2xpCardModes", 0));
        this.portMode3to4.removeItem(this.getAttributeValFor("Otu2xpCardModes", 1));
        this.portMode3to4.removeItem(this.getAttributeValFor("Otu2xpCardModes", 3));
        this.portMode3to4.removeItem(this.getAttributeValFor("Otu2xpCardModes", 4));
        this.termMode3to4 = this.addComboBox(this.port3to4ConfigPanel, "Termination Mode:", this.getAttributeFor("declTermModeFullSet"));
        this.termMode3to4.setEnabled(false);
        this.framingType3to4 = this.addTextPanel(this.port3to4ConfigPanel, "Framing Type:", 20);
        this.framingType3to4.setEditable(false);
        this.aisSquelch3to4 = this.addComboBox(this.port3to4ConfigPanel, "AIS/Squelch:", this.getAttributeFor("aisSquelch"));
        this.regenLineName3to4 = this.addTextPanel(this.port3to4ConfigPanel, "Regen Line Name:", 32);
        this.oduTransparency3to4 = this.addComboBox(this.port3to4ConfigPanel, "ODU Transparency:", this.getAttributeFor("OduTransparencyValue"));
    }

    private void createSplitterConfigPanel() {
        String string = "Splitter Config";
        this.splitterConfigPanel = Otu2xpCardProvPane.createVerticalPanel(string);
        this.termModeSplitter = this.addComboBox(this.splitterConfigPanel, "Termination Mode:  ", this.getAttributeFor("declTermModeFullSet"));
        this.termModeSplitter.setEnabled(true);
        this.framingTypeSplitter = this.addTextPanel(this.splitterConfigPanel, "Framing Type:", 20);
        this.framingTypeSplitter.setEditable(false);
        this.aisSquelchSplitter = this.addComboBox(this.splitterConfigPanel, "AIS/Squelch:", this.getAttributeFor("aisSquelch"));
        this.oduTransparencySplitter = this.addComboBox(this.splitterConfigPanel, "ODU Transparency:", this.getAttributeFor("OduTransparencyValue"));
        this.oduTransparencySplitter.setEnabled(false);
    }

    AbstractDwdmLineModel getLineModel(int n) {
        AbstractDwdmLineModel abstractDwdmLineModel = null;
        for (int i = 0; i < this.lineModels.length; ++i) {
            try {
                if (this.lineModels[i].getPortModel().getPortNum()[0] != n) continue;
                abstractDwdmLineModel = this.lineModels[i];
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return abstractDwdmLineModel;
    }

    public boolean isInterface1to3configured() {
        boolean bl = false;
        try {
            if (this.getLineModel(1) != null && this.getLineModel(3) != null) {
                this.getLineModel(1).getDwdmLineConfig();
                this.getLineModel(3).getDwdmLineConfig();
                bl = true;
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                db.println("No Such Interface Exception in isInterface1to3configured");
            }
            bl = false;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            if (db.on()) {
                db.println("Wrong Interface Type Exception in isInterface1to3configured");
            }
            bl = false;
        }
        return bl;
    }

    public boolean isInterface2to4configured() {
        boolean bl = false;
        try {
            if (this.getLineModel(2) != null && this.getLineModel(4) != null) {
                this.getLineModel(2).getDwdmLineConfig();
                this.getLineModel(4).getDwdmLineConfig();
                bl = true;
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                db.println("No Such Interface Exception in isInterface2to4configured");
            }
            bl = false;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            if (db.on()) {
                db.println("Wrong Interface Type Exception in isInterface2to4configured");
            }
            bl = false;
        }
        return bl;
    }

    public boolean isInterface3to4configured() {
        boolean bl = false;
        try {
            if (this.getLineModel(3) != null && this.getLineModel(4) != null) {
                this.getLineModel(3).getDwdmLineConfig();
                this.getLineModel(4).getDwdmLineConfig();
                bl = true;
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                db.println("No Such Interface Exception in isInterface3to4configured");
            }
            bl = false;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            if (db.on()) {
                db.println("Wrong Interface Type Exception in isInterface3to4configured");
            }
            bl = false;
        }
        return bl;
    }

    public void resetCardPane() {
        int n;
        Attribute attribute = this.getAttributeValFor("Otu2xpCardModes", 0);
        ActionListener[] actionListenerArray = this.cardMode.getActionListeners();
        for (n = 0; n < actionListenerArray.length; ++n) {
            this.cardMode.removeActionListener(actionListenerArray[n]);
        }
        this.cardMode.setSelectedItem(attribute);
        for (n = 0; n < actionListenerArray.length; ++n) {
            this.cardMode.addActionListener(actionListenerArray[n]);
        }
        if (!(this.isInterface3to4configured() || this.isInterface2to4configured() || this.isInterface1to3configured())) {
            this.cardMode.setEnabled(false);
        }
        this.cardConfigPanel.removeAll();
        this.cardConfigPanel.repaint();
        this.cardConfigPanel.revalidate();
    }

    public void refreshFromModel() throws Exception {
        block34: {
            int n;
            if (this.lineModels.length <= 0) {
                this.resetCardPane();
                this.resetDirty();
                return;
            }
            if (!(this.isInterface1to3configured() || this.isInterface2to4configured() || this.isInterface3to4configured())) {
                this.resetCardPane();
                this.resetDirty();
                return;
            }
            this.cardMode.setEnabled(true);
            if (db.on()) {
                db.println("In refreshFromModel() for Otu2xp Card pane");
            }
            if (this.isInterface1to3configured()) {
                this.lineConfig1to3 = this.getLineModel(1).getDwdmLineConfig();
            }
            if (this.isInterface2to4configured()) {
                this.lineConfig2to4 = this.getLineModel(2).getDwdmLineConfig();
            }
            if (this.isInterface3to4configured()) {
                this.lineConfig3to4 = this.getLineModel(3).getDwdmLineConfig();
            }
            this.cardConfigPanel.removeAll();
            try {
                this.otu2xpCardMode = this.otu2xpModel.getCardMode();
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
                return;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
                return;
            }
            if (this.otu2xpCardMode == 5 || this.otu2xpCardMode == 6) {
                if (this.isInterface1to3configured() && this.isInterface3to4configured()) {
                    this.cardConfigPanel.add(this.splitterConfigPanel);
                    this.cardMode.addItem(SPLITTER_MODE_STRING);
                    this.cardMode.setSelectedItem(SPLITTER_MODE_STRING);
                    this.cardMode.setEnabled(false);
                    this.updateSplitterConfigPanel();
                }
                this.resetDirty();
                return;
            }
            this.cardMode.removeItem(SPLITTER_MODE_STRING);
            this.cardMode.setEnabled(true);
            ActionListener[] actionListenerArray = this.cardMode.getActionListeners();
            for (n = 0; n < actionListenerArray.length; ++n) {
                this.cardMode.removeActionListener(actionListenerArray[n]);
            }
            this.cardMode.setSelectedIndex(this.otu2xpCardMode);
            for (n = 0; n < actionListenerArray.length; ++n) {
                this.cardMode.addActionListener(actionListenerArray[n]);
            }
            if (this.otu2xpCardMode != 2) {
                block33: {
                    if (this.isInterface1to3configured()) {
                        this.cardConfigPanel.add(this.port1to3ConfigPanel);
                        try {
                            this.updatePort1to3ConfigPanel();
                        }
                        catch (NoSuchInterface noSuchInterface) {
                            if (db.on()) {
                                SDebug.printStackTrace((Throwable)noSuchInterface);
                            }
                        }
                        catch (WrongInterfaceType wrongInterfaceType) {
                            if (!db.on()) break block33;
                            SDebug.printStackTrace((Throwable)wrongInterfaceType);
                        }
                    }
                }
                if (this.isInterface2to4configured()) {
                    this.cardConfigPanel.add(this.port2to4ConfigPanel);
                    try {
                        this.updatePort2to4ConfigPanel();
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)noSuchInterface);
                        }
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)wrongInterfaceType);
                        }
                    }
                }
            } else if (this.isInterface3to4configured()) {
                this.cardConfigPanel.add(this.port3to4ConfigPanel);
                try {
                    this.updatePort3to4ConfigPanel();
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)noSuchInterface);
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) break block34;
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
        }
        this.resetDirty();
    }

    public void updatePort1to3ConfigPanel() throws NoSuchInterface, WrongInterfaceType {
        if (this.otu2xpModel.getCardMode() == 3) {
            this.portMode1to3.setEnabled(true);
        } else {
            this.portMode1to3.setEnabled(false);
        }
        this.port1To3ModeVal = this.otu2xpModel.getPort1to3Mode();
        this.termMode1to3.setSelectedItem(this.getAttributeValFor("declTermModeFullSet", this.lineConfig1to3.termMode.value()));
        int n = this.getLineModel(1).getFramingType();
        this.framingType1to3.setText(this.getFramingTypeString(n));
        if (n == 2 || n == 3) {
            this.aisSquelch1to3.setEnabled(false);
            this.termMode1to3.setEnabled(false);
        }
        if (this.lineConfig1to3.termMode != eTermMode.TERM_TRANSPARENT) {
            this.aisSquelch1to3.setEnabled(false);
        }
        this.aisSquelch1to3.setSelectedItem(this.getAttributeValFor("aisSquelch", this.lineConfig1to3.aisSquelch.value()));
        this.regenLineName1to3.setText(this.lineConfig1to3.regenLineName);
        this.oduTransparency1to3.setSelectedItem(this.getAttributeValFor("OduTransparencyValue", this.lineConfig1to3.oduTransparency.value()));
        if (this.otu2xpCardMode == 4) {
            if (this.portMode1to3.getItemAt(2) == null) {
                this.portMode1to3.addItem(this.getAttributeValFor("Otu2xpCardModes", 4));
            }
        } else if (this.portMode1to3.getItemAt(2) != null) {
            this.portMode1to3.removeItem(this.getAttributeValFor("Otu2xpCardModes", 4));
        }
        this.portMode1to3.setSelectedItem(this.getAttributeValFor("Otu2xpCardModes", this.port1To3ModeVal));
    }

    public void updatePort2to4ConfigPanel() throws NoSuchInterface, WrongInterfaceType {
        if (this.otu2xpModel.getCardMode() == 3 || this.otu2xpModel.getCardMode() == 4) {
            this.portMode2to4.setEnabled(true);
        } else {
            this.portMode2to4.setEnabled(false);
        }
        this.port2To4ModeVal = this.otu2xpModel.getPort2to4Mode();
        this.termMode2to4.setSelectedItem(this.getAttributeValFor("declTermModeFullSet", this.lineConfig2to4.termMode.value()));
        int n = this.getLineModel(2).getFramingType();
        this.framingType2to4.setText(this.getFramingTypeString(n));
        if (n == 2 || n == 3) {
            this.aisSquelch2to4.setEnabled(false);
            this.termMode2to4.setEnabled(false);
        }
        if (this.lineConfig2to4.termMode != eTermMode.TERM_TRANSPARENT) {
            this.aisSquelch2to4.setEnabled(false);
        }
        this.aisSquelch2to4.setSelectedItem(this.getAttributeValFor("aisSquelch", this.lineConfig2to4.aisSquelch.value()));
        this.regenLineName2to4.setText(this.lineConfig2to4.regenLineName);
        this.oduTransparency2to4.setSelectedItem(this.getAttributeValFor("OduTransparencyValue", this.lineConfig2to4.oduTransparency.value()));
        this.portMode2to4.setSelectedItem(this.getAttributeValFor("Otu2xpCardModes", this.port2To4ModeVal));
    }

    public void updatePort3to4ConfigPanel() throws NoSuchInterface, WrongInterfaceType {
        this.port3To4ModeVal = this.otu2xpModel.getPort3to4Mode();
        this.termMode3to4.setSelectedItem(this.getAttributeValFor("declTermModeFullSet", this.lineConfig3to4.termMode.value()));
        int n = this.getLineModel(3).getFramingType();
        this.framingType3to4.setText(this.getFramingTypeString(n));
        if (n == 2 || n == 3) {
            this.aisSquelch3to4.setEnabled(false);
            this.termMode3to4.setEnabled(false);
        }
        if (this.lineConfig3to4.termMode != eTermMode.TERM_TRANSPARENT) {
            this.aisSquelch3to4.setEnabled(false);
        }
        this.aisSquelch3to4.setSelectedItem(this.getAttributeValFor("aisSquelch", this.lineConfig3to4.aisSquelch.value()));
        this.regenLineName3to4.setText(this.lineConfig3to4.regenLineName);
        this.oduTransparency3to4.setSelectedItem(this.getAttributeValFor("OduTransparencyValue", this.lineConfig3to4.oduTransparency.value()));
        this.portMode3to4.setSelectedItem(this.getAttributeValFor("Otu2xpCardModes", this.port3To4ModeVal));
    }

    public void updateSplitterConfigPanel() throws NoSuchInterface, WrongInterfaceType {
        this.termModeSplitter.setSelectedItem(this.getAttributeValFor("declTermModeFullSet", this.lineConfig1to3.termMode.value()));
        int n = this.getLineModel(1).getFramingType();
        this.framingTypeSplitter.setText(this.getFramingTypeString(n));
        if (n == 2 || n == 3 || this.lineConfig1to3.termMode != eTermMode.TERM_TRANSPARENT) {
            this.aisSquelchSplitter.setEnabled(false);
        }
        this.aisSquelchSplitter.setSelectedItem(this.getAttributeValFor("aisSquelch", this.lineConfig1to3.aisSquelch.value()));
        this.oduTransparencySplitter.setSelectedItem(this.getAttributeValFor("OduTransparencyValue", this.lineConfig1to3.oduTransparency.value()));
    }

    public void saveDwdmLineConfig1to3() throws NoSuchInterface, WrongInterfaceType {
        this.lineConfig1to3.aisSquelch = eAisSquelchMode.from_int(((Attribute)this.aisSquelch1to3.getSelectedItem()).getIntValue());
        this.lineConfig1to3.regenLineName = this.regenLineName1to3.getText();
        this.lineConfig1to3.termMode = eTermMode.from_int(this.termMode1to3.getSelectedIndex());
        boolean bl = this.portMode1to3.getSelectedIndex() == 1;
        this.lineConfig1to3.regenPeerLineIndex = bl ? this.getLineModel(3).getIndex() : 0;
        this.lineConfig1to3.wavelength = this.getLineModel((int)1).getDwdmLineConfig().wavelength;
        this.lineConfig1to3.oduTransparency = eDwdmOduTransparency.from_int(this.oduTransparency1to3.getSelectedIndex());
        this.lineConfig1to3.isLanWanMode = this.cardMode.getSelectedIndex() == 4;
    }

    public void saveDwdmLineConfig2to4() throws NoSuchInterface, WrongInterfaceType {
        this.lineConfig2to4.aisSquelch = eAisSquelchMode.from_int(((Attribute)this.aisSquelch2to4.getSelectedItem()).getIntValue());
        this.lineConfig2to4.regenLineName = this.regenLineName2to4.getText();
        boolean bl = this.portMode2to4.getSelectedIndex() == 1;
        this.lineConfig2to4.regenPeerLineIndex = bl ? this.getLineModel(4).getIndex() : 0;
        this.lineConfig2to4.termMode = eTermMode.from_int(this.termMode2to4.getSelectedIndex());
        this.lineConfig2to4.wavelength = this.getLineModel((int)2).getDwdmLineConfig().wavelength;
        this.lineConfig2to4.oduTransparency = eDwdmOduTransparency.from_int(this.oduTransparency2to4.getSelectedIndex());
        this.lineConfig2to4.isLanWanMode = false;
    }

    public void saveDwdmLineConfig3to4() throws NoSuchInterface, WrongInterfaceType {
        this.lineConfig3to4.aisSquelch = eAisSquelchMode.from_int(((Attribute)this.aisSquelch3to4.getSelectedItem()).getIntValue());
        this.lineConfig3to4.regenLineName = this.regenLineName3to4.getText();
        boolean bl = 2 == ((Attribute)this.cardMode.getSelectedItem()).getIntValue();
        this.lineConfig3to4.regenPeerLineIndex = bl ? this.getLineModel(4).getIndex() : 0;
        this.lineConfig3to4.termMode = eTermMode.from_int(this.termMode3to4.getSelectedIndex());
        this.lineConfig3to4.oduTransparency = eDwdmOduTransparency.from_int(this.oduTransparency3to4.getSelectedIndex());
        this.lineConfig3to4.isLanWanMode = false;
    }

    public void saveDwdmLineConfigSplitter() throws NoSuchInterface, WrongInterfaceType {
        this.lineConfig1to3.aisSquelch = eAisSquelchMode.from_int(((Attribute)this.aisSquelchSplitter.getSelectedItem()).getIntValue());
        this.lineConfig1to3.termMode = eTermMode.from_int(this.termModeSplitter.getSelectedIndex());
        this.lineConfig1to3.wavelength = this.getLineModel((int)1).getDwdmLineConfig().wavelength;
        this.lineConfig1to3.oduTransparency = eDwdmOduTransparency.from_int(this.oduTransparencySplitter.getSelectedIndex());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block68: {
            Object object = actionEvent.getSource();
            if (db.on()) {
                db.println("In actionPerformed() for Otu2xp Card pane");
            }
            try {
                int n;
                if (object == this.cardMode) {
                    n = 0;
                    try {
                        n = this.otu2xpModel.getCardMode();
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)noSuchInterface);
                        }
                        return;
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)wrongInterfaceType);
                        }
                        return;
                    }
                    this.otu2xpCardMode = this.cardMode.getSelectedIndex();
                    if (this.otu2xpCardMode == 5 || this.otu2xpCardMode == 6) {
                        if (this.isInterface1to3configured() && this.isInterface3to4configured()) {
                            this.cardConfigPanel.add(this.splitterConfigPanel);
                            this.updateSplitterConfigPanel();
                        }
                        this.resetDirty();
                        return;
                    }
                    if (this.otu2xpCardMode == 0) {
                        if (n == 4 && !ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)EMC.WID_OTU2_CARD_MODE_CHANGE_FROM_LANTOWAN, "Change Card Mode")) {
                            this.refreshFromModel();
                            this.resetDirty();
                            return;
                        }
                        this.cardConfigPanel.removeAll();
                        if (this.isInterface1to3configured()) {
                            this.cardConfigPanel.add(this.port1to3ConfigPanel);
                            if (this.portMode1to3.getItemAt(2) != null) {
                                this.portMode1to3.removeItem(this.getAttributeValFor("Otu2xpCardModes", 4));
                            }
                            this.portMode1to3.setSelectedItem(this.getAttributeValFor("Otu2xpCardModes", 0));
                            this.portMode1to3.setEnabled(false);
                            this.aisSquelch1to3.setEnabled(true);
                            this.regenLineName1to3.setEnabled(false);
                        }
                        if (this.isInterface2to4configured()) {
                            this.cardConfigPanel.add(this.port2to4ConfigPanel);
                            this.portMode2to4.setSelectedItem(this.getAttributeValFor("Otu2xpCardModes", 0));
                            this.portMode2to4.setEnabled(false);
                            this.aisSquelch2to4.setEnabled(true);
                            this.regenLineName2to4.setEnabled(false);
                        }
                        if (!this.isInterface1to3configured() && !this.isInterface2to4configured() && this.isInterface3to4configured()) {
                            this.setDirty();
                            this.cardConfigPanel.repaint();
                            return;
                        }
                    } else if (this.otu2xpCardMode == 1) {
                        if (n == 2 || n == 4) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CARD_MODE);
                            this.refreshFromModel();
                            this.resetDirty();
                            return;
                        }
                        this.cardConfigPanel.removeAll();
                        if (this.isInterface1to3configured()) {
                            this.cardConfigPanel.add(this.port1to3ConfigPanel);
                            this.portMode1to3.setSelectedItem(this.getAttributeValFor("Otu2xpCardModes", 1));
                            this.portMode1to3.setEnabled(false);
                            this.aisSquelch1to3.setEnabled(false);
                            this.regenLineName1to3.setEnabled(true);
                        }
                        if (this.isInterface2to4configured()) {
                            this.cardConfigPanel.add(this.port2to4ConfigPanel);
                            this.portMode2to4.setSelectedItem(this.getAttributeValFor("Otu2xpCardModes", 1));
                            this.portMode2to4.setEnabled(false);
                            this.aisSquelch2to4.setEnabled(false);
                            this.regenLineName2to4.setEnabled(true);
                        }
                    } else if (this.otu2xpCardMode == 3) {
                        if (n == 2) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CARD_MODE);
                            this.refreshFromModel();
                            this.resetDirty();
                            return;
                        }
                        if (n == 4 && !ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)EMC.WID_OTU2_CARD_MODE_CHANGE_FROM_LANTOWAN, "Change Card Mode")) {
                            this.refreshFromModel();
                            this.resetDirty();
                            return;
                        }
                        this.cardConfigPanel.removeAll();
                        if (this.isInterface1to3configured()) {
                            this.cardConfigPanel.add(this.port1to3ConfigPanel);
                            if (this.portMode1to3.getItemAt(2) != null) {
                                this.portMode1to3.removeItem(this.getAttributeValFor("Otu2xpCardModes", 4));
                            }
                            this.portMode1to3.setEnabled(true);
                        }
                        if (this.isInterface2to4configured()) {
                            this.cardConfigPanel.add(this.port2to4ConfigPanel);
                            this.portMode2to4.setEnabled(true);
                        }
                    } else if (this.otu2xpCardMode == 4) {
                        if (n == this.otu2xpCardMode) {
                            return;
                        }
                        if (n == 2 || !this.isInterface1to3configured()) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CARD_MODE);
                            this.refreshFromModel();
                            this.resetDirty();
                            return;
                        }
                        if (!ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)EMC.WID_OTU2_CARD_MODE_CHANGE, "Change Card Mode")) {
                            this.refreshFromModel();
                            this.resetDirty();
                            return;
                        }
                        this.cardConfigPanel.removeAll();
                        if (this.isInterface1to3configured()) {
                            this.cardConfigPanel.add(this.port1to3ConfigPanel);
                            if (this.portMode1to3.getItemAt(2) == null) {
                                this.portMode1to3.addItem(this.getAttributeValFor("Otu2xpCardModes", 4));
                            }
                            this.portMode1to3.setSelectedIndex(2);
                            this.portMode1to3.setEnabled(false);
                            this.termMode1to3.setSelectedItem(this.getAttributeValFor("declTermModeFullSet", eTermMode.TERM_LINE.value()));
                            this.termMode1to3.setEnabled(false);
                            this.framingType1to3.setText(this.getFramingTypeString(2));
                            this.aisSquelch1to3.setSelectedItem(this.getAttributeValFor("aisSquelch", eAisSquelchMode.MODE_SQUELCH.value()));
                            this.regenLineName1to3.setEnabled(false);
                            this.oduTransparency1to3.setSelectedItem(this.getAttributeValFor("OduTransparencyValue", eDwdmOduTransparency.CISCO_EXTENDED_USE.value()));
                            this.oduTransparency1to3.setEnabled(false);
                        }
                        if (this.isInterface2to4configured()) {
                            this.cardConfigPanel.add(this.port2to4ConfigPanel);
                            this.portMode2to4.setEnabled(true);
                        }
                    } else if (this.otu2xpCardMode == 2) {
                        if (n == this.otu2xpCardMode) {
                            return;
                        }
                        if (n == 1 || n == 4 || n == 3 || !this.isInterface3to4configured()) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CARD_MODE);
                            this.refreshFromModel();
                            this.resetDirty();
                            return;
                        }
                        if (!ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)EMC.WID_EFEC_CARD_MODE, "Apply EFEC Mode")) {
                            this.refreshFromModel();
                            this.resetDirty();
                            return;
                        }
                        if (this.isInterface3to4configured()) {
                            this.cardConfigPanel.removeAll();
                            this.cardConfigPanel.add(this.port3to4ConfigPanel);
                            this.portMode3to4.setSelectedItem(this.getAttributeValFor("Otu2xpCardModes", 2));
                            this.portMode3to4.setEnabled(false);
                            this.aisSquelch3to4.setSelectedItem(this.getAttributeValFor("aisSquelch", 1));
                            this.aisSquelch3to4.setEnabled(false);
                        }
                    }
                }
                if (object == this.portMode1to3) {
                    if (this.portMode1to3.getSelectedIndex() == 1) {
                        this.termMode1to3.setSelectedItem(this.getAttributeValFor("declTermModeFullSet", 0));
                        this.termMode1to3.setEnabled(false);
                        this.oduTransparency1to3.setEnabled(true);
                        this.aisSquelch1to3.setEnabled(false);
                        this.regenLineName1to3.setEnabled(true);
                    } else {
                        this.termMode1to3.setEnabled(true);
                        this.oduTransparency1to3.setEnabled(false);
                        this.aisSquelch1to3.setEnabled(true);
                        this.regenLineName1to3.setEnabled(false);
                    }
                } else if (object == this.portMode2to4) {
                    if (this.portMode2to4.getSelectedIndex() == 1) {
                        this.termMode2to4.setSelectedItem(this.getAttributeValFor("declTermModeFullSet", 0));
                        this.termMode2to4.setEnabled(false);
                        this.oduTransparency2to4.setEnabled(true);
                        this.aisSquelch2to4.setEnabled(false);
                        this.regenLineName2to4.setEnabled(true);
                    } else {
                        this.termMode2to4.setEnabled(true);
                        this.oduTransparency2to4.setEnabled(false);
                        this.aisSquelch2to4.setEnabled(true);
                        this.regenLineName2to4.setEnabled(false);
                    }
                } else if (object == this.termMode1to3) {
                    if (this.termMode1to3.getSelectedItem() != this.getAttributeValFor("declTermModeFullSet", 0)) {
                        this.aisSquelch1to3.setSelectedItem(this.getAttributeValFor("aisSquelch", 1));
                        this.aisSquelch1to3.setEnabled(false);
                    } else {
                        this.aisSquelch1to3.setEnabled(true);
                    }
                } else if (object == this.termMode2to4) {
                    if (this.termMode2to4.getSelectedItem() != this.getAttributeValFor("declTermModeFullSet", 0)) {
                        this.aisSquelch2to4.setSelectedItem(this.getAttributeValFor("aisSquelch", 1));
                        this.aisSquelch2to4.setEnabled(false);
                    } else {
                        this.aisSquelch2to4.setEnabled(true);
                    }
                } else if (object == this.termModeSplitter) {
                    if (this.termModeSplitter.getSelectedItem() != this.getAttributeValFor("declTermModeFullSet", 0)) {
                        this.aisSquelchSplitter.setSelectedItem(this.getAttributeValFor("aisSquelch", 1));
                        this.aisSquelchSplitter.setEnabled(false);
                    } else {
                        this.aisSquelchSplitter.setEnabled(true);
                    }
                }
                if (this.isInterface1to3configured()) {
                    n = this.getLineModel(1).getFramingType();
                    if (n == 2 || n == 3) {
                        this.aisSquelch1to3.setEnabled(false);
                        this.aisSquelchSplitter.setEnabled(false);
                        this.termMode1to3.setEnabled(false);
                        this.termModeSplitter.setEnabled(false);
                    }
                    if (this.termMode1to3.getSelectedIndex() != 0) {
                        this.aisSquelch1to3.setEnabled(false);
                        this.aisSquelchSplitter.setEnabled(false);
                    }
                }
                if (this.isInterface2to4configured()) {
                    n = this.getLineModel(2).getFramingType();
                    if (n == 2 || n == 3) {
                        this.aisSquelch2to4.setEnabled(false);
                        this.termMode2to4.setEnabled(false);
                    }
                    if (this.termMode2to4.getSelectedIndex() != 0) {
                        this.aisSquelch2to4.setEnabled(false);
                    }
                }
                this.cardConfigPanel.repaint();
                this.cardConfigPanel.revalidate();
            }
            catch (Exception exception) {
                if (!db.on()) break block68;
                db.println("Exception in Action performed of OTU2XP card pane");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChangesToModel() throws Exception {
        block31: {
            String string = "";
            if (db.on()) {
                db.println("In applyChangesToModel() for Otu2xp Card pane");
            }
            try {
                this.setCursor(3);
                if (this.otu2xpCardMode == 5 || this.otu2xpCardMode == 6) {
                    if (this.isInterface3to4configured() && this.isInterface1to3configured()) {
                        this.saveDwdmLineConfigSplitter();
                        try {
                            if (db.on()) {
                                db.println("setDwdmLineConfig for Splitter config Interfaces ");
                            }
                            this.getLineModel(1).setDwdmLineConfig(this.lineConfig1to3);
                        }
                        catch (DetailedConfigError detailedConfigError) {
                            string = string + "Splitter Configuration Error:\n" + detailedConfigError.getMessage() + "\n";
                            this.refreshFromModel();
                        }
                    }
                    break block31;
                }
                if (this.otu2xpCardMode == 2) {
                    if (this.isInterface3to4configured()) {
                        this.saveDwdmLineConfig3to4();
                        try {
                            if (db.on()) {
                                db.println("setDwdmLineConfig for Interfaces 3-4 ");
                            }
                            this.getLineModel(3).setDwdmLineConfig(this.lineConfig3to4);
                        }
                        catch (DetailedConfigError detailedConfigError) {
                            string = string + "Line 3-4 Configuration Error:\n" + detailedConfigError.getMessage() + "\n";
                            this.refreshFromModel();
                        }
                    }
                    break block31;
                }
                if (this.otu2xpCardMode == 3 && this.portMode1to3.getSelectedIndex() == this.portMode2to4.getSelectedIndex()) {
                    String string2 = "In the mixed card mode, the ports 1-3 and 2-4 cannot beconfigured in the same mode.";
                    ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_INVALID_CARD_MODE, string2);
                    this.refreshFromModel();
                    this.resetDirty();
                    return;
                }
                if (this.isInterface1to3configured()) {
                    this.saveDwdmLineConfig1to3();
                    try {
                        if (db.on()) {
                            db.println("setDwdmLineConfig for Interfaces 1-3 ");
                        }
                        this.getLineModel(1).setDwdmLineConfig(this.lineConfig1to3);
                    }
                    catch (DetailedConfigError detailedConfigError) {
                        string = string + "Line 1-3 Configuration Error:\n" + detailedConfigError.getMessage() + "\n";
                        this.refreshFromModel();
                    }
                }
                if (this.isInterface2to4configured()) {
                    this.saveDwdmLineConfig2to4();
                    try {
                        if (db.on()) {
                            db.println("setDwdmLineConfig for Interfaces 2-4 ");
                        }
                        this.getLineModel(2).setDwdmLineConfig(this.lineConfig2to4);
                    }
                    catch (DetailedConfigError detailedConfigError) {
                        string = string + "Line 2-4 Configuration Error:\n" + detailedConfigError.getMessage() + "\n";
                        this.refreshFromModel();
                    }
                }
                if (this.otu2xpCardMode == 0 && !this.isInterface1to3configured() && !this.isInterface2to4configured() && this.isInterface3to4configured()) {
                    this.saveDwdmLineConfig3to4();
                    try {
                        if (db.on()) {
                            db.println("setDwdmLineConfig for Interfaces 3-4 ");
                        }
                        this.getLineModel(3).setDwdmLineConfig(this.lineConfig3to4);
                    }
                    catch (DetailedConfigError detailedConfigError) {
                        string = string + "Line 3-4 Configuration Error:\n" + detailedConfigError.getMessage() + "\n";
                        this.refreshFromModel();
                    }
                }
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Exception in Apply to model" + exception.getMessage());
                    SDebug.printStackTrace((Throwable)exception);
                }
                this.refreshFromModel();
            }
            finally {
                this.setCursor(0);
                if (string.equals("")) break block31;
                throw new ConfigError(string);
            }
        }
    }

    private String getFramingTypeString(int n) {
        if (3 == n) {
            return "FC";
        }
        if (4 == n) {
            return "OTN";
        }
        if (1 == n) {
            return "SDH";
        }
        if (0 == n) {
            return "SONET";
        }
        if (2 == n) {
            return "ETHERNET";
        }
        if (5 == n) {
            return "UNFRAMED";
        }
        return "";
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        this.lineModels = this.eqpmtModel.getDwdmLineModels();
        this.refreshFromModel();
    }

    protected void registerWithModel() {
        super.registerWithModel();
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = this.eqpmtModel.getDwdmLineModels();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            abstractDwdmLineModelArray[i].addObserver((Observer)((Object)this));
        }
        this.registerForLineUpdates();
    }

    protected void unRegisterWithModel() {
        super.unRegisterWithModel();
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = this.eqpmtModel.getDwdmLineModels();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            abstractDwdmLineModelArray[i].deleteObserver((Observer)((Object)this));
        }
    }

    public void update(Observable observable, Object object) {
        block9: {
            block8: {
                super.update(observable, object);
                if (observable == this.eqpmtModel || observable instanceof DwdmTrkLineModel) {
                    try {
                        if (db.on()) {
                            db.println(" Update for line #" + ((DwdmTrkLineModel)((Object)observable)).getPort().getPortNum()[0]);
                            db.println("Update Type : " + object);
                        }
                        this.lineModels = this.eqpmtModel.getDwdmLineModels();
                        this.registerWithModel();
                        this.requestRefresh(observable, this.getRefreshThread(observable));
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block8;
                        exception.printStackTrace();
                    }
                }
            }
            if (object instanceof DwdmLineUpdate) {
                try {
                    this.lineModels = ((DwdmLineUpdate)object).getDwdmLineModels();
                    if (db.on()) {
                        db.println(" Update for Add/delete of PPMs : Total PPMs : " + this.lineModels.length);
                    }
                    this.registerWithModel();
                    this.requestRefresh(observable, this.getRefreshThread(observable));
                }
                catch (Exception exception) {
                    if (!db.on()) break block9;
                    exception.printStackTrace();
                }
            }
        }
    }

    protected Runnable getRefreshThread(Observable observable) {
        return new Runnable(){

            public void run() {
                block2: {
                    try {
                        Otu2xpCardProvPane.this.refreshFromModel();
                    }
                    catch (Exception exception) {
                        if (!DwdmCardProvPane.db.on()) break block2;
                        exception.printStackTrace();
                    }
                }
            }
        };
    }
}

