/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvOpticsCardModel;
import cerent.cms.fv.IFvOpticsPortModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.fv.IFvSideModel;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.functional.DirectionLessSideModel;
import cerent.cms.ui.functional.FunctBandDomainGrapher;
import cerent.cms.ui.functional.FunctBandPortGraphic;
import cerent.cms.ui.functional.FunctCardGrapher;
import cerent.cms.ui.functional.FunctFiberGrapher;
import cerent.cms.ui.functional.FunctFiberPortGraphic;
import cerent.cms.ui.functional.FunctNodeCardElem;
import cerent.cms.ui.functional.FunctPSMCardGrapher;
import cerent.cms.ui.functional.FunctPassiveDCUCardGrapher;
import cerent.cms.ui.functional.FunctSideViewLink;
import cerent.cms.ui.functional.FunctTxpCreator;
import cerent.cms.ui.functional.FunctTxpCreatorFactory;
import cerent.cms.ui.functional.FunctViewPureGraphicalLink;
import cerent.cms.ui.functional.WxcFunctCardGrapher;
import cerent.cms.ui.functional.helper.MPOHelper;
import cerent.cms.ui.functional.helper.SvgFactoryDirector;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.UPopupMenu;
import cerent.util.view.fv.GrapherViewCommand;
import cerent.util.view.fv.ISvgParams;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewLink;
import cerent.util.view.fv.IViewShapeInfo;
import cerent.util.view.fv.IViewSvg;
import cerent.util.view.fv.MouseViewCommand;
import cerent.util.view.fv.ViewAttribute;
import cerent.util.view.fv.ViewBandDomainGrapher;
import cerent.util.view.fv.ViewCardGrapher;
import cerent.util.view.fv.ViewCompositeGraphic;
import cerent.util.view.fv.ViewDomainGrapher;
import cerent.util.view.fv.ViewDwdmSide;
import cerent.util.view.fv.ViewGeneralCompositeGraphic;
import cerent.util.view.fv.ViewGraphLabel;
import cerent.util.view.fv.ViewGrapher;
import cerent.util.view.fv.ViewGraphicSet;
import cerent.util.view.fv.ViewHalfZoomingGraphic;
import cerent.util.view.fv.ViewInternalLink;
import cerent.util.view.fv.ViewLink;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.ViewPin;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.ViewShapeInfo;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.FunctException;
import cerent.util.view.fv.helper.IFunctNode;
import cerent.util.view.fv.helper.SvgParams;
import cerent.util.view.fv.helper.SvgParamsHelper;
import cerent.util.view.fv.helper.ViewModelUpdateType;
import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.event.ManagerSelectionListener;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.graphic.composite.layout.IlvAttachmentLocation;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalConstraint;
import ilog.views.graphlayout.hierarchical.IlvRelativePositionConstraint;
import ilog.views.graphlayout.hierarchical.IlvSameLevelConstraint;
import ilog.views.graphlayout.link.longlink.IlvLongLinkLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctDomainGrapher
extends ViewDomainGrapher
implements ActionListener {
    protected ActionOrganizer actOrg = null;
    private WxcFunctCardGrapher wxcCard = null;
    private IFvSideModel[] domSideModel = new IFvSideModel[]{null, null, null};
    private ViewGraphicSet vgSet;
    private List<FunctPassiveDCUCardGrapher> usedDcu = new ArrayList<FunctPassiveDCUCardGrapher>();
    private HashMap<String, FunctBandPortGraphic> allBandPort = new HashMap();

    public FunctDomainGrapher(SvgParams svgParams, ViewGraphicSet viewGraphicSet) {
        super((ISvgParams)svgParams);
        this.vgSet = viewGraphicSet;
        this.layout.getNodeLayout().setFlowDirection(2);
        this.layout.getNodeLayout().setVerticalNodeOffset(100.0f);
        this.layout.getNodeLayout().setHorizontalNodeOffset(100.0f);
        ((IlvLongLinkLayout)this.layout.getLinkLayout()).setMinStartSegmentLength(5.0f);
        ((IlvLongLinkLayout)this.layout.getLinkLayout()).setMinEndSegmentLength(5.0f);
        this.setKeepingAspectRatio(true);
    }

    public void init() {
        this.initShapeinfo();
        this.regForEvents();
        this.initdbg();
        this.initSelection();
        try {
            this.initViewGraphic(this.vgSet);
            ArrayList arrayList = this.getViewManager().getLinksBySide(this.getViewManager().getNodeLinks(), ViewDwdmSide.getSideLabelFromId((int)this.domSideModel[0].getId()));
            Map map = this.getViewManager().getDomainSortedCards(this.domSideModel, arrayList);
            if (this.getViewManager().isFromNfv()) {
                this.addSideName(this.domSideModel[0]);
            } else if (this.nm.getIFvAlarmStore() != null) {
                this.addAlarmGrapher(this.domSideModel[0]);
            }
            this.initDomainCards(map);
            try {
                this.updateLocalLinks(arrayList);
            }
            catch (FunctException functException) {
                FunctDebug.printStackTrace((Throwable)functException);
            }
            this.initPatchPanel(arrayList, (Map)map.get(ViewManager.ViewPortTypeEnum.PROT));
            int n = this.layout.performLayout(true, true, true);
            if (n != 5 && this.db.on()) {
                this.db.println("Layout not done");
            }
        }
        catch (RuntimeException runtimeException) {
            FunctDebug.printStackTrace((Throwable)runtimeException);
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            FunctDebug.printStackTrace((Throwable)ilvGraphLayoutException);
        }
    }

    public void addAlarmGrapher(IFvSideModel iFvSideModel) {
        IViewGraph iViewGraph = null;
        int n = 9;
        if (this.getViewManager().isFromNfv()) {
            n = 11;
        }
        try {
            SvgParams svgParams = new SvgParams(this.getNode(), this.getViewManager(), n, (IViewGraph)this, (Object)("AlarmGrapher" + iFvSideModel.getNameLabel()), (Object)iFvSideModel, IViewGraph.Layers.Alarm);
            iViewGraph = SvgFactoryDirector.getDefaultViewElem(svgParams);
        }
        catch (FunctException functException) {
            FunctDebug.printStackTrace((Throwable)functException);
        }
        catch (Exception exception) {
            FunctDebug.printStackTrace((Throwable)exception);
        }
        this.setMovable((IlvGraphic)iViewGraph);
        if (iViewGraph != null) {
            this.addGraphNode(iViewGraph, true, IViewGraph.Layers.Alarm);
        }
    }

    public void addNodeName() {
        ViewHalfZoomingGraphic viewHalfZoomingGraphic;
        IViewGraph iViewGraph = null;
        try {
            viewHalfZoomingGraphic = new SvgParams(this.getNode(), this.getViewManager(), 12, (Object)"NODE_NAME", (Object)this.getNode().getName(), IViewGraph.Layers.SideDecoration);
            iViewGraph = SvgFactoryDirector.getDefaultViewElem((SvgParams)viewHalfZoomingGraphic);
        }
        catch (FunctException functException) {
            FunctDebug.printStackTrace((Throwable)functException);
        }
        catch (Exception exception) {
            FunctDebug.printStackTrace((Throwable)exception);
        }
        viewHalfZoomingGraphic = new ViewHalfZoomingGraphic((ViewGeneralCompositeGraphic)iViewGraph, 8);
        if (viewHalfZoomingGraphic != null) {
            this.addGraphNode((IViewGraph)viewHalfZoomingGraphic, true, IViewGraph.Layers.SideDecoration);
        }
        this.setMovable((IlvGraphic)viewHalfZoomingGraphic);
    }

    public void addSideName(IFvSideModel iFvSideModel) {
        ViewHalfZoomingGraphic viewHalfZoomingGraphic;
        IViewGraph iViewGraph = null;
        try {
            viewHalfZoomingGraphic = new SvgParams(this.getNode(), this.getViewManager(), 13, (Object)("SIDE_NAME-" + iFvSideModel.getName()), (Object)("Side: " + iFvSideModel.getName() + "\n" + this.getNode().getName()), IViewGraph.Layers.SideDecoration);
            iViewGraph = SvgFactoryDirector.getDefaultViewElem((SvgParams)viewHalfZoomingGraphic);
        }
        catch (FunctException functException) {
            FunctDebug.printStackTrace((Throwable)functException);
        }
        catch (Exception exception) {
            FunctDebug.printStackTrace((Throwable)exception);
        }
        viewHalfZoomingGraphic = new ViewHalfZoomingGraphic((ViewGeneralCompositeGraphic)iViewGraph, 8);
        if (viewHalfZoomingGraphic != null) {
            this.addGraphNode((IViewGraph)viewHalfZoomingGraphic, true, IViewGraph.Layers.SideDecoration);
        }
        this.setMovable((IlvGraphic)viewHalfZoomingGraphic);
    }

    public void addSource(ViewPin viewPin, boolean bl) {
        IViewGraph iViewGraph = null;
        try {
            SvgParams svgParams = null;
            svgParams = bl ? new SvgParams(this.getNode(), this.getViewManager(), 18, (Object)"BIDIRECTIONAL", null, IViewGraph.Layers.Ancillary) : new SvgParams(this.getNode(), this.getViewManager(), 14, (Object)"SOURCE", null, IViewGraph.Layers.Ancillary);
            iViewGraph = SvgFactoryDirector.getDefaultViewElem(svgParams);
        }
        catch (FunctException functException) {
            FunctDebug.printStackTrace((Throwable)functException);
        }
        catch (Exception exception) {
            FunctDebug.printStackTrace((Throwable)exception);
        }
        if (iViewGraph instanceof IlvGraphic) {
            viewPin.pinCompo.setChildren(1, (IlvGraphic)iViewGraph);
            viewPin.left = false;
            viewPin.bottom = true;
            viewPin.pinCompo.setConstraints(1, (Object)new IlvAttachmentConstraint(IlvAttachmentLocation.BottomRight, IlvAttachmentLocation.Center));
            if (this.isAddLabelFlipNeeded()) {
                this.rotateSourceDestination(viewPin);
            }
            this.allSourceDestination.put(viewPin.key, viewPin);
        }
    }

    public void addDestination(ViewPin viewPin, boolean bl) {
        IViewGraph iViewGraph = null;
        try {
            SvgParams svgParams = null;
            svgParams = bl ? new SvgParams(this.getNode(), this.getViewManager(), 18, (Object)"BIDIRECTIONAL", null, IViewGraph.Layers.Ancillary) : new SvgParams(this.getNode(), this.getViewManager(), 15, (Object)"DESTINATION", null, IViewGraph.Layers.Ancillary);
            iViewGraph = SvgFactoryDirector.getDefaultViewElem(svgParams);
        }
        catch (FunctException functException) {
            FunctDebug.printStackTrace((Throwable)functException);
        }
        catch (Exception exception) {
            FunctDebug.printStackTrace((Throwable)exception);
        }
        if (iViewGraph instanceof IlvGraphic) {
            if (bl) {
                viewPin.pinCompo.setChildren(1, (IlvGraphic)iViewGraph);
                viewPin.left = false;
                viewPin.bottom = true;
                viewPin.pinCompo.setConstraints(1, (Object)new IlvAttachmentConstraint(IlvAttachmentLocation.BottomRight, IlvAttachmentLocation.Center));
                if (this.isAddLabelFlipNeeded()) {
                    this.rotateSourceDestination(viewPin);
                }
            } else if (this.isAddLabelFlipNeeded()) {
                viewPin.pinCompo.setChildren(1, (IlvGraphic)iViewGraph);
                ((IlvGraphic)iViewGraph).rotate(((IlvGraphic)iViewGraph).getCenter(null), 180.0);
                viewPin.left = false;
                viewPin.bottom = false;
                viewPin.pinCompo.setConstraints(1, (Object)new IlvAttachmentConstraint(IlvAttachmentLocation.TopRight, IlvAttachmentLocation.Center));
            } else {
                viewPin.pinCompo.setChildren(1, (IlvGraphic)iViewGraph);
                viewPin.left = true;
                viewPin.bottom = true;
                viewPin.pinCompo.setConstraints(1, (Object)new IlvAttachmentConstraint(IlvAttachmentLocation.BottomLeft, IlvAttachmentLocation.Center));
            }
            this.allSourceDestination.put(viewPin.key, viewPin);
        }
    }

    public void dispose() {
        this.unregForEvents();
        this.actOrg = null;
        this.wxcCard = null;
        super.dispose();
    }

    private void regForEvents() {
        this.domSideModel[0].addObserver((Observer)((Object)this));
        if (this.domSideModel[1] != null) {
            this.domSideModel[1].addObserver((Observer)((Object)this));
        }
        if (this.domSideModel[2] != null) {
            this.domSideModel[2].addObserver((Observer)((Object)this));
        }
        if (this.domSideModel[2] != null) {
            this.domSideModel[2].addObserver((Observer)((Object)this));
        }
    }

    private void unregForEvents() {
        this.domSideModel[0].deleteObserver((Observer)((Object)this));
        if (this.domSideModel[1] != null) {
            this.domSideModel[1].deleteObserver((Observer)((Object)this));
        }
        if (this.domSideModel[2] != null) {
            this.domSideModel[2].deleteObserver((Observer)((Object)this));
        }
    }

    private void initdbg() {
        this.db = FunctDebug.instance().addChild("FunctDomainGrapher", "Dump the info related to Band Info");
    }

    private void initSelection() {
        this.addManagerSelectionListener((ManagerSelectionListener)new ViewDomainGrapher.MyViewDomainListener((ViewDomainGrapher)this));
    }

    private void initDomainCards(Map<ViewManager.ViewPortTypeEnum, Map<Integer, IFvCardModel>> map) {
        this.initFiberSideCards();
        this.initSideViewGraphs(map);
        this.updateFiberLinks();
    }

    protected boolean isDomain() {
        return true;
    }

    protected ViewGraphLabel createCardLabel(ViewAttribute viewAttribute) throws Exception {
        return (ViewGraphLabel)SvgFactoryDirector.getViewElem(SvgParamsHelper.getSvgLabelParams((IFvNodeModel)this.getNode(), (IViewGraph)this, (ViewAttribute)viewAttribute));
    }

    public String getGraphName() {
        return "DefaultDomainRect" + this.domSideModel[0].getNameLabel();
    }

    private void initFiberSideCards() {
        IFvCardModel iFvCardModel = null;
        IFvCardModel iFvCardModel2 = null;
        for (int i = 0; i < this.domSideModel.length; ++i) {
            int[] nArray;
            if (this.domSideModel[i] == null) continue;
            if (!(this.domSideModel[i] instanceof DirectionLessSideModel)) {
                this.addFiberGrapher(i, null);
            }
            for (int n : nArray = this.domSideModel[i].getLinesIn()) {
                iFvCardModel = (IFvCardModel)this.nm.getEntityModelByIndex(n).getParentModel();
                this.addCard(iFvCardModel);
            }
            for (int n : nArray = this.domSideModel[i].getLinesOut()) {
                iFvCardModel2 = (IFvCardModel)this.nm.getEntityModelByIndex(n).getParentModel();
                if (iFvCardModel.getIndex() == iFvCardModel2.getIndex()) continue;
                this.addCard(iFvCardModel2);
            }
        }
    }

    private void initPatchPanel(ArrayList<ViewInternalLink> arrayList, Map<Integer, IFvCardModel> map) {
        try {
            FunctTxpCreator functTxpCreator = FunctTxpCreatorFactory.functTxpCreator(arrayList, map, (ViewGrapher)this);
            if (functTxpCreator != null) {
                functTxpCreator.createAndLinkTxp((IViewGraph)this);
            }
        }
        catch (FunctException functException) {
            FunctDebug.printStackTrace((Throwable)functException);
        }
    }

    public static int getBandfromPos(int n, boolean bl) {
        if (bl) {
            return n / 16 + (n % 16 == 0 ? 0 : 1);
        }
        return n / 8 + (n % 8 == 0 ? 0 : 1);
    }

    private void initSideViewGraphs(Map<ViewManager.ViewPortTypeEnum, Map<Integer, IFvCardModel>> map) {
        HashMap hashMap = this.getGraphChildren();
        this.initSideGraphsCards(map.get(ViewManager.ViewPortTypeEnum.OTS), hashMap);
        this.initSideGraphsCards(map.get(ViewManager.ViewPortTypeEnum.DROP), hashMap);
        this.initSideGraphsCards(map.get(ViewManager.ViewPortTypeEnum.ADD), hashMap);
    }

    private void initSideGraphsCards(Map<Integer, IFvCardModel> map, HashMap<String, IViewGraph> hashMap) {
        for (IFvCardModel iFvCardModel : map.values()) {
            if (hashMap.containsKey(ViewManager.idToString((int)iFvCardModel.getIndex()))) continue;
            this.addCard(iFvCardModel);
        }
    }

    public void setMovable(IlvGraphic ilvGraphic) {
        if (this.getViewManager().isFromNfv() && ilvGraphic != null) {
            ilvGraphic.setMovable(false);
        }
    }

    private boolean addCard(IFvCardModel iFvCardModel) {
        if (iFvCardModel == null) {
            return false;
        }
        if (!iFvCardModel.isOpticsCard()) {
            return false;
        }
        IViewGraph iViewGraph = null;
        try {
            SvgParams svgParams = SvgParamsHelper.getSvgCardParams((IViewGraph)this, (ViewManager)this.getViewManager(), (IFvCardModel)iFvCardModel);
            if (!iFvCardModel.isPassiveModule() && ((IFvOpticsCardModel)iFvCardModel).isAmpliWithBoosterRole() && iFvCardModel.getEqType() != 287 && iFvCardModel.getEqType() != 321 && iFvCardModel.getEqType() != 295) {
                if (iFvCardModel.getEqType() == 281) {
                    svgParams.setOtherShapeToDisplay((IViewSvg.IViewSvgEnum)IViewSvg.SvgCardShape.BST_AMP);
                } else {
                    svgParams.setOtherShapeToDisplay((IViewSvg.IViewSvgEnum)IViewSvg.SvgCardShape.BST);
                }
            }
            if ((iViewGraph = SvgFactoryDirector.getViewElem(svgParams)) == null) {
                return false;
            }
            this.setMovable((IlvGraphic)iViewGraph);
            if (iViewGraph instanceof FunctPassiveDCUCardGrapher) {
                FunctPassiveDCUCardGrapher functPassiveDCUCardGrapher = this.addDcuNode((FunctPassiveDCUCardGrapher)iViewGraph);
                if (functPassiveDCUCardGrapher == null) {
                    this.addGraphNode(iViewGraph, false, IViewGraph.Layers.Card);
                } else {
                    try {
                        this.addGraphNode((IViewGraph)functPassiveDCUCardGrapher, false, IViewGraph.Layers.Card, iViewGraph.getGraphKey());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        FunctDebug.printStackTrace((Throwable)illegalArgumentException);
                    }
                }
            } else if (!(iViewGraph instanceof FunctPSMCardGrapher)) {
                this.addGraphNode(iViewGraph, false, IViewGraph.Layers.Card);
            } else if (((FunctPSMCardGrapher)iViewGraph).getProtectionType() != 1) {
                this.addGraphNode(iViewGraph, false, IViewGraph.Layers.Card);
                this.psmLineorPathPresent = (FunctPSMCardGrapher)iViewGraph;
            } else {
                return false;
            }
            if (((FunctCardGrapher)iViewGraph).isEvenCard()) {
                ((FunctCardGrapher)iViewGraph).doFlipH();
                ((ViewCompositeGraphic)iViewGraph).graphicFlipPortsLabel(1.0, -1.0);
            }
            switch (iFvCardModel.getEqType()) {
                case 130: 
                case 196: 
                case 239: {
                    if (!((IFvOpticsCardModel)iFvCardModel).isAmplitWithPreRole()) break;
                    ((FunctCardGrapher)iViewGraph).doFlipV();
                    ((FunctCardGrapher)iViewGraph).doFlipH();
                    ((ViewCompositeGraphic)iViewGraph).graphicFlipPortsLabel(-1.0, -1.0);
                    break;
                }
                case 266: 
                case 270: {
                    this.wxcCard = (WxcFunctCardGrapher)iViewGraph;
                }
            }
        }
        catch (FunctException functException) {
            FunctDebug.printStackTrace((Throwable)functException);
            return false;
        }
        catch (Exception exception) {
            FunctDebug.printStackTrace((Throwable)exception);
            return false;
        }
        return true;
    }

    private FunctPassiveDCUCardGrapher addDcuNode(FunctPassiveDCUCardGrapher functPassiveDCUCardGrapher) {
        FunctPassiveDCUCardGrapher functPassiveDCUCardGrapher2 = null;
        if (this.usedDcu.size() > 0) {
            for (FunctPassiveDCUCardGrapher functPassiveDCUCardGrapher3 : this.usedDcu) {
                if (!functPassiveDCUCardGrapher3.isContained(functPassiveDCUCardGrapher)) continue;
                functPassiveDCUCardGrapher2 = functPassiveDCUCardGrapher3;
                break;
            }
        }
        if (functPassiveDCUCardGrapher2 == null) {
            this.usedDcu.add(functPassiveDCUCardGrapher);
        }
        return functPassiveDCUCardGrapher2;
    }

    public WxcFunctCardGrapher getWxcToPPMashGraph() {
        return this.wxcCard;
    }

    public String getSideName() {
        return this.domSideModel[0].getNameLabel();
    }

    public int getSideId() {
        return this.domSideModel[0].getId();
    }

    public int getSideLabelValue() {
        return this.domSideModel[0].getNameLabelValue();
    }

    public int getSideRole() {
        return this.domSideModel[0].getRole();
    }

    public int getSideId(int n) {
        return this.domSideModel[n].getId();
    }

    public boolean hasProtection() {
        return this.domSideModel[1] != null;
    }

    protected void onInitPopupMenuDbg(UPopupMenu uPopupMenu) {
        this.actOrg = new ActionOrganizer(this);
        this.initPopupMenuDbg(uPopupMenu);
        this.actOrg = null;
    }

    public void onInitPopupMenu(UPopupMenu uPopupMenu) {
        this.actOrg = new ActionOrganizer(this);
        this.initPopupMenu(uPopupMenu);
        this.actOrg = null;
    }

    public void secondaryOnInitPopupMenu(UPopupMenu uPopupMenu) {
        this.actOrg = new ActionOrganizer(this);
        this.secInitPopupMenu(uPopupMenu);
        this.actOrg = null;
    }

    protected void secInitPopupMenu(UPopupMenu uPopupMenu) {
        uPopupMenu.addSeparator();
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Rotate Left", 76);
        this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Rotate Right", 82);
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        if (this.isCollapsed()) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Open Node", 68);
        } else if (this.isTheActiveGraph()) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Close Node", 85);
        }
    }

    protected void initPopupMenuDbg(UPopupMenu uPopupMenu) {
        if (!this.isCollapsed() && !this.isTheActiveGraph()) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Rotate Left", 76);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Rotate Right", 82);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Horizontal flip", 72);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Vertical flip", 86);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Close Node") {
            this.setMustFlip(true);
            this.getTk().doGoToRootGraph();
            this.flipComponents();
            this.performLayout(true, true, false);
            this.getTk().fitView();
        } else if (string == "Rotate Left") {
            this.doRotateL();
        } else if (string == "Rotate Right") {
            this.doRotateR();
        } else if (string == "Horizontal flip") {
            this.doFlipH();
        } else if (string == "Vertical flip") {
            this.doFlipV();
        } else if (string == "Perform AutoLayout") {
            this.doAutoLayout(true);
        } else if (string == "Fit to View") {
            this.fitToView();
            this.setMustFlip(false);
        } else if (string == "Go Back to Network FV") {
            this.getViewManager().getViewTk().goBackToNetFv();
        }
        this.getTk().invalidateView();
        this.getTk().reDraw();
    }

    public void doAutoLayout(boolean bl) {
        try {
            this.layout.performLayout(true, true, false);
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            FunctDebug.printStackTrace((Throwable)ilvGraphLayoutException);
        }
        this.getTk().fitView();
    }

    private void doRotateL() {
        this.doShapeRotate(new Double(-90.0));
    }

    private void doRotateR() {
        this.doShapeRotate(new Double(90.0));
    }

    public void doFlipH() {
        this.doFlipH(true);
    }

    public void doFlipH(boolean bl) {
        IViewShapeInfo iViewShapeInfo;
        iViewShapeInfo.setFlipH(!(iViewShapeInfo = this.getInfo()).getFlipH());
        if (bl) {
            this.initReDraws();
            this.invalidateRegion(this.boundingBox());
        }
        this.scale(1.0, -1.0);
        this.flipCardPortsLabel(1, -1);
        this.flipLinkBalloon(1, -1);
        this.setCoordinates(iViewShapeInfo.getCenterX(), iViewShapeInfo.getCenterY(), 0.0, true);
        if (bl) {
            this.invalidateRegion(this.boundingBox());
            this.reDrawViews();
        }
    }

    public void doFlipV() {
        this.doFlipV(true);
    }

    public void doFlipV(boolean bl) {
        IViewShapeInfo iViewShapeInfo;
        iViewShapeInfo.setFlipV(!(iViewShapeInfo = this.getInfo()).getFlipV());
        if (bl) {
            this.initReDraws();
            this.invalidateRegion(this.boundingBox());
        }
        this.scale(-1.0, 1.0);
        this.flipCardPortsLabel(-1, 1);
        this.flipLinkBalloon(-1, 1);
        this.setCoordinates(iViewShapeInfo.getCenterX(), iViewShapeInfo.getCenterY(), 0.0, true);
        if (bl) {
            this.invalidateRegion(this.boundingBox());
            this.reDrawViews();
        }
    }

    void doubleClicked() {
        this.getTk().displayDomain((ViewDomainGrapher)this);
    }

    public void doMouseClick(MouseViewCommand mouseViewCommand) {
        if (this.db.on()) {
            this.db.println("FunctDomainGrapher doMouseClick");
        }
    }

    public void doMouseDoubleClick(MouseViewCommand mouseViewCommand) {
        this.fitToView();
    }

    public void fitToView() {
        this.getTk().setGraph((IlvGrapher)this);
        this.getTk().fitView();
        this.setMustFlip(true);
        this.flipComponents();
        this.doAutoLayout(false);
    }

    public void fitParentToView(boolean bl) {
        this.getTk().setGraph((IlvGrapher)this);
        this.getTk().fitView();
        this.setMustFlip(bl);
        this.flipComponents();
        this.doAutoLayout(false);
    }

    public void mpoLinkVisible(boolean bl, int n) {
        Collection collection = this.getMpoLinks().values();
        for (IViewLink iViewLink : collection) {
            if (!(iViewLink instanceof FunctViewPureGraphicalLink) || ((FunctViewPureGraphicalLink)iViewLink).getEven() != n) continue;
            ((FunctViewPureGraphicalLink)iViewLink).setLinkVisible(bl);
            ((FunctViewPureGraphicalLink)iViewLink).reDraw();
        }
    }

    public void doMousePopup(MouseViewCommand mouseViewCommand) {
        if (this.db.on()) {
            this.db.println("doMousePopup");
        }
        UPopupMenu uPopupMenu = new UPopupMenu();
        this.onInitPopupMenu(uPopupMenu);
        if (mouseViewCommand.getKeyIntValue() == 8) {
            this.onInitPopupMenuDbg(uPopupMenu);
        }
        uPopupMenu.show((Component)mouseViewCommand.getViewManager().getViewTk(), mouseViewCommand.getEvent().getX(), mouseViewCommand.getEvent().getY());
    }

    public void doMouseUpdate(MouseViewCommand mouseViewCommand) {
        if (this.db.on()) {
            this.db.println("doMouseUpdate");
        }
    }

    public void doAdd(GrapherViewCommand grapherViewCommand) {
        IFunctNode iFunctNode = null;
        if (!(grapherViewCommand.getValue() instanceof IFunctNode)) {
            return;
        }
        iFunctNode = (IFunctNode)grapherViewCommand.getValue();
        this.addCard(((FunctNodeCardElem)iFunctNode).getCard());
        this.updateLinks(this.getViewManager().getLinksBySide(this.getViewManager().getNodeLinks(), this.domSideModel[0].getId()), ViewModelUpdateType.ADDED);
    }

    public void doDelete(GrapherViewCommand grapherViewCommand) {
    }

    public IViewGraph addFiberGrapher(int n, ViewCardGrapher viewCardGrapher) {
        if (this.getViewManager().isFromNfv()) {
            return null;
        }
        FunctFiberGrapher functFiberGrapher = null;
        try {
            SvgParams svgParams = new SvgParams(this.getNode(), this.getViewManager(), 3, (IViewGraph)this, (Object)("FiberGrapher" + this.domSideModel[n].getNameLabel()), (Object)this.domSideModel[n], IViewGraph.Layers.Card);
            functFiberGrapher = (FunctFiberGrapher)SvgFactoryDirector.getDefaultViewElem(svgParams);
            functFiberGrapher.setLinkedCard(viewCardGrapher);
        }
        catch (FunctException functException) {
            FunctDebug.printStackTrace((Throwable)functException);
        }
        catch (SAXException sAXException) {
            FunctDebug.printStackTrace((Throwable)sAXException);
        }
        catch (IOException iOException) {
            FunctDebug.printStackTrace((Throwable)iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FunctDebug.printStackTrace((Throwable)parserConfigurationException);
        }
        this.setMovable((IlvGraphic)functFiberGrapher);
        if (functFiberGrapher != null) {
            this.addGraphNode((IViewGraph)functFiberGrapher, true, IViewGraph.Layers.Card);
        }
        return functFiberGrapher;
    }

    public void doMouseDrag(MouseViewCommand mouseViewCommand) {
        if (this.boundingBox().getMinX() > 0.0) {
            this.shape.setCenterX(this.boundingBox().getCenterX());
        } else {
            this.shape.setCenterX(0.0);
        }
        if (this.boundingBox().getY() > 0.0) {
            this.shape.setCenterY(this.boundingBox().getCenterY());
        } else {
            this.shape.setCenterY(0.0);
        }
        if (!(this.boundingBox().getX() > 0.0) || !(this.boundingBox().getY() > 0.0)) {
            this.updateCoordinates();
        }
    }

    public void updateDomainLinks() {
        this.updateLinks(this.getViewManager().getLinksBySide(this.getViewManager().getNodeLinks(), this.domSideModel[0].getId()), ViewModelUpdateType.CHANGED);
    }

    public IViewGraph getFiberSideGrapher(int n) {
        return (IViewGraph)this.getGraphChildren().get(this.domSideModel[n].getName());
    }

    private void updateFiberLinks() {
        FunctCardGrapher functCardGrapher = null;
        FunctCardGrapher functCardGrapher2 = null;
        FunctSideViewLink functSideViewLink = null;
        if (this.getViewManager().isFromNfv()) {
            return;
        }
        for (int i = 0; i < this.domSideModel.length; ++i) {
            FunctFiberPortGraphic functFiberPortGraphic;
            ViewPortGraphic viewPortGraphic;
            if (this.domSideModel[i] == null || this.domSideModel[i] instanceof DirectionLessSideModel) continue;
            functCardGrapher = this.getLineCard(this.domSideModel[i].getLineOut());
            functCardGrapher2 = this.getLineCard(this.domSideModel[i].getLineIn());
            FunctFiberGrapher functFiberGrapher = (FunctFiberGrapher)this.getFiberSideGrapher(i);
            if (functCardGrapher != null) {
                viewPortGraphic = (ViewPortGraphic)functCardGrapher.getGraphChildren().get(ViewManager.idToString((int)this.domSideModel[i].getLineOut()));
                if (viewPortGraphic == null) {
                    viewPortGraphic = (ViewPortGraphic)functCardGrapher.getGraphChildren().get("FunctMpoPortGraphicMPO_PORT-SIDE-1-RX");
                }
                functFiberPortGraphic = functFiberGrapher.getLineIn();
                functSideViewLink = new FunctSideViewLink(this, this.getTk(), (ViewCompositeGraphic)functCardGrapher, (IViewGraph)viewPortGraphic, (ViewCompositeGraphic)functFiberGrapher, (IViewGraph)functFiberPortGraphic, true, this.getNodemodel());
                try {
                    this.connectPorts((ViewCompositeGraphic)functCardGrapher, viewPortGraphic, (ViewCompositeGraphic)functFiberGrapher, functFiberPortGraphic, (IViewLink)functSideViewLink);
                }
                catch (FunctException functException) {
                    FunctDebug.printStackTrace((Throwable)functException);
                }
                this.sideGraphLinks.put(256 + this.domSideModel[i].getId(), functSideViewLink);
            }
            if (functCardGrapher2 == null) continue;
            viewPortGraphic = (ViewPortGraphic)functCardGrapher2.getGraphChildren().get(ViewManager.idToString((int)this.domSideModel[i].getLineIn()));
            functFiberPortGraphic = functFiberGrapher.getLineOut();
            functSideViewLink = new FunctSideViewLink(this, this.getTk(), (ViewCompositeGraphic)functFiberGrapher, (IViewGraph)functFiberPortGraphic, (ViewCompositeGraphic)functCardGrapher2, (IViewGraph)viewPortGraphic, true, this.getNodemodel());
            try {
                this.connectPorts((ViewCompositeGraphic)functFiberGrapher, functFiberPortGraphic, (ViewCompositeGraphic)functCardGrapher2, viewPortGraphic, (IViewLink)functSideViewLink);
            }
            catch (FunctException functException) {
                FunctDebug.printStackTrace((Throwable)functException);
            }
            this.sideGraphLinks.put(512 + this.domSideModel[i].getId(), functSideViewLink);
        }
    }

    private FunctCardGrapher getLineCard(int n) {
        HashMap hashMap;
        IFvOpticsPortModel iFvOpticsPortModel = (IFvOpticsPortModel)this.nm.getEntityModelByIndex(n);
        if (iFvOpticsPortModel != null && (hashMap = ViewManager.getGraphCards((IViewGraph)this)).containsKey(String.valueOf(iFvOpticsPortModel.getParentModel().getEntityIndex()))) {
            return (FunctCardGrapher)hashMap.get(String.valueOf(iFvOpticsPortModel.getParentModel().getEntityIndex()));
        }
        return null;
    }

    protected void initShapeinfo() {
        this.shape = new ViewShapeInfo((ViewGrapher)this, this.domSideModel[0].getId());
    }

    public IFvSideModel getSideModel() {
        return this.domSideModel[0];
    }

    public IFvSideModel getSideModel(int n) {
        return this.domSideModel[0];
    }

    public String getGraphKey() {
        return this.key;
    }

    public void addLink(ViewPortGraphic viewPortGraphic, ViewPortGraphic viewPortGraphic2) {
    }

    public void delLink(IViewLink iViewLink) {
    }

    public ArrayList<ViewInternalLink> updateLinks(ArrayList<ViewInternalLink> arrayList, Integer n) {
        ArrayList arrayList2 = this.getViewManager().getLinksBySide(arrayList, this.domSideModel[0].getId());
        final ArrayList arrayList3 = ViewManager.getNewListItems((ArrayList)arrayList2, (ArrayList)ViewManager.getInternalLink((HashMap)this.graphLinks));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FunctDomainGrapher.this.notPerformLayout();
                try {
                    FunctDomainGrapher.this.updateLocalLinks(arrayList3);
                }
                catch (FunctException functException) {
                    FunctDebug.printStackTrace((Throwable)functException);
                }
                FunctDomainGrapher.this.redrawAllLinks();
                FunctDomainGrapher.this.doAutoLayout(false);
            }
        });
        return new ArrayList<ViewInternalLink>();
    }

    private void updateLocalLinks(ArrayList<ViewInternalLink> arrayList) throws FunctException {
        Iterator<ViewInternalLink> iterator = arrayList.iterator();
        int n = 1;
        ViewCompositeGraphic viewCompositeGraphic = null;
        ViewCompositeGraphic viewCompositeGraphic2 = null;
        while (iterator.hasNext()) {
            ViewInternalLink viewInternalLink = iterator.next();
            if (viewInternalLink.isTxpOrPsmtxpLnk()) continue;
            try {
                boolean bl;
                String string = null;
                String string2 = null;
                ViewCompositeGraphic viewCompositeGraphic3 = null;
                ViewCompositeGraphic viewCompositeGraphic4 = null;
                string = this.getCardKey(viewInternalLink, true);
                string2 = this.getCardKey(viewInternalLink, false);
                do {
                    viewCompositeGraphic3 = (ViewCompositeGraphic)this.getGraphChildren().get(string);
                    viewCompositeGraphic4 = (ViewCompositeGraphic)this.getGraphChildren().get(string2);
                    if (viewCompositeGraphic3 == null || viewCompositeGraphic4 == null) {
                        this.linkEndpointsExist(viewInternalLink, string, string2);
                        if (viewInternalLink.isPassiveLnk()) {
                            bl = false;
                            continue;
                        }
                        bl = true;
                        continue;
                    }
                    bl = false;
                } while (bl);
                if (viewCompositeGraphic3 instanceof FunctPassiveDCUCardGrapher && viewCompositeGraphic4 instanceof FunctPassiveDCUCardGrapher) continue;
                if (!viewInternalLink.isPassivePPmashLnk()) {
                    if (viewCompositeGraphic3 == null && viewCompositeGraphic4 == null) continue;
                    ViewPortGraphic viewPortGraphic = (ViewPortGraphic)viewCompositeGraphic3.getGraphChildren().get(ViewManager.idToString((int)viewInternalLink.getLink().getFrom()));
                    ViewPortGraphic viewPortGraphic2 = (ViewPortGraphic)viewCompositeGraphic4.getGraphChildren().get(ViewManager.idToString((int)viewInternalLink.getLink().getTo()));
                    if (viewPortGraphic2 == null || viewPortGraphic == null) {
                        throw new FunctException("No port to create Link");
                    }
                    this.checkDCUConnection(viewInternalLink, (FunctCardGrapher)viewCompositeGraphic3, (FunctCardGrapher)viewCompositeGraphic4);
                    if (viewPortGraphic.linkIsVisible(viewInternalLink.getLink()) || viewPortGraphic2.linkIsVisible(viewInternalLink.getLink())) continue;
                    IViewLink iViewLink = this.getTk().createCardLink(viewInternalLink, viewCompositeGraphic3, viewPortGraphic, viewCompositeGraphic4, viewPortGraphic2, true);
                    try {
                        this.connectPorts(viewCompositeGraphic3, viewPortGraphic, viewCompositeGraphic4, viewPortGraphic2, iViewLink);
                    }
                    catch (FunctException functException) {
                        FunctDebug.printStackTrace((Throwable)functException);
                    }
                    this.graphLinks.put(iViewLink.getIndex(), (ViewLink)iViewLink);
                    ViewManager.addToLog((Object)this, (String)("added link " + iViewLink.getName() + " index=" + iViewLink.getIndex()));
                    viewInternalLink.getLink().addObserver((Observer)((Object)this));
                    if (this.addConstraints(viewCompositeGraphic3, viewCompositeGraphic4, n, false)) {
                        ++n;
                    }
                    if (viewCompositeGraphic3.getGraphName().contains("PSM") && viewPortGraphic.getGraphName().contains("COM")) {
                        viewCompositeGraphic = viewCompositeGraphic4;
                        continue;
                    }
                    if (!viewCompositeGraphic4.getGraphName().contains("PSM") || !viewPortGraphic2.getGraphName().contains("COM")) continue;
                    viewCompositeGraphic2 = viewCompositeGraphic3;
                    continue;
                }
                this.getViewManager().getViewTk().setWXConnect(viewInternalLink, true);
                this.getViewManager().getViewTk().addPPmashLinks(viewInternalLink);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                FunctDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        if (viewCompositeGraphic != null && viewCompositeGraphic2 != null) {
            this.addConstraints(viewCompositeGraphic, viewCompositeGraphic2, n, true);
        }
    }

    private boolean addConstraints(ViewCompositeGraphic viewCompositeGraphic, ViewCompositeGraphic viewCompositeGraphic2, int n, boolean bl) {
        if (bl) {
            this.layout.getNodeLayout().addConstraint((IlvHierarchicalConstraint)new IlvSameLevelConstraint((Object)viewCompositeGraphic, (Object)viewCompositeGraphic2));
            return true;
        }
        if (viewCompositeGraphic2.getGraphName().contains("PASSIVE DCU")) {
            IFvOpticsCardModel iFvOpticsCardModel = (IFvOpticsCardModel)((ViewCardGrapher)viewCompositeGraphic).getCard();
            this.layout.getNodeLayout().addConstraint((IlvHierarchicalConstraint)new IlvSameLevelConstraint((Object)viewCompositeGraphic, (Object)viewCompositeGraphic2));
            if (iFvOpticsCardModel.isAmpliWithBoosterRole() && !iFvOpticsCardModel.getEqLabel().contains("SMR")) {
                this.layout.getNodeLayout().addConstraint((IlvHierarchicalConstraint)new IlvRelativePositionConstraint((Object)viewCompositeGraphic, (Object)viewCompositeGraphic2, (float)n));
                ((FunctCardGrapher)viewCompositeGraphic2).doFlipH();
                viewCompositeGraphic2.graphicFlipPortsLabel(1.0, -1.0);
            } else {
                this.layout.getNodeLayout().addConstraint((IlvHierarchicalConstraint)new IlvRelativePositionConstraint((Object)viewCompositeGraphic2, (Object)viewCompositeGraphic, (float)n));
            }
            return true;
        }
        if (viewCompositeGraphic2.getGraphName().contains("OSCM")) {
            this.layout.getNodeLayout().addConstraint((IlvHierarchicalConstraint)new IlvSameLevelConstraint((Object)viewCompositeGraphic, (Object)viewCompositeGraphic2));
            if (viewCompositeGraphic.getGraphName().contains("RAMP") || viewCompositeGraphic.getGraphName().contains("SMR")) {
                this.layout.getNodeLayout().addConstraint((IlvHierarchicalConstraint)new IlvRelativePositionConstraint((Object)viewCompositeGraphic, (Object)viewCompositeGraphic2, (float)n));
                ((FunctCardGrapher)viewCompositeGraphic2).doFlipV();
                ((FunctCardGrapher)viewCompositeGraphic2).doFlipH();
                viewCompositeGraphic2.graphicFlipPortsLabel(-1.0, -1.0);
            } else {
                this.layout.getNodeLayout().addConstraint((IlvHierarchicalConstraint)new IlvRelativePositionConstraint((Object)viewCompositeGraphic2, (Object)viewCompositeGraphic, (float)n));
            }
            return true;
        }
        if (viewCompositeGraphic.getGraphName().contains("MUX") && viewCompositeGraphic2.getGraphName().contains("WXC")) {
            this.layout.getNodeLayout().addConstraint((IlvHierarchicalConstraint)new IlvSameLevelConstraint((Object)viewCompositeGraphic, (Object)viewCompositeGraphic2));
            this.layout.getNodeLayout().addConstraint((IlvHierarchicalConstraint)new IlvRelativePositionConstraint((Object)viewCompositeGraphic2, (Object)viewCompositeGraphic, (float)n));
            return true;
        }
        if ((viewCompositeGraphic.getGraphName().contains("WXC") || viewCompositeGraphic.getGraphName().contains("WSS")) && viewCompositeGraphic2.getGraphName().contains("DMX")) {
            this.layout.getNodeLayout().addConstraint((IlvHierarchicalConstraint)new IlvSameLevelConstraint((Object)viewCompositeGraphic, (Object)viewCompositeGraphic2));
            if (((ViewCardGrapher)viewCompositeGraphic).isEvenCard()) {
                this.layout.getNodeLayout().addConstraint((IlvHierarchicalConstraint)new IlvRelativePositionConstraint((Object)viewCompositeGraphic, (Object)viewCompositeGraphic2, (float)n));
            } else {
                this.layout.getNodeLayout().addConstraint((IlvHierarchicalConstraint)new IlvRelativePositionConstraint((Object)viewCompositeGraphic2, (Object)viewCompositeGraphic, (float)n));
            }
            return true;
        }
        return false;
    }

    public void checkDCUConnection(ViewInternalLink viewInternalLink, FunctCardGrapher functCardGrapher, FunctCardGrapher functCardGrapher2) {
        try {
            IFvCardModel iFvCardModel = viewInternalLink.getLink().getFromPortModel().getCardModel();
            IFvCardModel iFvCardModel2 = viewInternalLink.getLink().getToPortModel().getCardModel();
            if (iFvCardModel.getEqType() == 129 || iFvCardModel.getEqType() == 281 || iFvCardModel.getEqType() == 294 || iFvCardModel.getEqType() == 296 || iFvCardModel.getEqType() == 295 || iFvCardModel.getEqType() == 287 || iFvCardModel.getEqType() == 321 || iFvCardModel.getEqType() == 240) {
                if (iFvCardModel2.getEqType() == 298 || iFvCardModel2.getEqType() == 299 || iFvCardModel2.getEqType() == 312) {
                    functCardGrapher.setDCUConnected();
                }
            } else if (!(iFvCardModel2.getEqType() != 129 && iFvCardModel2.getEqType() != 281 && iFvCardModel2.getEqType() != 294 && iFvCardModel2.getEqType() != 296 && iFvCardModel2.getEqType() != 295 && iFvCardModel2.getEqType() != 287 && iFvCardModel2.getEqType() != 321 && iFvCardModel2.getEqType() != 240 || iFvCardModel.getEqType() != 298 && iFvCardModel.getEqType() != 299 && iFvCardModel.getEqType() != 312)) {
                functCardGrapher2.setDCUConnected();
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
        }
    }

    private boolean linkEndpointsExist(ViewInternalLink viewInternalLink, String string, String string2) {
        boolean bl = true;
        try {
            if (!this.getGraphChildren().containsKey(string)) {
                bl = this.addCard(viewInternalLink.getLink().getFromPortModel().getCardModel());
            } else if (!this.getGraphChildren().containsKey(string2)) {
                bl = this.addCard(viewInternalLink.getLink().getToPortModel().getCardModel());
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private String getCardKey(ViewInternalLink viewInternalLink, boolean bl) throws AbstractCmsNoSuchEntityException {
        IFvPortModel iFvPortModel = null;
        iFvPortModel = bl ? viewInternalLink.getLink().getFromPortModel() : viewInternalLink.getLink().getToPortModel();
        IFvCardModel iFvCardModel = iFvPortModel.getCardModel();
        return ViewManager.idToString((int)iFvCardModel.getEntityIndex());
    }

    public void insertSideWP(IFvSideModel iFvSideModel) {
        int n = ViewDwdmSide.getSideRole((int)iFvSideModel.getId());
        if (n != 0) {
            this.domSideModel[n - 1] = iFvSideModel;
        } else {
            this.domSideModel[n] = iFvSideModel;
        }
    }

    public void insertSecondarySide(IFvSideModel iFvSideModel, int n) {
        this.domSideModel[n] = iFvSideModel;
    }

    public void addPortGraph(FunctBandPortGraphic functBandPortGraphic) {
        this.allBandPort.put(functBandPortGraphic.getGraphKey(), functBandPortGraphic);
    }

    public FunctBandPortGraphic getPortGraph(String string) {
        return this.allBandPort.get(string);
    }

    public boolean hasMMU() {
        return this.domSideModel[2] != null;
    }

    public void addMPOLinks(FunctBandDomainGrapher functBandDomainGrapher, int n) {
        if (functBandDomainGrapher != null && n > 0) {
            for (String string : this.children.keySet()) {
                IViewGraph iViewGraph = (IViewGraph)this.children.get(string);
                if (!(iViewGraph instanceof ViewCardGrapher)) continue;
                IFvCardModel iFvCardModel = ((ViewCardGrapher)iViewGraph).getCardModel();
                int n2 = iFvCardModel.getEqType();
                int n3 = 0;
                boolean bl = false;
                switch (n2) {
                    case 131: 
                    case 191: 
                    case 242: 
                    case 263: 
                    case 265: 
                    case 267: 
                    case 269: {
                        n3 = 256;
                        bl = true;
                        break;
                    }
                    case 132: 
                    case 192: 
                    case 241: 
                    case 264: 
                    case 268: {
                        n3 = 512;
                        bl = true;
                        break;
                    }
                }
                if (!bl) continue;
                ViewCardGrapher viewCardGrapher = (ViewCardGrapher)iViewGraph;
                String string2 = "FunctBandPortGraphicCARD_PORT-BAND-" + n;
                FunctBandPortGraphic functBandPortGraphic = null;
                string2 = n3 == 256 ? string2 + "-RX" : string2 + "-TX";
                functBandPortGraphic = (FunctBandPortGraphic)viewCardGrapher.getGraphChildren().get(string2);
                if (functBandPortGraphic == null) continue;
                FunctViewPureGraphicalLink functViewPureGraphicalLink = functBandPortGraphic.createPortMpoLink(functBandDomainGrapher, null);
                int n4 = 0;
                if (functBandDomainGrapher.getGraphKey().indexOf("EVEN") >= 0) {
                    n4 = 16;
                }
                functViewPureGraphicalLink.setIndexMask(n3 + n4 + MPOHelper.mpoNumberFromPort(functBandPortGraphic.getPortModel().getPositionInParent(), functBandPortGraphic.getPortModel().getCardModel()) + 1);
                this.mpoLinks.put(functViewPureGraphicalLink.getIndex(), functViewPureGraphicalLink);
            }
        }
    }

    public ViewPortGraphic[] getLineCardPort(boolean bl, int n) {
        ViewPortGraphic[] viewPortGraphicArray = null;
        int n2 = 0;
        switch (n) {
            default: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 2;
            }
        }
        if (this.domSideModel[n2] != null) {
            int[] nArray = null;
            nArray = bl ? this.domSideModel[n2].getLinesOut() : this.domSideModel[n2].getLinesIn();
            viewPortGraphicArray = new ViewPortGraphic[nArray.length];
            int n3 = 0;
            for (int n4 : nArray) {
                viewPortGraphicArray[n3] = (ViewPortGraphic)this.getLineCard(n4).getGraphChildren().get(ViewManager.idToString((int)n4));
                ++n3;
            }
        }
        return viewPortGraphicArray;
    }

    public void collapseMPOandPerformLayout(boolean bl, boolean bl2, boolean bl3) {
        FunctBandDomainGrapher functBandDomainGrapher = null;
        for (IViewGraph iViewGraph : this.getGraphChildren().values()) {
            if (!(iViewGraph instanceof FunctBandDomainGrapher) || (functBandDomainGrapher = (FunctBandDomainGrapher)iViewGraph).isCollapsed()) continue;
            IlvGraphicBag ilvGraphicBag = functBandDomainGrapher.getGraphicBag();
            if (ilvGraphicBag == null) {
                functBandDomainGrapher.setCollapsed(true);
                continue;
            }
            ilvGraphicBag.applyToObject((IlvGraphic)functBandDomainGrapher, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    ((IlvGrapher)object).setCollapsed(true);
                }
            }, (Object)functBandDomainGrapher, false);
        }
        this.mpoLinkVisible(false, 0);
        this.mpoLinkVisible(false, 16);
        try {
            this.layout.performLayout(bl, bl2, bl3);
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            FunctDebug.printStackTrace((Throwable)ilvGraphLayoutException);
        }
    }

    public HashMap<Integer, IViewLink> getTxpGraphLinks() {
        Collection collection = this.getGraphChildren().values();
        for (IViewGraph iViewGraph : collection) {
            if (!(iViewGraph instanceof ViewBandDomainGrapher)) continue;
            return ((ViewBandDomainGrapher)iViewGraph).getGraphLinks();
        }
        return new HashMap<Integer, IViewLink>();
    }
}

