/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.EtherMedia.eEncapCrcType;
import cerent.cms.idl.EtherMedia.ePosFramingType;
import cerent.cms.idl.EtherMedia.sML2PosPortAdminInfo;
import cerent.cms.idl.EtherMedia.sML2PosPortInfo;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InvalidCardMode;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ML2PosLineModel;
import cerent.cms.model.ML2PosPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.enumeration.EtherEnumStrings;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IAdminTableAccess;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.WID;
import cerent.util.gui.SoakTimePropertyEditor;
import java.awt.Component;
import java.awt.Frame;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class ML2PosPortProvTableModel
extends AbstractTableModel
implements Observer,
IAdminTableAccess {
    public static final int PORT_NUMBER_INDEX = 0;
    public static final int PORT_NAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int SERVICE_STATE_INDEX = 3;
    public static final int PSAS_INDEX = 4;
    public static final int SOAK_TIME_INDEX = 5;
    public static final int LINK_STATE_INDEX = 6;
    public static final int FRAMING_TYPE_INDEX = 7;
    public static final int CRC_TYPE_INDEX = 8;
    public static final int MTU_INDEX = 9;
    public static String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "Service State", "PSAS", "Soak Time", "Link State", "Framing Type", "Encap CRC", "MTU"};
    public static String[] columnToolTips = new String[]{null, null, null, null, "Pre-Service Alarm Suppression", "Alarm Soak Time", null, null, null};
    private static final Attribute ADMIN_UP = new Attribute("Up", 0);
    private static final Attribute ADMIN_DOWN = new Attribute("Down", 1);
    private ML2ModuleModel eqpmtModel = null;
    private ML2PosPortModel[] portModels = null;
    private ML2PosLineModel[] lineModels = null;
    private sML2PosPortAdminInfo[] posPortAdminInfo = null;
    private sML2PosPortInfo[] posPortInfo = null;
    private boolean[][] isDirty = null;
    private String[] portName = null;
    private Boolean[] suppress = null;
    private int[] soakTime = null;
    private Object[] adminState;
    private int numLines = 0;
    private IServiceState[] serviceState;
    private boolean isPortOOSServiceAffecting;
    private TDMTerminology term;
    private static final SDebug db = new SDebug("ML2PosPortProvTableModel");

    public ML2PosPortProvTableModel(ML2ModuleModel mL2ModuleModel, ML2PosPortModel[] mL2PosPortModelArray, ML2PosLineModel[] mL2PosLineModelArray) {
        if (mL2ModuleModel == null || mL2PosPortModelArray == null || mL2PosLineModelArray == null || mL2PosPortModelArray.length != mL2PosLineModelArray.length) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + mL2ModuleModel + " portModels=" + mL2PosPortModelArray + " lineModels=" + mL2PosLineModelArray);
            }
            return;
        }
        this.eqpmtModel = mL2ModuleModel;
        this.portModels = mL2PosPortModelArray;
        this.lineModels = mL2PosLineModelArray;
        this.numLines = mL2PosLineModelArray.length;
        if (mL2ModuleModel.isInMapperMode()) {
            this.posPortAdminInfo = new sML2PosPortAdminInfo[this.numLines];
        }
        this.posPortInfo = new sML2PosPortInfo[this.numLines];
        this.portName = new String[this.numLines];
        this.adminState = new Object[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        if (!mL2ModuleModel.isInMapperMode()) {
            this.suppress = new Boolean[this.numLines];
        }
        this.soakTime = new int[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.term = this.getTerm();
        this.resetDirty();
        this.registerWithLineModels();
        this.isPortOOSServiceAffecting = this.eqpmtModel.getNodeModelDelegate().getPlatform().isPortOOSserviceAfecting();
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (n2 == 1 || n2 == 7 || n2 == 2 && this.eqpmtModel.isInMapperMode() || n2 == 5 || n2 == 4 || n2 == 8 && this.isCRCEditable(n)) {
            bl = AbstractPane.isUserAuthorized(this.eqpmtModel, SecurityLevel.PROVISIONING);
        }
        return bl;
    }

    private boolean isCRCEditable(int n) {
        if (this.eqpmtModel.isInMapperMode()) {
            return this.posPortAdminInfo[n].framingType == ePosFramingType.GFP_F;
        }
        return false;
    }

    public sML2PosPortInfo getPosPortInfoFromModel(int n) throws NoSuchInterface, WrongInterfaceType {
        sML2PosPortInfo sML2PosPortInfo2 = this.lineModels[n].getML2PosPortInfo();
        if (db.on()) {
            db.println("ML2PosPortInfo: row=" + n);
            db.println("   adminState=" + sML2PosPortInfo2.adminState.value());
            db.println("   linkUp=" + sML2PosPortInfo2.linkUp);
        }
        return sML2PosPortInfo2;
    }

    public sML2PosPortAdminInfo getPosPortAdminInfoFromModel(int n) throws NoSuchInterface, WrongInterfaceType, InvalidCardMode {
        sML2PosPortAdminInfo sML2PosPortAdminInfo2 = this.lineModels[n].getML2PosPortAdminInfo();
        if (db.on()) {
            db.println("ML2PosPortAdminInfo: row=" + n);
            db.println("   framing type=" + sML2PosPortAdminInfo2.framingType.value());
            db.println("   payloadCrcType=" + sML2PosPortAdminInfo2.payloadCrcType.value());
        }
        return sML2PosPortAdminInfo2;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    private String getLineNumber(int n) {
        try {
            if (this.eqpmtModel.isRPRMode()) {
                return this.rprRowNumber(n);
            }
            return String.valueOf(this.portModels[n].getPort());
        }
        catch (Exception exception) {
            if (ML2PosPortProvTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: {
                return String.class;
            }
            case 4: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    private String getPortNameFromModel(int n) {
        String string;
        block2: {
            string = "";
            try {
                string = this.lineModels[n].getAlias();
            }
            catch (Exception exception) {
                if (!ML2PosPortProvTableModel.db.on) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    private String getLinkState(int n) {
        try {
            return this.posPortInfo[n].linkUp ? "Up" : "Down";
        }
        catch (Exception exception) {
            if (ML2PosPortProvTableModel.db.on) {
                db.println("Exception caught accessing link state: " + exception);
            }
            return exception.toString();
        }
    }

    private Boolean getPreServiceAlarmSuppress(int n) {
        block4: {
            this.suppress[n] = Boolean.FALSE;
            try {
                this.suppress[n] = this.lineModels[n].getPreServiceAlarmSuppress();
                if (ML2PosPortProvTableModel.db.on) {
                    db.println("getPSAS: row " + n + " suppress " + this.suppress[n]);
                }
            }
            catch (EMCProvisionError eMCProvisionError) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)eMCProvisionError.getEID());
            }
            catch (Exception exception) {
                if (!ML2PosPortProvTableModel.db.on) break block4;
                db.println("Exception caught accessing PSAS: " + exception);
            }
        }
        return this.suppress[n];
    }

    private void setPreServiceAlarmSuppress(int n, Boolean bl) {
        this.suppress[n] = bl;
        this.isDirty[n][4] = true;
        if (ML2PosPortProvTableModel.db.on) {
            db.println("setPSAS, row " + n + " newSuppress " + bl);
        }
    }

    private String getSoakTimeAsHHMM(int n) throws NoSuchInterface {
        return SoakTimePropertyEditor.toStringHHMM(this.soakTime[n]);
    }

    public Object getValueAt(int n, int n2) {
        String string = "";
        try {
            switch (n2) {
                case 0: {
                    return this.getLineNumber(n);
                }
                case 1: {
                    return this.portName[n];
                }
                case 2: {
                    if (this.adminState[n] instanceof AdminState) {
                        return ((AdminState)this.adminState[n]).toString(this.term);
                    }
                    return this.adminState[n];
                }
                case 4: {
                    if (!this.eqpmtModel.isInMapperMode()) {
                        return this.suppress[n];
                    }
                    return Boolean.FALSE;
                }
                case 5: {
                    return this.getSoakTimeAsHHMM(n);
                }
                case 3: {
                    return this.serviceState[n].toString(this.term);
                }
                case 6: {
                    return this.getLinkState(n);
                }
                case 7: {
                    if (this.eqpmtModel.isInMapperMode()) {
                        return this.getFramingType(n);
                    }
                    return "";
                }
                case 8: {
                    if (this.eqpmtModel.isInMapperMode()) {
                        return this.getEncapCrcType(n);
                    }
                    return "";
                }
                case 9: {
                    return new Integer(this.posPortInfo[n].mtu);
                }
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in getValueAt " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
            string = exception.toString();
        }
        return string;
    }

    public Attribute getFramingType(int n) throws NoSuchInterface, WrongInterfaceType, InvalidCardMode {
        return EtherEnumStrings.get(ePosFramingType.class, this.posPortAdminInfo[n].framingType.value());
    }

    public Attribute getEncapCrcType(int n) throws NoSuchInterface, WrongInterfaceType, InvalidCardMode {
        return EtherEnumStrings.get(eEncapCrcType.class, this.posPortAdminInfo[n].payloadCrcType.value());
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 1: {
                String string;
                if (!(object instanceof String) || (string = (String)object) == null) break;
                this.portName[n] = string;
                break;
            }
            case 2: {
                this.adminState[n] = object;
                break;
            }
            case 4: {
                if (!(object instanceof Boolean)) break;
                this.setPreServiceAlarmSuppress(n, (Boolean)object);
                break;
            }
            case 5: {
                int n3 = this.soakTime[n];
                try {
                    n3 = SoakTimePropertyEditor.toIntValue((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    db.fine("Number Format Exception on " + (String)object);
                }
                if (this.soakTime[n] == n3) {
                    return;
                }
                this.soakTime[n] = n3;
                break;
            }
            case 7: {
                this.posPortAdminInfo[n].framingType = ePosFramingType.from_int(((Attribute)object).getIntValue());
                this.setEncapCRCBasedOnFramingType(this.posPortAdminInfo[n]);
                break;
            }
            case 8: {
                eEncapCrcType eEncapCrcType2 = eEncapCrcType.from_int(((Attribute)object).getIntValue());
                if (this.posPortAdminInfo[n].framingType == ePosFramingType.GFP_F && eEncapCrcType2 == eEncapCrcType.CRC_NONE) {
                    ErrorMsg.displayWarning((Component)this.getFrame(), (WID)EMC.WID_ENCAP_CHANGE_FOR_GFP_FRAMING);
                }
                this.posPortAdminInfo[n].payloadCrcType = eEncapCrcType2;
                break;
            }
            default: {
                return;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableRowsUpdated(n, n);
    }

    private void setEncapCRCBasedOnFramingType(sML2PosPortAdminInfo sML2PosPortAdminInfo2) {
        if (sML2PosPortAdminInfo2.framingType == ePosFramingType.HDLC) {
            sML2PosPortAdminInfo2.payloadCrcType = eEncapCrcType.CRC_32;
        }
    }

    protected eAdminState getNewAdminState(int n) throws NoSuchInterface {
        if (this.eqpmtModel.isInMapperMode()) {
            return ((AdminState)this.adminState[n]).getAdminStateEnum();
        }
        return eAdminState.from_int(((Attribute)this.adminState[n]).getIntValue());
    }

    public AdminState getAdminState(int n) throws NoSuchInterface {
        if (this.eqpmtModel.isInMapperMode()) {
            return (AdminState)this.adminState[n];
        }
        eAdminState eAdminState2 = eAdminState.from_int(((Attribute)this.adminState[n]).getIntValue());
        return AdminState.enumToAdminState(eAdminState2);
    }

    protected eAdminState getAdminStateFromModel(int n) throws NoSuchInterface {
        return this.lineModels[n].getAdminStateEnum();
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        block2: {
            try {
                this.resetLineCache(n);
                this.fireTableRowsUpdated(n, n);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    private void resetLineCache(int n) throws Exception {
        this.posPortInfo[n] = this.getPosPortInfoFromModel(n);
        this.portName[n] = this.getPortNameFromModel(n);
        if (this.eqpmtModel.isInMapperMode()) {
            this.adminState[n] = AdminState.enumToAdminState(this.getAdminStateFromModel(n));
            this.posPortAdminInfo[n] = this.getPosPortAdminInfoFromModel(n);
        } else {
            this.adminState[n] = this.getAdminStateFromModel(n).value() == 0 || this.getAdminStateFromModel(n).value() == 3 ? ADMIN_UP : ADMIN_DOWN;
        }
        sServiceState sServiceState2 = this.lineModels[n].getServiceState();
        this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        if (!this.eqpmtModel.isInMapperMode()) {
            this.suppress[n] = this.getPreServiceAlarmSuppress(n);
        }
        this.soakTime[n] = this.lineModels[n].getSoakTime();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public boolean validateChanges(int n) throws Exception {
        if (this.eqpmtModel.isInMapperMode()) {
            sML2PosPortAdminInfo sML2PosPortAdminInfo2 = this.getPosPortAdminInfoFromModel(n);
            sML2PosPortAdminInfo sML2PosPortAdminInfo3 = this.posPortAdminInfo[n];
            if (this.getAdminStateFromModel(n) == eAdminState.ADMIN_IS && (sML2PosPortAdminInfo2.framingType != sML2PosPortAdminInfo3.framingType || sML2PosPortAdminInfo2.payloadCrcType != sML2PosPortAdminInfo3.payloadCrcType)) {
                return false;
            }
        }
        return true;
    }

    public void applyToModel(int n) throws Exception {
        if (this.isDirty[n][5]) {
            if (db.on()) {
                db.println("setting line soakTime " + this.soakTime[n]);
            }
            this.lineModels[n].setSoakTime(this.soakTime[n]);
        }
        eAdminState eAdminState2 = this.getNewAdminState(n);
        if (this.isDirty[n][2]) {
            this.lineModels[n].setAdminState(eAdminState2);
        }
        if (this.isDirty[n][1]) {
            try {
                this.lineModels[n].setAlias(this.portName[n]);
            }
            catch (Exception exception) {
                if (ML2PosPortProvTableModel.db.on) {
                    db.println("Exception caught trying to set port name : " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (!this.eqpmtModel.isInMapperMode() && this.isDirty[n][4]) {
            try {
                this.lineModels[n].setPreServiceAlarmSuppress(this.suppress[n]);
                if (db.on()) {
                    db.println("applyToModel: row " + n + " setting PSAS " + this.suppress[n]);
                }
            }
            catch (EMCProvisionError eMCProvisionError) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)eMCProvisionError.getEID());
            }
        }
        if (this.eqpmtModel.isInMapperMode() && (this.isDirty[n][7] || this.isDirty[n][8])) {
            this.lineModels[n].setML2PosPortAdminInfo(this.posPortAdminInfo[n]);
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public Object[] getAdminStateAttrs() {
        if (this.eqpmtModel.isInMapperMode()) {
            boolean bl = AdminState.isANSI(this.eqpmtModel.getNodeModel().getTdmProtocolType());
            return AdminState.getDefaultAdminStates(bl);
        }
        Object[] objectArray = new Attribute[]{ADMIN_UP, ADMIN_DOWN};
        return objectArray;
    }

    public Attribute[] getPosFramingTypeAttrs() {
        if (this.eqpmtModel.getEqType() == 283) {
            return EtherEnumStrings.get(ePosFramingType.class, EtherEnumStrings.POS_FRAMING_MIN);
        }
        return EtherEnumStrings.get(ePosFramingType.class, EtherEnumStrings.POS_FRAMING_NO_X86);
    }

    public Attribute[] getEncapCrcTypeAttrs() {
        return EtherEnumStrings.get(eEncapCrcType.class, EtherEnumStrings.ML2_ENCAP_CRC);
    }

    public boolean isAdminStateDirty(int n) {
        return this.isDirty[n][2];
    }

    private void registerWithLineModels() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver(this);
        }
    }

    private void unRegisterWithLineModels() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            int n;
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            if ((n = Arrays.asList(this.lineModels).indexOf(observable)) != -1) {
                this.refreshLineFromModel(n);
            }
        }
    }

    private TDMTerminology getTerm() {
        return this.eqpmtModel.getNodeModel().getTDMTerminology();
    }

    public void dispose() {
        this.unRegisterWithLineModels();
    }

    protected Frame getFrame() {
        return this.eqpmtModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }

    private String rprRowNumber(int n) {
        String string = null;
        if (this.eqpmtModel.isRPRMode()) {
            if (n == 0) {
                string = "RPR East";
            } else if (n == 1) {
                string = "RPR West";
            }
        }
        return string;
    }
}

