/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.idl.Circuits.eCircuitType;
import cerent.cms.idl.EtherMedia.sSonetPathsPosPortInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ML2PosPortModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class ML2PosPortUsageTableModel
extends AbstractTableModel {
    public static final int PORT_INDEX = 0;
    public static final int ALLOCATION_INDEX = 1;
    public static final int POOL_INDEX = 2;
    private String[] columnNames = new String[]{"Port", "Allocation", "Pool"};
    private ML2ModuleModel eqpmtModel = null;
    private ML2PosPortModel[] portModels = null;
    private sSonetPathsPosPortInfo[] infoList = null;
    private EntityCellRenderer myPortRenderer;
    private TDMTerminology terms;
    private static final SDebug db = new SDebug("ML2PosPortUsageTableModel");

    public ML2PosPortUsageTableModel(ML2ModuleModel mL2ModuleModel) {
        this.eqpmtModel = mL2ModuleModel;
        this.portModels = mL2ModuleModel.getPosPortModels();
        this.myPortRenderer = new EntityCellRenderer();
        this.terms = mL2ModuleModel.getNodeModel().getTDMTerminology();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < this.columnNames.length) {
            return this.columnNames[n];
        }
        return null;
    }

    public int getRowCount() {
        return this.infoList == null ? 0 : this.infoList.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    public Object getValueAt(int n, int n2) {
        block7: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getPortDescription(this.infoList[n].port);
                    }
                    case 1: {
                        return this.getAllocationDescription(this.infoList[n]);
                    }
                    case 2: {
                        return String.valueOf(this.infoList[n].sonetPool);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block7;
                db.println("Error in getValueAt " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    private String getAllocationDescription(sSonetPathsPosPortInfo sSonetPathsPosPortInfo2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(sSonetPathsPosPortInfo2.numOfPathsInUse));
        stringBuffer.append(" ");
        if (this.isHoCircuit(sSonetPathsPosPortInfo2.cirType)) {
            stringBuffer.append(this.terms.getGeneralTerms(0));
        } else {
            stringBuffer.append(this.terms.getGeneralTerms(1));
        }
        if (sSonetPathsPosPortInfo2.numOfPathsInUse > 1) {
            stringBuffer.append("s");
        }
        stringBuffer.append(" ");
        if (this.isVcatCircuit(sSonetPathsPosPortInfo2.cirType)) {
            stringBuffer.append("(");
            stringBuffer.append("VCAT, ");
            stringBuffer.append(sSonetPathsPosPortInfo2.vcatMode ? "LCAS" : "NON-LCAS");
            stringBuffer.append(")");
        } else {
            stringBuffer.append("(CCAT)");
        }
        return stringBuffer.toString();
    }

    private boolean isHoCircuit(eCircuitType eCircuitType2) {
        return eCircuitType2 == eCircuitType.STS_CIRCUIT || eCircuitType2 == eCircuitType.STS_VCAT_CIRCUIT || eCircuitType2 == eCircuitType.VC_HO_PATH_CIRCUIT || eCircuitType2 == eCircuitType.VC_HO_PATH_VCAT_CIRCUIT;
    }

    private boolean isVcatCircuit(eCircuitType eCircuitType2) {
        return eCircuitType2 == eCircuitType.STS_VCAT_CIRCUIT || eCircuitType2 == eCircuitType.VT_VCAT_CIRCUIT || eCircuitType2 == eCircuitType.VC_HO_PATH_VCAT_CIRCUIT || eCircuitType2 == eCircuitType.VC_LO_PATH_VCAT_CIRCUIT;
    }

    protected String getPortDescription(int n) throws AbstractCmsNoSuchEntityException {
        return this.myPortRenderer.getPortString(this.portModels[--n], false);
    }

    public void refreshFromModel() throws Exception {
        TreeMap<Integer, sSonetPathsPosPortInfo> treeMap = new TreeMap<Integer, sSonetPathsPosPortInfo>();
        sSonetPathsPosPortInfo[] sSonetPathsPosPortInfoArray = this.eqpmtModel.getSonetPathsPosPortInfoList();
        if (sSonetPathsPosPortInfoArray != null && sSonetPathsPosPortInfoArray.length > 0) {
            for (int i = 0; i < sSonetPathsPosPortInfoArray.length; ++i) {
                treeMap.put(new Integer(sSonetPathsPosPortInfoArray[i].port), sSonetPathsPosPortInfoArray[i]);
            }
        }
        ArrayList arrayList = new ArrayList(treeMap.values());
        this.infoList = arrayList.toArray(new sSonetPathsPosPortInfo[0]);
        this.fireTableDataChanged();
    }
}

