/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IShelfViewModel;
import cerent.cms.model.PassiveChassisModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ms.MsPassiveShelfLayout;
import cerent.cms.ui.ms.ShelfBehavior;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.CardPanel;
import cerent.cms.ui.shelf.ICardPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class AbstractMsPassiveUnitGraphic
extends CardGraphic {
    protected final ShelfBehavior shelfBehavior;
    protected final IShelfViewModel chassis;
    protected final int unitPosition;
    protected final boolean userPriv;

    public AbstractMsPassiveUnitGraphic(IShelfViewModel iShelfViewModel, IEntityModel iEntityModel, MsPassiveShelfLayout msPassiveShelfLayout, int n) {
        super(iShelfViewModel.getNodeModelDelegate(), iEntityModel, msPassiveShelfLayout, MsPassiveShelfLayout.db, false);
        this.shelfBehavior = new ShelfBehavior(this.nodeModel, this.db);
        this.chassis = iShelfViewModel;
        this.unitPosition = n;
        this.userPriv = AbstractPane.isUserAuthorized(iShelfViewModel, SecurityLevel.SUPERUSER);
    }

    public void rightMouseClicked(Point point, CardPanel cardPanel) {
        this.db.info("rightMouseClicked for passive unit: " + this.entityM);
        JPopupMenu jPopupMenu = null;
        jPopupMenu = new JPopupMenu("Action");
        JMenuItem jMenuItem = null;
        if (this.entityM == null || this.canDeleteShelf()) {
            jMenuItem = this.makeMenuAction("Delete Shelf", this.userPriv);
            jMenuItem.setMnemonic('D');
            jPopupMenu.add(jMenuItem);
        }
        if (this.entityM == null) {
            short s = this.chassis.getRUOccupied();
            eEqType[] eEqTypeArray = this.getProvisionableUnits();
            if (eEqTypeArray != null) {
                JMenu jMenu = new JMenu("Add Unit");
                for (eEqType eEqType2 : eEqTypeArray) {
                    String string = this.shelfBehavior.getShelfName(eEqType2);
                    if (s != ChassisModels.getChassisHeight(eEqType2) || this.shelfBehavior.getAvailableSlots(string).length <= 1) continue;
                    jMenuItem = this.makeMenuAction(string, this.userPriv);
                    jMenu.add(jMenuItem);
                }
                jPopupMenu.add(jMenu);
            }
        } else {
            jMenuItem = this.makeMenuAction("Delete Unit", this.userPriv);
            jMenuItem.setMnemonic('U');
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.show(cardPanel, point.x, point.y);
    }

    private boolean canDeleteShelf() {
        return this.parent.getShelfSlotCount() > 1 || ((PassiveChassisModel)this.chassis).getInnerChild() != null;
    }

    protected eEqType[] getProvisionableUnits() {
        return this.shelfBehavior.getProvisionableUnitsOnShelf(eEqType.PASSIVE_CHASSIS);
    }

    private void addPassiveUnit(String string) {
        if (this.db.on()) {
            this.db.fine("creating unit " + string);
        }
        this.shelfBehavior.addUnit(this, this.chassis.getRackNumber(), this.chassis.getRackPosition(), (short)this.unitPosition, string);
    }

    private void deletePassiveUnit() {
        if (this.db.on()) {
            this.db.fine("delete unit " + this.entityM);
        }
        this.cardBehavior.deleteCard(this, this.entityM);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Delete Shelf")) {
                boolean bl = this.shelfBehavior.deleteShelf(this.parent, this.chassis);
                this.setDisabled(bl);
            } else if (string.equals("Delete Unit")) {
                this.deletePassiveUnit();
            } else {
                this.addPassiveUnit(string);
            }
        }
    }

    public ICardPainter getCardPainter() {
        return new MsCardPainter(this, (MsPassiveShelfLayout)this.parent, this.unitPosition);
    }

    public Color getCurrentColor() {
        if (this.getModel() == null) {
            return Color.gray.brighter();
        }
        return super.getCurrentColor();
    }

    public String getEqLabel() {
        if (this.getModel() == null) {
            return "" + this.unitPosition;
        }
        return super.getEqLabel().replace("PASSIVE ", "");
    }

    protected static class MsCardPainter
    implements ICardPainter {
        protected final int UNIT_WIDTH;
        protected final int UNIT_HEIGHT;
        private final int LABEL_X_OFFSET;
        private final int LABEL_Y_OFFSET;
        private final float FONT_SIZE;
        private final Rectangle mainRectangle;
        private final CardGraphic cg;
        private final Rectangle leftExtractorRectangle;
        private final Rectangle rightExtractorRectangle;

        public MsCardPainter(CardGraphic cardGraphic, MsPassiveShelfLayout msPassiveShelfLayout) {
            this(cardGraphic, msPassiveShelfLayout, 0);
        }

        public MsCardPainter(CardGraphic cardGraphic, MsPassiveShelfLayout msPassiveShelfLayout, int n) {
            this.cg = cardGraphic;
            this.UNIT_WIDTH = msPassiveShelfLayout.getUnitWidth();
            this.UNIT_HEIGHT = msPassiveShelfLayout.getUnitHeight();
            this.LABEL_X_OFFSET = this.UNIT_WIDTH / 2;
            this.LABEL_Y_OFFSET = this.UNIT_HEIGHT > 10 ? this.UNIT_HEIGHT / 2 + 4 : this.UNIT_HEIGHT - 1;
            this.FONT_SIZE = this.UNIT_HEIGHT > 10 && this.UNIT_WIDTH > 52 ? 12.0f : 8.0f;
            this.mainRectangle = new Rectangle(0, 0, this.UNIT_WIDTH, this.UNIT_HEIGHT);
            this.leftExtractorRectangle = new Rectangle(2, 2, 3, this.UNIT_HEIGHT - 5);
            this.rightExtractorRectangle = new Rectangle(this.UNIT_WIDTH - 6 + n, 2, 3, this.UNIT_HEIGHT - 5);
        }

        public void updateWidth() {
        }

        public int getOpticonXOffset() {
            return 0;
        }

        public int getOpticonYOffset() {
            return 0;
        }

        public int getMultiPortOpticonXOffset() {
            return 0;
        }

        public int getOpticonXSpacing() {
            return 0;
        }

        public int getOpticonYSpacing() {
            return 0;
        }

        public int getMiniMultiPortOticonXOffset() {
            return 0;
        }

        public int getCardWidth() {
            return this.UNIT_WIDTH;
        }

        public int getCardHeight() {
            return this.UNIT_HEIGHT;
        }

        public Rectangle getMainRectangle() {
            return this.mainRectangle;
        }

        public int getPortWidth() {
            return 0;
        }

        public int getPortHeight() {
            return 0;
        }

        public int getMiniPortWidth() {
            return 0;
        }

        public int getMiniPortHeight() {
            return 0;
        }

        public int getMiniOpticonXSpacing() {
            return 0;
        }

        public int getMiniOpticonYSpacing() {
            return 0;
        }

        public int getMiniOpticonYOffset() {
            return 0;
        }

        public int getSmallMiniPortWidth() {
            return 0;
        }

        public int getSmallMiniPortHeight() {
            return 0;
        }

        public int getSmallMiniOpticonYSpacing() {
            return 0;
        }

        public int getSmallMiniOpticonYOffset() {
            return 0;
        }

        public int getPortX(int n, int n2) {
            return 0;
        }

        public int getPortY(int n, int n2) {
            return 0;
        }

        public int getSmallPortWidth() {
            return 0;
        }

        public int getSmallPortHeight() {
            return 0;
        }

        public int getPortConn1X() {
            return 0;
        }

        public int getPortConn2X() {
            return 0;
        }

        public int getPortConn1Y() {
            return 0;
        }

        public int getPortConn2Y() {
            return 0;
        }

        public int getSmallPortConn1Y() {
            return 0;
        }

        public int getSmallPortConn2Y() {
            return 0;
        }

        public int getSmallPortConn1X() {
            return 0;
        }

        public int getSmallPortConn2X() {
            return 0;
        }

        public int getSmallerPortConn1Y() {
            return 0;
        }

        public int getSmallerPortConn2Y() {
            return 0;
        }

        public int getPortLoopbackDist() {
            return 0;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setColor(this.cg.getCurrentColor());
            graphics2D.fill(this.mainRectangle);
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.draw(this.mainRectangle);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setStroke(stroke);
            if (this.cg.getModel() != null) {
                graphics2D.setStroke(new BasicStroke(1.0f));
                graphics2D.setColor(Color.gray);
                graphics2D.draw(this.leftExtractorRectangle);
                graphics2D.draw(this.rightExtractorRectangle);
                graphics2D.setColor(Color.black);
            }
            Font font = graphics2D.getFont();
            Font font2 = font.deriveFont(1, this.FONT_SIZE);
            graphics2D.setFont(font2);
            String string = this.cg.getEqLabel();
            FontMetrics fontMetrics = component.getFontMetrics(font2);
            graphics2D.drawString(string, this.LABEL_X_OFFSET - fontMetrics.stringWidth(string) / 2, this.LABEL_Y_OFFSET);
            graphics2D.setFont(font);
        }
    }
}

