/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.muxdemux;

import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Optics.eSwitchablePortState;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.ui.ConvertPwrToDb;
import cerent.cms.ui.OpticalTableModel;
import cerent.cms.ui.Wavelength;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;

public class MuxDmuxParametersTableModel
extends OpticalTableModel {
    public static final int ACTUAL_WAVEL_INDEX = 14;
    public static final int EXPECTED_WAVEL_INDEX = 15;
    public static final int ACTUAL_BAND_INDEX = 16;
    public static final int EXPECTED_BAND_INDEX = 17;
    public static final int ADD_POWER_PT_INDEX = 18;
    public static final int ADD_PASSTHROUGH_STATE_INDEX = 19;
    public static String[] columnNames = new String[]{"Actual Wavelength", "Expected Wavelength", "Actual Band", "Expected Band", "Power ADD", "Path Value"};
    public static final String[] AddPTVoaStateStrings = new String[]{"Standby", "Active"};
    public static final String[] WavelengthStrings = new String[]{"AUTOPROV", "1530.33 nm", "1546.12 nm"};
    public static final String[] Mux4_WavelengthStrings = new String[]{"AUTOPROV", "1530.33 nm", "1534.25 nm", "1538.19 nm", "1542.14 nm", "1546.12 nm", "1550.12 nm", "1554.13 nm", "1558.17 nm"};
    public static final String[] MuxDmx32_WavelengthStrings = new String[]{"AUTOPROV", "1530.33 nm"};
    public static final String[] MuxDmx40_WavelengthStrings = new String[]{"AUTOPROV", "1530.33 nm"};
    public static final String[] MuxDmx40_CEvenOdd_WavelengthStrings = new String[]{"AUTOPROV", "1530.33 nm", "1530.72 nm"};
    public static final String[] MuxDmx32_L_WavelengthStrings = new String[]{"AUTOPROV", "1577.86 nm"};
    public static final String[] MuxDmx40_L_WavelengthStrings = new String[]{"AUTOPROV", "1571.24 nm"};
    protected int[] expectedWavelength;
    private int[] expectedBandWavelength;
    protected int[] actualWavelength;
    private int[] actualBandWavelength;
    private int[] addPTVoaState;
    private int[] AddPower;
    private static final SDebug db = new SDebug("MuxDmuxParametersTableModel");

    public MuxDmuxParametersTableModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(db, abstractOpticsLineModelArray);
        this.expectedWavelength = new int[this.numLines];
        this.expectedBandWavelength = new int[this.numLines];
        this.actualWavelength = new int[this.numLines];
        this.actualBandWavelength = new int[this.numLines];
        this.AddPower = new int[this.numLines];
        this.addPTVoaState = new int[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.expectedWavelength[i] = -1;
            this.expectedBandWavelength[i] = -1;
            this.actualWavelength[i] = -1;
            this.actualBandWavelength[i] = -1;
            this.addPTVoaState[i] = -1;
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return super.getColumnCount() + columnNames.length;
    }

    public String[] getWavelengthStrings() {
        return WavelengthStrings;
    }

    public String[] getWavelengthStrings_4MD() {
        return Mux4_WavelengthStrings;
    }

    public String[] getMuxDmx32_WavelengthStrings() {
        return MuxDmx32_WavelengthStrings;
    }

    public String[] getMuxDmx40_WavelengthStrings() {
        return MuxDmx40_WavelengthStrings;
    }

    public String[] getMuxDmx40_L_WavelengthStrings() {
        return MuxDmx40_L_WavelengthStrings;
    }

    public String[] getMuxDmx40_CEvenOdd_WavelengthStrings() {
        return MuxDmx40_CEvenOdd_WavelengthStrings;
    }

    public String[] getMuxDmx32_L_WavelengthStrings() {
        return MuxDmx32_L_WavelengthStrings;
    }

    public String[] getaddptStrings() {
        return AddPTVoaStateStrings;
    }

    public boolean isCellEditable(int n, int n2) {
        if (!this.isUserAuthorized(SecurityLevel.PROVISIONING)) {
            return false;
        }
        if (n2 == 17 && n == 0 || n2 == 15 && n == 0 && this.getPortNumber(n) == 1) {
            return true;
        }
        return super.isCellEditable(n, n2);
    }

    public String getColumnName(int n) {
        if (n < 14) {
            return super.getColumnName(n);
        }
        return columnNames[n - 14];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 14: {
                    return this.getActualWavelength(n);
                }
                case 15: {
                    return this.getExpectedWavelength(n);
                }
                case 18: {
                    return this.getAddPower(n);
                }
                case 19: {
                    return this.getAddPTVoaState(n);
                }
            }
            return super.getValueAt(n, n2);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.fine("OadmParametersTableModel: error in getValueAt" + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value row=" + n + " col=" + n2);
        }
        boolean bl = false;
        try {
            switch (n2) {
                case 15: {
                    int n3 = 0;
                    n3 = this.eqpmtModel.getEqType() == 242 || this.eqpmtModel.getEqType() == 241 || this.eqpmtModel.getEqType() == 268 || this.eqpmtModel.getEqType() == 267 || this.eqpmtModel.getEqType() == 269 || this.eqpmtModel.getEqType() == 263 || this.eqpmtModel.getEqType() == 264 || this.eqpmtModel.getEqType() == 265 ? Wavelength.getWavelengthFromWavelengthString((String)object) : (133 == this.eqpmtModel.getEqType() ? this.getIndexOf((String)object, Mux4_WavelengthStrings) : this.getIndexOf((String)object, MuxDmx32_WavelengthStrings));
                    if (this.expectedWavelength[n] == n3) {
                        return;
                    }
                    this.expectedWavelength[n] = n3;
                    break;
                }
                default: {
                    super.setValueAt(object, n, n2);
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            if (MuxDmuxParametersTableModel.db.on) {
                SDebug.printStackTrace((Throwable)classCastException);
            }
            return;
        }
        this.isDirty[n][n2] = bl ? !this.isDirty[n][n2] : true;
        this.fireTableCellUpdated(n, n2);
    }

    protected int getIndexOf(Object object, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        return list.indexOf(object);
    }

    private String getAddPTVoaState(int n) {
        block6: {
            if (this.addPTVoaState[n] == -1) {
                try {
                    if ((this.model[n].getFeatures() & 0x10) == 16) {
                        int n2;
                        int n3 = n2 = this.model[n] != null ? this.model[n].getAddPTPortState() : -1;
                        if (n2 == eSwitchablePortState.STANDBY.value()) {
                            this.addPTVoaState[n] = 0;
                            break block6;
                        }
                        if (n2 == eSwitchablePortState.ACTIVE.value()) {
                            this.addPTVoaState[n] = 1;
                            break block6;
                        }
                        return "N/A";
                    }
                    return "N/A";
                }
                catch (Exception exception) {
                    return "N/A";
                }
            }
        }
        return AddPTVoaStateStrings[this.addPTVoaState[n]];
    }

    private String getAddPower(int n) {
        String string;
        block4: {
            string = "N/A";
            try {
                if ((this.model[n].getFeatures() & 0x10) == 16) {
                    int n2 = this.model[n].getAddPower();
                    if (n2 != -1000000) {
                        string = ConvertPwrToDb.formatDecimalNumber(n2);
                    }
                    return string;
                }
            }
            catch (Exception exception) {
                if (!MuxDmuxParametersTableModel.db.on) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    private String getExpectedWavelength(int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        if (133 == this.eqpmtModel.getEqType()) {
            n2 = 4;
            n3 = 1;
        } else {
            n2 = 1;
            n3 = 0;
        }
        if (this.expectedWavelength[n] == -1 && this.model[n] != null && this.model[n] instanceof OpticsChannelModel) {
            OpticsChannelModel opticsChannelModel = (OpticsChannelModel)this.model[n];
            try {
                this.expectedWavelength[n] = opticsChannelModel.getExpectedWaveLength();
                bl = true;
            }
            catch (Exception exception) {
                this.expectedWavelength[n] = 0;
            }
        }
        if (this.eqpmtModel.getEqType() == 242 || this.eqpmtModel.getEqType() == 241) {
            if (this.expectedWavelength[n] == -1) {
                return MuxDmx32_L_WavelengthStrings[0];
            }
            return Wavelength.getWavelengthStringFromWavelength(this.expectedWavelength[n]);
        }
        if (this.eqpmtModel.getEqType() == 267 || this.eqpmtModel.getEqType() == 269 || this.eqpmtModel.getEqType() == 268) {
            if (this.expectedWavelength[n] == -1) {
                return MuxDmx40_L_WavelengthStrings[0];
            }
            return Wavelength.getWavelengthStringFromWavelength(this.expectedWavelength[n]);
        }
        if (this.eqpmtModel.getEqType() == 265) {
            if (this.expectedWavelength[n] == -1) {
                return MuxDmx40_WavelengthStrings[0];
            }
            return Wavelength.getWavelengthStringFromWavelength(this.expectedWavelength[n]);
        }
        if (this.eqpmtModel.getEqType() == 263 || this.eqpmtModel.getEqType() == 264) {
            if (this.expectedWavelength[n] == -1) {
                return MuxDmx40_CEvenOdd_WavelengthStrings[0];
            }
            return Wavelength.getWavelengthStringFromWavelength(this.expectedWavelength[n]);
        }
        if (133 == this.eqpmtModel.getEqType()) {
            if (this.expectedWavelength[n] == -1) {
                return Mux4_WavelengthStrings[0];
            }
            int n4 = this.expectedWavelength[n];
            if (n4 > 1) {
                n4 = n4 / n2 + n3;
            }
            if (bl) {
                if (n > 0) {
                    return Wavelength.getWavelengthStringFromWavelength(this.expectedWavelength[n]);
                }
                this.expectedWavelength[n] = n4;
                return Mux4_WavelengthStrings[this.expectedWavelength[n]];
            }
            if (n > 0) {
                return Wavelength.getWavelengthStringFromWavelength(this.expectedWavelength[n]);
            }
            return Mux4_WavelengthStrings[this.expectedWavelength[n]];
        }
        if (this.expectedWavelength[n] == -1) {
            return WavelengthStrings[0];
        }
        int n5 = this.expectedWavelength[n];
        if (n5 > 1) {
            n5 = n5 / n2 + n3;
        }
        if (bl) {
            if (n > 0) {
                return Wavelength.getWavelengthStringFromWavelength(this.expectedWavelength[n]);
            }
            this.expectedWavelength[n] = n5;
            return Wavelength.getWavelengthStringFromWavelength(this.expectedWavelength[n]);
        }
        if (n > 0) {
            return Wavelength.getWavelengthStringFromWavelength(this.expectedWavelength[n]);
        }
        return Wavelength.getWavelengthStringFromWavelength(this.expectedWavelength[n]);
    }

    private void setExpectedWavelength(int n) throws AnnotatedException {
        int n2 = 1;
        int n3 = 0;
        if (133 == this.eqpmtModel.getEqType()) {
            n2 = 4;
            n3 = 3;
        }
        int n4 = this.expectedWavelength[n];
        if (!this.eqpmtModel.isOPT_AMP_L() && this.eqpmtModel.getEqType() != 242) {
            if (n4 > 1) {
                n4 = n4 * n2 - n3;
            }
        } else if ((this.eqpmtModel.getEqType() == 263 || this.eqpmtModel.getEqType() == 264 || this.eqpmtModel.getEqType() == 265 || this.eqpmtModel.getEqType() == 268 || this.eqpmtModel.getEqType() == 269 || this.eqpmtModel.getEqType() == 267) && n4 > 1) {
            n4 = n4 * n2 - n3;
        }
        try {
            OpticsChannelModel opticsChannelModel = (OpticsChannelModel)this.model[n];
            opticsChannelModel.setExpectedWaveLength(eWavelength.from_int(n4));
        }
        catch (Exception exception) {
            throw new AnnotatedException(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_SETEXPECTED_WAVELENGTH), exception);
        }
    }

    protected String getActualWavelength(int n) {
        int n2 = 0;
        if (this.actualBandWavelength[n] == -1) {
            if (this.model[n] != null && this.model[n] instanceof OpticsChannelModel) {
                OpticsChannelModel opticsChannelModel = (OpticsChannelModel)this.model[n];
                try {
                    this.actualWavelength[n] = n2 = opticsChannelModel.getActualWaveLength();
                }
                catch (Exception exception) {
                    n2 = 0;
                }
            } else {
                this.actualWavelength[n] = n2;
            }
        }
        return Wavelength.getWavelengthStringFromWavelength(this.actualWavelength[n]);
    }

    public void refreshLineFromModel(int n) {
        if (n > this.getRowCount() || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.getExpectedWavelength(n);
        this.getActualWavelength(n);
        this.getAddPTVoaState(n);
        this.getAddPower(n);
        super.refreshLineFromModel(n);
    }

    protected void resetLineCache(int n) {
        super.resetLineCache(n);
        this.expectedWavelength[n] = -1;
        this.expectedBandWavelength[n] = -1;
        this.actualWavelength[n] = -1;
        this.actualBandWavelength[n] = -1;
        this.AddPower[n] = -1;
        this.addPTVoaState[n] = -1;
        this.resetDirtyBits(n);
    }

    public void applyToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.getRowCount(); ++n) {
                if (this.isDirty[n][15]) {
                    this.setExpectedWavelength(n);
                }
                if (!this.isDirty[n][19]) continue;
                if (this.addPTVoaState[n] == eSwitchablePortState.STANDBY.value()) {
                    this.model[n].setAddPTPortState(eSwitchablePortState.STANDBY);
                    continue;
                }
                this.model[n].setAddPTPortState(eSwitchablePortState.ACTIVE);
            }
            super.applyToModel();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
            this.refreshFromModel();
        }
        catch (ProvisionError provisionError) {
            ErrorMsg.displayDetailed((Component)this.getFrame(), EMC.EID_ACTION_NOTALLOWED, provisionError.toString());
            this.refreshFromModel();
        }
        catch (Exception exception) {
            if (this.FlgAdminStateChanged) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_CHANGE_ADMIN_STATE_NOTALLOWED);
            } else {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
            }
            this.refreshFromModel();
        }
    }

    private int getPortNumber(int n) {
        int n2;
        try {
            n2 = this.model[n].getPortNumber();
        }
        catch (NoSuchInterface noSuchInterface) {
            if (MuxDmuxParametersTableModel.db.on) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            n2 = n + 1;
        }
        return n2;
    }
}

