/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nedefaults;

import cerent.cms.idl.Security.NotAuthenticated;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.nedefaults.DefaultsManager;
import cerent.cms.model.nedefaults.DefaultsNode;
import cerent.cms.model.nedefaults.IDefaultsElement;
import cerent.cms.model.nedefaults.IDefaultsNode;
import cerent.cms.ui.DataSourceControl;
import cerent.cms.ui.nedefaults.DefaultsDataSource;
import cerent.cms.ui.nedefaults.DefaultsTableModel;
import cerent.cms.ui.shelf.SppDefaultsEditorPane;
import cerent.util.AnnotatedException;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.SortableProperties;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedLogDialog;
import cerent.util.gui.PersistentFileChooserDialog;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DefaultsController
implements DataSourceControl,
Runnable {
    private static final String PROP_PREF = "ctc.defaults";
    private static final String PROP_SCOPE = "scope";
    private final IObservableManager dummyOM = new ObservableManager(new Observer(){

        public void update(Observable observable, Object object) {
        }
    }, true);
    private static final String NODE_DEFAULTS_SOURCE = "Node Defaults";
    private static final DefaultsNode LOADING_DNODE = new DefaultsNode("Loading Defaults...");
    private static final DefaultMutableTreeNode LOADING_TREE_NODE = new DefaultMutableTreeNode(LOADING_DNODE);
    private static final DefaultsNode ERROR_DNODE = new DefaultsNode("Error Loading Defaults");
    static DefaultMutableTreeNode ERROR_TREE_NODE = new DefaultMutableTreeNode(ERROR_DNODE);
    private SppDefaultsEditorPane pane;
    private DefaultsTableModel tableModel;
    private DefaultTreeModel treeModel;
    private IDefaultsNode droot;
    private NodeModelDelegate nmd;
    private SDebug dbg;
    private boolean dirty;
    private boolean disposed = false;

    public DefaultsController(SppDefaultsEditorPane sppDefaultsEditorPane, NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        this.pane = sppDefaultsEditorPane;
        this.nmd = nodeModelDelegate;
        this.dbg = sDebug;
        this.treeModel = new DefaultTreeModel(LOADING_TREE_NODE);
        this.tableModel = new DefaultsTableModel(this, new DefaultsDataSource());
    }

    public void init(JTable jTable) {
        this.tableModel.initTable(jTable);
        this.setEditorContent(LOADING_TREE_NODE);
    }

    private void refreshPane(String string) {
        this.tableModel.fireTableDataChanged();
        this.refreshTree((DefaultMutableTreeNode)this.treeModel.getRoot());
        this.pane.updateLabel(string);
    }

    private void refreshTree(TreeNode treeNode) {
        this.treeModel.nodeChanged(treeNode);
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            this.refreshTree(treeNode.getChildAt(i));
        }
    }

    private File getFile(boolean bl) {
        byte by;
        String string;
        String string2;
        if (bl) {
            string2 = "Export defaults to file";
            string = "Select the file where defaults should be exported to";
            by = 3;
        } else {
            string2 = "Import defaults from file";
            string = "Select the file from where defaults should be imported";
            by = 1;
        }
        return PersistentFileChooserDialog.getFile((Component)((Object)this.pane), (String)string2, (Object)string, (byte)by, (String)"ctc", (String)"defaults.history", (int)20);
    }

    public void exportDefaults() {
        File file = this.getFile(true);
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        DefaultsManager defaultsManager = this.nmd.getDefaultsManager();
        try {
            defaultsManager.exportDefaults(file);
        }
        catch (Exception exception) {
            if (this.dbg.isSevereEnabled()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            ErrorMsg.displayError((Component)((Object)this.pane), (EID)EMC.EID_FAIL_SAVE_DEFAULTS_PARAM_1, (Object)string);
            return;
        }
        this.pane.updateLabel(string);
    }

    public void importDefaults() {
        File file = this.getFile(false);
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        DefaultsManager defaultsManager = this.nmd.getDefaultsManager();
        try {
            if (!defaultsManager.importDefaults(file, this.getDefaultsRoot(false), new ConfirmImport())) {
                ErrorMsg.displayError((Component)((Object)this.pane), (EID)EMC.EID_FILE_LOAD_PARAM_1, (Object)string);
                return;
            }
        }
        catch (CTCUserException cTCUserException) {
            if (this.dbg.isSevereEnabled()) {
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            ErrorMsg.displayError((Component)((Object)this.pane), (EID)EMC.EID_FILE_LOAD_PARAM_1, (Object)string);
            return;
        }
        catch (Exception exception) {
            if (this.dbg.isSevereEnabled()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            ErrorMsg.displayError((Component)((Object)this.pane), (EID)EMC.EID_NODE_PROP_LOAD);
            return;
        }
        this.dbg.info("Import successful, refreshing pane for " + string);
        if (this.droot.isDirty()) {
            this.dbg.info("Root shows something is dirty for " + string);
            this.refreshPane(string);
            this.pane.setDirty();
        } else {
            this.refreshPane(NODE_DEFAULTS_SOURCE);
        }
    }

    protected final Component getParentComponent() {
        return this.pane;
    }

    public IObservableManager getObservableManager() {
        return this.dummyOM;
    }

    public DefaultsTableModel getTableModel() {
        return this.tableModel;
    }

    public boolean findDefault(String string) {
        return this.getTableModel().findDefault(string);
    }

    public boolean findNextDefault(String string) {
        return this.getTableModel().findNextDefault(string);
    }

    public boolean enableNext() {
        return this.getTableModel().enableNext();
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    private IDefaultsNode getDefaultsRoot(boolean bl) throws Exception {
        if (this.droot == null || bl) {
            this.droot = this.nmd.getDefaultsManager().getDefaultsTree(this.droot);
            if (this.nmd.getDefaultsManager().getErrorString() != null) {
                ErrorMsg.displayError((Component)((Object)this.pane), (EID)EMC.EID_RTRV_DEFAULTS_PARAM_1, (Object)this.nmd.getDefaultsManager().getErrorString());
            }
        }
        return this.droot;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public void setDirty(IDefaultsElement iDefaultsElement) {
        this.pane.setDirty();
        this.updateTreeModel((DefaultMutableTreeNode)this.treeModel.getRoot(), iDefaultsElement.getFullName());
    }

    public void setShellPassword(String string) {
        this.nmd.getDefaultsManager().setPassword(string);
    }

    public boolean validateData() {
        return true;
    }

    private void getSideEffects(IDefaultsNode iDefaultsNode, SideEffects[] sideEffectsArray) {
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            if (iDefaultsNodeArray[i] instanceof IDefaultsElement) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
                this.dbg.fine("Side effects check on  element " + iDefaultsElement.getFullName());
                if (!iDefaultsElement.isDirty()) continue;
                if (iDefaultsElement.causesReboot()) {
                    this.dbg.fine("element " + iDefaultsElement.getFullName() + " reboots");
                    sideEffectsArray[4].increment(iDefaultsElement.getFullName());
                    continue;
                }
                if (iDefaultsElement.disconnects()) {
                    this.dbg.fine("element " + iDefaultsElement.getFullName() + " disconnects");
                    sideEffectsArray[3].increment(iDefaultsElement.getFullName());
                    continue;
                }
                if (iDefaultsElement.reprovisions()) {
                    this.dbg.fine("element " + iDefaultsElement.getFullName() + " reprovisions");
                    sideEffectsArray[1].increment();
                    continue;
                }
                sideEffectsArray[0].increment();
                continue;
            }
            this.dbg.fine("Side effects check on  node " + iDefaultsNodeArray[i].getName());
            this.getSideEffects(iDefaultsNodeArray[i], sideEffectsArray);
        }
    }

    private SideEffects[] getSideEffects(IDefaultsNode iDefaultsNode) {
        SideEffects[] sideEffectsArray = new SideEffects[9];
        for (int i = 0; i < sideEffectsArray.length; ++i) {
            sideEffectsArray[i] = new SideEffects();
        }
        this.getSideEffects(iDefaultsNode, sideEffectsArray);
        return sideEffectsArray;
    }

    private void applyToNode(IDefaultsNode iDefaultsNode) throws Exception {
        if (iDefaultsNode != null) {
            SideEffects[] sideEffectsArray = this.getSideEffects(iDefaultsNode);
            boolean bl = false;
            String string = this.nmd.getPlatform().getReprovisioningScopeForDefaults();
            String string2 = "Changing default values for some node level attributes overrides the current provisioning. \n" + string + "\n";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            int n = 0;
            if (sideEffectsArray[1].whether()) {
                bl = true;
            }
            if (sideEffectsArray[3].whether()) {
                string3 = "Changing default values for " + sideEffectsArray[3].effectors() + " might cause CTC to disconnect.\n";
                n += sideEffectsArray[3].howMany();
                bl = true;
            }
            if (sideEffectsArray[4].whether()) {
                string4 = "Changing default values for " + sideEffectsArray[4].effectors() + " will even cause the node to reboot.\n ";
                n += sideEffectsArray[4].howMany();
                bl = true;
            }
            if (n > 1) {
                string5 = "Because more than one of the defaults changed might cause a loss of connection or a reboot, \nall of the changes requested might not be applied.\n";
            }
            if (bl && !CerentDialog.yesNoDialog((Component)((Object)this.pane), (String)(string2 + string3 + string4 + string5 + "\nDo you want to continue?"), (String)"Apply Defaults to Node")) {
                throw new Exception("The apply was canceled by the user.");
            }
            this.nmd.getDefaultsManager().applyToNode(iDefaultsNode);
        }
    }

    public void applyToModel() throws Exception {
        try {
            this.applyToNode(this.droot);
            this.droot.resetDirty();
            this.refreshPane(NODE_DEFAULTS_SOURCE);
        }
        catch (NotAuthenticated notAuthenticated) {
            throw new AnnotatedException(ErrorMsg.getString((EID)EMC.EID_AUTH_ERROR), (Exception)((Object)notAuthenticated));
        }
        catch (Exception exception) {
            if (this.dbg.isSevereEnabled()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            throw new Exception(exception.getMessage());
        }
    }

    public void refreshFromModel() throws Exception {
        String string = this.getTreeSelection();
        Preferences.instance().setProperty(PROP_PREF, PROP_SCOPE, string);
        new Thread((Runnable)this, "NE Defaults loader for " + this.nmd.getName()).start();
    }

    public void refreshFromModel(int n) throws Exception {
        this.refreshFromModel();
    }

    public void disposeDataSource() {
        this.dbg.fine("disposing");
        this.disposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.disposed) {
            this.dbg.severe("run called on a disposed controller");
        } else {
            this.dbg.severe("running");
            this.pane.clearLabel();
            this.pane.enableButtons(false);
            try {
                this.droot = this.getDefaultsRoot(true);
                DefaultMutableTreeNode defaultMutableTreeNode = this.createTree(this.droot);
                this.treeModel.setRoot(defaultMutableTreeNode);
                String string = Preferences.instance().getProperty(PROP_PREF, PROP_SCOPE, null);
                DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                if (string != null) {
                    defaultMutableTreeNode2 = this.getTreeRoot(defaultMutableTreeNode, string);
                }
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = defaultMutableTreeNode;
                }
                this.pane.getTreeSelectionModel().setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
                this.pane.updateLabel(NODE_DEFAULTS_SOURCE);
            }
            catch (Exception exception) {
                this.setEditorContent(ERROR_TREE_NODE);
                String string = "No reason available";
                if (exception.getMessage() != null) {
                    string = exception.toString();
                }
                if (this.dbg.isSevereEnabled()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                ErrorMsg.displayError((Component)((Object)this.pane), (EID)EMC.EID_RTRV_DEFAULTS_PARAM_1, (Object)string);
            }
            finally {
                this.pane.enableButtons(true);
            }
        }
    }

    private Properties getDefaultsProperties() throws Exception {
        SortableProperties sortableProperties = new SortableProperties(new Properties());
        HashMap hashMap = new HashMap();
        this.fillMap(hashMap, this.getDefaultsRoot(false));
        for (String string : hashMap.keySet()) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)hashMap.get(string);
            sortableProperties.setProperty(string, iDefaultsElement.getValue());
        }
        sortableProperties.setSortedKeys(true);
        return sortableProperties;
    }

    private void fillMap(Map map, IDefaultsNode iDefaultsNode) {
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsNode iDefaultsNode2 = iDefaultsNodeArray[i];
            if (iDefaultsNode2 instanceof IDefaultsElement) {
                map.put(((IDefaultsElement)iDefaultsNode2).getFullName(), iDefaultsNode2);
                continue;
            }
            this.fillMap(map, iDefaultsNode2);
        }
    }

    public void setTableContent(TreePath treePath) {
        if (treePath != null) {
            TreeMap treeMap = new TreeMap();
            this.fillMap(treeMap, this.getDefaultsNode(treePath));
            this.tableModel.setScope(this.tableModel, treeMap);
        }
    }

    public void setEditorContent(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.droot = (DefaultsNode)defaultMutableTreeNode.getUserObject();
        this.treeModel.setRoot(defaultMutableTreeNode);
        this.pane.getTreeSelectionModel().clearSelection();
        this.pane.getTreeSelectionModel().setSelectionPath(new TreePath(defaultMutableTreeNode));
    }

    private void updateTreeModel(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        this.treeModel.nodeChanged(defaultMutableTreeNode);
        int n = string.indexOf(46);
        if (n < 0) {
            return;
        }
        String string2 = string.substring(0, n);
        string = string.substring(n + 1);
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            IDefaultsNode iDefaultsNode = (IDefaultsNode)defaultMutableTreeNode3.getUserObject();
            if (!iDefaultsNode.getName().equals(string2)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            break;
        }
        if (defaultMutableTreeNode2 != null) {
            this.updateTreeModel(defaultMutableTreeNode2, string);
        }
    }

    private String getTreeSelection() {
        TreePath treePath = this.pane.getTreeSelectionModel().getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            return ((IDefaultsNode)defaultMutableTreeNode.getUserObject()).getFullName();
        }
        return "";
    }

    private DefaultMutableTreeNode getTreeRoot(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        String string2;
        int n = string.indexOf(46);
        if (n < 0) {
            string2 = string;
            string = null;
        } else {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            IDefaultsNode iDefaultsNode = (IDefaultsNode)defaultMutableTreeNode3.getUserObject();
            if (!iDefaultsNode.getName().equals(string2)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            break;
        }
        if (defaultMutableTreeNode2 != null && string != null) {
            return this.getTreeRoot(defaultMutableTreeNode2, string);
        }
        return defaultMutableTreeNode2;
    }

    boolean isAuthorized() {
        return this.nmd.isUserAuthorized(SecurityLevel.SUPERUSER);
    }

    private DefaultMutableTreeNode createTree(IDefaultsNode iDefaultsNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(iDefaultsNode);
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        for (int i = 0; i < iDefaultsNodeArray.length && !(iDefaultsNodeArray[i] instanceof IDefaultsElement); ++i) {
            defaultMutableTreeNode.add(this.createTree(iDefaultsNodeArray[i]));
        }
        return defaultMutableTreeNode;
    }

    private IDefaultsNode getDefaultsNode(TreePath treePath) {
        Object var2_2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return (IDefaultsNode)defaultMutableTreeNode.getUserObject();
    }

    private class ConfirmImport
    implements DefaultsManager.IValidity {
        private ConfirmImport() {
        }

        public boolean doCancel(int n, DetailedLog detailedLog) {
            if (detailedLog != null) {
                String string = "Accepted " + n + " defaults with valid values\n" + detailedLog.getDesc() + ".\n" + "Continue importing this file anyway? (Invalid entries will be ignored)";
                DetailedLogDialog detailedLogDialog = new DetailedLogDialog(JOptionPane.getFrameForComponent((Component)((Object)DefaultsController.this.pane)), "Import Defaults", (Icon)CerentDialog.FATAL_ICON, string, detailedLog, true, 3);
                detailedLogDialog.show();
                return detailedLogDialog.isCancelled();
            }
            DefaultsController.this.dbg.severe("Unexpected empty warning list!");
            return false;
        }
    }

    private class SideEffects {
        private String concatenation = null;
        private int count = 0;

        SideEffects() {
        }

        private void increment(String string) {
            this.concatenation = this.concatenation == null ? string : new StringBuffer(this.concatenation.length() + string.length() + 5).append(this.concatenation).append(", ").append(string).toString();
            ++this.count;
        }

        private void increment() {
            ++this.count;
        }

        private boolean whether() {
            return this.count > 0;
        }

        private int howMany() {
            return this.count;
        }

        private String effectors() {
            return this.concatenation;
        }
    }
}

