/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.version.EleInterfaceVersion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class NodeSetupSelection
extends JDialog
implements ActionListener {
    private static final String VIGNETTE = "/images/CTC_dialogVignette.gif";
    private static final String NEXT = "Next>";
    private static final String CANCEL = "Cancel";
    private JList lstNodes;
    private DefaultListModel listModel;
    private JButton nextButton;
    private JButton cancelButton;
    private String[] nodesArray;
    private NsdWizardInfo wzInfo;
    private MouseListener mouseListener = null;

    public NodeSetupSelection(Frame frame, boolean bl, NsdWizardInfo nsdWizardInfo, String[] stringArray) {
        super(frame, "Node Setup Selection for " + nsdWizardInfo.getNodeName(), true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NodeSetupSelection.this.dispose();
            }
        });
        this.mouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                NodeSetupSelection.this.nextButton.setEnabled(!NodeSetupSelection.this.lstNodes.isSelectionEmpty());
            }
        };
        this.nodesArray = stringArray;
        this.wzInfo = nsdWizardInfo;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getUpperPane(), "Center");
        container.add((Component)this.getBottomPane(), "South");
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private JPanel getRightPane() {
        JPanel jPanel = AbstractPane.createVerticalPanel(null);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = AbstractPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel("Select Node Profile:");
        jLabel.setAlignmentX(0.0f);
        jLabel.setHorizontalAlignment(2);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        this.lstNodes = new JList(this.getNodeSetupList());
        this.lstNodes.setSelectionMode(0);
        this.lstNodes.addMouseListener(this.mouseListener);
        jPanel2 = AbstractPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add((Component)new UScrollPane((Component)this.lstNodes));
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel2 = AbstractPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        return jPanel;
    }

    private JPanel getLeftPane() {
        JPanel jPanel = new JPanel();
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource(VIGNETTE));
        jPanel.add(new JLabel(imageIcon));
        return jPanel;
    }

    private JPanel getUpperPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getLeftPane(), "West");
        jPanel.add((Component)this.getRightPane(), "Center");
        return jPanel;
    }

    private JPanel getBottomPane() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 5, 5));
        this.nextButton = new JButton(NEXT);
        this.cancelButton = new JButton(CANCEL);
        jPanel.add(this.nextButton);
        jPanel.add(this.cancelButton);
        jPanel.add(new CSHelpButton(CSHelpConst.NodeSetupWizard));
        this.nextButton.addActionListener(this);
        this.nextButton.setEnabled(false);
        this.cancelButton.addActionListener(this);
        return jPanel;
    }

    private DefaultListModel getNodeSetupList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(this.nodesArray));
        String[] stringArray = arrayList.toArray(new String[0]);
        this.listModel = new DefaultListModel();
        for (int i = 0; i < stringArray.length; ++i) {
            this.listModel.addElement(stringArray[i]);
        }
        return this.listModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.nextButton) {
            this.handleNext();
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    private void handleNext() {
        if (!this.validatePage()) {
            return;
        }
        this.checkXmlFileVersion();
        this.dispose();
    }

    private void checkXmlFileVersion() {
        String string;
        EleInterfaceVersion eleInterfaceVersion = new EleInterfaceVersion();
        String string2 = eleInterfaceVersion.getSwVersion().substring(0, 5);
        String string3 = string = this.wzInfo.getNodesVer()[this.wzInfo.getSelIndex() + 1] != null ? this.wzInfo.getNodesVer()[this.wzInfo.getSelIndex() + 1] : "07.XX";
        if (!string2.regionMatches(true, 0, string, 0, 4)) {
            this.setVisible(false);
            CerentDialog.infoDialog((Component)this, (String)("The NE (" + string + ") that you are trying to import does not match the CTC version (" + string2 + ").\n Some changes may not take effect."), (String)"Wizard Node Selection");
        }
    }

    private boolean validatePage() {
        this.wzInfo.setSelNode((String)this.lstNodes.getSelectedValue());
        return true;
    }

    public void dispose() {
        super.dispose();
    }
}

