/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Optics.eBand;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.ui.nodesetup.IWzTaskListener;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.util.SDebug;
import java.lang.reflect.Field;
import java.util.List;

public abstract class WzTask {
    protected static final String DIVIDER_NONL = "------------------------------------------------";
    protected static final String DIVIDER = "------------------------------------------------";
    protected static final String APPLY = ">> Applied...\n";
    protected static final String DONE = ">> Done...\n";
    protected static final String DOTS = "...";
    protected static final String NEWLINE = "\n";
    private static final String PORT_NFOUND = ">> Cannot find port: ";
    private static final String BADWL = "invalid wavelength value";
    private static final String IDLE = "idle";
    private static final String WORKING = "working";
    private static final String COMPLETED = "completed";
    private String status;
    private IWzTaskListener listener;
    protected final NodeModelDelegate node;
    protected final NsdWizardInfo wzInfo;
    protected final EntityTableModel entm;
    protected boolean isMs = false;
    private static final SDebug db = new SDebug("WzTask");

    public WzTask(NsdWizardInfo nsdWizardInfo, NodeModelDelegate nodeModelDelegate) {
        this.node = nodeModelDelegate;
        this.wzInfo = nsdWizardInfo;
        this.entm = this.node.getEntityTableModel();
        this.isMs = this.node.isMultishelf();
        this.status = IDLE;
    }

    public static void begin(NsdWizardInfo nsdWizardInfo) {
        nsdWizardInfo.logInfo(">>>> Start Time " + nsdWizardInfo.getCurrentTimeStamp() + " <<<<\n");
        nsdWizardInfo.logInfo("------------------------------------------------");
    }

    public final void begin() {
        WzTask.begin(this.wzInfo);
    }

    public static void end(NsdWizardInfo nsdWizardInfo) {
        nsdWizardInfo.logInfo("\n>>>> End Time " + nsdWizardInfo.getCurrentTimeStamp() + " <<<<");
    }

    public final void end() {
        WzTask.end(this.wzInfo);
    }

    public abstract void doTask();

    public final void addListener(IWzTaskListener iWzTaskListener) {
        this.listener = iWzTaskListener;
    }

    private void changeStatus(String string) {
        if (!this.status.equals(string)) {
            this.status = string;
            if (this.listener != null) {
                this.listener.taskStatusChanged();
                if (this.isCompleted()) {
                    this.listener.taskFinished();
                }
            }
        }
    }

    public final boolean isIdle() {
        return this.status.equals(IDLE);
    }

    protected final void setWorking() {
        this.changeStatus(WORKING);
    }

    public final boolean isWorking() {
        return this.status.equals(WORKING);
    }

    protected final void setCompleted() {
        this.wzInfo.logInfo("------------------------------------------------");
        this.changeStatus(COMPLETED);
    }

    public final boolean isCompleted() {
        return this.status.equals(COMPLETED);
    }

    public String toString() {
        return "WzTask: " + this.status;
    }

    protected String getPortString(String string, String string2, String string3, String string4) {
        String string5;
        if (string4 == null) {
            string5 = "Node";
        } else {
            if (string3 != null) {
                string5 = "Unit " + string3;
            } else {
                if (string == null) {
                    string = "x";
                }
                if (string2 == null) {
                    string2 = "x";
                }
                string5 = (this.isMs ? "Shelf " + string + ", " : "") + "Slot " + string2;
            }
            string5 = string5 + ", Port " + string4;
        }
        return string5;
    }

    protected ModuleModel getCardModel(int n, int n2) {
        IEntityModel iEntityModel = null;
        ModuleModel moduleModel = null;
        try {
            iEntityModel = this.entm.getEntityModelBySlot(n, n2);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (WzTask.db.on) {
                db.println("No slot found");
            }
            this.wzInfo.logError(">> Cannot find port: no shelf/slot found\n");
            return null;
        }
        List list = iEntityModel.getChildren();
        if (list == null || list.size() == 0) {
            if (WzTask.db.on) {
                db.println("No card found");
            }
            this.wzInfo.logError(">> Cannot find port: no card found\n");
            return null;
        }
        try {
            moduleModel = (ModuleModel)list.get(0);
        }
        catch (ClassCastException classCastException) {
            this.wzInfo.logError(">> Cannot find port: no card found\n");
            return null;
        }
        return moduleModel;
    }

    protected PortModel getPortModel(String string, String string2, String string3, String string4) {
        ModuleModel moduleModel = null;
        moduleModel = string3 != null ? PassiveModuleModel.getPassiveUnitById(this.node, Integer.parseInt(string3)) : this.getCardModel(Integer.parseInt(string), Integer.parseInt(string2));
        if (moduleModel == null) {
            this.wzInfo.logError(">> Cannot find port: no card found\n");
            return null;
        }
        return this.getPortModel(moduleModel, Integer.parseInt(string4));
    }

    private PortModel getPortModel(ModuleModel moduleModel, int n) {
        PortModel[] portModelArray;
        for (PortModel portModel : portModelArray = moduleModel.getPortModels()) {
            int[] nArray = portModel.getPortNum();
            if (nArray[0] != n) continue;
            return portModel;
        }
        this.wzInfo.logError(">> Cannot find port: no port found\n");
        return null;
    }

    protected eWavelength convertWl(String string) throws Exception {
        eWavelength eWavelength2 = null;
        if (string != null) {
            double d = Double.parseDouble(string);
            long l = (long)d;
            long l2 = (long)((d - (double)l) * 1000.0) + 5L;
            d = (double)l + (double)(l2 /= 10L) / 100.0;
            String string2 = "" + d;
            string2 = string2.replaceAll("\\.", "_");
            string2 = string2.replaceAll(",", "_");
            String string3 = "WV_" + string2;
            try {
                Field field = eWavelength.class.getField(string3);
                eWavelength2 = (eWavelength)field.get(null);
            }
            catch (Throwable throwable) {
                throw new Exception(BADWL);
            }
        }
        return eWavelength2;
    }

    protected eBand convertBand(String string) throws Exception {
        eBand eBand2 = null;
        if (string != null) {
            double d = Double.parseDouble(string);
            long l = (long)d;
            long l2 = (long)((d - (double)l) * 1000.0) + 5L;
            d = (double)l + (double)(l2 /= 10L) / 100.0;
            String string2 = "" + d;
            string2 = string2.replaceAll("\\.", "_");
            string2 = string2.replaceAll(",", "_");
            String string3 = "BN_" + string2;
            try {
                Field field = eBand.class.getField(string3);
                eBand2 = (eBand)field.get(null);
            }
            catch (Throwable throwable) {
                throw new Exception(BADWL);
            }
        }
        return eBand2;
    }
}

