/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.SonetMedia.sLineStats;
import cerent.cms.idl.SonetMedia.sPhysicalStats;
import cerent.cms.idl.SonetMedia.sSectionStats;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmLineStats;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererStat;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.util.SDebug;

public abstract class PmLayerTdmLine
extends PmLayer {
    protected sLineStats[] lineStatsVal;
    protected TdmLineModel model = null;
    protected int numRegisters;
    protected int numParms;
    protected int lineParmCount;
    protected int phyParmCount;
    protected sSectionStats[] sectionStatsVal;
    protected sPhysicalStats[] physicalStatsVal;
    public static String[] parmNames;
    public static String[] phyParmNames;
    public static final int LBC_INDEX = 0;
    public static final int OPT_INDEX = 1;
    public static final int OPR_INDEX = 2;
    public static final int NUM_PHY_PM = 3;
    protected int BASE_PSCW_INDEX;
    protected int BASE_PSCS_INDEX;
    protected int BASE_PSC_INDEX;
    private static final sSectionStats _defaultSectionStats;
    private static final sLineStats _defaultLineStats;
    private static final sPhysicalStats _defaultPhysicalStats;
    private static final SDebug db;

    public PmLayerTdmLine(PmTableModel pmTableModel, TdmLineModel tdmLineModel, int n, boolean bl) {
        super(pmTableModel, tdmLineModel, bl);
        this.model = tdmLineModel;
        this.initParms();
        this.numRegisters = n;
        this.sectionStatsVal = new sSectionStats[n];
        this.lineStatsVal = new sLineStats[n];
        this.physicalStatsVal = new sPhysicalStats[n];
        this.tossData();
    }

    public PmLayerTdmLine(PmTableModel pmTableModel, TdmLineModel tdmLineModel, int n) {
        this(pmTableModel, tdmLineModel, n, true);
    }

    protected void initParms() {
        this.initLineParamNames();
        this.initParamCount();
    }

    protected abstract void initLineParamNames();

    protected void initParamCount() {
        this.phyParmCount = 0;
        try {
            int n = this.model.getModuleModel().getEqType();
            if (n == 9) {
                this.lineParmCount = this.BASE_PSCW_INDEX;
            } else if (n == 10 || n == 85) {
                this.lineParmCount = this.BASE_PSCS_INDEX;
            } else if (n == 118 || n == 120 || n == 121 || n == 181 || n == 182 || n == 274 || n == 275 || n == 276 || n == 119) {
                this.lineParmCount = this.BASE_PSC_INDEX;
            } else if (n == 157 || n == 232 || n == 106) {
                this.lineParmCount = this.BASE_PSCW_INDEX;
            }
            this.phyParmCount = this.supportsPhysicalPm() ? 3 : 0;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.println("Caught AbstractCmsNoSuchEntityException. Could not get ModuleModel");
        }
        this.numParms = this.lineParmCount + this.phyParmCount;
    }

    public void clearStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.model.clearStats(this.nearEnd, this.intervalType);
    }

    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (this.sectionStatsVal[n] == null || this.lineStatsVal[n] == null || this.physicalStatsVal[n] == null || this.sectionStatsVal[n] == _defaultSectionStats || this.lineStatsVal[n] == _defaultLineStats || this.physicalStatsVal[n] == _defaultPhysicalStats) {
            this.sectionStatsVal[n] = _defaultSectionStats;
            this.lineStatsVal[n] = _defaultLineStats;
            this.physicalStatsVal[n] = _defaultPhysicalStats;
            try {
                TdmLineStats tdmLineStats = this.model.getStats(this.nearEnd, this.intervalType, (short)n);
                this.sectionStatsVal[n] = tdmLineStats.sectionStats;
                this.lineStatsVal[n] = tdmLineStats.lineStats;
                this.physicalStatsVal[n] = tdmLineStats.physicalStats;
            }
            catch (InternalCommError internalCommError) {
                this.sectionStatsVal[n] = new sSectionStats(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);
                this.lineStatsVal[n] = new sLineStats(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);
                this.physicalStatsVal[n] = new sPhysicalStats(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID);
                throw internalCommError;
            }
            if (db.on() && n == 0) {
                this.printStats(0);
            }
        }
    }

    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        Object object = new PmRendererStat(PM_STATS_INVALID);
        if (n < this.lineParmCount) {
            object = this.getLinePmValue(n, n2);
        } else if ((n -= this.lineParmCount) < this.phyParmCount) {
            object = this.getPhysicalPmValue(n, n2);
        }
        return object;
    }

    protected abstract Object getLinePmValue(int var1, int var2) throws NoSuchInterface, WrongInterfaceType, InternalCommError;

    protected Object getPhysicalPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        sPmStat sPmStat2 = PM_STATS_INVALID;
        switch (n) {
            case 0: {
                sPmStat2 = this.physicalStatsVal[n2].lbc;
                break;
            }
            case 1: {
                sPmStat2 = this.physicalStatsVal[n2].opt;
                break;
            }
            case 2: {
                sPmStat2 = this.physicalStatsVal[n2].opr;
                break;
            }
            default: {
                db.println("WARNING: PmLayerTdmLine.getPmValue needs updating, unknown value " + n);
            }
        }
        return new PmRendererStat(sPmStat2);
    }

    public String parmName(int n) {
        String string = "";
        if (n < this.lineParmCount) {
            string = parmNames[n];
        } else if ((n -= this.lineParmCount) < this.phyParmCount) {
            string = phyParmNames[n];
        }
        return string;
    }

    public int parmCount() {
        return this.numParms;
    }

    private void printStats(int n) {
        db.println("Section sefs=" + this.strPmStat(this.sectionStatsVal[n].sefs) + " ses" + this.strPmStat(this.sectionStatsVal[n].ses) + " es" + this.strPmStat(this.sectionStatsVal[n].es) + " cv" + this.strPmStat(this.sectionStatsVal[n].cv) + " uas" + this.strPmStat(this.sectionStatsVal[n].uas));
        db.println("Line cv=" + this.strPmStat(this.lineStatsVal[n].cv) + " es=" + this.strPmStat(this.lineStatsVal[n].es) + " ses=" + this.strPmStat(this.lineStatsVal[n].ses) + " uas=" + this.strPmStat(this.lineStatsVal[n].uas) + " fc=" + this.strPmStat(this.lineStatsVal[n].fc));
        db.println("Physical lbc=" + this.strPmStat(this.physicalStatsVal[n].lbc) + " opt=" + this.strPmStat(this.physicalStatsVal[n].opt) + " opr=" + this.strPmStat(this.physicalStatsVal[n].opr));
    }

    private String strPmStat(sPmStat sPmStat2) {
        if (sPmStat2.valid) {
            return Integer.toString(sPmStat2.cnt);
        }
        return "#";
    }

    public void setModel(InterfaceModel interfaceModel) {
        this.model = (TdmLineModel)interfaceModel;
    }

    public void tossData() {
        for (int i = 0; i < this.numRegisters; ++i) {
            this.sectionStatsVal[i] = null;
            this.lineStatsVal[i] = null;
            this.physicalStatsVal[i] = null;
        }
    }

    protected boolean supportsPhysicalPm() throws AbstractCmsNoSuchEntityException {
        return this.model.getModuleModel().supportsPhysicalPm();
    }

    static {
        phyParmNames = new String[]{"LBC (%)", "OPT (%)", "OPR (%)"};
        _defaultSectionStats = new sSectionStats(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);
        _defaultLineStats = new sLineStats(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);
        _defaultPhysicalStats = new sPhysicalStats(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID);
        db = new SDebug("PmLayerTdmLine");
    }
}

