/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.rmon;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EtherLineUpdate;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.RmonLineUpdate;
import cerent.cms.model.RmonModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.rmon.RmonPmCellRenderer;
import cerent.cms.ui.rmon.RmonPmHistTableModel;
import cerent.util.IAsyncObserver;
import cerent.util.SDebug;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class RmonPmHistPane
extends AbstractPane
implements ActionListener,
IAsyncObserver,
Runnable {
    private int[] widths = new int[]{230, 80};
    private JButton retrieveButton;
    private JLabel retrievalTime;
    private UComboBox seriesCB;
    private UComboBox portCB;
    private RmonPmCellRenderer pmCellRenderer;
    private RmonPmHistTableModel dataModel;
    private String statusString;
    private JobStatus jobStatus;
    protected ModuleModel eqpmtModel;
    protected IRmonModel[] rmonModels;
    private static final SDebug db = new SDebug("RmonPmHistPane");

    public RmonPmHistPane(String string, TabbedView tabbedView, IRmonModel[] iRmonModelArray) {
        this(string, tabbedView, null, iRmonModelArray);
        this.eqpmtModel = (ModuleModel)this.getUiModel();
    }

    public RmonPmHistPane(String string, TabbedView tabbedView, ModuleModel moduleModel, IRmonModel[] iRmonModelArray) {
        super(string, tabbedView);
        this.rmonModels = iRmonModelArray;
        this.eqpmtModel = moduleModel;
        this.registerWithModel();
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof RmonLineUpdate) {
            RmonLineUpdate rmonLineUpdate = (RmonLineUpdate)object;
            if (db.on()) {
                db.println("Received RmonLineUpdate...");
            }
            this.setLineModels(rmonLineUpdate.getRmonModels());
        } else if (object instanceof EtherLineUpdate) {
            EtherLineUpdate etherLineUpdate = (EtherLineUpdate)object;
            EtherLineModel[] etherLineModelArray = etherLineUpdate.getEtherLineModels();
            if (etherLineModelArray == null) {
                if (db.on()) {
                    db.println("Received EtherLineUpdate. No ETHER port");
                }
                return;
            }
            IRmonModel[] iRmonModelArray = new IRmonModel[etherLineModelArray.length];
            for (int i = 0; i < iRmonModelArray.length; ++i) {
                iRmonModelArray[i] = etherLineModelArray[i].getRmonModel();
            }
            if (db.on()) {
                db.println("Received EtherLineUpdate. Num of line is " + etherLineModelArray.length);
            }
            this.setLineModels(iRmonModelArray);
        } else {
            db.fine("refreshMyLines received " + object);
        }
    }

    private void init() {
        Serializable serializable;
        this.setLayout(new BorderLayout());
        NodeModelDelegate nodeModelDelegate = this.eqpmtModel.getNodeModelDelegate();
        this.dataModel = this.getDataModel();
        this.retrievalTime = new JLabel(" ");
        this.retrievalTime.setHorizontalAlignment(0);
        this.pmCellRenderer = new RmonPmCellRenderer();
        this.table = new UTable((TableModel)this.dataModel);
        this.table.getTableHeader().setUpdateTableInRealTime(true);
        this.table.setDefaultRenderer(Long.class, this.pmCellRenderer);
        this.table.setDefaultRenderer(String.class, this.pmCellRenderer);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        UTable uTable = new UTable((TableModel)this.dataModel);
        uTable.setExportable(false);
        uTable.getTableHeader().setUpdateTableInRealTime(false);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        for (int i = 0; i < 1; ++i) {
            serializable = tableColumnModel.getColumn(0);
            tableColumnModel.removeColumn((TableColumn)serializable);
            ((TableColumn)serializable).setPreferredWidth(this.widths[i]);
            ((TableColumn)serializable).setResizable(false);
            ((TableColumn)serializable).setMinWidth(this.widths[i]);
            ((TableColumn)serializable).setMaxWidth(this.widths[i]);
            defaultTableColumnModel.addColumn((TableColumn)serializable);
        }
        this.table.setColumnModel(tableColumnModel);
        uTable.setColumnModel(defaultTableColumnModel);
        uTable.setPreferredScrollableViewportSize(uTable.getPreferredSize());
        uTable.getTableHeader().setReorderingAllowed(false);
        uTable.setAutoCreateColumnsFromModel(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(false);
        uTable.setCellSelectionEnabled(false);
        uTable.setRowSelectionAllowed(false);
        uScrollPane.setRowHeaderView((Component)uTable);
        uScrollPane.setCorner("UPPER_LEFT_CORNER", (Component)uTable.getTableHeader());
        JPanel jPanel = RmonPmHistPane.createVerticalPanel(null);
        this.retrievalTime.setAlignmentX(0.0f);
        uScrollPane.setAlignmentX(0.0f);
        serializable = RmonPmHistPane.createHorizontalPanel(null);
        ((Container)serializable).setLayout(new FlowLayout(0, 5, 5));
        ((Container)serializable).add(this.retrievalTime);
        jPanel.add(this.makeControlPanel());
        jPanel.add((Component)serializable);
        this.add(jPanel, "South");
        this.add((Component)uScrollPane, "Center");
        this.updateControls();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    protected RmonPmHistTableModel getDataModel() {
        return new RmonPmHistTableModel(this, this.eqpmtModel);
    }

    public void fixedUpColumn() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < 1; ++i) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        }
        this.table.repaint();
    }

    private JPanel makeControlPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = RmonPmHistPane.createHorizontalPanel(null);
        this.seriesCB = new UComboBox((Object[])ElementDefaults.PM_INTERVAL_TYPES);
        this.seriesCB.setSelectedIndex(0);
        this.portCB = new UComboBox(this.getPortList());
        this.portCB.setRenderer((ListCellRenderer)new RmonCardPortRenderer());
        this.portCB.setPreferredSize(new Dimension(150, 50));
        this.retrieveButton = new JButton("Refresh");
        this.retrieveButton.addActionListener(this);
        jPanel2.add(new JLabel("Interval:"));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this.seriesCB);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(new JLabel("Port:"));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this.portCB);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.retrieveButton);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(new CSHelpButton(CSHelpConst.RmonPmHistPane));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 50, 5, 50));
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)new JLabel(), "East");
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.retrieveButton) {
            this.refreshNow();
        }
    }

    protected Vector getPortList() {
        Vector<PortModel> vector = new Vector<PortModel>();
        for (int i = 0; i < this.rmonModels.length; ++i) {
            try {
                vector.add(this.rmonModels[i].getPortModel());
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return vector;
    }

    public void enteringPage() {
        if (this.dataModel == null) {
            this.init();
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.refreshNow();
    }

    public void leavingPage() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    public void refresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshNow() {
        try {
            this.setCursor(3);
            if (this.seriesCB.getSelectedIndex() != -1 && this.portCB.getSelectedIndex() != -1) {
                int n = this.portCB.getSelectedIndex();
                this.dataModel.refresh(this.rmonModels[n], this.seriesCB.getSelectedIndex(), this);
                this.updateTimeLabel(n);
            } else {
                this.dataModel.refresh(null, 0, this);
                this.retrievalTime.setText("");
            }
        }
        catch (InternalCommError internalCommError) {
            db.println("Caught InternalCommError in refreshNow!");
            if (db.on()) {
                SDebug.printStackTrace((Throwable)internalCommError);
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                db.println("Caught exception in RmonPmHistPane.refreshNow: " + (Object)((Object)noSuchInterface));
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in RmonPmHistPane.refreshNow: " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.setCursor(0);
        }
    }

    private void updateTimeLabel(int n) {
        String string = this.dataModel.getLastIntervalTimeStamp();
        if (string.length() > 0) {
            String string2 = RmonModel.getSeriesDesc(this.seriesCB.getSelectedIndex());
            this.retrievalTime.setText("\"Prev\"" + string2 + " interval start time: " + string);
        } else {
            this.retrievalTime.setText(" ");
        }
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void dispose() {
        if (this.dataModel != null) {
            this.dataModel.dispose();
        }
        super.dispose();
    }

    public void setLineModels(IRmonModel[] iRmonModelArray) {
        this.rmonModels = iRmonModelArray;
        if (this.dataModel != null) {
            this.updateControls();
            this.refreshNow();
        }
    }

    private void updateControls() {
        boolean bl = this.rmonModels.length != 0;
        Object object = this.portCB.getSelectedItem();
        this.portCB.removeAllItems();
        if (bl) {
            for (int i = 0; i < this.rmonModels.length; ++i) {
                try {
                    this.portCB.addItem((Object)this.rmonModels[i].getPortModel());
                    continue;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            if (object == null) {
                if (this.portCB.getItemCount() > 0) {
                    this.portCB.setSelectedIndex(0);
                }
            } else {
                this.portCB.setSelectedItem(object);
            }
        }
        this.seriesCB.setEnabled(bl);
        this.portCB.setEnabled(bl);
        this.retrieveButton.setEnabled(bl);
    }

    public void asyncUpdate(Object object, JobStatus jobStatus) {
        this.statusString = (String)object;
        this.jobStatus = jobStatus;
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        if (this.jobStatus == JobStatus.JOB_COMPLETE) {
            if (this.portCB.getSelectedIndex() != -1) {
                this.updateTimeLabel(this.portCB.getSelectedIndex());
            }
            this.retrieveButton.setEnabled(true);
        } else if (this.statusString != null) {
            this.retrievalTime.setText("Retrieving " + this.statusString + "...");
        }
    }

    class RmonCardPortRenderer
    extends JLabel
    implements ListCellRenderer {
        public RmonCardPortRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            try {
                if (object instanceof String) {
                    this.setText((String)object);
                } else if (object instanceof PortModel) {
                    PortModel portModel = (PortModel)object;
                    EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                    this.setText(entityCellRenderer.getPortString(portModel, false));
                }
            }
            catch (Exception exception) {
                db.println("RmonCardPortRenderer caught Exception: " + exception);
            }
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }
}

