/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.rmon;

import cerent.cms.idl.Common.sTime;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EtherLineUpdate;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.Operation;
import cerent.cms.model.PortModel;
import cerent.cms.model.RmonLineUpdate;
import cerent.cms.model.SecurityModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.BaselineStatsDialog;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.ClearStatsDialog;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.rmon.RmonPmCellRenderer;
import cerent.cms.ui.rmon.RmonPmStatTableModel;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IAsyncObserver;
import cerent.util.ObservableManager;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class RmonPmStatPane
extends AbstractPane
implements ActionListener,
IAsyncObserver,
Runnable {
    private static final int colZeroWidth = 230;
    private boolean bSameStatsId;
    protected IRmonModel[] rmonModels;
    protected ModuleModel moduleModel;
    protected NodeModelDelegate nodeModel;
    public static final String REFRESH = "Refresh";
    private JButton refreshPB;
    public static final String ZERO = "Clear...";
    public static final String ZERO_TOOLTIP = "Initialize current registers to zero";
    private JButton zeroPB;
    public static final String BASELINE = "Baseline...";
    public static final String BASELINE_TOOLTIP = "Establish current data as a baseline reference";
    private JButton baselinePB;
    private JLabel dateLB;
    private RmonPmCellRenderer pmCellRenderer;
    private Timer refreshTimer;
    private RefreshTimerListener refreshTimerListener;
    private static final String CLEAR_CURRENT_MSG = "Proceeding will clear these statistics on the card\nand cannot be undone.  Do you really want to initialize\nthe currently selected registers to zero (port";
    private static final String CLEAR_PORT_MSG_1 = "Proceeding will clear these statistics of port ";
    private static final String CLEAR_PORT_MSG_2 = " on the card\nand cannot be undone.  Do you really want to initialize\nall current registers on port ";
    private static final String CLEAR_CARD_MSG = "Proceeding will clear these statistics on the card\nand cannot be undone.  Do you really want to initialize\nall current registers on all ports of the card to zero?";
    private String[] rateStrs = new String[]{"None", "15 Seconds", "30 Seconds", "1 Minute", "3 Minutes", "5 Minutes"};
    private String statusString;
    private JobStatus jobStatus;
    private int[] rates = new int[]{86400000, 15000, 30000, 60000, 180000, 300000};
    private JTable table2;
    private UComboBox refreshComboBox;
    private String autoRefreshPrefPath;
    private String autoRefreshPrefKey;
    private boolean enteringPage = false;
    private RmonPmStatTableModel dataModel;
    private SecurityModel secModel;
    private Observer pmClearObserver;
    private MouseListener headerListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent mouseEvent) {
            JTable jTable = ((JTableHeader)mouseEvent.getComponent()).getTable();
            if (jTable != null) {
                Point point = mouseEvent.getPoint();
                int n = jTable.getTableHeader().columnAtPoint(point);
                if (n != -1) {
                    jTable.addColumnSelectionInterval(n, n);
                }
            }
        }
    };
    private ObservableManager _obsMgr;
    private static final SDebug db = new SDebug("RmonPmStatPane");

    public RmonPmStatPane(String string, TabbedView tabbedView, IRmonModel[] iRmonModelArray) {
        this(string, tabbedView, iRmonModelArray, true);
    }

    public RmonPmStatPane(String string, TabbedView tabbedView, IRmonModel[] iRmonModelArray, boolean bl) {
        super(string, tabbedView);
        this.rmonModels = iRmonModelArray;
        this.moduleModel = (ModuleModel)this.getUiModel();
        this.nodeModel = this.moduleModel.getNodeModelDelegate();
        this.bSameStatsId = bl;
        this.registerWithModel();
    }

    private void setupColumnHeader() {
        this.table.getTableHeader().setUpdateTableInRealTime(true);
        this.table.setDefaultRenderer(Long.class, this.pmCellRenderer);
        this.table.setDefaultRenderer(String.class, this.pmCellRenderer);
        this.table.setColumnSelectionAllowed(true);
        this.table.setRowSelectionAllowed(false);
        this.table.setSelectionMode(0);
        if (this.rmonModels.length != 0) {
            this.table.addColumnSelectionInterval(1, 1);
        }
        this.table2.getTableHeader().setUpdateTableInRealTime(false);
        this.table2.setColumnSelectionAllowed(false);
        this.table2.setRowSelectionAllowed(false);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        int n = this.table.getFontMetrics(this.table.getFont()).stringWidth("888/88/88 88:88:88 8888");
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumnModel.removeColumn(tableColumn);
        tableColumn.setPreferredWidth(230);
        tableColumn.setResizable(false);
        tableColumn.setMinWidth(230);
        tableColumn.setMaxWidth(230);
        defaultTableColumnModel.addColumn(tableColumn);
        for (int i = 0; i < this.rmonModels.length; ++i) {
            tableColumnModel.getColumn(i).setHeaderRenderer(new RmonPortTableHeaderRenderer(this.getName(), this.moduleModel));
            try {
                PortModel portModel = this.rmonModels[i].getPortModel();
                tableColumnModel.getColumn(i).setHeaderValue(portModel);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            tableColumnModel.getColumn(i).setPreferredWidth(n);
        }
        this.table2.setColumnModel(defaultTableColumnModel);
        this.table2.setPreferredScrollableViewportSize(new Dimension(tableColumn.getPreferredWidth() + this.table2.getColumnModel().getColumnMargin(), 0));
        this.table2.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().addMouseListener(this.headerListener);
    }

    private void init() {
        this.getObsMgr().addObservable(this.toObservables(this.rmonModels));
        this.dataModel = new RmonPmStatTableModel(this.rmonModels, this.moduleModel, this.bSameStatsId);
        this.setLayout(new BorderLayout());
        this.refreshTimer = null;
        this.refreshTimerListener = new RefreshTimerListener();
        this.pmCellRenderer = new RmonPmCellRenderer();
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table2 = new UTable((TableModel)this.dataModel);
        ((UTable)this.table2).setExportable(false);
        this.setupColumnHeader();
        uScrollPane.setRowHeaderView((Component)this.table2);
        uScrollPane.setCorner("UPPER_LEFT_CORNER", (Component)this.table2.getTableHeader());
        this.dateLB = new JLabel(" ");
        this.dateLB.setAlignmentX(0.0f);
        uScrollPane.setAlignmentX(0.0f);
        JPanel jPanel = RmonPmStatPane.createVerticalPanel(null);
        JPanel jPanel2 = RmonPmStatPane.createHorizontalPanel(null);
        jPanel2.setLayout(new FlowLayout(0, 5, 5));
        jPanel2.add(this.dateLB);
        jPanel.add(this.getButtonBar());
        jPanel.add(jPanel2);
        this.add(jPanel, "South");
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.autoRefreshPrefPath = "ctc";
        this.autoRefreshPrefKey = "PM-auto-refresh-rate";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshPB) {
            this.refreshNow(null);
        } else if (object == this.baselinePB) {
            this.baselineStats();
        } else if (object == this.zeroPB) {
            this.clearStats();
        } else if (db.on()) {
            db.println("actionPerformed by unknown component");
        }
    }

    private void baselineStats() {
        int[] nArray = this.getSelectedPortNum();
        BaselineStatsDialog baselineStatsDialog = new BaselineStatsDialog(this.uiToolkit.getApplicationFrame(), nArray);
        baselineStatsDialog.setAllPortRadioButtonTitle(null);
        baselineStatsDialog.setVisible(true);
        int n = baselineStatsDialog.getChoice();
        if (n != 0) {
            if ((n & 4) != 0) {
                if ((n & 2) != 0) {
                    this.dataModel.setBaseline();
                } else {
                    int[] nArray2 = this.table.getSelectedColumns();
                    if (nArray2 != null) {
                        this.dataModel.setBaseline(nArray2[0]);
                    }
                }
            } else if ((n & 2) != 0) {
                this.dataModel.resetBaseline();
            } else {
                int[] nArray3 = this.table.getSelectedColumns();
                if (nArray3 != null) {
                    this.dataModel.resetBaseline(nArray3[0]);
                }
            }
        }
        baselineStatsDialog.dispose();
    }

    private int[] getSelectedPortNum() {
        int[] nArray;
        block3: {
            nArray = null;
            try {
                nArray = this.rmonModels[this.table.getSelectedColumns()[0]].getPortModel().getPortNum();
                String string = this.getName();
                if (string.equals("RPR Span")) {
                    nArray = new int[]{-1};
                }
            }
            catch (Exception exception) {
                nArray = new int[]{-1};
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return nArray;
    }

    private void clearStats() {
        if (this.moduleModel.getNodeModelDelegate().isVersionUpStateEnabled()) {
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_NODE_UPGRADING_EXCEPTION);
            return;
        }
        String string = null;
        int[] nArray = null;
        int[] nArray2 = this.getSelectedPortNum();
        ClearStatsDialog clearStatsDialog = new ClearStatsDialog(this.uiToolkit.getApplicationFrame(), nArray2, false);
        String string2 = this.getName();
        if (string2.equals("RPR Span")) {
            clearStatsDialog.setVisible(false);
        } else {
            clearStatsDialog.setVisible(true);
        }
        switch (clearStatsDialog.getChoice()) {
            case 0: {
                if (!db.on()) break;
                db.println("CLEAR_NONE");
                break;
            }
            case 2: {
                String string3 = PortHelper.getConcatenatedString((int[])nArray2);
                if (db.on()) {
                    db.println("CLEAR PORT " + string3);
                }
                string = CLEAR_PORT_MSG_1 + string3 + CLEAR_PORT_MSG_2 + string3 + "?";
                nArray = new int[]{this.table.getSelectedColumns()[0]};
                break;
            }
            case 3: {
                if (db.on()) {
                    db.println("CLEAR ALL PORTS");
                }
                string = CLEAR_CARD_MSG;
                nArray = new int[this.rmonModels.length];
                for (int i = 0; i < this.rmonModels.length; ++i) {
                    nArray[i] = i;
                }
                break;
            }
            default: {
                if (!db.on()) break;
                db.println("NOTHING SELECTED!");
            }
        }
        clearStatsDialog.dispose();
        if (string != null && CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)"Zero Data")) {
            if (db.on()) {
                db.print("calling dataModel.clearStats( [");
                for (int i = 0; i < nArray.length; ++i) {
                    db.print(nArray[i] + (i < nArray.length - 1 ? "," : ""));
                }
                db.println("] )");
            }
            try {
                this.dataModel.clearStats(nArray);
                if (clearStatsDialog.getChoice() != 2) {
                    this.refreshNow(null);
                } else {
                    this.refreshNow(nArray);
                }
            }
            catch (InternalCommError internalCommError) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_COMMUNICATION_ERROR_PARAM_1, (Object)"Error Zeroing Data");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshNow(int[] nArray) {
        try {
            this.setCursor(3);
            this.updateTimeLabel();
            if (this.dataModel != null) {
                this.dataModel.refreshData(this, nArray);
            } else if (db.on()) {
                db.println("  The dataModel is null!!");
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in RmonPmStatPane.refreshNow: " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.setCursor(0);
        }
    }

    public void enteringPage() {
        this.enteringPage = true;
        if (this.dataModel == null) {
            this.init();
        }
        if (this.pmClearObserver != null) {
            this.enableZeroPB();
            this.secModel.addObserver(this.pmClearObserver);
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        int n = Preferences.instance().getInt(this.autoRefreshPrefPath, this.autoRefreshPrefKey, 0);
        if (null != this.refreshComboBox) {
            int n2 = this.getIndexForMillis(n);
            this.refreshComboBox.setSelectedIndex(n2);
            if (null != this.refreshTimer) {
                if (0 == n2) {
                    if (db.on()) {
                        db.println("Stopping auto-refresh timer.A");
                    }
                    this.refreshTimer.stop();
                } else if (!this.refreshTimer.isRunning()) {
                    if (db.on()) {
                        db.println("Starting auto-refresh timer.B delay = " + this.refreshTimer.getDelay());
                    }
                    this.refreshTimer.start();
                } else if (db.on()) {
                    db.println("refreshTimer was already running with delay = " + this.refreshTimer.getDelay());
                }
            }
        }
        this.getObsMgr().setPassing(true);
        this.refreshNow(null);
        this.enteringPage = false;
    }

    public void leavingPage() {
        if (this.pmClearObserver != null) {
            this.secModel.deleteObserver(this.pmClearObserver);
        }
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (null != this.refreshComboBox) {
            this.saveAutoRefreshPref();
        }
        if (null != this.refreshTimer) {
            if (db.on()) {
                db.println("Stopping auto-refresh timer.B");
            }
            this.refreshTimer.stop();
        }
        this.dataModel.resetBaseline();
    }

    private int getIndexForMillis(int n) {
        int n2 = 0;
        for (int i = 0; i < this.rates.length; ++i) {
            if (this.rates[i] != n) continue;
            n2 = i;
        }
        return n2;
    }

    private void saveAutoRefreshPref() {
        if (null != this.refreshComboBox) {
            int n = this.refreshComboBox.getSelectedIndex();
            int n2 = this.rates[n];
            Preferences.instance().setInt(this.autoRefreshPrefPath, this.autoRefreshPrefKey, n2);
        }
    }

    public void refresh() {
    }

    public void updateTimeLabel() {
        sTime sTime2;
        try {
            sTime2 = this.nodeModel.getTime();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            sTime2 = new sTime(0, 0, 0, 1, 1, 1970, false);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(sTime2.year, sTime2.month - 1, sTime2.day, sTime2.hour, sTime2.minute, sTime2.second);
        this.dateLB.setText("Statistics at " + DateFormat.getDateTimeInstance(1, 1).format(gregorianCalendar.getTime()));
    }

    private UComboBox addCB(String string) {
        UComboBox uComboBox = new UComboBox();
        uComboBox.setName(string);
        uComboBox.addActionListener((ActionListener)this);
        return uComboBox;
    }

    private JPanel getButtonBar() {
        JPanel jPanel = RmonPmStatPane.createHorizontalPanel(null);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 50, 5, 50));
        this.refreshPB = new JButton(REFRESH);
        this.refreshPB.addActionListener(this);
        this.refreshPB.setAlignmentY(0.5f);
        JPanel jPanel2 = new JPanel();
        this.refreshComboBox = new UComboBox((Object[])this.rateStrs);
        this.refreshComboBox.addItemListener((ItemListener)new RefreshComboBoxListener());
        jPanel2.add(new JLabel("Auto-refresh:"));
        jPanel2.add((Component)this.refreshComboBox);
        this.baselinePB = new JButton(BASELINE);
        this.baselinePB.addActionListener(this);
        this.baselinePB.setToolTipText(BASELINE_TOOLTIP);
        jPanel.add(Box.createHorizontalStrut(4));
        jPanel.add(this.refreshPB);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.baselinePB);
        jPanel.add(Box.createHorizontalStrut(4));
        this.secModel = (SecurityModel)this.nodeModel.getSecurityModel();
        if (this.moduleModel.supportsClearPM()) {
            this.zeroPB = new JButton(ZERO);
            this.zeroPB.setAlignmentY(0.5f);
            this.zeroPB.setToolTipText(ZERO_TOOLTIP);
            this.zeroPB.setVisible(true);
            this.zeroPB.addActionListener(this);
            jPanel.add(this.zeroPB);
            this.pmClearObserver = new Observer(){

                public void update(Observable observable, Object object) {
                    RmonPmStatPane.this.enableZeroPB();
                }
            };
            this.enableZeroPB();
        }
        jPanel.add(Box.createHorizontalStrut(4));
        jPanel.add(new CSHelpButton(CSHelpConst.RmonPmStatPane));
        jPanel.add(Box.createHorizontalStrut(4));
        return jPanel;
    }

    public void destroy() {
        super.destroy();
    }

    public void dispose() {
        if (this.table != null && this.table.getTableHeader() != null) {
            this.table.getTableHeader().removeMouseListener(this.headerListener);
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
        if (this.dataModel != null) {
            this.dataModel.dispose();
        }
        super.dispose();
    }

    public void asyncUpdate(Object object, JobStatus jobStatus) {
        this.statusString = (String)object;
        this.jobStatus = jobStatus;
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        if (this.jobStatus == JobStatus.JOB_COMPLETE) {
            this.updateTimeLabel();
            this.refreshPB.setEnabled(true);
        } else if (this.statusString != null) {
            this.dateLB.setText("Retrieving " + this.statusString + "...");
        }
    }

    protected void refreshMyLines(Object object) {
        boolean bl = false;
        if (object instanceof RmonLineUpdate) {
            if (db.on()) {
                db.println("Received RmonLineUpdate...");
            }
            bl = true;
            RmonLineUpdate rmonLineUpdate = (RmonLineUpdate)object;
            this.rmonModels = rmonLineUpdate.getRmonModels();
        } else if (object instanceof EtherLineUpdate) {
            if (db.on()) {
                db.println("Received EtherLineUpdate...");
            }
            bl = true;
            EtherLineUpdate etherLineUpdate = (EtherLineUpdate)object;
            EtherLineModel[] etherLineModelArray = etherLineUpdate.getEtherLineModels();
            if (etherLineModelArray == null) {
                if (db.on()) {
                    db.println("Received EtherLineUpdate. No ETHER port");
                }
                return;
            }
            IRmonModel[] iRmonModelArray = new IRmonModel[etherLineModelArray.length];
            for (int i = 0; i < iRmonModelArray.length; ++i) {
                iRmonModelArray[i] = etherLineModelArray[i].getRmonModel();
            }
            this.rmonModels = iRmonModelArray;
        } else {
            db.fine("refreshMyLines received " + object);
        }
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (RmonPmStatPane.this.dataModel != null) {
                        RmonPmStatPane.this.getObsMgr().setObservable(RmonPmStatPane.this.toObservables(RmonPmStatPane.this.rmonModels));
                        RmonPmStatPane.this.dataModel.refreshMyLines(RmonPmStatPane.this.rmonModels);
                        RmonPmStatPane.this.setupColumnHeader();
                    }
                }
            });
        }
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    private Observable[] toObservables(IRmonModel[] iRmonModelArray) {
        Observable[] observableArray = new Observable[iRmonModelArray.length];
        for (int i = 0; i < iRmonModelArray.length; ++i) {
            observableArray[i] = iRmonModelArray[i].getInterfaceModel();
        }
        return observableArray;
    }

    private void enableZeroPB() {
        super.enableComponent(this.zeroPB, this.secModel, this.secModel.getOperationPrivilege(Operation.CLEAR_PM));
    }

    private class RefreshComboBoxListener
    implements ItemListener {
        private RefreshComboBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (1 == itemEvent.getStateChange()) {
                int n;
                if (!RmonPmStatPane.this.enteringPage) {
                    IgnorableDialog.infoDialog((Component)RmonPmStatPane.this.getParentView(), (String)"The selected auto-refresh value will be applied to all\nperformance monitoring for the current user. ", (String)"Notice", (String)"IgnoreAutoRefreshMessage", (String)"Warn auto refresh affects all performance monitoring for user");
                }
                if ((n = RmonPmStatPane.this.refreshComboBox.getSelectedIndex()) == 0) {
                    if (RmonPmStatPane.this.refreshTimer.isRunning()) {
                        if (db.on()) {
                            db.println("Stopping auto-refresh timer.C");
                        }
                        RmonPmStatPane.this.refreshTimer.stop();
                    }
                } else if (n > 0 && n < RmonPmStatPane.this.rates.length) {
                    if (null != RmonPmStatPane.this.refreshTimer) {
                        if (db.on()) {
                            db.println("Stopping auto-refresh timer.D");
                        }
                        RmonPmStatPane.this.refreshTimer.stop();
                    }
                    RmonPmStatPane.this.refreshTimer = null;
                    RmonPmStatPane.this.refreshTimer = new Timer(RmonPmStatPane.this.rates[n], RmonPmStatPane.this.refreshTimerListener);
                    if (db.on()) {
                        db.println("Starting auto-refresh timer.A");
                    }
                    RmonPmStatPane.this.refreshTimer.start();
                } else {
                    if (db.on()) {
                        db.println("Stopping auto-refresh timer.E");
                    }
                    RmonPmStatPane.this.refreshTimer.stop();
                }
                RmonPmStatPane.this.saveAutoRefreshPref();
            }
        }
    }

    private class RefreshTimerListener
    implements ActionListener {
        private RefreshTimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RmonPmStatPane.this.refreshNow(null);
        }
    }

    public class RmonPortTableHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private ModuleModel moduleModel;
        private String tabName;

        public RmonPortTableHeaderRenderer(String string, ModuleModel moduleModel) {
            this.tabName = string;
            this.moduleModel = moduleModel;
        }

        public void updateUI() {
            super.updateUI();
            LookAndFeel.installColorsAndFont(this, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
            LookAndFeel.installBorder(this, "TableHeader.cellBorder");
            this.setHorizontalAlignment(0);
        }

        private String rprColNo(int n) {
            String string = null;
            if (this.moduleModel.isRPRMode()) {
                if (n == 0) {
                    string = "RPR East";
                } else if (n == 1) {
                    string = "RPR West";
                }
            }
            return string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null && object instanceof PortModel) {
                try {
                    PortModel portModel = (PortModel)object;
                    EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                    String string = entityCellRenderer.getPortString(portModel, false);
                    String string2 = "Port " + string;
                    if (this.moduleModel.isRPRMode() && this.tabName.equals("RPR Span")) {
                        string2 = this.rprColNo(n2);
                    }
                    this.setText(string2);
                    this.setToolTipText(string2);
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    this.setText("?????");
                }
            } else {
                this.setText("?????");
            }
            return this;
        }
    }
}

