/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.OCNPortGraphic;
import cerent.cms.ui.shelf.OpticalPortGraphic;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Observable;

public abstract class AbstractOCNCard
extends CardGraphic {
    protected OpticalPortGraphic[] portGraphics = null;

    protected AbstractOCNCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        super(entityModel, abstractShelfLayout, sDebug, true);
        if (entityModel instanceof ModuleModel || entityModel instanceof PpmModel) {
            List list = this.getPorts();
            int n = list.size();
            this.portGraphics = new OpticalPortGraphic[n];
            if (n == 1) {
                this.portGraphics[0] = this.createPortGraphic(this.cardPainter.getOpticonXOffset(), this.cardPainter.getOpticonYOffset(), (PortModel)list.get(0));
            } else if (n < 7) {
                for (int i = 0; i < n; ++i) {
                    this.portGraphics[i] = this.createPortGraphic(this.cardPainter.getMultiPortOpticonXOffset() + this.cardPainter.getOpticonXSpacing() * i, this.cardPainter.getOpticonYOffset() + this.cardPainter.getOpticonYSpacing() * i, (PortModel)list.get(i));
                }
            } else {
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    n2 = i > 3 ? (this.cardPainter.getMiniOpticonYSpacing() - this.cardPainter.getMiniPortHeight()) * 2 : 0;
                    this.portGraphics[i] = this.createPortGraphic(this.cardPainter.getMultiPortOpticonXOffset() + this.cardPainter.getOpticonXSpacing() * i, this.cardPainter.getMiniOpticonYOffset() + (this.cardPainter.getMiniOpticonYSpacing() * i + n2), this.cardPainter.getMiniPortWidth(), this.cardPainter.getMiniPortHeight(), (PortModel)list.get(i));
                }
            }
            if (this.alarmStore != null) {
                this.update(this.alarmStore.getAlarmStatusObservable(), this.alarmStore.getAlarmStatus());
            }
        }
    }

    protected List getPorts() {
        return this.getModel().getChildren();
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (!this.portGraphics[i].contains(mouseEvent.getPoint())) continue;
                return this.portGraphics[i].getTooltipText();
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            this.db.println("exception in getTooltipText: " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (object instanceof AlarmStatus && this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null) continue;
                this.portGraphics[i].update(observable, this.alarmStore);
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null) continue;
                this.portGraphics[i].dispose();
                this.portGraphics[i] = null;
            }
            this.portGraphics = null;
        }
    }

    protected String getStateString() {
        if (this.eqState == null) {
            return "";
        }
        return ElementDefaults.eqStateToOCNString(this.eqState);
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintIcon(component, graphics2D, n, n2);
        for (int i = 0; i < this.portGraphics.length; ++i) {
            this.portGraphics[i].draw(graphics2D);
        }
    }

    protected OpticalPortGraphic createPortGraphic(int n, int n2, PortModel portModel) {
        return new OCNPortGraphic(this, n, n2, portModel);
    }

    protected OpticalPortGraphic createPortGraphic(int n, int n2, int n3, int n4, PortModel portModel) {
        return new OCNPortGraphic(this, n, n2, n3, n4, portModel);
    }
}

