/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.PortModel;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardView;
import cerent.util.ILoNum;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractPortGraphic
extends JPanel
implements Observer {
    protected int currentSeverity = 0;
    protected Color currentColor = ElementDefaults.OOS_DSBLD_COLOR;
    protected int currentAdminState = 1;
    protected CardView parent;
    protected EntityModel model;
    protected InterfaceModel ifModel = null;
    protected JLabel lbl1 = null;
    protected String statusString;
    protected int portNo;
    protected int slotNo;
    protected int nodeId;
    protected boolean special = false;
    protected static final String fontName = "Arial";
    protected static final int fontSize = 10;
    private ITdmProtocolType protocolType = null;
    private static final Color[] severityColor = new Color[]{ElementDefaults.IS_COLOR, ElementDefaults.MINOR_ALARM_COLOR, ElementDefaults.MAJOR_ALARM_COLOR, ElementDefaults.CRITICAL_ALARM_COLOR};
    private static final SDebug db = new SDebug((KDebug)AbstractShelfLayout.db, "PortGraphic");
    protected String prefix;
    protected IPlatform pci;

    public AbstractPortGraphic(CardView cardView, EntityModel entityModel, int n) {
        this(cardView, entityModel, n, false);
    }

    public AbstractPortGraphic(CardView cardView, EntityModel entityModel, int n, boolean bl) {
        this.model = entityModel;
        this.parent = cardView;
        this.portNo = n;
        this.slotNo = entityModel.getSlot();
        this.special = bl;
        this.pci = entityModel.getNodeModelDelegate().getPlatform();
        this.prefix = this.pci.getSeparator().length() > 0 ? this.pci.getSeparator() + " " : "";
        try {
            this.nodeId = entityModel.getNodeModelDelegate().getNodeId();
            this.getTdmProtocolType();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("Failed to get nodeid or system type");
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        this.setBackground(severityColor[this.currentSeverity]);
        this.addLabel(n, entityModel);
        if (entityModel instanceof PortModel) {
            this.ifModel = (InterfaceModel)((PortModel)entityModel).getInterfaceModel();
            this.slotNo = entityModel.getSlot();
        }
        this.setDeSelected();
    }

    private ITdmProtocolType getTdmProtocolType() {
        if (this.protocolType == null) {
            this.protocolType = this.model.getNodeModel().getTdmProtocolTypeObj();
        }
        return this.protocolType;
    }

    protected void addLabel(int n, EntityModel entityModel) {
        int n2 = entityModel.getModuleModel().getEqType();
        if (n2 == 87 || n2 == 86 || n2 == 251) {
            return;
        }
        Font font = new Font(fontName, 1, 10);
        this.lbl1 = n < 10 ? new JLabel("0" + Integer.toString(n)) : new JLabel(Integer.toString(n));
        this.lbl1.setFont(font);
        this.lbl1.setHorizontalAlignment(0);
        this.lbl1 = AbstractShelfLayout.formatLabel(this.lbl1);
        if (this.special) {
            Color color = this.lbl1.getForeground();
            for (int i = 0; i < 5; ++i) {
                color = color.brighter();
            }
            this.lbl1.setForeground(color);
        }
        int n3 = entityModel.getEqType();
        if (this.getTdmProtocolType().isSonet() && n3 == 34 && n2 != 218 && n2 != 248 && n2 != 234) {
            ICircuitSize iCircuitSize = CircuitSize.getCircuitSizeWithSameCapacity((int)n3, (int)this.getTdmProtocolType().getEnum());
            short s = iCircuitSize.size2widthOfLoCircuit();
            ILoNum iLoNum = entityModel.getModuleModel().getLoNumForPort(n, (int)s);
            if (iLoNum != null) {
                JLabel jLabel = new JLabel(this.prefix + iLoNum.groupString());
                jLabel.setFont(font);
                jLabel.setHorizontalAlignment(0);
                this.setLayout(new GridLayout(this.pci.getRow(), this.pci.getColumn()));
                this.add(this.lbl1);
                this.add(jLabel);
            } else {
                this.setLayout(new GridLayout(1, 1));
                this.add(this.lbl1);
            }
        } else {
            this.setLayout(new GridLayout(1, 1));
            this.add(this.lbl1);
        }
    }

    protected abstract void registerWithModel();

    public abstract void dispose();

    public void update(Observable observable, Object object) {
        db.fine("update port " + this.portNo);
        if (null != object && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            this.showState();
        }
    }

    protected abstract void showState();

    public void setAlarmState(int n) {
        if (n > 0) {
            db.fine("setAlarmState " + n + " for " + this.model);
        }
        if (this.currentSeverity != n) {
            this.currentSeverity = n;
            if (this.currentAdminState == 0) {
                this.setCurrentColor(AbstractPortGraphic.getPortColorByAdminStateAndSeverity(this.currentAdminState, n));
                this.repaint();
            }
        }
    }

    public static Color getPortColorByAdminStateAndSeverity(int n, int n2) {
        Color color;
        switch (n) {
            case 0: {
                color = severityColor[n2];
                if (!db.on()) break;
                db.println("State = inService; Severity " + n2);
                break;
            }
            case 3: {
                color = ElementDefaults.IS_AINS_COLOR;
                if (!db.on()) break;
                db.println("State = Ains");
                break;
            }
            case 2: {
                color = ElementDefaults.OOS_MT_COLOR;
                if (!db.on()) break;
                db.println("State = Maintenance");
                break;
            }
            default: {
                color = ElementDefaults.OOS_DSBLD_COLOR;
                if (!db.on()) break;
                db.println("State = outOfService");
            }
        }
        return color;
    }

    public void repaint() {
        this.setBackground(this.currentColor);
        super.repaint();
    }

    public EntityModel getModel() {
        return this.model;
    }

    public void setSelected() {
        db.fine("setSelected for port " + this.portNo);
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.invalidate();
    }

    public void setDeSelected() {
        db.fine("setDeSelected for port " + this.portNo);
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.invalidate();
    }

    protected void setCurrentColor(Color color) {
        db.fine("setCurrentColor " + color + " for port " + this.portNo);
        this.currentColor = color;
    }

    protected void setCurrentState(int n) {
        db.fine("setCurrentState " + n + " for port " + this.portNo);
        this.currentAdminState = n;
    }
}

