/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IModel;
import cerent.cms.model.ISideModels;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.MaintPwrMonitoringPane;
import cerent.cms.ui.shelf.MaintTabWssEPwrMonitoringPane;
import java.awt.Component;
import java.awt.GridLayout;

public class MaintTabPwrMonitoringPane
extends AbstractPane {
    public MaintTabPwrMonitoringPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.subTabs = new SubTabbedView(tabbedView.getUiModel(), tabbedView);
        this.subTabs.setTabPlacement(2);
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.subTabs);
    }

    protected void init() {
        this.subTabs.removeAll();
        if (!MaintTabPwrMonitoringPane.isPwrMonitoringSupported((NodeModelDelegate)this.getUiModel().getNodeModel())) {
            return;
        }
        ISideModels iSideModels = this.getUiModel().getNodeModel().getSideModels();
        int n = MaintPwrMonitoringPane.hasWxc(this.getUiModel()) || MaintPwrMonitoringPane.hasSMR2(this.getUiModel()) || iSideModels.getSides().length > 2 ? 8 : 2;
        for (int i = 1; i <= n; i += 2) {
            if (!MaintTabPwrMonitoringPane.sideDefined(iSideModels, i) && !MaintTabPwrMonitoringPane.sideDefined(iSideModels, i + 1)) continue;
            String string = "<html>Optical Side<br>    " + DwdmSide.getSideFromOffset(i) + "-" + DwdmSide.getSideFromOffset(i + 1) + "<html>";
            this.subTabs.add((Component)((Object)new MaintPwrMonitoringPane(string, this.subTabs, i)));
        }
    }

    private static final boolean sideDefined(ISideModels iSideModels, int n) {
        try {
            return iSideModels.getSideById(n) != null;
        }
        catch (WrongNodeSide wrongNodeSide) {
            return false;
        }
    }

    public void leavingPage() throws Exception {
        db.fine("Entered leavingPage()");
    }

    public void enteringPage() throws Exception {
        db.fine("Entered enteringPage()");
        this.init();
        this.subTabs.setShowing(true);
    }

    public void refresh() throws Exception {
        db.fine("Entered refresh()");
    }

    public static boolean isPwrMonitoringSupported(NodeModelDelegate nodeModelDelegate) {
        return nodeModelDelegate.isDwdmNodeType() && (nodeModelDelegate.getNodeOpticalType() == 12 || nodeModelDelegate.getNodeOpticalType() == 14);
    }

    public static Pane CreatePane(IModel iModel, String string, TabbedView tabbedView, int n) {
        if (MaintPwrMonitoringPane.hasWssE(iModel)) {
            return new MaintTabWssEPwrMonitoringPane(string, tabbedView);
        }
        if (MaintPwrMonitoringPane.hasWxc(iModel) || MaintPwrMonitoringPane.hasSMR2(iModel) || MaintPwrMonitoringPane.getROADMCount(iModel) > 2) {
            return new MaintTabPwrMonitoringPane(string, tabbedView);
        }
        return new MaintPwrMonitoringPane(string, tabbedView, 255);
    }
}

