/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Dwdm.sOpticsCurrentValues;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsOchTermModel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererOpticStat;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;

public class MaintViewCachedFacility {
    public InterfaceModel ifModel;
    public String cachedLocationString = "???";
    public String cachedAdminStateString = "???";
    public String cachedServiceStateString = "???";
    public String cachedPowerString = "???";
    public String cachedOSCPowerString = "???";
    private static final String NA = "N/A";
    private static final int UNDEFINED = -1000000;
    private static final int NOT_SUPPORTED = -1;
    private static final SDebug db = new SDebug("MaintViewCachedFacility");

    public MaintViewCachedFacility(InterfaceModel interfaceModel) {
        this.ifModel = interfaceModel;
    }

    public void updateCachedStrings() {
        this.updateLocationString();
        this.updateAdminStateString();
        this.updateServiceStateString();
        this.updatePowerString();
    }

    private void updateLocationString() {
        String string = "";
        boolean bl = this.ifModel instanceof OpticsOchTermModel;
        String string2 = this.getModuleNameString();
        String string3 = this.getPortTypeString();
        try {
            String string4;
            String string5;
            IPortModel iPortModel = this.ifModel.getPortModel();
            IModuleModel iModuleModel = iPortModel.getModuleModel();
            INodeModel iNodeModel = this.ifModel.getNodeModel();
            if (iNodeModel.isMultishelf()) {
                string5 = String.valueOf(iPortModel.getShelfId());
                if (string5.length() == 1) {
                    string5 = " " + string5;
                }
                string = string + "Shelf " + string5 + ", ";
            }
            string = string + "Slot ";
            string5 = String.valueOf(iModuleModel.getSlot());
            if (string5.length() == 1) {
                string5 = " " + string5;
            }
            string = string + string5 + " (" + string2 + "), ";
            if (!bl) {
                string = string + "Port ";
                string4 = PortHelper.getPortNumString((IPortModel)iPortModel);
                if (string4.length() == 1) {
                    string4 = " " + string4;
                }
                string = string + string4 + " (" + string3 + ")";
            } else {
                string = string + "OCH " + this.getLambda();
            }
            try {
                string4 = this.ifModel.getAlias();
                if (string4.length() > 0) {
                    string = string + " \"" + string4 + "\"";
                }
            }
            catch (Exception exception) {
                MaintViewCachedFacility.maybeDumpError(exception, "Alias: " + string);
            }
            this.cachedLocationString = string;
        }
        catch (Exception exception) {
            MaintViewCachedFacility.maybeDumpError(exception, "Location: " + string);
        }
    }

    private String getModuleNameString() {
        String string = "";
        try {
            IPortModel iPortModel = this.ifModel.getPortModel();
            IModuleModel iModuleModel = iPortModel.getModuleModel();
            string = iModuleModel.getEqTypeName();
        }
        catch (Exception exception) {
            MaintViewCachedFacility.maybeDumpError(exception, "Module Name");
        }
        return string;
    }

    private TDMTerminology getTerms(IEntityModel iEntityModel) {
        return iEntityModel.getNodeModel().getTDMTerminology();
    }

    private String getPortTypeString() {
        String string = "";
        try {
            IPortModel iPortModel = this.ifModel.getPortModel();
            if (this.ifModel instanceof AbstractDwdmLineModel) {
                string = PortHelper.getPortTypeString((IEntityModel)iPortModel);
            }
            if (this.ifModel instanceof AbstractOpticsLineModel) {
                string = ((AbstractOpticsLineModel)this.ifModel).getOptPortTypeString();
            }
        }
        catch (Exception exception) {
            MaintViewCachedFacility.maybeDumpError(exception, "Port Type");
        }
        return string;
    }

    private void updateAdminStateString() {
        try {
            eAdminState eAdminState2 = this.ifModel.getAdminStateEnum();
            AdminState adminState = AdminState.enumToAdminState(eAdminState2);
            this.cachedAdminStateString = adminState.toString(this.getTerms((IEntityModel)this.ifModel.getPortModel()));
        }
        catch (Exception exception) {
            MaintViewCachedFacility.maybeDumpError(exception, "Admin State");
        }
    }

    private void updateServiceStateString() {
        try {
            sServiceState sServiceState2 = this.ifModel.getServiceState();
            IServiceState iServiceState = ServiceStateFactory.getServiceState(sServiceState2);
            this.cachedServiceStateString = iServiceState.toString(this.getTerms((IEntityModel)this.ifModel.getPortModel()));
        }
        catch (Exception exception) {
            MaintViewCachedFacility.maybeDumpError(exception, "Service State");
        }
    }

    private boolean isPreProvisioned() {
        try {
            return this.ifModel.getModuleModel().getState() == eEqState.NOT_PRESENT;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return true;
        }
    }

    private sOpticsCurrentValues getClearedData() {
        if (this.isPreProvisioned()) {
            return null;
        }
        return new sOpticsCurrentValues(0, 0, 0);
    }

    private sOpticsCurrentValues getUnsupportedData() {
        if (this.isPreProvisioned()) {
            return null;
        }
        return new sOpticsCurrentValues(-1, -1, -1);
    }

    private void updatePowerString() {
        if (this.ifModel instanceof AbstractDwdmLineModel) {
            StringBuilder stringBuilder;
            block25: {
                PmRendererOpticStat pmRendererOpticStat;
                sOpticsCurrentValues sOpticsCurrentValues2;
                AbstractDwdmLineModel abstractDwdmLineModel;
                block24: {
                    abstractDwdmLineModel = (AbstractDwdmLineModel)this.ifModel;
                    stringBuilder = new StringBuilder("RX: ");
                    sOpticsCurrentValues2 = null;
                    try {
                        sOpticsCurrentValues2 = abstractDwdmLineModel.getOpticsCurrentValues();
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        sOpticsCurrentValues2 = this.getClearedData();
                        MaintViewCachedFacility.maybeDumpError((Exception)((Object)wrongInterfaceType), "Power");
                    }
                    catch (InternalCommError internalCommError) {
                        sOpticsCurrentValues2 = this.getClearedData();
                        MaintViewCachedFacility.maybeDumpError((Exception)((Object)internalCommError), "Power");
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        sOpticsCurrentValues2 = this.getClearedData();
                        MaintViewCachedFacility.maybeDumpError((Exception)((Object)noSuchInterface), "Power");
                    }
                    catch (UnsupportedOperation unsupportedOperation) {
                        sOpticsCurrentValues2 = this.getUnsupportedData();
                        MaintViewCachedFacility.maybeDumpError((Exception)((Object)unsupportedOperation), "Power");
                    }
                    if (sOpticsCurrentValues2 != null) {
                        try {
                            int n = sOpticsCurrentValues2.rxPower;
                            if (n == -1) {
                                stringBuilder.append(NA);
                                break block24;
                            }
                            pmRendererOpticStat = new PmRendererOpticStat(0, n, true);
                            stringBuilder.append(pmRendererOpticStat.toString());
                        }
                        catch (Exception exception) {
                            stringBuilder.append(NA);
                            MaintViewCachedFacility.maybeDumpError(exception, "Power:" + stringBuilder);
                        }
                    } else {
                        stringBuilder.append(NA);
                    }
                }
                stringBuilder.append(", TX: ");
                if (abstractDwdmLineModel.supportsTxPower() && sOpticsCurrentValues2 != null) {
                    try {
                        int n = sOpticsCurrentValues2.txPower;
                        if (n == -1) {
                            stringBuilder.append(NA);
                            break block25;
                        }
                        pmRendererOpticStat = new PmRendererOpticStat(0, n, true);
                        stringBuilder.append(pmRendererOpticStat.toString());
                    }
                    catch (Exception exception) {
                        stringBuilder.append(NA);
                        MaintViewCachedFacility.maybeDumpError(exception, "Power:" + stringBuilder);
                    }
                } else {
                    stringBuilder.append(NA);
                }
            }
            this.cachedPowerString = stringBuilder.toString();
            this.cachedOSCPowerString = NA;
        } else if (this.ifModel instanceof AbstractOpticsLineModel) {
            AbstractOpticsLineModel abstractOpticsLineModel = (AbstractOpticsLineModel)this.ifModel;
            try {
                int n = abstractOpticsLineModel.getActualPower();
                this.cachedPowerString = this.parsePower(n);
            }
            catch (Exception exception) {
                this.cachedPowerString = NA;
                MaintViewCachedFacility.maybeDumpError(exception, "Power:" + this.cachedPowerString);
            }
            try {
                int n = abstractOpticsLineModel.getOSCPower();
                this.cachedOSCPowerString = this.parsePower(n);
            }
            catch (Exception exception) {
                this.cachedOSCPowerString = NA;
                MaintViewCachedFacility.maybeDumpError(exception, "OSCPower:" + this.cachedOSCPowerString);
            }
        } else {
            this.cachedPowerString = "N/A (Invalid Model!)";
            if (db.on()) {
                db.println("Model is: " + this.ifModel);
            }
        }
    }

    private String parsePower(int n) {
        if (n == -1000000) {
            return NA;
        }
        int n2 = 0;
        String string = Integer.toString(n);
        n2 = string.startsWith("-") ? 2 : 1;
        string = string.length() > n2 ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (n2 == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
        return string;
    }

    private static void maybeDumpError(Exception exception, String string) {
        if (db.on()) {
            KDebug.printStackTrace((Throwable)exception);
            db.println(string);
        }
    }

    private String getLambda() {
        String string;
        block4: {
            try {
                int n = ((OpticsOchTermModel)this.ifModel).getActualWaveLength();
                string = Wavelength.getWavelengthStringFromWavelength(n);
            }
            catch (NoSuchInterface noSuchInterface) {
                string = NA;
                if (db.on()) {
                    KDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                string = NA;
                if (!db.on()) break block4;
                KDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return string;
    }
}

