/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.CTCUserException;
import cerent.cms.model.OchsPwrMonitoringModel;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.shelf.XAssisChartElements;
import cerent.util.gui.DefaultChartDataModel;
import ilog.views.chart.IlvStyle;
import java.awt.Color;
import java.awt.Paint;

public class OchsPwrMonitoringChartModel
extends DefaultChartDataModel {
    private double[][] yvalues;
    private OchsPwrMonitoringModel ochsPwrModel = null;
    private int cardIndex;
    private int band;
    private XAssisChartElements xAxis;
    private int side;
    private double maximum = -25.0;
    private double minimum = -25.0;
    private static final Color ADD_style_color = Color.RED;
    private static final Color OUT_style_color = Color.BLUE;
    private static final Color[] PT_style_colors = new Color[]{Color.ORANGE, Color.LIGHT_GRAY, Color.PINK, Color.YELLOW, Color.DARK_GRAY, Color.GREEN, Color.BLACK, Color.CYAN};

    public OchsPwrMonitoringChartModel(OchsPwrMonitoringModel ochsPwrMonitoringModel, int n, int n2) {
        this.ochsPwrModel = ochsPwrMonitoringModel;
        this.cardIndex = n;
        this.band = n2;
    }

    public OchsPwrMonitoringChartModel(OchsPwrMonitoringModel ochsPwrMonitoringModel, int n, int n2, XAssisChartElements xAssisChartElements) {
        this.ochsPwrModel = ochsPwrMonitoringModel;
        this.cardIndex = n;
        this.band = n2;
        this.xAxis = xAssisChartElements;
        this.side = 0;
    }

    public void init() throws CTCUserException {
        this.yvalues = this.ochsPwrModel.getEqualizationPwrValues(this.cardIndex, this.band, this.xAxis);
        for (int i = 0; i < this.getNumSeries(); ++i) {
            this.max(this.getYSeries(i));
        }
    }

    public int getSide() {
        if (this.side == 0) {
            this.side = this.ochsPwrModel.getSide();
        }
        return this.side;
    }

    public String getSideStr() {
        return DwdmSide.getSideFromOffset(this.getSide());
    }

    public void refreshPwrData() throws CTCUserException {
        this.yvalues = this.ochsPwrModel.getEqualizationPwrValues(this.cardIndex, this.band, this.xAxis);
        this.reloadData();
    }

    public String[] getPointLabels() {
        return this.xAxis.getPointLabels();
    }

    public String[] getSeriesLabels() {
        return this.xAxis.getSeriesLabels();
    }

    public double[] getXSeries(int n) {
        return this.xAxis.getXvalues();
    }

    public double[] getYSeries(int n) {
        return this.yvalues[n];
    }

    public int getNumSeries() {
        return this.yvalues.length;
    }

    public IlvStyle[] getStyles() {
        IlvStyle[] ilvStyleArray = new IlvStyle[this.getNumSeries()];
        ilvStyleArray[this.xAxis.ADD] = new IlvStyle((Paint)ADD_style_color);
        ilvStyleArray[this.xAxis.OUT] = new IlvStyle((Paint)OUT_style_color);
        for (int i = 0; i < ilvStyleArray.length - 2; ++i) {
            ilvStyleArray[this.xAxis.PT + i] = new IlvStyle((Paint)PT_style_colors[i]);
        }
        return ilvStyleArray;
    }

    private void max(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > this.maximum)) continue;
            this.maximum = dArray[i];
        }
    }

    public double getMax() {
        if (this.maximum == -25.0) {
            return 0.0;
        }
        return this.maximum + 0.5;
    }

    public double getMin() {
        return this.minimum;
    }
}

