/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp;

import cerent.cms.INodeModelDelegate;
import cerent.cms.model.Attribute;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeHelper;
import cerent.cms.model.IOpticsModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.LmpConstants;
import cerent.cms.model.LmpCtrlChannelModel;
import cerent.cms.model.LmpDataLinkModels;
import cerent.cms.model.LmpException;
import cerent.cms.model.PortModel;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.Pane;
import cerent.cms.ui.shelf.lmp.DataLinkDataSource;
import cerent.cms.ui.shelf.lmp.PortWrapper;
import cerent.cms.ui.shelf.lmp.TeLinkDataSource;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.TextAreaDialog;
import cerent.util.gui.UDialog;
import com.cisco.crs.model.EntityTableModel;
import com.cisco.crs.model.PlimPortId;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DataLinkCreationDialog
extends UDialog
implements ActionListener,
LmpConstants {
    public static final String TITLE = "Create LMP Data Link";
    private JButton okButton;
    private JButton cancelButton;
    private Pane parent;
    protected static INodeHelper nodeHelper;
    protected DataLinkDataSource dsc;
    protected DataLinkDataSource.Info value;
    protected JComboBox localPort;
    protected JTextField localPortId;
    protected JComboBox type;
    protected JComboBox localTeLinkId;
    protected JTextField remoteDataLinkId;
    protected JComboBox remoteCrsPortId;
    private boolean ok = false;
    private EntityTableModel etmcrs;

    public static DataLinkCreationDialog getCreationDialog(Pane pane, DataLinkDataSource dataLinkDataSource, INodeHelper iNodeHelper) {
        nodeHelper = iNodeHelper;
        return new DataLinkCreationDialog(JOptionPane.getFrameForComponent((Component)pane), TITLE, new Object[]{pane, dataLinkDataSource});
    }

    protected DataLinkCreationDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.ok = false;
        Object[] objectArray = (Object[])object;
        this.parent = (Pane)objectArray[0];
        this.dsc = (DataLinkDataSource)objectArray[1];
        if (this.value == null) {
            this.value = new DataLinkDataSource.Info(this.dsc);
        } else {
            DataLinkDataSource dataLinkDataSource = this.dsc;
            dataLinkDataSource.getClass();
            this.value = new DataLinkDataSource.Info(dataLinkDataSource, this.value);
        }
        jPanel.add((Component)this.getCenterPanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        this.parent = null;
        this.dsc = null;
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.valuesOk()) {
                this.ok = true;
                this.dispose();
            }
        } else if (object == this.cancelButton) {
            this.ok = false;
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    public boolean ok() {
        return this.ok;
    }

    public DataLinkDataSource.Info getValues() {
        return this.value;
    }

    private void displayStatusMessage(final String string, final String string2) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new TextAreaDialog(JOptionPane.getFrameForComponent((Component)((Object)DataLinkCreationDialog.this)), string, string2, 650, 200);
            }
        });
    }

    private String toString(Exception exception) {
        int n;
        if (exception instanceof NumberFormatException) {
            return "invalid number format: " + exception.getMessage();
        }
        String string = exception.getMessage();
        if ((string == null || string.length() == 0) && (n = (string = exception.toString()).lastIndexOf(46)) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private boolean valuesOk() {
        Object object;
        Serializable serializable;
        DataLinkDataSource.Column column;
        ArrayList<Object> arrayList;
        block18: {
            arrayList = new ArrayList<Object>();
            column = this.dsc.getColumn("Local Port");
            try {
                column.setColumnValue(this.value, this.localPort.getSelectedItem());
            }
            catch (Exception exception) {
                arrayList.add(column.getName());
                arrayList.add(exception);
            }
            try {
                if (this.value._localPort == null || this.value._vLocalPortId == 0 || !LmpDataLinkModels.isChanRx((IPortModel)(serializable = this.dsc.getPortByIndex(this.value._vLocalPortId)))) break block18;
                object = ((PortModel)serializable).getInterfaceModel();
                int n = 0;
                if (object instanceof IOpticsModel) {
                    try {
                        n = ((IOpticsModel)object).getReversePort();
                    }
                    catch (Exception exception) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
                if (n == 0) {
                    arrayList.add(column.getName());
                    arrayList.add(new Exception("Cannot find the corresponding TX port"));
                }
            }
            catch (Exception exception) {
                arrayList.add(column.getName());
                arrayList.add(exception);
            }
        }
        column = this.dsc.getColumn("Data Link Type");
        try {
            column.setColumnValue(this.value, this.type.getSelectedItem());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Local TE Link Id");
        try {
            column.setColumnValue(this.value, this.localTeLinkId.getSelectedItem());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Remote Port Id");
        if (!this.value._vIsCrs || Preferences.instance().getInt("ctc.router", "skipLmp", 0) != 0) {
            try {
                column.setColumnValue(this.value, this.remoteDataLinkId.getText());
            }
            catch (Exception exception) {
                arrayList.add(column.getName());
                arrayList.add(exception);
            }
        }
        if (this.value._vIsCrs) {
            this.value.setRemoteCrsPortId(((PlimPortId)this.remoteCrsPortId.getSelectedItem()).getPortId());
        }
        if (arrayList.size() > 0) {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("Failed to validate LMP Data Link parameters:\n\n");
            object = arrayList.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                Exception exception = (Exception)object.next();
                ((StringBuffer)serializable).append(string);
                ((StringBuffer)serializable).append(": ");
                ((StringBuffer)serializable).append(this.toString(exception));
                ((StringBuffer)serializable).append("\n");
            }
            this.displayStatusMessage("LMP Data Link Validation Errors", ((StringBuffer)serializable).toString());
        }
        return arrayList.size() <= 0;
    }

    private void helpPutDefaultType(String string, JComboBox jComboBox) {
        jComboBox.setSelectedItem(this.dsc.getTypeChoice(this.dsc.getDefaultValue(string)));
    }

    private void putDefaults() {
        this.helpPutDefaultType("Data Link Type", this.type);
    }

    private JPanel getCenterPanel() {
        TeLinkDataSource.Info[] infoArray;
        PortWrapper[] portWrapperArray;
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 5, 5));
        try {
            portWrapperArray = this.dsc.getLocalPortChoices(this.value);
        }
        catch (LmpException lmpException) {
            ErrorMsg.displayError((Component)((Object)this), (EID)lmpException.getEid());
            portWrapperArray = new PortWrapper[]{};
        }
        try {
            infoArray = this.getTeLinks();
        }
        catch (LmpException lmpException) {
            ErrorMsg.displayError((Component)((Object)this), (EID)lmpException.getEid());
            infoArray = new TeLinkDataSource.Info[]{};
        }
        jPanel.add(new JLabel("Local Port:", 4));
        this.localPort = new JComboBox<PortWrapper>(portWrapperArray);
        jPanel.add(this.localPort);
        jPanel.add(new JLabel("Local Port Id:", 4));
        this.localPortId = new JTextField(20);
        jPanel.add(this.localPortId);
        jPanel.add(new JLabel("Data Link Type:", 4));
        this.type = new JComboBox<Attribute>(this.dsc.getTypeChoices());
        jPanel.add(this.type);
        jPanel.add(new JLabel("Local TE Link Id:", 4));
        this.localTeLinkId = new JComboBox();
        jPanel.add(this.localTeLinkId);
        jPanel.add(new JLabel("Remote CRS Port Id:", 4));
        this.remoteDataLinkId = new JTextField(20);
        PlimPortId[] plimPortIdArray = new PlimPortId[]{};
        if (infoArray.length > 0) {
            try {
                plimPortIdArray = this.getCrsPorts(infoArray[0].getLocalTeLinkId());
            }
            catch (LmpException lmpException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)lmpException.getEid());
                plimPortIdArray = new PlimPortId[]{};
            }
        }
        this.remoteCrsPortId = new JComboBox<PlimPortId>(plimPortIdArray);
        if (plimPortIdArray.length > 0) {
            this.remoteDataLinkId.setEnabled(false);
        }
        if (infoArray.length != 0) {
            if (plimPortIdArray.length == 0) {
                this.value._vIsCrs = false;
                this.remoteCrsPortId.setEnabled(false);
            } else {
                this.value._vIsCrs = true;
                this.remoteCrsPortId.setEnabled(true);
            }
        } else {
            this.value._vIsCrs = false;
            this.remoteCrsPortId.setEnabled(false);
        }
        jPanel.add(this.remoteCrsPortId);
        jPanel.add(new JLabel("Remote Port Id:", 4));
        jPanel.add(this.remoteDataLinkId);
        jPanel.add(new JLabel("", 4));
        this.putDefaults();
        this.localPortId.setEnabled(false);
        this.updateLocalPortId();
        this.localPort.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DataLinkCreationDialog.this.updateLocalPortId();
            }
        });
        this.localTeLinkId.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PlimPortId[] plimPortIdArray;
                try {
                    plimPortIdArray = DataLinkCreationDialog.this.getCrsPorts(((TeLinkDataSource.Info)DataLinkCreationDialog.this.localTeLinkId.getSelectedItem()).getLocalTeLinkId());
                }
                catch (LmpException lmpException) {
                    ErrorMsg.displayError((Component)((Object)DataLinkCreationDialog.this), (EID)lmpException.getEid());
                    plimPortIdArray = new PlimPortId[]{};
                }
                DataLinkCreationDialog.this.remoteDataLinkId.setText("");
                if (plimPortIdArray.length == 0) {
                    DataLinkCreationDialog.this.value._vIsCrs = false;
                    DataLinkCreationDialog.this.remoteCrsPortId.removeAllItems();
                    DataLinkCreationDialog.this.remoteCrsPortId.setEnabled(false);
                    DataLinkCreationDialog.this.remoteDataLinkId.setEnabled(true);
                } else {
                    DataLinkCreationDialog.this.remoteDataLinkId.setEnabled(Preferences.instance().getInt("ctc.router", "skipLmp", 0) != 0);
                    DataLinkCreationDialog.this.remoteCrsPortId.setEnabled(true);
                    DataLinkCreationDialog.this.remoteCrsPortId.removeAllItems();
                    for (PlimPortId plimPortId : plimPortIdArray) {
                        DataLinkCreationDialog.this.remoteCrsPortId.addItem(plimPortId);
                    }
                    DataLinkCreationDialog.this.value._vIsCrs = true;
                }
            }
        });
        for (TeLinkDataSource.Info info : infoArray) {
            this.localTeLinkId.addItem(info);
        }
        return jPanel;
    }

    private void updateLocalPortId() {
        PortWrapper portWrapper = (PortWrapper)this.localPort.getSelectedItem();
        this.localPortId.setText(portWrapper != null ? this.dsc.asString(portWrapper.getPortId(), '0', 8) : "");
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        jPanel.add(new CSHelpButton(this.getCsHelpId()));
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected CSHelpID getCsHelpId() {
        return CSHelpConst.LmpDataLinkCreationDialog;
    }

    private PlimPortId[] getCrsPorts(int n) throws LmpException {
        String string = InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(this.dsc.getTeLinkChoice(n).getRemoteNodeId()));
        IEntityTableModel iEntityTableModel = nodeHelper.getEntityTableModel(string);
        if (iEntityTableModel == null || !((INodeModelDelegate)iEntityTableModel.getNodeModel().getDelegate()).getPlatform().isCRS()) {
            return new PlimPortId[0];
        }
        this.etmcrs = (EntityTableModel)iEntityTableModel;
        List<PlimPortId> list = this.etmcrs.getPlimPortIndices();
        List<PlimPortId> list2 = this.dsc.getUsedCrsPorts(string);
        if (this.value._vModel != null) {
            list2.remove(new PlimPortId(this.value._vRemoteCrsPortId));
        }
        list.removeAll(list2);
        return list.toArray(new PlimPortId[list.size()]);
    }

    private TeLinkDataSource.Info[] getTeLinks() throws LmpException {
        if (this.value._vModel == null) {
            return this.dsc.getFilteredTeLinkChoices();
        }
        TeLinkDataSource.Info[] infoArray = this.dsc.getFilteredTeLinkChoices();
        ArrayList<TeLinkDataSource.Info> arrayList = new ArrayList<TeLinkDataSource.Info>();
        if (this.value._vIsCrs) {
            arrayList.add(this.dsc.getTeLinkChoice(this.value.getLocalTeLinkId()));
        }
        for (int i = 0; i < infoArray.length; ++i) {
            LmpCtrlChannelModel lmpCtrlChannelModel = infoArray[i].getModel().findControlChannel();
            if (lmpCtrlChannelModel == null || lmpCtrlChannelModel.isRemoteCrs() != this.value._vIsCrs) continue;
            arrayList.add(infoArray[i]);
        }
        return arrayList.toArray(new TeLinkDataSource.Info[arrayList.size()]);
    }
}

