/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Node.SnmpV3AuthProtocol;
import cerent.cms.idl.Node.SnmpV3PrivProtocol;
import cerent.cms.idl.Node.sSnmpV3Engine;
import cerent.cms.idl.Node.sSnmpV3Key;
import cerent.cms.idl.Node.sSnmpV3PassKey;
import cerent.cms.idl.Node.sSnmpV3User;
import cerent.cms.model.SnmpModel;
import cerent.cms.ui.Pane;
import cerent.cms.ui.shelf.snmp.UserCreatePane;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class UserCreateDialog
extends UDialog
implements ActionListener {
    public static final String CREATE_TITLE = "Create User";
    public static final String EDIT_TITLE = "Edit User";
    public static final int SNMP_USER_MIN_CHARS = 8;
    private JButton okButton;
    private JButton cancelButton;
    private boolean isCreate = true;
    private sSnmpV3User sUser = null;
    private Pane parent;
    UserCreatePane userPane;
    protected SnmpModel snmpModel;
    private boolean ok = false;
    private static final SDebug db = new SDebug("UserCreateDialog");

    public static UserCreateDialog instance(Pane pane, Object object) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        return new UserCreateDialog(frame, CREATE_TITLE, object);
    }

    private UserCreateDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.ok = false;
        this.snmpModel = (SnmpModel)object;
        jPanel.add((Component)this.getCreatePanel(), "Center");
        this.setSize(new Dimension(440, 210));
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        this.parent = null;
        this.isCreate = true;
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                if (this.apply()) {
                    this.ok();
                    this.ok = true;
                    this.dispose();
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_ERROR_CREATING_USER);
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    protected boolean apply() throws Exception {
        return this.validateFields();
    }

    private void ok() {
        UserCreatePane userCreatePane = this.userPane;
        if (this.sUser == null) {
            sSnmpV3User sSnmpV3User2 = new sSnmpV3User();
            sSnmpV3User2.engine = new sSnmpV3Engine();
            sSnmpV3User2.engine.engineid = new byte[16];
            sSnmpV3User2.engine.boots = 0;
            sSnmpV3User2.engine.engineidlen = 0;
            sSnmpV3User2.authProtocol = SnmpV3AuthProtocol.from_int(this.getAuthProtocol());
            sSnmpV3User2.authKey = this.getAuthPassKey();
            sSnmpV3User2.group = this.getGroupName();
            sSnmpV3User2.privKey = this.getPrivPassKey();
            sSnmpV3User2.privProtocol = SnmpV3PrivProtocol.from_int(this.getPrivProtocol());
            sSnmpV3User2.username = this.getUserName();
            this.snmpModel.setSnmpV3User(sSnmpV3User2);
        } else {
            if (this.sUser.authProtocol.value() != this.getAuthProtocol() || !this.userPane.getAuthPass().equalsIgnoreCase("")) {
                this.sUser.authProtocol = SnmpV3AuthProtocol.from_int(this.getAuthProtocol());
                this.sUser.authKey = this.getAuthPassKey();
            } else {
                this.sUser.authKey.regenerateKey = false;
            }
            if (this.sUser.privProtocol.value() != this.getPrivProtocol() || !this.userPane.getPrivPass().equalsIgnoreCase("")) {
                this.sUser.privKey = this.getPrivPassKey();
                this.sUser.privProtocol = SnmpV3PrivProtocol.from_int(this.getPrivProtocol());
            } else {
                this.sUser.privKey.regenerateKey = false;
            }
            this.sUser.group = this.getGroupName();
            this.snmpModel.setSnmpV3User(this.sUser);
        }
    }

    public String getUserName() {
        return this.userPane.getUserName();
    }

    public String getGroupName() {
        return this.userPane.getGroupName();
    }

    public sSnmpV3PassKey getAuthPassKey() {
        String string;
        sSnmpV3PassKey sSnmpV3PassKey2 = new sSnmpV3PassKey();
        sSnmpV3PassKey2.password = string = this.userPane.getAuthPass();
        sSnmpV3PassKey2.regenerateKey = true;
        sSnmpV3PassKey2.key = new sSnmpV3Key();
        sSnmpV3PassKey2.key.key = new byte[20];
        sSnmpV3PassKey2.key.keylen = 0;
        return sSnmpV3PassKey2;
    }

    public sSnmpV3PassKey getPrivPassKey() {
        String string;
        sSnmpV3PassKey sSnmpV3PassKey2 = new sSnmpV3PassKey();
        sSnmpV3PassKey2.password = string = this.userPane.getPrivPass();
        sSnmpV3PassKey2.regenerateKey = true;
        sSnmpV3PassKey2.key = new sSnmpV3Key();
        sSnmpV3PassKey2.key.key = new byte[20];
        sSnmpV3PassKey2.key.keylen = 0;
        return sSnmpV3PassKey2;
    }

    public int getAuthProtocol() {
        return this.userPane.getAuthProtocol();
    }

    public int getPrivProtocol() {
        return this.userPane.getPrivProtocol();
    }

    private JPanel getCreatePanel() {
        this.userPane = new UserCreatePane(this);
        return this.userPane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private boolean validateFields() {
        int n;
        boolean bl = true;
        String string = this.getUserName();
        if (string.length() < 6) {
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_USER_NAME_LENGTH_PARAM_1, (Object)Integer.toString(6));
            bl = false;
        }
        String string2 = this.userPane.getAuthPass();
        String string3 = this.userPane.getPrivPass();
        if (bl) {
            if (this.isCreate) {
                if (string2.length() < 8 && this.getAuthProtocol() != 0 || string3.length() < 8 && this.getPrivProtocol() != 0) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.WID_SNMP_PASSWORD_LENGTH, (Object)Integer.toString(8));
                    bl = false;
                }
            } else {
                boolean bl2 = false;
                n = 0;
                if (this.sUser.authProtocol.value() != this.getAuthProtocol()) {
                    bl2 = true;
                } else if (string2.length() != 0) {
                    bl2 = true;
                }
                if (this.sUser.privProtocol.value() != this.getPrivProtocol()) {
                    n = 1;
                } else if (string3.length() != 0) {
                    n = 1;
                }
                if (string2.length() < 8 && this.getAuthProtocol() != 0 && bl2 || string3.length() < 8 && this.getPrivProtocol() != 0 && n != 0) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.WID_SNMP_PASSWORD_LENGTH, (Object)Integer.toString(8));
                    bl = false;
                }
            }
        }
        String[] stringArray = this.getSnmpModel().getSnmpV3UserList();
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals(string) || !this.isCreate) continue;
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_USER_EXISTS);
            bl = false;
            break;
        }
        return bl;
    }

    protected void setSelectedTrap(sSnmpV3User sSnmpV3User2) {
        this.setTitle(EDIT_TITLE);
        this.isCreate = false;
        this.sUser = sSnmpV3User2;
        UserCreatePane userCreatePane = this.userPane;
        userCreatePane.setSelectedItem(sSnmpV3User2);
    }

    public SnmpModel getSnmpModel() {
        return this.snmpModel;
    }

    public boolean isCreate() {
        return this.isCreate;
    }
}

