/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wxc;

import cerent.cms.idl.OpticsTopology.sOpticalPatchCord;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.shelf.MaintPwrMonitoringPane;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WxcMeshppTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{"Mesh Patch Panel Ports", "Ports on Cards"};
    public static final int FROM_INDEX = 0;
    public static final int TO_INDEX = 1;
    private NodeModelDelegate nodeModel;
    IModel model;
    private ArrayList<TableData> sourceData = new ArrayList();
    private static final SDebug db = new SDebug("WxcMeshppTableModel");

    public WxcMeshppTableModel(NodeModelDelegate nodeModelDelegate, IModel iModel) {
        this.nodeModel = nodeModelDelegate;
        this.model = iModel;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public int getRowCount() {
        return this.sourceData.size();
    }

    public ArrayList<TableData> getSourceData() {
        return this.sourceData;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.sourceData.get(n).getFrom();
            }
            case 1: {
                return this.sourceData.get(n).getTo();
            }
        }
        return null;
    }

    public void refresh() {
        this.compileSourceData();
        this.fireTableDataChanged();
    }

    private void compileSourceData() {
        ArrayList arrayList = null;
        boolean bl = false;
        if (MaintPwrMonitoringPane.hasWxc(this.nodeModel)) {
            ArrayList<TableData> arrayList2;
            IEntityModel[] iEntityModelArray;
            if (this.model instanceof IChassisModel) {
                arrayList = new ArrayList(MaintPwrMonitoringPane.getWxc(this.model));
            } else if (this.model instanceof NodeModelDelegate) {
                arrayList = new ArrayList(0);
                bl = true;
                iEntityModelArray = this.nodeModel.getChassisModels();
                for (int i = 0; i < iEntityModelArray.length; ++i) {
                    arrayList2 = new ArrayList(MaintPwrMonitoringPane.getWxc((IModel)iEntityModelArray[i]));
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        arrayList.add(iterator.next());
                    }
                }
            }
            arrayList2 = new ArrayList<TableData>();
            iEntityModelArray = arrayList.iterator();
            while (iEntityModelArray.hasNext()) {
                TableData tableData = new TableData((OpticsModuleModel)iEntityModelArray.next(), bl);
                if (!tableData.hasPatchord) continue;
                arrayList2.add(tableData);
                arrayList2.add(new TableData(tableData));
            }
            this.sourceData = new ArrayList(arrayList2);
        } else {
            this.sourceData = new ArrayList();
        }
    }

    public static final String setPatchString(boolean bl, String string, OpticsModuleModel opticsModuleModel) {
        String string2 = new String();
        if (bl) {
            string2 = "Shelf " + String.valueOf(opticsModuleModel.getShelfId()) + ",";
        }
        string2 = string2 + "Slot " + String.valueOf(opticsModuleModel.getSlot());
        string2 = string2 + " (" + opticsModuleModel.getEqTypeName() + "), ";
        string2 = string2 + "port " + string;
        return string2;
    }

    public class TableData {
        private OpticsModuleModel card;
        private String from;
        private String to;
        private boolean multiShelf;
        private boolean hasPatchord;
        private String optSide;

        public TableData(OpticsModuleModel opticsModuleModel, boolean bl) {
            block22: {
                if (opticsModuleModel.hasDWDMPatchCord() || opticsModuleModel.getSide() != 0) {
                    block21: {
                        this.card = opticsModuleModel;
                        this.multiShelf = bl;
                        try {
                            this.optSide = DwdmSide.getSideFromOffset(this.card.getOpticsLineModels()[0].getSide());
                        }
                        catch (NoSuchInterface noSuchInterface) {
                            this.optSide = DwdmSide.getSideFromOffset(0);
                        }
                        catch (WrongInterfaceType wrongInterfaceType) {
                            this.optSide = DwdmSide.getSideFromOffset(0);
                            if (db.on()) {
                                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                            }
                        }
                        catch (InternalCommError internalCommError) {
                            this.optSide = DwdmSide.getSideFromOffset(0);
                            if (!db.on()) break block21;
                            SDebug.printStackTrace((Throwable)internalCommError);
                        }
                    }
                    try {
                        this.hasPatchord = true;
                        switch (opticsModuleModel.getEqType()) {
                            case 266: 
                            case 270: {
                                this.wxcToAmpli(bl, "EXP-TX", opticsModuleModel.getDWDMPatchCords());
                                this.setFrom(bl, "LC");
                                break;
                            }
                            case 129: 
                            case 130: 
                            case 196: 
                            case 239: 
                            case 240: 
                            case 277: 
                            case 278: 
                            case 281: {
                                this.setTo(bl, "LINE-TX", this.card);
                                this.setFrom(bl, "LC");
                                break;
                            }
                            default: {
                                if (db.on()) {
                                    db.println("Wrong card. create an empty to and from cell");
                                }
                                this.to = "";
                                this.from = "";
                                break;
                            }
                        }
                    }
                    catch (FeatureUnsupported featureUnsupported) {
                        if (db.on()) {
                            db.println("No Patchord. create an empty to and from cell");
                        }
                        this.to = "";
                        this.from = "";
                        this.hasPatchord = false;
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)featureUnsupported);
                        }
                        break block22;
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        if (db.on()) {
                            db.println("No Patchord. create an empty to and from cell");
                        }
                        this.to = "";
                        this.from = "";
                        this.hasPatchord = false;
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)noSuchInterface);
                        }
                        break block22;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (db.on()) {
                            db.println("No Patchord. create an empty to and from cell");
                        }
                        this.to = "";
                        this.from = "";
                        this.hasPatchord = false;
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        }
                        break block22;
                    }
                }
                this.hasPatchord = false;
            }
        }

        public TableData(TableData tableData) {
            this.card = tableData.card;
            this.multiShelf = tableData.multiShelf;
            this.optSide = tableData.optSide;
            switch (this.card.getEqType()) {
                case 266: 
                case 270: {
                    this.setFrom(this.multiShelf, "MPO");
                    this.setTo(this.multiShelf, "EXP-RX (1-8)", this.card);
                    break;
                }
                case 129: 
                case 130: 
                case 196: 
                case 239: 
                case 240: 
                case 277: 
                case 278: 
                case 281: {
                    this.setFrom(this.multiShelf, "LC");
                    this.setTo(this.multiShelf, "LC", this.card);
                    break;
                }
                default: {
                    if (db.on()) {
                        db.println("Copy from a Wrong card. create an empty to and from cell");
                    }
                    this.to = "";
                    this.from = "";
                }
            }
        }

        public final String getFrom() {
            return this.from;
        }

        public final String getTo() {
            return this.to;
        }

        public final boolean hasPatchord() {
            return this.hasPatchord;
        }

        private final void setFrom(boolean bl, String string) {
            this.from = "PP-MESH," + string + " (" + this.optSide + " )";
        }

        private void setTo(boolean bl, String string, OpticsModuleModel opticsModuleModel) {
            this.to = WxcMeshppTableModel.setPatchString(bl, string, opticsModuleModel);
        }

        private void wxcToAmpli(boolean bl, String string, sOpticalPatchCord[] sOpticalPatchCordArray) throws AbstractCmsNoSuchEntityException {
            NodeModelDelegate nodeModelDelegate = this.card.getNodeModelDelegate();
            EntityTableModel entityTableModel = nodeModelDelegate.getEntityTableModel();
            boolean bl2 = false;
            block7: for (int i = 0; i < sOpticalPatchCordArray.length && !bl2; ++i) {
                IEntityModel iEntityModel;
                block10: {
                    iEntityModel = entityTableModel.getEntityModelByIndex(sOpticalPatchCordArray[i].from);
                    try {
                        if (((OpticsPortModel)iEntityModel).getOptPortType() != OpticalPortType.OUT_EXPRESS) {
                        }
                        break block10;
                    }
                    catch (NoSuchEquipment noSuchEquipment) {
                    }
                    catch (WrongPortType wrongPortType) {}
                    continue;
                }
                iEntityModel = entityTableModel.getEntityModelByIndex(sOpticalPatchCordArray[i].to);
                int n = iEntityModel.getParent().getEqType();
                switch (n) {
                    case 129: {
                        this.setTo(bl, "COM-TX", (OpticsModuleModel)iEntityModel.getParent());
                        bl2 = true;
                        continue block7;
                    }
                    case 130: 
                    case 196: 
                    case 239: 
                    case 240: 
                    case 277: 
                    case 278: 
                    case 281: {
                        this.setTo(bl, "LINE-TX", (OpticsModuleModel)iEntityModel.getParent());
                        bl2 = true;
                    }
                }
            }
            if (!bl2) {
                this.setTo(bl, string, this.card);
            }
        }
    }
}

