/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import java.awt.event.ActionEvent;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class StackTraceUtil {
    public static final String DUMP_THREADS_ACTION = "dumpthreads";

    private StackTraceUtil() {
    }

    public static int getDefaultThreadDumpKeyCode() {
        return 92;
    }

    public static int getDefaultThreadDumpModifiers() {
        return 2;
    }

    public static AbstractAction bindKeyToDumpThreads(JComponent jComponent, int n, int n2, final PrintStream printStream) {
        jComponent.getInputMap(2).put(KeyStroke.getKeyStroke(n, n2), DUMP_THREADS_ACTION);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StackTraceUtil.dumpThreads(printStream);
                    }
                });
            }
        };
        jComponent.getActionMap().put(DUMP_THREADS_ACTION, abstractAction);
        return abstractAction;
    }

    public static AbstractAction bindKeyToDumpThreads(JComponent jComponent, PrintStream printStream) {
        return StackTraceUtil.bindKeyToDumpThreads(jComponent, StackTraceUtil.getDefaultThreadDumpKeyCode(), StackTraceUtil.getDefaultThreadDumpModifiers(), printStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpThreads(PrintStream printStream) {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        Set<Thread> set = map.keySet();
        TreeSet<Thread> treeSet = new TreeSet<Thread>(new Comparator<Thread>(){

            @Override
            public int compare(Thread thread, Thread thread2) {
                return thread.getName().compareTo(thread2.getName());
            }
        });
        treeSet.addAll(set);
        for (Thread thread : treeSet) {
            Object object;
            Thread.State state = thread.getState();
            printStream.print("\"" + thread.getName() + ": " + state.toString().toLowerCase().replace('_', '-') + "\"");
            if (thread.isDaemon()) {
                printStream.print(" daemon");
            }
            printStream.print(" prio=" + thread.getPriority());
            printStream.print(" tid=0x" + new Formatter().format("%08x", thread.hashCode()));
            printStream.print(" nid=0x" + Long.toHexString(thread.getId()));
            StackTraceElement[] stackTraceElementArray = map.get(thread);
            if (stackTraceElementArray != null && stackTraceElementArray.length > 0 && (state == Thread.State.BLOCKED || state == Thread.State.WAITING || state == Thread.State.TIMED_WAITING)) {
                object = stackTraceElementArray[0];
                Object object2 = ((StackTraceElement)object).getClassName();
                int n = ((String)object2).lastIndexOf(".");
                if (n >= 0) {
                    object2 = ((String)object2).substring(n + 1);
                }
                printStream.print(" in " + (String)object2 + "." + ((StackTraceElement)object).getMethodName() + "()");
            }
            printStream.println("");
            object = printStream;
            synchronized (object) {
                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                    printStream.println("\tat " + stackTraceElement);
                }
            }
            printStream.println("");
        }
    }
}

