/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model;

import cerent.cms.model.CmsObservable;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.model.event.ICardAlarmStore;
import cerent.cms.model.event.StoreObservable;
import cerent.util.UObservable;
import cerent.util.gui.row.RowDataSourceListener;
import com.cisco.crs.model.CrsAlarm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlarmStore
implements IAlarmStore {
    private TreeSet<CrsAlarm> lastAlarms;
    private AlarmStatus alarmStatus;
    protected CmsObservable alarmStatusObservable = new StoreObservable("CRS_Alarm_store");

    public AlarmStore() {
        this.alarmStatus = new AlarmStatus();
        this.lastAlarms = new TreeSet();
    }

    public void removeClearedAlarms() {
    }

    public void flushAlarmStore() {
    }

    public IAlarmStatus getAlarmStatus() {
        return this.alarmStatus;
    }

    public ArrayList getAlarmByCondition(int n) {
        return new ArrayList();
    }

    public void addAlarmStatusObserver(Observer observer) {
        this.alarmStatusObservable.addObserver(observer);
    }

    public void deleteAlarmStatusObserver(Observer observer) {
        this.alarmStatusObservable.deleteObserver(observer);
    }

    public Observable getAlarmStatusObservable() {
        return null;
    }

    public ICardAlarmStore getCardAlarmStore(int n) {
        return null;
    }

    public ICardAlarmStore getCardAlarmStore(int n, int n2) {
        return null;
    }

    public boolean isAutoDeleteCleared() {
        return false;
    }

    public void setAutoDeleteCleared(boolean bl) {
    }

    public void addObserver(Observer observer) {
    }

    public void deleteObserver(Observer observer) {
    }

    public UObservable getStoreObservable() {
        return null;
    }

    public void update(Observable observable, Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectAtRow(int n) {
        TreeSet<CrsAlarm> treeSet = this.lastAlarms;
        synchronized (treeSet) {
            if (n > this.lastAlarms.size()) {
                return -1;
            }
            return this.lastAlarms.toArray()[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        TreeSet<CrsAlarm> treeSet = this.lastAlarms;
        synchronized (treeSet) {
            return this.lastAlarms.size();
        }
    }

    public void addRowDataSourceListener(RowDataSourceListener rowDataSourceListener) {
    }

    public void removeRowDataSourceListener(RowDataSourceListener rowDataSourceListener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllObjects() {
        TreeSet<CrsAlarm> treeSet = this.lastAlarms;
        synchronized (treeSet) {
            return this.lastAlarms;
        }
    }

    public Class getRowObjectClass() {
        return CrsAlarm.class;
    }

    public int setObjectAtRow(int n, Object object) {
        return -1;
    }

    public int remove(int[] nArray) {
        return 0;
    }

    public int findSame(Object object) {
        return -1;
    }

    public Object clone(Object object) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAlarms(TreeSet<CrsAlarm> treeSet) {
        TreeSet<CrsAlarm> treeSet2 = this.lastAlarms;
        synchronized (treeSet2) {
            CrsAlarm crsAlarm;
            Iterator<CrsAlarm> iterator = treeSet.iterator();
            Iterator<CrsAlarm> iterator2 = this.lastAlarms.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                crsAlarm = iterator.next();
                if (this.lastAlarms.contains(crsAlarm)) continue;
                this.addAlarm(crsAlarm);
                bl = true;
            }
            while (iterator2.hasNext()) {
                crsAlarm = iterator2.next();
                if (treeSet.contains(crsAlarm)) continue;
                this.removeAlarm(crsAlarm);
                bl = true;
            }
            if (bl) {
                this.lastAlarms = treeSet;
                this.alarmStatusObservable.setChanged();
                this.alarmStatusObservable.notifyObservers(this.alarmStatus);
            }
        }
    }

    private void addAlarm(CrsAlarm crsAlarm) {
        CrsAlarm.SeverityClass severityClass = crsAlarm.getSeverityClass();
        if (severityClass == CrsAlarm.SeverityClass.CRITICAL) {
            this.alarmStatus.incrementSeverity(4);
        } else if (severityClass == CrsAlarm.SeverityClass.MAJOR) {
            this.alarmStatus.incrementSeverity(3);
        } else if (severityClass == CrsAlarm.SeverityClass.MINOR) {
            this.alarmStatus.incrementSeverity(2);
        }
    }

    private void removeAlarm(CrsAlarm crsAlarm) {
        CrsAlarm.SeverityClass severityClass = crsAlarm.getSeverityClass();
        if (severityClass == CrsAlarm.SeverityClass.CRITICAL) {
            this.alarmStatus.decrementSeverity(4);
        } else if (severityClass == CrsAlarm.SeverityClass.MAJOR) {
            this.alarmStatus.decrementSeverity(3);
        } else if (severityClass == CrsAlarm.SeverityClass.MINOR) {
            this.alarmStatus.decrementSeverity(2);
        }
    }
}

