/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVcatTermAttributes;
import cerent.cms.model.ModelUpdateType;
import cerent.util.tty.CLIParsingUtils;
import cerent.util.tty.ICLIXMLTags;
import com.cisco.crs.model.AbstractModel;
import com.cisco.crs.model.CLICommandFailure;
import com.cisco.crs.model.CLICommander;
import com.cisco.crs.model.ChassisModel;
import com.cisco.crs.model.CircuitFactoryModel;
import com.cisco.crs.model.EntityModel;
import com.cisco.crs.model.PlatformNodeModel;
import com.cisco.crs.model.PlimPortId;
import com.cisco.crs.model.PlimPortModel;
import com.cisco.crs.model.core.AbstractCLIAdapter;
import com.cisco.crs.model.core.CachedValue;
import com.cisco.crs.model.parser.AlarmParser;
import com.cisco.crs.model.parser.ShowInventoryParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityTableModel
extends AbstractModel
implements IEntityTableModel,
ICLIXMLTags {
    public static final int NC_SHELF_ID = 1;
    private static final String ENDL = "\r\n";
    private static final String DWDM = "dwdm";
    private static final String _PARAMETER_ = "_Parameter_";
    private static final String _PARAMETER2_ = "_Parameter2_";
    private CachedValue getInventoryCV;
    private CachedValue getAlarmsCV;
    private List<ChassisModel> chassis = new LinkedList<ChassisModel>();
    private Map<Integer, IEntityModel> entities = new HashMap<Integer, IEntityModel>();

    public EntityTableModel(PlatformNodeModel platformNodeModel) {
        super(platformNodeModel, platformNodeModel.getChildDebug(EntityTableModel.class));
        this.getInventoryCV = new CachedValue(new GetInventory());
        this.getAlarmsCV = new CachedValue(new GetAlarms());
    }

    public IEntityModel getEntityModelByIndex(int n) throws AbstractCmsNoSuchEntityException {
        IEntityModel iEntityModel = this.entities.get(n);
        if (iEntityModel == null) {
            throw new CmsNoSuchEntityException("The entity model does not exist for the index 0x" + Integer.toHexString(n) + ".\nThis is a normal result of some race conditions.");
        }
        return iEntityModel;
    }

    public List<PlimPortId> getPlimPortIndices() {
        ArrayList<PlimPortId> arrayList = new ArrayList<PlimPortId>();
        for (IEntityModel iEntityModel : this.entities.values()) {
            if (iEntityModel.getEqType() != 291) continue;
            PlimPortModel plimPortModel = (PlimPortModel)iEntityModel;
            arrayList.add(new PlimPortId(iEntityModel.getIndex(), plimPortModel.getPlimType()));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public void init() {
        this.db.addCommand(this, "dumpTable", "Dump entity table as a tree");
        this.getInventoryCV.init();
        this.getAlarmsCV.init();
        super.init0();
        for (ChassisModel chassisModel : this.chassis) {
            chassisModel.init();
        }
    }

    @Override
    public void dispose() {
        this.getInventoryCV.dispose();
        this.getAlarmsCV.dispose();
        super.dispose();
    }

    public Integer[] getElementIndices() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (EntityModel entityModel : this.entities.values()) {
            eClass eClass2 = eClass.from_int(entityModel.getGenericClass());
            if (eClass2 != eClass.PORT && eClass2 != eClass.E_MODULE) continue;
            arrayList.add(new Integer(entityModel.getEntityIndex()));
        }
        return arrayList.toArray(new Integer[0]);
    }

    public IEntityModel getEntityModelBySlot(int n) throws AbstractCmsNoSuchEntityException {
        return this.getEntityModelBySlot(1, n);
    }

    public IEntityModel getEntityModelBySlot(int n, int n2) throws AbstractCmsNoSuchEntityException {
        ChassisModel chassisModel = this.getChassis(n);
        if (chassisModel == null) {
            throw new CmsNoSuchEntityException("No entity found at shelf " + n + ", slot " + n2);
        }
        return chassisModel.getSlot(n2);
    }

    public IEntityModel getChassis() {
        if (this.chassis.size() == 0) {
            return this.chassis.get(0);
        }
        return null;
    }

    public List getAvailEntitiesForLo(int n, boolean bl) {
        return Collections.EMPTY_LIST;
    }

    public List getAvailEntitiesForVt(int n, boolean bl) {
        return Collections.EMPTY_LIST;
    }

    public List getAvailEntitiesForHo(short s, int n, boolean bl) {
        return Collections.EMPTY_LIST;
    }

    public List getAvailEntitiesForDstHo(int n, short s, int n2, boolean bl) {
        return Collections.EMPTY_LIST;
    }

    public List getAvailEntitiesForSecHo(int n, short s, int n2, boolean bl) {
        return Collections.EMPTY_LIST;
    }

    public List getAvailEntitiesForSts(short s, int n, boolean bl) {
        return Collections.EMPTY_LIST;
    }

    public void filterDropEntities(List list, IEntityModel iEntityModel, int n, int n2, List list2) {
    }

    public void lapFilterEntities(List list, List list2) {
    }

    public void screenAvailEntities(IEntityModel[] iEntityModelArray, List list, boolean bl) {
    }

    public List getAvailEntitiesForLoVcat(int n, IVcatTermAttributes iVcatTermAttributes, boolean bl) {
        return Collections.EMPTY_LIST;
    }

    public List getAvailEntitiesForHoVcat(short s, IVcatTermAttributes iVcatTermAttributes, boolean bl) {
        return Collections.EMPTY_LIST;
    }

    public List getFirstAvailPairPPorts(short s) {
        return null;
    }

    public void testEntity(IEntityModel iEntityModel) {
    }

    public ChassisModel[] getAllChassis() {
        return this.chassis.toArray(new ChassisModel[0]);
    }

    public void addEntityModel(EntityModel entityModel) {
        if (this.db.isFinerEnabled()) {
            this.db.println("addEntityModel() called for " + entityModel);
        }
        if (entityModel instanceof ChassisModel) {
            this.chassis.add((ChassisModel)entityModel);
        }
        this.entities.put(entityModel.getEntityIndex(), entityModel);
        entityModel.addObserver((Observer)this.getNodeModel());
        if (this.isInited()) {
            entityModel.init();
        }
        this.setChanged();
    }

    void removeEntityModel(EntityModel entityModel) {
        if (this.db.isFinerEnabled()) {
            this.db.println("removeEntityModel() called for " + entityModel);
        }
        if (entityModel instanceof ChassisModel) {
            this.chassis.remove((ChassisModel)entityModel);
        }
        this.entities.remove(entityModel.getEntityIndex());
        this.setChanged();
    }

    public ChassisModel getChassis(int n) throws AbstractCmsNoSuchEntityException {
        for (ChassisModel chassisModel : this.chassis) {
            if (chassisModel.getShelfId() != n) continue;
            return chassisModel;
        }
        throw new CmsNoSuchEntityException("The entity model does not exist for Shelf " + n);
    }

    public void updateCompleted() {
        if (!((CircuitFactoryModel)this.node.getCircuitFactoryModel()).isInited()) {
            ((CircuitFactoryModel)this.node.getCircuitFactoryModel()).init();
        } else {
            ((CircuitFactoryModel)this.node.getCircuitFactoryModel()).updateCircuits();
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public final void dumpTable() {
        for (ChassisModel chassisModel : this.chassis) {
            this.debugDumpEntityTree(chassisModel);
        }
    }

    public void debugDumpEntityTree(IEntityModel iEntityModel) {
        this.db.println("--- Entity Tree " + (iEntityModel instanceof IChassisModel ? "(Shelf " + ((IChassisModel)iEntityModel).getShelfId() + ") " : "") + "---");
        this.debugDumpEntityTree(iEntityModel, 0);
        this.db.println("^^^ Entity Tree " + (iEntityModel instanceof IChassisModel ? "(Shelf " + ((IChassisModel)iEntityModel).getShelfId() + ") " : "") + "^^^");
    }

    private void debugDumpEntityTree(IEntityModel iEntityModel, int n) {
        if (null != iEntityModel) {
            String string = "";
            for (int i = 0; i < n; ++i) {
                string = string + "| ";
            }
            this.db.println(string + iEntityModel.toString());
            Iterator iterator = iEntityModel.getChildren().iterator();
            while (iterator.hasNext()) {
                this.debugDumpEntityTree((IEntityModel)iterator.next(), n + 1);
            }
        }
    }

    public boolean deleteSRLG(INodeModel iNodeModel, String string) {
        block7: {
            if (iNodeModel instanceof PlatformNodeModel) {
                PlatformNodeModel platformNodeModel = (PlatformNodeModel)iNodeModel;
                try {
                    CLICommander cLICommander = platformNodeModel.getCLICommander();
                    SRLGOperations sRLGOperations = new SRLGOperations();
                    boolean bl = sRLGOperations.deleteSRLG(cLICommander, string);
                    if (!bl) {
                        if (this.db.on()) {
                            this.db.print("Unable to delete the SRLGs from CRS " + iNodeModel.getName());
                        }
                        return false;
                    }
                    break block7;
                }
                catch (Exception exception) {
                    if (this.db.on()) {
                        this.db.print("Caught Exception while deleting the SRLGs from CRS " + iNodeModel.getName());
                    }
                    return false;
                }
            }
            if (this.db.on()) {
                this.db.print("Got wrong Node Model." + iNodeModel.getName());
            }
            return false;
        }
        return true;
    }

    public boolean setSRLG(INodeModel iNodeModel, List list, String string) {
        block6: {
            if (iNodeModel instanceof PlatformNodeModel) {
                PlatformNodeModel platformNodeModel = (PlatformNodeModel)iNodeModel;
                try {
                    CLICommander cLICommander = platformNodeModel.getCLICommander();
                    SRLGOperations sRLGOperations = new SRLGOperations();
                    boolean bl = sRLGOperations.setSRLG(cLICommander, list, string);
                    if (!bl) {
                        if (this.db.on()) {
                            this.db.print("Unable to set the SRLGs on CRS " + iNodeModel.getName());
                        }
                        return false;
                    }
                    break block6;
                }
                catch (Exception exception) {
                    if (this.db.on()) {
                        this.db.print("Caught Exception while setting the SRLGs on CRS " + iNodeModel.getName());
                    }
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public String getEmbargo(INodeModel iNodeModel, int n, String string) {
        if (iNodeModel instanceof PlatformNodeModel) {
            PlatformNodeModel platformNodeModel = (PlatformNodeModel)iNodeModel;
            try {
                CLICommander cLICommander = platformNodeModel.getCLICommander();
                CoMOperations coMOperations = new CoMOperations();
                String string2 = coMOperations.getEmbargo(cLICommander, n, string);
                if (string2 == null) {
                    if (this.db.on()) {
                        this.db.print("Unable to get the Embargo from the CRS " + iNodeModel.getName());
                    }
                    return null;
                }
                return string2;
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    this.db.print("Caught Exception while getting the Embargo from CRS " + iNodeModel.getName());
                }
                return null;
            }
        }
        return null;
    }

    public String getTransportAdminState(INodeModel iNodeModel, String string) {
        if (iNodeModel instanceof PlatformNodeModel) {
            PlatformNodeModel platformNodeModel = (PlatformNodeModel)iNodeModel;
            try {
                CLICommander cLICommander = platformNodeModel.getCLICommander();
                CoMOperations coMOperations = new CoMOperations();
                String string2 = coMOperations.getTransportAdminState(cLICommander, string);
                if (string2 == null) {
                    if (this.db.on()) {
                        this.db.print("Unable to get the TAS from the CRS " + iNodeModel.getName());
                    }
                    return null;
                }
                return string2;
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    this.db.print("Caught Exception while getting the TAS from CRS " + iNodeModel.getName());
                }
                return null;
            }
        }
        return null;
    }

    public boolean setTransportAdminState(INodeModel iNodeModel, String string, String string2) {
        if (iNodeModel instanceof PlatformNodeModel) {
            PlatformNodeModel platformNodeModel = (PlatformNodeModel)iNodeModel;
            try {
                CLICommander cLICommander = platformNodeModel.getCLICommander();
                CoMOperations coMOperations = new CoMOperations();
                boolean bl = coMOperations.setTransportAdminState(cLICommander, string, string2);
                if (!bl) {
                    if (this.db.on()) {
                        this.db.print("Unable to set the TAS on the CRS " + iNodeModel.getName());
                    }
                    return false;
                }
                return bl;
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    this.db.print("Caught Exception while setting the TAS on the CRS " + iNodeModel.getName());
                }
                return false;
            }
        }
        return false;
    }

    public List getPortEntities() {
        return Collections.EMPTY_LIST;
    }

    private class CoMOperations {
        private static final String RODAN_CARD = "TenGigE";
        private static final String GODZILLA_CARD = "POS";
        private static final String TRANSPORT_ADMIN_STATE = "TransportAdminState";
        private static final String MAINTENANCE_EMBARGO = "MaintenanceEmbargo";
        private static final String GET_EMBARGO = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<Get>\r\n<Configuration>\r\n<InterfaceConfigurationTable MajorVersion=\"3\" MinorVersion=\"1\">\r\n<InterfaceConfiguration>\r\n<Naming>\r\n<Active>act</Active>\r\n<InterfaceName>_Parameter__Parameter2_</InterfaceName>\r\n</Naming>\r\n<MaintenanceEmbargo/>\r\n</InterfaceConfiguration>\r\n</InterfaceConfigurationTable>\r\n</Configuration>\r\n</Get>\r\n</Request>";
        private static final String GET_TRANSPORT_ADMIN_STATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<Get>\r\n<Configuration>\r\n<InterfaceConfigurationTable MajorVersion=\"3\" MinorVersion=\"1\">\r\n<InterfaceConfiguration>\r\n<Naming>\r\n<Active>act</Active>\r\n<InterfaceName>dwdm_Parameter_</InterfaceName>\r\n</Naming>\r\n<DWDM MajorVersion=\"3\" MinorVersion=\"0\">\r\n<TransportAdminState/>\r\n</DWDM>\r\n</InterfaceConfiguration>\r\n</InterfaceConfigurationTable>\r\n</Configuration>\r\n</Get>\r\n</Request>";
        private static final String SET_TRANSPORT_ADMIN_STATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<Set>\r\n<Configuration>\r\n<InterfaceConfigurationTable MajorVersion=\"3\" MinorVersion=\"1\">\r\n<InterfaceConfiguration>\r\n<Naming>\r\n<Active>act</Active>\r\n<InterfaceName>dwdm_Parameter_</InterfaceName>\r\n</Naming>\r\n<DWDM MajorVersion=\"3\" MinorVersion=\"0\">\r\n<TransportAdminState>_Parameter2_</TransportAdminState>\r\n</DWDM>\r\n</InterfaceConfiguration>\r\n</InterfaceConfigurationTable>\r\n</Configuration>\r\n</Set>\r\n<Commit IgnoreOtherSessions=\"true\"/>\r\n<Clear/>\r\n</Request>";

        private CoMOperations() {
        }

        private String getEmbargo(CLICommander cLICommander, int n, String string) {
            try {
                if (n == -1) {
                    if (EntityTableModel.this.db.on()) {
                        EntityTableModel.this.db.println("Invalid Equipment type received: " + n);
                    }
                    return null;
                }
                String string2 = null;
                if (n == 290) {
                    string2 = GET_EMBARGO.replaceAll(EntityTableModel._PARAMETER_, RODAN_CARD);
                } else if (n == 292 || n == 320) {
                    string2 = GET_EMBARGO.replaceAll(EntityTableModel._PARAMETER_, GODZILLA_CARD);
                }
                string2 = string2.replaceAll(EntityTableModel._PARAMETER2_, string);
                String string3 = cLICommander.sendCommand(string2);
                if (cLICommander.isResponseErroneous(string3)) {
                    return null;
                }
                return this.parseResponse(string3, MAINTENANCE_EMBARGO);
            }
            catch (CLICommandFailure cLICommandFailure) {
                if (EntityTableModel.this.db.on()) {
                    EntityTableModel.this.db.println("Got error:" + cLICommandFailure.getMessage());
                }
                return null;
            }
        }

        private String getTransportAdminState(CLICommander cLICommander, String string) {
            try {
                String string2 = GET_TRANSPORT_ADMIN_STATE.replaceAll(EntityTableModel._PARAMETER_, string);
                String string3 = cLICommander.sendCommand(string2);
                if (cLICommander.isResponseErroneous(string3)) {
                    return null;
                }
                return this.parseResponse(string3, TRANSPORT_ADMIN_STATE);
            }
            catch (CLICommandFailure cLICommandFailure) {
                if (EntityTableModel.this.db.on()) {
                    EntityTableModel.this.db.println("Got error:" + cLICommandFailure.getMessage());
                }
                return null;
            }
        }

        private boolean setTransportAdminState(CLICommander cLICommander, String string, String string2) {
            try {
                String string3 = SET_TRANSPORT_ADMIN_STATE.replaceAll(EntityTableModel._PARAMETER_, string).replaceAll(EntityTableModel._PARAMETER2_, string2);
                String string4 = cLICommander.sendCommand(string3);
                return !cLICommander.isResponseErroneous(string4);
            }
            catch (CLICommandFailure cLICommandFailure) {
                if (EntityTableModel.this.db.on()) {
                    EntityTableModel.this.db.println("Got error:" + cLICommandFailure.getMessage());
                }
                return false;
            }
        }

        private String parseResponse(String string, String string2) {
            block9: {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                try {
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
                    Element element = document.getDocumentElement();
                    NodeList nodeList = element.getElementsByTagName(string2);
                    if (nodeList != null && nodeList.getLength() > 0) {
                        return ((Element)nodeList.item(0)).getTextContent();
                    }
                }
                catch (DOMException dOMException) {
                    if (EntityTableModel.this.db.on()) {
                        EntityTableModel.this.db.println("Got Exception:" + dOMException);
                    }
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    if (EntityTableModel.this.db.on()) {
                        EntityTableModel.this.db.println("Got Exception:" + parserConfigurationException);
                    }
                }
                catch (SAXException sAXException) {
                    if (EntityTableModel.this.db.on()) {
                        EntityTableModel.this.db.println("Got Exception:" + sAXException);
                    }
                }
                catch (IOException iOException) {
                    if (!EntityTableModel.this.db.on()) break block9;
                    EntityTableModel.this.db.println("Got Exception:" + iOException);
                }
            }
            return null;
        }
    }

    private class GetAlarms
    extends AbstractCLIAdapter {
        private static final String GET_ALARMS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request><Get><Operational><AlarmLogger><AlarmTable><Filter><AlarmLoggerEventFilter><BiStateSetOnly>True</BiStateSetOnly></AlarmLoggerEventFilter></Filter></AlarmTable></AlarmLogger></Operational></Get></Request>";

        public GetAlarms() {
            super(EntityTableModel.this.getNMD(), EntityTableModel.this, GET_ALARMS, new AlarmParser(EntityTableModel.this, EntityTableModel.this.db));
        }
    }

    private class GetInventory
    extends AbstractCLIAdapter {
        private static final String SHOW_INVENTORY = "show inventory";

        public GetInventory() {
            super(EntityTableModel.this.getNMD(), EntityTableModel.this, CLIParsingUtils.encloseCLICommandInXML((String)SHOW_INVENTORY), new ShowInventoryParser(EntityTableModel.this, EntityTableModel.this.db));
        }
    }

    private class SRLGOperations {
        private static final int MAX_SETS = 7;
        private static final String DELETE_SRLG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<Delete>\r\n<Configuration>\r\n<InterfaceConfigurationTable MajorVersion=\"3\" MinorVersion=\"1\">\r\n<InterfaceConfiguration>\r\n<Naming>\r\n<Active>act</Active>\r\n<InterfaceName>dwdm_Parameter_</InterfaceName>\r\n</Naming>\r\n<DWDM MajorVersion=\"3\" MinorVersion=\"0\">\r\n<NetworkSrlgTable>\r\n</NetworkSrlgTable>\r\n</DWDM>\r\n</InterfaceConfiguration>\r\n</InterfaceConfigurationTable>\r\n</Configuration>\r\n</Delete>\r\n<Commit IgnoreOtherSessions=\"true\"/>\r\n<Clear/>\r\n</Request>";
        private static final String xml_start = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<Set>\r\n<Configuration>\r\n<InterfaceConfigurationTable MajorVersion=\"3\" MinorVersion=\"1\">\r\n<InterfaceConfiguration>\r\n<Naming>\r\n<Active>act</Active>\r\n<InterfaceName>dwdm_Parameter_</InterfaceName>\r\n</Naming>\r\n<DWDM MajorVersion=\"3\" MinorVersion=\"0\">\r\n<NetworkSrlgTable>\r\n";
        private static final String xml_end = "</NetworkSrlgTable>\r\n</DWDM>\r\n</InterfaceConfiguration>\r\n</InterfaceConfigurationTable>\r\n</Configuration>\r\n</Set>\r\n<Commit IgnoreOtherSessions=\"true\"/>\r\n<Clear/>\r\n</Request>";
        private static final String start_request = "<NetworkSrlg>\r\n<Naming>\r\n<SetId>";
        private static final String end_request = "</SetId>\r\n</Naming>";

        private SRLGOperations() {
        }

        private boolean deleteSRLG(CLICommander cLICommander, String string) {
            try {
                String string2 = DELETE_SRLG.replaceAll(EntityTableModel._PARAMETER_, string);
                String string3 = cLICommander.sendCommand(string2);
                if (cLICommander.isResponseErroneous(string3)) {
                    return false;
                }
            }
            catch (CLICommandFailure cLICommandFailure) {
                if (EntityTableModel.this.db.on()) {
                    EntityTableModel.this.db.println("Got error:" + cLICommandFailure.getMessage());
                }
                return false;
            }
            return true;
        }

        private boolean setSRLG(CLICommander cLICommander, List list, String string) {
            try {
                String string2 = this.constructSetSRLGXML(list, string);
                String string3 = cLICommander.sendCommand(string2);
                if (cLICommander.isResponseErroneous(string3)) {
                    return false;
                }
            }
            catch (CLICommandFailure cLICommandFailure) {
                if (EntityTableModel.this.db.on()) {
                    EntityTableModel.this.db.println("Got error:" + cLICommandFailure.getMessage());
                }
                return false;
            }
            return true;
        }

        private String constructSetSRLGXML(List list, String string) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 1;
            int n3 = 1;
            for (n = 0; n < list.size(); ++n) {
                if (n3 % 7 == 0) {
                    arrayList.add(start_request + n2 + end_request + EntityTableModel.ENDL + stringBuffer + EntityTableModel.ENDL + "</NetworkSrlg>" + EntityTableModel.ENDL);
                    stringBuffer.delete(0, stringBuffer.length());
                    ++n2;
                    n3 = 1;
                }
                stringBuffer.append("<Srlg_SRLGCOUNTER_>" + list.get(n).toString() + "</Srlg_SRLGCOUNTER_>");
                int n4 = stringBuffer.indexOf("_SRLGCOUNTER_");
                int n5 = n4 + "_SRLGCOUNTER_".length();
                stringBuffer.replace(n4, n5, Integer.toString(n3));
                n4 = stringBuffer.indexOf("_SRLGCOUNTER_");
                n5 = n4 + "_SRLGCOUNTER_".length();
                stringBuffer.replace(n4, n5, Integer.toString(n3++));
            }
            if (!stringBuffer.equals("")) {
                arrayList.add(start_request + n2 + end_request + EntityTableModel.ENDL + stringBuffer + EntityTableModel.ENDL + "</NetworkSrlg>" + EntityTableModel.ENDL);
            }
            stringBuffer.delete(0, stringBuffer.length());
            for (n = 0; n < arrayList.size(); ++n) {
                stringBuffer.append(arrayList.get(n).toString());
            }
            String string2 = xml_start + stringBuffer + xml_end;
            string2 = string2.replaceAll(EntityTableModel._PARAMETER_, string);
            return string2;
        }
    }
}

