/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model.core;

import cerent.cms.model.CircuitDropInfo;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitId;
import cerent.cms.model.CktInfo;
import cerent.cms.model.ICircuitDropInfo;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitInfo;
import cerent.cms.model.VlanInfo;
import cerent.util.InetUtil;

public class TTIObject {
    private String ipAddr;
    private int nodeId;
    private int uniqueId;
    private String portInternalId;
    private int portId;
    public String circuitName;
    public String crc16;
    private int[] lookuptable = new int[]{0, 49345, 49537, 320, 49921, 960, 640, 49729, 50689, 1728, 1920, 51009, 1280, 50625, 50305, 1088, 52225, 3264, 3456, 52545, 3840, 53185, 52865, 3648, 2560, 51905, 52097, 2880, 51457, 2496, 2176, 51265, 55297, 6336, 6528, 55617, 6912, 56257, 55937, 6720, 7680, 57025, 57217, 8000, 56577, 7616, 7296, 56385, 5120, 54465, 54657, 5440, 55041, 6080, 5760, 54849, 53761, 4800, 4992, 54081, 4352, 53697, 53377, 4160, 61441, 12480, 12672, 61761, 13056, 62401, 62081, 12864, 13824, 63169, 63361, 14144, 62721, 13760, 13440, 62529, 15360, 64705, 64897, 15680, 65281, 16320, 16000, 65089, 64001, 15040, 15232, 64321, 14592, 63937, 63617, 14400, 10240, 59585, 59777, 10560, 60161, 11200, 10880, 59969, 60929, 11968, 12160, 61249, 11520, 60865, 60545, 11328, 58369, 9408, 9600, 58689, 9984, 59329, 59009, 9792, 8704, 58049, 58241, 9024, 57601, 8640, 8320, 57409, 40961, 24768, 24960, 41281, 25344, 41921, 41601, 25152, 26112, 42689, 42881, 26432, 42241, 26048, 25728, 42049, 27648, 44225, 44417, 27968, 44801, 28608, 28288, 44609, 43521, 27328, 27520, 43841, 26880, 43457, 43137, 26688, 30720, 47297, 47489, 31040, 47873, 31680, 31360, 47681, 48641, 32448, 32640, 48961, 32000, 48577, 48257, 31808, 46081, 29888, 30080, 46401, 30464, 47041, 46721, 30272, 29184, 45761, 45953, 29504, 45313, 29120, 28800, 45121, 20480, 37057, 37249, 20800, 37633, 21440, 21120, 37441, 38401, 22208, 22400, 38721, 21760, 38337, 38017, 21568, 39937, 23744, 23936, 40257, 24320, 40897, 40577, 24128, 23040, 39617, 39809, 23360, 39169, 22976, 22656, 38977, 34817, 18624, 18816, 35137, 19200, 35777, 35457, 19008, 19968, 36545, 36737, 20288, 36097, 19904, 19584, 35905, 17408, 33985, 34177, 17728, 34561, 18368, 18048, 34369, 33281, 17088, 17280, 33601, 16640, 33217, 32897, 16448};

    private String calculateCRC16(String string) {
        byte[] byArray = string.getBytes();
        int n = 0;
        for (byte by : byArray) {
            n = n >>> 8 ^ this.lookuptable[(n ^ by) & 0xFF];
        }
        Object object = Integer.toHexString(n);
        String string2 = "";
        for (int i = 0; i < 4 - ((String)object).length(); ++i) {
            string2 = string2 + "0";
        }
        string2 = string2 + (String)object;
        return string2;
    }

    private String sanitizeIpAddr(String string) {
        int n;
        String string2 = "";
        String string3 = "";
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != '.') {
                string3 = string3 + string.charAt(n);
                continue;
            }
            if (string3.length() == 3) {
                string2 = string2 + string3;
                string3 = "";
                continue;
            }
            for (int i = 0; i < 3 - string3.length(); ++i) {
                string2 = string2 + "0";
            }
            string2 = string2 + string3;
            string3 = "";
        }
        for (n = 0; n < 3 - string3.length(); ++n) {
            string2 = string2 + "0";
        }
        string2 = string2 + string3;
        return string2;
    }

    private String restoreSanitizedIpAddr(String string) {
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (i > 0 && i % 3 == 0) {
                string2 = string2 + Integer.parseInt(string3) + ".";
                string3 = "";
                string3 = string3 + string.charAt(i);
                continue;
            }
            string3 = string3 + string.charAt(i);
        }
        return string2 + Integer.parseInt(string3);
    }

    private String sanitizeUniqueId(int n) {
        String string = "";
        String string2 = Integer.toString(n);
        for (int i = string2.length(); i < 3; ++i) {
            string = string + "0";
        }
        string = string + string2;
        return string;
    }

    private String sanitizeNodeId(int n) {
        String string = "";
        String string2 = Integer.toHexString(n);
        for (int i = string2.length(); i < 8; ++i) {
            string = string + "0";
        }
        string = string + string2;
        return string;
    }

    private int restoreSanitizedUniqueId(String string) {
        return Integer.parseInt(string);
    }

    private String sanitizePortInternalId(String string) {
        int n;
        String string2 = "";
        String string3 = "";
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != '/') {
                string3 = string3 + string.charAt(n);
                continue;
            }
            if (string3.length() == 2) {
                string2 = string2 + string3;
                string3 = "";
                continue;
            }
            for (int i = 0; i < 2 - string3.length(); ++i) {
                string2 = string2 + "0";
            }
            string2 = string2 + string3;
            string3 = "";
        }
        for (n = 0; n < 2 - string3.length(); ++n) {
            string2 = string2 + "0";
        }
        string2 = string2 + string3;
        return "0x" + string2;
    }

    private String restoreSanitizedPortInternalId(String string) {
        int n;
        String string2 = "";
        string = string.substring(2, string.length());
        String string3 = "";
        String string4 = "";
        for (n = 0; n < string.length(); ++n) {
            if (n > 0 && n % 2 == 0) {
                string3 = string3 + Integer.parseInt(string4) + "/";
                string4 = "";
                string4 = string4 + string.charAt(n);
                continue;
            }
            string4 = string4 + string.charAt(n);
        }
        for (n = 0; n < string.length(); ++n) {
            int n2 = Integer.parseInt(String.valueOf(string.charAt(n)));
            string2 = n2 > 0 ? string2 + (n2 + 1) : (n > 0 && n % 2 == 1 ? string2 + (n2 + 1) : string2 + string.charAt(n));
        }
        this.portId = Integer.parseInt(string2, 16);
        return string3 + Integer.parseInt(string4);
    }

    private String sanitizeCRC16(String string) {
        return "0x" + string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.sanitizeIpAddr(this.ipAddr));
        stringBuffer.append(this.sanitizeNodeId(this.nodeId));
        stringBuffer.append(this.sanitizeUniqueId(this.uniqueId));
        stringBuffer.append(this.sanitizePortInternalId(this.portInternalId));
        stringBuffer.append(this.circuitName);
        String string = stringBuffer.toString();
        stringBuffer.append(this.sanitizeCRC16(this.calculateCRC16(string)));
        return stringBuffer.toString();
    }

    public boolean containsValidCircuit() {
        long l = Long.parseLong(this.sanitizeIpAddr(this.ipAddr));
        return l != 0L;
    }

    public void invalidateCircuit() {
        this.ipAddr = "0.0.0.0";
    }

    public boolean initialize(String string) {
        if (string.length() != 63) {
            return false;
        }
        String string2 = string.substring(0, 57);
        String string3 = string.substring(57, string.length());
        if (!(string3 = string3.substring(2, string3.length())).equals(this.calculateCRC16(string2))) {
            return false;
        }
        this.ipAddr = this.restoreSanitizedIpAddr(string2.substring(0, 12));
        this.nodeId = new Long(Long.parseLong(string2.substring(12, 20), 16)).intValue();
        this.uniqueId = this.restoreSanitizedUniqueId(string2.substring(20, 23));
        this.portInternalId = this.restoreSanitizedPortInternalId(string2.substring(23, 33));
        this.circuitName = string2.substring(33, 57).trim();
        return true;
    }

    public ICircuitInfo getICircuitInfo(int n, int n2) {
        int n3 = InetUtil.parseDottedString(this.ipAddr);
        ICircuitDropInfo[] iCircuitDropInfoArray = new CircuitDropInfo[]{new CircuitDropInfo(new CircuitEnd(n3, 0, null, null, false, 0), 3)};
        ICircuitEnd[] iCircuitEndArray = new CircuitEnd[]{new CircuitEnd(n, n2, null, null, false, 0)};
        return new CktInfo(0, iCircuitEndArray, iCircuitDropInfoArray, false, new VlanInfo[0], 31, 15, 1, this.circuitName.trim(), 0, 0, 0, 0);
    }

    public ICircuitId getICircuitId() {
        return new CircuitId(this.nodeId, this.uniqueId);
    }

    public void setIpAddr(String string) {
        this.ipAddr = string;
    }

    public String getIpAddr() {
        return this.ipAddr;
    }

    public void setNodeId(int n) {
        this.nodeId = n;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public ICircuitId getCircuitId() {
        int n = this.nodeId;
        int n2 = this.uniqueId;
        return new CircuitId(n, n2);
    }

    public void setUniqueId(int n) {
        this.uniqueId = n;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public int getPortId() {
        return this.portId;
    }

    public void setPortId(int n) {
        this.portId = n;
    }

    public void setPortInternalId(String string) {
        this.portInternalId = string;
    }

    public String getPortInternalId() {
        return this.portInternalId;
    }

    public void setCircuitName(String string) {
        if (string.length() > 24) {
            this.circuitName = string.substring(0, 24);
        } else {
            this.circuitName = string;
            for (int i = 0; i < 24 - string.length(); ++i) {
                this.circuitName = this.circuitName + " ";
            }
        }
    }

    public String getCircuitName() {
        return this.circuitName;
    }

    public static void main(String[] stringArray) {
        TTIObject tTIObject = new TTIObject();
        tTIObject.setIpAddr("127.0.0.1");
        tTIObject.setNodeId(165539583);
        tTIObject.setUniqueId(1);
        tTIObject.setPortInternalId("0/1/0/1");
        tTIObject.setCircuitName("Circuito di prova");
        System.out.println(">>>>" + tTIObject.toString() + "<<<<<");
        TTIObject tTIObject2 = new TTIObject();
        if (!tTIObject2.initialize(tTIObject.toString())) {
            System.out.println("Initialize failed.");
        }
        System.out.println(">>>" + tTIObject2.getIpAddr() + "<<<<");
        System.out.println(">>>" + tTIObject2.getNodeId() + "<<<<");
        System.out.println(">>>" + tTIObject2.getUniqueId() + "<<<<");
        System.out.println(">>>" + tTIObject2.getPortInternalId() + "<<<<");
        System.out.println(">>>" + tTIObject2.getPortId() + "<<<<");
        System.out.println(">>>" + tTIObject2.getCircuitName() + "<<<<");
        ICircuitId iCircuitId = tTIObject2.getCircuitId();
        System.out.println("CID>>>");
        System.out.println("NID:" + iCircuitId.getNodeId());
        System.out.println("UID:" + iCircuitId.getUniquePart().getUniqueId());
        String string = tTIObject.toString();
        string = string.replace('C', 'Z');
        if (!tTIObject2.initialize(string)) {
            System.out.println("Initialize failed.");
        }
    }
}

