/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model.parser;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Dwdm.eDwdmFecMode;
import cerent.cms.model.AdminState;
import cerent.cms.ui.Wavelength;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.tty.ICLIXMLTags;
import com.cisco.crs.model.core.CLIParserError;
import com.cisco.crs.model.core.CLIResponse;
import com.cisco.crs.model.core.ICLIParser;
import com.cisco.crs.model.core.MultipleCLIResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ShowControllersDwdmParser
implements ICLIParser,
ICLIXMLTags {
    private static ShowControllersDwdmParser instance;

    private ShowControllersDwdmParser() {
    }

    public static final ShowControllersDwdmParser instance() {
        if (instance == null) {
            instance = new ShowControllersDwdmParser();
        }
        return instance;
    }

    public CLIResponse parseResponse(String string) throws CLIParserError {
        Object object;
        Response response = new Response();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            object = documentBuilderFactory.newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(new ByteArrayInputStream(string.getBytes()));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            SDebug.printStackTrace((Throwable)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            SDebug.printStackTrace((Throwable)sAXException);
        }
        catch (IOException iOException) {
            SDebug.printStackTrace((Throwable)iOException);
        }
        if (document == null) {
            return null;
        }
        object = document.getDocumentElement();
        response.setState(this.parseState((Element)object));
        response.setWlen(this.parseWlen((Element)object));
        response.setG709Attr(this.parseG709((Element)object));
        response.setTTI(this.parseTTI((Element)object));
        response.setLmpId(this.parseLmpId((Element)object));
        response.setConnectionId(this.parseConnectionId((Element)object));
        return response;
    }

    private ControllerState parseState(Element element) throws CLIParserError {
        ControllerState controllerState = new ControllerState();
        NodeList nodeList = element.getElementsByTagName("Shutdown");
        if (nodeList != null && nodeList.getLength() > 0 && ((Element)nodeList.item(0)).getTextContent().equals("true")) {
            controllerState.setState(StateEnum.ADMIN_DOWN);
        } else {
            controllerState.setState(StateEnum.UP);
        }
        return controllerState;
    }

    private DwdmWavelength parseWlen(Element element) throws CLIParserError {
        DwdmWavelength dwdmWavelength = new DwdmWavelength();
        NodeList nodeList = element.getElementsByTagName("WaveChannel");
        if (nodeList == null || nodeList.getLength() == 0) {
            nodeList = element.getElementsByTagName("Wavelength");
        }
        if (nodeList != null && nodeList.getLength() > 0) {
            int n = Wavelength.getLambdaFromCrsLambdaId(((Element)nodeList.item(0)).getTextContent());
            dwdmWavelength.setValue(n);
            dwdmWavelength.setLabel(Wavelength.getWavelengthStringFromWavelength(n));
        }
        return dwdmWavelength;
    }

    private LmpId parseLmpId(Element element) throws CLIParserError {
        String string;
        int n;
        LmpId lmpId = new LmpId();
        NodeList nodeList = element.getElementsByTagName("CLI");
        if (nodeList != null && nodeList.getLength() > 0 && (n = (string = ((Element)nodeList.item(0)).getTextContent()).indexOf("Dec =")) > -1) {
            String string2 = string.substring(n + 5);
            string2 = string2.substring(0, string2.indexOf("\n")).trim();
            lmpId.setValue(Integer.parseInt(string2));
        }
        return lmpId;
    }

    private ConnectionId parseConnectionId(Element element) throws CLIParserError {
        ConnectionId connectionId = new ConnectionId();
        NodeList nodeList = element.getElementsByTagName("NetworkConnectionId");
        if (nodeList != null && nodeList.getLength() > 0) {
            String string = ((Element)nodeList.item(0)).getTextContent().trim();
            connectionId.setValue(string);
        }
        return connectionId;
    }

    private G709Attr parseG709(Element element) throws CLIParserError {
        G709Attr g709Attr = new G709Attr();
        NodeList nodeList = element.getElementsByTagName("G709");
        if (nodeList != null && nodeList.getLength() > 0) {
            String string;
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagName("Enabled");
            boolean bl = false;
            bl = nodeList2.getLength() > 0 ? (string = ((Element)nodeList2.item(0)).getTextContent()).equals("true") : true;
            g709Attr.setOtnStatus(bl);
            nodeList2 = ((Element)nodeList.item(0)).getElementsByTagName("FEC");
            if (nodeList2.getLength() > 0) {
                string = ((Element)nodeList2.item(0)).getTextContent();
                if (string.equals("Standard")) {
                    g709Attr.setFecMode(eDwdmFecMode.STANDARD_FEC);
                } else if (string.equals("None")) {
                    g709Attr.setFecMode(eDwdmFecMode.DISABLE_FEC);
                } else {
                    g709Attr.setFecMode(eDwdmFecMode.ENHANCED_FEC);
                }
            } else {
                g709Attr.setFecMode(eDwdmFecMode.ENHANCED_FEC);
            }
            nodeList2 = element2.getElementsByTagName("OTUThreshold");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element3 = (Element)nodeList2.item(i);
                String string2 = ((Element)element3.getElementsByTagName("Threshold").item(0)).getTextContent();
                short s = Short.parseShort(((Element)element3.getElementsByTagName("ThresholdValue").item(0)).getTextContent());
                if (string2.equals("OTU_SF")) {
                    g709Attr.setSfBerLevel(s);
                    continue;
                }
                if (!string2.equals("OTU_SD")) continue;
                g709Attr.setSdBerLevel(s);
            }
        } else {
            g709Attr.setOtnStatus(true);
            g709Attr.setFecMode(eDwdmFecMode.ENHANCED_FEC);
        }
        return g709Attr;
    }

    private TTI parseTTI(Element element) throws CLIParserError {
        TTI tTI = new TTI();
        NodeList nodeList = element.getElementsByTagName("OTUTxTTI");
        if (nodeList != null && nodeList.getLength() > 0 && (nodeList = ((Element)nodeList.item(0)).getElementsByTagName("AsciiString")) != null && nodeList.getLength() > 0) {
            tTI.setTx(((Element)nodeList.item(0)).getTextContent());
        }
        if ((nodeList = element.getElementsByTagName("OTUExpectedTTI")) != null && nodeList.getLength() > 0 && (nodeList = ((Element)nodeList.item(0)).getElementsByTagName("AsciiString")) != null && nodeList.getLength() > 0) {
            tTI.setExpected(((Element)nodeList.item(0)).getTextContent());
        }
        return tTI;
    }

    public static class ConnectionId
    extends CLIResponse {
        private String value = null;

        public String prettyString() {
            return this.value;
        }

        public boolean equals(Object object) {
            return object instanceof LmpId && ((ConnectionId)object).value == this.value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }

    public static class ControllerState
    extends CLIResponse {
        private StateEnum state = StateEnum.UNKNOWN;

        ControllerState() {
        }

        public StateEnum getState() {
            return this.state;
        }

        public void setState(StateEnum stateEnum) {
            this.state = stateEnum;
        }

        public String prettyString() {
            return this.state.prettyString();
        }
    }

    public static class DwdmWavelength
    extends CLIResponse {
        private int value = 174;
        private String label = Wavelength.getWavelengthStringFromWavelength(this.value);

        DwdmWavelength() {
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String string) {
            this.label = string;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }

        public boolean equals(Object object) {
            if (object instanceof DwdmWavelength) {
                DwdmWavelength dwdmWavelength = (DwdmWavelength)object;
                return dwdmWavelength.value == this.value;
            }
            return false;
        }

        public String prettyString() {
            return this.label;
        }
    }

    public static class G709Attr
    extends CLIResponse {
        private boolean otnStatus = false;
        private eDwdmFecMode fecMode = eDwdmFecMode.DISABLE_FEC;
        short sfBerLevel = (short)3;
        short sdBerLevel = (short)6;

        G709Attr() {
        }

        public eDwdmFecMode getFecMode() {
            return this.fecMode;
        }

        public void setFecMode(eDwdmFecMode eDwdmFecMode2) {
            this.fecMode = eDwdmFecMode2;
        }

        public boolean isOtnStatus() {
            return this.otnStatus;
        }

        public void setOtnStatus(boolean bl) {
            this.otnStatus = bl;
        }

        public short getSdBerLevel() {
            return this.sdBerLevel;
        }

        public void setSdBerLevel(short s) {
            this.sdBerLevel = s;
        }

        public short getSfBerLevel() {
            return this.sfBerLevel;
        }

        public void setSfBerLevel(short s) {
            this.sfBerLevel = s;
        }

        public boolean equals(Object object) {
            if (object instanceof G709Attr) {
                G709Attr g709Attr = (G709Attr)object;
                return g709Attr.isOtnStatus() == this.isOtnStatus() && g709Attr.getFecMode() == this.getFecMode() && g709Attr.getSdBerLevel() == this.getSdBerLevel() && g709Attr.getSfBerLevel() == this.getSfBerLevel();
            }
            return false;
        }

        public String prettyString() {
            return this.isOtnStatus() ? "OTN Enabled, FEC " + this.getFecMode().toString() + ", SD BER 1E-" + this.getSdBerLevel() + ", SF BER 1E-" + this.getSfBerLevel() : "OTN Disabled";
        }
    }

    public static class LmpId
    extends CLIResponse {
        private int value = 0;

        public String prettyString() {
            return String.valueOf(this.value);
        }

        public boolean equals(Object object) {
            return object instanceof LmpId && ((LmpId)object).value == this.value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }
    }

    public static class Response
    extends MultipleCLIResponse {
        private ControllerState state = new ControllerState();
        private DwdmWavelength wlen = new DwdmWavelength();
        private G709Attr g709Attr = new G709Attr();
        private TTI tti = new TTI();
        private LmpId lmpId = new LmpId();
        private ConnectionId connectionId = new ConnectionId();

        protected CLIResponse[] doGetResponses() {
            return new CLIResponse[]{this.state, this.wlen, this.g709Attr, this.tti, this.lmpId, this.connectionId};
        }

        protected void doUpdate(int n, CLIResponse cLIResponse) {
            switch (n) {
                case 0: {
                    this.state = (ControllerState)cLIResponse;
                    break;
                }
                case 1: {
                    this.wlen = (DwdmWavelength)cLIResponse;
                    break;
                }
                case 2: {
                    this.g709Attr = (G709Attr)cLIResponse;
                    break;
                }
                case 3: {
                    this.tti = (TTI)cLIResponse;
                    break;
                }
                case 4: {
                    this.lmpId = (LmpId)cLIResponse;
                    break;
                }
                case 5: {
                    this.connectionId = (ConnectionId)cLIResponse;
                }
            }
        }

        public G709Attr getG709Attr() {
            return this.g709Attr;
        }

        public void setG709Attr(G709Attr g709Attr) {
            this.g709Attr = g709Attr;
        }

        public ControllerState getState() {
            return this.state;
        }

        public void setState(ControllerState controllerState) {
            this.state = controllerState;
        }

        public DwdmWavelength getWlen() {
            return this.wlen;
        }

        public void setWlen(DwdmWavelength dwdmWavelength) {
            this.wlen = dwdmWavelength;
        }

        public TTI getTTI() {
            return this.tti;
        }

        public void setTTI(TTI tTI) {
            this.tti = tTI;
        }

        public LmpId getLmpId() {
            return this.lmpId;
        }

        public void setLmpId(LmpId lmpId) {
            this.lmpId = lmpId;
        }

        public ConnectionId getConnectionId() {
            return this.connectionId;
        }

        public void setConnectionId(ConnectionId connectionId) {
            this.connectionId = connectionId;
        }

        public String prettyString() {
            return "State=" + this.state.prettyString() + ", G709=" + this.g709Attr.prettyString() + ", Wavelength=" + this.wlen.prettyString() + ", TTI=" + this.tti.prettyString() + ", LMP ID=" + this.lmpId.prettyString() + ", CONNECTION ID=" + this.connectionId.prettyString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StateEnum {
        UNKNOWN(0, "unknown"),
        UP(1, "up"),
        ADMIN_DOWN(2, "admin-down");

        private int value;
        private String label;
        private int serviceState;
        private eAdminState adminState;

        private StateEnum(int n2, String string2) {
            this.value = n2;
            this.label = string2;
            this.adminState = this.toAdminState();
            this.serviceState = this.toServiceState();
        }

        public String getLabel() {
            return this.label;
        }

        public int getValue() {
            return this.value;
        }

        public eAdminState toAdminState() {
            switch (this.value) {
                case 1: {
                    return eAdminState.ADMIN_IS;
                }
                case 2: {
                    return eAdminState.ADMIN_OOS_DSBLD;
                }
            }
            return null;
        }

        public int toServiceState() {
            switch (this.value) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 2;
                }
            }
            return -1;
        }

        public int getAdminState() {
            return this.adminState.value();
        }

        public int getServiceStateType() {
            return this.serviceState;
        }

        public String adminStateString() {
            return AdminState.enumAdminStateToStr(this.adminState);
        }

        public String serviceStateString() {
            TDMTerminology tDMTerminology = TDMTerminology.getDefault();
            return tDMTerminology.getTermForServiceState(this.serviceState);
        }

        public String prettyString() {
            return "State=" + this.getLabel() + "(AdminState=" + this.adminStateString() + ", ServiceState=" + this.serviceStateString() + ")";
        }
    }

    public static class TTI
    extends CLIResponse {
        private String tx = null;
        private String expected = null;

        TTI() {
        }

        public String getTx() {
            return this.tx;
        }

        public void setTx(String string) {
            this.tx = string;
        }

        public String getExpected() {
            return this.expected;
        }

        public void setExpected(String string) {
            this.expected = string;
        }

        public String prettyString() {
            return "tx: " + this.tx + " - expected: " + this.expected;
        }
    }
}

