/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc454.ui.ms;

import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.ms.AbstractMsShelfLayout;
import cerent.cms.ui.ms.BayViewPanel;
import cerent.cms.ui.ms.MsCardPanel;
import cerent.cms.ui.ms.ShelfTransferHandler;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.util.gui.IconImpl;
import com.cisco.ctc454.ui.ms.MsCardFactory;
import com.cisco.ctc454.ui.ms.MsCardPainter;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MsShelfLayout
extends AbstractMsShelfLayout {
    private static final int SHELF_SLOT_COUNT = 17;
    private static final float FONT_TO_CARD_W_RATIO = 0.33333334f;
    private static final Font TEXT_FONT = new Font("Arial", 0, Math.round(4.0f));
    private static final Font labelFont = new Font("Arial", 0, 10);
    private JLabel idLbl;

    public MsShelfLayout(IChassisModel iChassisModel, AbstractViewController abstractViewController, BayViewPanel bayViewPanel) {
        super(iChassisModel, abstractViewController, bayViewPanel);
    }

    protected void refreshShelfColor() {
        this.setShelfColor(this.getState());
        this.labelsPanel.setBackground(this.currShelfColor);
        this.idLbl.setBackground(this.currShelfColor);
    }

    protected Font getTextFont() {
        return TEXT_FONT;
    }

    protected void createLabels() {
        if (this.labelsPanel == null) {
            this.labelsPanel = this.getInnerLabelPanel(new GridLayout(1, this.cards.length, 0, 0), this.chassis.getTDMTerminology());
            Dimension dimension = new Dimension(204, 10);
            this.labels = new JLabel[17];
            for (int i = 0; i < 17; ++i) {
                this.labels[i] = new JLabel("");
            }
            this.idLbl = new JLabel("Shelf " + this.chassis.getShelfId());
            this.idLbl.setFont(labelFont);
            this.idLbl.setPreferredSize(dimension);
            this.idLbl.setMinimumSize(dimension);
            this.idLbl.setHorizontalAlignment(0);
            this.labelsPanel.add(this.idLbl);
            this.refreshShelfColor();
        }
    }

    protected void createSlotsPanel() {
        this.slotsPanel = new JPanel(new FlowLayout(0, 0, 0));
        Dimension dimension = new Dimension(12, MsCardPainter.CARD_HEIGHT);
        ShelfTransferHandler shelfTransferHandler = new ShelfTransferHandler(this.chassis.getNodeModelDelegate().getChassisModelsInstance(), this.bvp.getRVP().getMVP());
        for (int i = 0; i < this.cards.length; ++i) {
            IconImpl iconImpl = new IconImpl(dimension);
            this.cards[i] = new MsCardPanel(iconImpl, this);
            this.cards[i].addMouseListener(this.mouseListener);
            this.cards[i].addMouseMotionListener(this.mouseListener);
            this.cards[i].setTransferHandler(shelfTransferHandler);
            this.slotsPanel.add(this.cards[i]);
        }
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.setTransferHandler(shelfTransferHandler);
    }

    protected CardGraphic createCard(EntityModel entityModel) {
        return MsCardFactory.createMsCard(entityModel, this);
    }

    public int getShelfSlotCount() {
        return 17;
    }
}

