/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.stm1e;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.sonet.HoPathPmThresholdsPane;
import cerent.cms.ui.sonet.SonetFEPmThresholdsPane;
import cerent.cms.ui.sonet.TdmSectionPmThresholdsPane;
import cerent.util.SDebug;
import com.cisco.ctc455.ui.stm1e.STM1E12MSPmThresholdsPane;
import com.cisco.ctc455.ui.stm1e.STM1E12PathPmThresholdsPane;
import com.cisco.ctc455.ui.stm1e.STM1E12RSPmThresholdsPane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public class STM1E12ThresholdProvPane
extends AbstractPane {
    protected TdmLineModel[] models;
    protected SonetThresholdButtonPanel buttonPanel = null;
    protected JPanel tablePanel = null;
    protected Pane[] panes = null;
    protected Pane currentPane = null;
    protected CardLayout cl = null;
    protected static final String FE_SEC_1DAY_PANEL = "FE_SEC_1DAY";
    protected static final String FE_SEC_15MIN_PANEL = "FE_SEC_15MIN";
    protected static final String FE_LIN_1DAY_PANEL = "FE_LIN_1DAY";
    protected static final String FE_LIN_15MIN_PANEL = "FE_LIN_15MIN";
    protected static final String NE_SEC_1DAY_PANEL = "NE_SEC_1DAY";
    protected static final String NE_SEC_15MIN_PANEL = "NE_SEC_15MIN";
    protected static final String NE_LIN_1DAY_PANEL = "NE_LIN_1DAY";
    protected static final String NE_LIN_15MIN_PANEL = "NE_LIN_15MIN";
    protected static final String NE_PATH_15MIN_PANEL = "NE_PATH_15MIN";
    protected static final String FE_PATH_15MIN_PANEL = "FE_PATH_15MIN";
    protected static final String NE_PATH_1DAY_PANEL = "NE_PATH_1DAY";
    protected static final String FE_PATH_1DAY_PANEL = "FE_PATH_1DAY";
    protected static final int NE_PATH_15MIN = 8;
    protected static final int FE_PATH_15MIN = 12;
    protected static final int NE_PATH_1DAY = 9;
    protected static final int FE_PATH_1DAY = 13;
    protected static final int FE_SEC_1DAY = 7;
    protected static final int FE_SEC_15MIN = 6;
    protected static final int FE_LIN_1DAY = 5;
    protected static final int FE_LIN_15MIN = 4;
    protected static final int NE_SEC_1DAY = 3;
    protected static final int NE_SEC_15MIN = 2;
    protected static final int NE_LIN_1DAY = 1;
    protected static final int NE_LIN_15MIN = 0;
    private JLabel tableLabel = new JLabel("TEST LABEL...");
    private String tableLabelString = new String();
    private JPanel labeledTablePanel = null;
    private boolean isSdh;
    private static final SDebug db = new SDebug("STM1E12ThresholdProvPane");

    public STM1E12ThresholdProvPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray) {
        super(string, tabbedView);
        this.models = tdmLineModelArray;
        this.panes = new Pane[14];
        this.isSdh = this.getUiModel().getNodeModel().getTdmProtocolTypeObj().isSdh();
        this.initializeTempPanes();
        this.initializeLayout();
        this.showPanel(this.panes[0]);
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
    }

    private void initializeTempPanes() {
        this.panes[7] = this.getSonetSectionPmThresholdsPane(FE_SEC_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false);
        this.panes[6] = this.getSonetSectionPmThresholdsPane(FE_SEC_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false);
        this.panes[4] = this.getSonetPmThresholdsPane(FE_LIN_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false);
        this.panes[5] = this.getSonetPmThresholdsPane(FE_LIN_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false);
        this.panes[3] = this.getSonetSectionPmThresholdsPane(NE_SEC_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true);
        this.panes[2] = this.getSonetSectionPmThresholdsPane(NE_SEC_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true);
        this.panes[0] = this.getSonetPmThresholdsPane(NE_LIN_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true);
        this.panes[1] = this.getSonetPmThresholdsPane(NE_LIN_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true);
        this.panes[8] = this.getSonetPathPmThresholdsPane(NE_PATH_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true);
        this.panes[12] = this.getSonetPathPmThresholdsPane(FE_PATH_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false);
        this.panes[9] = this.getSonetPathPmThresholdsPane(NE_PATH_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true);
        this.panes[13] = this.getSonetPathPmThresholdsPane(FE_PATH_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false);
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.getTablePanel(), "Center");
        this.add(this.getButtonPanel(), "South");
    }

    protected SonetThresholdButtonPanel getButtonPanel() {
        if (null == this.buttonPanel) {
            this.buttonPanel = new SonetThresholdButtonPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tablePanel = new JPanel();
        this.cl = new CardLayout();
        this.tablePanel.setLayout(this.cl);
        this.tablePanel.setPreferredSize(new Dimension(800, 300));
        jPanel.add((Component)this.tableLabel, "North");
        jPanel.add((Component)this.tablePanel, "Center");
        return jPanel;
    }

    protected STM1E12MSPmThresholdsPane getSonetPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        return new STM1E12MSPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
    }

    protected STM1E12RSPmThresholdsPane getSonetSectionPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        return new STM1E12RSPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
    }

    protected STM1E12PathPmThresholdsPane getSonetPathPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        return new STM1E12PathPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl, 1);
    }

    protected void showPanel(Pane pane) {
        block5: {
            try {
                if (this.currentPane != null) {
                    TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
                    this.currentPane.leavingPage();
                    this.tablePanel.remove((Component)this.currentPane);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("Error in leaving page");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        try {
            pane.enteringPage();
            TablePropertyMgr.getColumnPrefs(pane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + pane.getName());
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        this.currentPane = pane;
        this.tablePanel.add((Component)this.currentPane, pane.getName());
        this.cl.show(this.tablePanel, pane.getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
        if (this.currentPane != null) {
            this.currentPane.leavingPage();
        }
    }

    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
        }
        this.getButtonPanel().refreshAction();
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
    }

    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    public void destroy() {
        for (int i = 0; i < this.panes.length; ++i) {
            if (this.panes[i] == null) continue;
            TablePropertyMgr.setColumnPrefs(this.panes[i].getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.panes[i].getName());
            if (this.panes[i] instanceof HoPathPmThresholdsPane) {
                ((HoPathPmThresholdsPane)this.panes[i]).dispose();
            } else if (this.panes[i] instanceof SonetFEPmThresholdsPane) {
                ((SonetFEPmThresholdsPane)this.panes[i]).dispose();
            } else if (this.panes[i] instanceof TdmSectionPmThresholdsPane) {
                ((TdmSectionPmThresholdsPane)this.panes[i]).dispose();
            }
            this.panes[i].destroy();
            this.panes[i] = null;
        }
        this.cl = null;
        this.buttonPanel = null;
        super.destroy();
    }

    protected boolean supportsFELine() {
        return true;
    }

    protected boolean supportsFEPath() {
        return false;
    }

    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    protected class SonetThresholdButtonPanel
    extends JPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JRadioButton buttonNE;
        public JRadioButton buttonFE;
        public JRadioButton buttonSection;
        public JRadioButton buttonLine;
        public JRadioButton buttonPath;
        public JButton showButton = new JButton("Refresh");
        public ButtonGroup periodButtonGroup;
        public ButtonGroup endButtonGroup;
        public ButtonGroup secLineButtonGroup;
        protected int PATH_MASK = 8;
        protected int FE_MASK = 4;
        protected int SEC_MASK = 2;
        protected int ONE_DAY_MASK = 1;

        public SonetThresholdButtonPanel() {
            this.initialize();
        }

        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.buttonNE = new JRadioButton("Near End", true);
            this.buttonFE = new JRadioButton("Far End");
            this.buttonSection = new JRadioButton(STM1E12ThresholdProvPane.this.isSdh ? "Regeneration Section" : "Section");
            this.buttonLine = new JRadioButton(STM1E12ThresholdProvPane.this.isSdh ? "Multiplex Section" : "Line", true);
            this.buttonPath = new JRadioButton("Path");
            this.secLineButtonGroup = new ButtonGroup();
            this.secLineButtonGroup.add(this.buttonSection);
            this.secLineButtonGroup.add(this.buttonLine);
            this.secLineButtonGroup.add(this.buttonPath);
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.endButtonGroup = new ButtonGroup();
            this.endButtonGroup.add(this.buttonNE);
            this.endButtonGroup.add(this.buttonFE);
            this.showButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SonetThresholdButtonPanel.this.refreshAction();
                }
            });
            this.initButtonListeners();
            Dimension dimension = new Dimension(90, 70);
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder(" Directions "));
            jPanel.setPreferredSize(dimension);
            jPanel.add(this.buttonNE);
            jPanel.add(this.buttonFE);
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel2.setBorder(BorderFactory.createTitledBorder(" Intervals "));
            jPanel2.setPreferredSize(dimension);
            jPanel2.add(this.button15Min);
            jPanel2.add(this.button1Day);
            JPanel jPanel3 = new JPanel(new GridLayout(2, 2, 0, 0));
            jPanel3.setBorder(BorderFactory.createTitledBorder(" Types "));
            if (STM1E12ThresholdProvPane.this.isSdh) {
                jPanel3.setPreferredSize(new Dimension(dimension.width * 4, dimension.height));
            } else {
                jPanel3.setPreferredSize(new Dimension(dimension.width * 2, dimension.height));
            }
            jPanel3.add(this.buttonLine);
            jPanel3.add(this.buttonPath);
            jPanel3.add(this.buttonSection);
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(jPanel2);
            this.add(jPanel3);
            this.add(this.showButton);
            this.setPreferredSize(new Dimension(800, 75));
        }

        protected void initButtonListeners() {
            this.buttonFE.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (((JRadioButton)itemEvent.getSource()).isSelected()) {
                        if (STM1E12ThresholdProvPane.this.supportsFELine()) {
                            if (!SonetThresholdButtonPanel.this.buttonLine.isSelected()) {
                                SonetThresholdButtonPanel.this.buttonLine.setSelected(true);
                            }
                        } else {
                            SonetThresholdButtonPanel.this.buttonLine.setEnabled(false);
                        }
                        if (STM1E12ThresholdProvPane.this.supportsFEPath()) {
                            if (!SonetThresholdButtonPanel.this.buttonPath.isSelected()) {
                                SonetThresholdButtonPanel.this.buttonPath.setSelected(true);
                            }
                        } else {
                            SonetThresholdButtonPanel.this.buttonPath.setEnabled(false);
                        }
                        SonetThresholdButtonPanel.this.buttonSection.setEnabled(false);
                    } else {
                        if (!SonetThresholdButtonPanel.this.buttonLine.isEnabled()) {
                            SonetThresholdButtonPanel.this.buttonLine.setEnabled(true);
                        }
                        if (!SonetThresholdButtonPanel.this.buttonSection.isEnabled()) {
                            SonetThresholdButtonPanel.this.buttonSection.setEnabled(true);
                        }
                        if (!SonetThresholdButtonPanel.this.buttonPath.isEnabled()) {
                            SonetThresholdButtonPanel.this.buttonPath.setEnabled(true);
                        }
                    }
                }
            });
        }

        public void refreshAction() {
            int n = 0;
            STM1E12ThresholdProvPane.this.tableLabelString = " ";
            if (this.endButtonGroup.getSelection() == this.buttonFE.getModel()) {
                if (db.on()) {
                    db.println("FE");
                }
                n |= this.FE_MASK;
                STM1E12ThresholdProvPane.this.tableLabelString = STM1E12ThresholdProvPane.this.tableLabelString + "Far End";
            } else {
                STM1E12ThresholdProvPane.this.tableLabelString = STM1E12ThresholdProvPane.this.tableLabelString + "Near End";
            }
            if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                if (db.on()) {
                    db.println("1 Day");
                }
                n |= this.ONE_DAY_MASK;
                STM1E12ThresholdProvPane.this.tableLabelString = STM1E12ThresholdProvPane.this.tableLabelString + ", 1 Day";
            } else {
                STM1E12ThresholdProvPane.this.tableLabelString = STM1E12ThresholdProvPane.this.tableLabelString + ", 15 Min";
            }
            if (this.secLineButtonGroup.getSelection() == this.buttonSection.getModel()) {
                STM1E12ThresholdProvPane.this.tableLabelString = STM1E12ThresholdProvPane.this.tableLabelString + ", Regeneration Section";
            } else if (this.secLineButtonGroup.getSelection() == this.buttonPath.getModel()) {
                STM1E12ThresholdProvPane.this.tableLabelString = STM1E12ThresholdProvPane.this.tableLabelString + ", Path";
            } else {
                STM1E12ThresholdProvPane.this.tableLabelString = STM1E12ThresholdProvPane.this.tableLabelString + ", Multiplex Section";
            }
            if (this.secLineButtonGroup.getSelection() == this.buttonSection.getModel()) {
                if (db.on()) {
                    db.println("Section pressed");
                }
                n |= this.SEC_MASK;
            }
            if (this.secLineButtonGroup.getSelection() == this.buttonPath.getModel()) {
                if (db.on()) {
                    db.println("Path pressed");
                }
                n |= this.PATH_MASK;
            }
            switch (n) {
                case 7: {
                    if (db.on()) {
                        db.println("FE SEC 1DAY");
                    }
                    STM1E12ThresholdProvPane.this.showPanel(STM1E12ThresholdProvPane.this.panes[7]);
                    break;
                }
                case 6: {
                    if (db.on()) {
                        db.println("FE SEC 15MIN");
                    }
                    STM1E12ThresholdProvPane.this.showPanel(STM1E12ThresholdProvPane.this.panes[6]);
                    break;
                }
                case 5: {
                    if (db.on()) {
                        db.println("FE LIN 1DAY");
                    }
                    STM1E12ThresholdProvPane.this.showPanel(STM1E12ThresholdProvPane.this.panes[5]);
                    break;
                }
                case 4: {
                    if (db.on()) {
                        db.println("FE LIN 15MIN");
                    }
                    STM1E12ThresholdProvPane.this.showPanel(STM1E12ThresholdProvPane.this.panes[4]);
                    break;
                }
                case 3: {
                    if (db.on()) {
                        db.println("NE SEC 1DAY");
                    }
                    STM1E12ThresholdProvPane.this.showPanel(STM1E12ThresholdProvPane.this.panes[3]);
                    break;
                }
                case 2: {
                    if (db.on()) {
                        db.println("NE SEC 15MIN");
                    }
                    STM1E12ThresholdProvPane.this.showPanel(STM1E12ThresholdProvPane.this.panes[2]);
                    break;
                }
                case 1: {
                    if (db.on()) {
                        db.println("NE LIN 1 Day");
                    }
                    STM1E12ThresholdProvPane.this.showPanel(STM1E12ThresholdProvPane.this.panes[1]);
                    break;
                }
                case 0: {
                    if (db.on()) {
                        db.println("NE LIN 15MIN");
                    }
                    STM1E12ThresholdProvPane.this.showPanel(STM1E12ThresholdProvPane.this.panes[0]);
                    break;
                }
                case 8: {
                    if (db.on()) {
                        db.println("NE PATH 15MIN");
                    }
                    STM1E12ThresholdProvPane.this.showPanel(STM1E12ThresholdProvPane.this.panes[8]);
                    break;
                }
                case 12: {
                    if (db.on()) {
                        db.println("FE PATH 15MIN");
                    }
                    STM1E12ThresholdProvPane.this.showPanel(STM1E12ThresholdProvPane.this.panes[12]);
                    break;
                }
                case 9: {
                    if (db.on()) {
                        db.println("NE PATH 1DAY");
                    }
                    STM1E12ThresholdProvPane.this.showPanel(STM1E12ThresholdProvPane.this.panes[9]);
                    break;
                }
                case 13: {
                    if (db.on()) {
                        db.println("FE PATH 1DAY");
                    }
                    STM1E12ThresholdProvPane.this.showPanel(STM1E12ThresholdProvPane.this.panes[13]);
                }
            }
            STM1E12ThresholdProvPane.this.tableLabel.setText(STM1E12ThresholdProvPane.this.tableLabelString);
        }
    }
}

