/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AdminState;
import cerent.cms.model.AsapEtherLineModel;
import cerent.cms.model.AsapModuleModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.EtherLineUpdate;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.AnnotatedException;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import com.cisco.ctc600.ui.asap.AsapEtherLineMaintTableModel;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AsapEtherLineMaintPane
extends NodeProvPane
implements TableModelListener {
    private AsapEtherLineMaintTableModel dataModel = null;
    private AsapEtherLineModel[] etherLineModels = null;
    private ObservableManager obsMgr = null;
    private static final SDebug db = new SDebug("AsapEtherLineMaintPane");

    public AsapEtherLineMaintPane(String string, TabbedView tabbedView, AsapEtherLineModel[] asapEtherLineModelArray) {
        super(string, tabbedView);
        this.etherLineModels = asapEtherLineModelArray;
        this.dataModel = new AsapEtherLineMaintTableModel((AsapModuleModel)this.getUiModel(), asapEtherLineModelArray);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.add((Component)uScrollPane);
        this.customizedProvPane();
        this.table.sizeColumnsToFit(-1);
        this.registerWithModel();
    }

    private void customizedProvPane() {
        TableColumn tableColumn = null;
        Attribute[] attributeArray = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[0]);
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(5);
        this.setCellEditorAdminState();
        tableColumn = this.table.getColumn(this.dataModel.columnNames[3]);
        attributeArray = this.dataModel.getLoopbackAttrs();
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
        tableColumn.sizeWidthToFit();
    }

    protected void setCellEditorAdminState() {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[1]);
        boolean bl = this.uiModel.getNodeModel().getTdmProtocolTypeObj().isSonet();
        AdminState[] adminStateArray = AdminState.getDefaultAdminStates(bl);
        JComboBox<AdminState> jComboBox = new JComboBox<AdminState>(adminStateArray);
        jComboBox.setEditable(false);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn.sizeWidthToFit();
        tableColumn.setPreferredWidth(tableColumn.getWidth());
    }

    private JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected void registerWithModel() {
        super.registerWithModel();
        this.getObsMgr().setObservable((Observable[])this.etherLineModels);
    }

    protected ObservableManager getObsMgr() {
        if (this.obsMgr == null) {
            this.obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this.obsMgr;
    }

    public void changeMessage(Observable observable, Object object) {
        db.fine("Got an Update Message for " + observable);
        if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                AsapEtherLineMaintPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.etherLineModels).indexOf(observable);
        if (n != -1) {
            db.fine("Refreshing Line " + n);
            this.dataModel.refreshLineFromModel(n);
        } else {
            db.fine("Change message cannot find Model " + observable);
        }
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof EtherLineUpdate) {
            this.etherLineModels = (AsapEtherLineModel[])((EtherLineUpdate)object).getEtherLineModels();
            this.getObsMgr().setObservable((Observable[])this.etherLineModels);
            db.fine("Refreshing lines, ethernet lines= " + this.etherLineModels.length);
            this.dataModel.refreshMyLines(this.etherLineModels);
        } else if (db.on()) {
            db.println("refreshMyLines received " + object);
        }
    }

    public void dispose() {
        if (this.obsMgr != null) {
            this.obsMgr.removeObservable((Observable[])this.etherLineModels);
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.dispose();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.etherLineModels.length == 0) {
            return;
        }
        int n = tableModelEvent.getLastRow() > this.etherLineModels.length ? this.etherLineModels.length - 1 : tableModelEvent.getLastRow();
        for (int i = tableModelEvent.getFirstRow(); i <= n; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws AnnotatedException {
        try {
            if (!this.verifyApplyChangesToModel()) {
                return;
            }
            this.dataModel.applyToModel();
            this.setDirty(false);
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes. ", exception);
        }
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        this.getObsMgr().setPassing(true);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    private boolean verifyApplyChangesToModel() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = true;
        if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.etherLineModels)) {
            stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            String string = AdminState.getSevWarningMsg(this.dataModel, this.etherLineModels, false, true);
            stringBuffer.append(string).append("\n");
        }
        for (int i = 0; !bl && i < this.etherLineModels.length; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            eLoopback eLoopback2 = this.dataModel.getOldLoopback(i);
            eLoopback eLoopback3 = this.dataModel.getNewLoopback(i);
            if (eLoopback3 != eLoopback.LINE_LOOPBACK && eLoopback3 != eLoopback.INWARD_LOOPBACK || eLoopback2 != eLoopback.NO_LOOPBACK) continue;
            bl = true;
            stringBuffer.append("Some lines are being placed in Loopback.").append('\n');
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(this.getApplyString());
            bl2 = CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog");
        }
        return bl2;
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.AsapEtherLineMaintPane;
    }
}

