/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelTimeBasedAttributeCache;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.util.HashMap;

public class ModelAttributeCacheManager {
    private static final Preferences prefs = Preferences.instance();
    private static final int ATTR_TIMEOUT = 1000 * prefs.getInt("ctc", "modelattrcache.timeout", 60);
    private static final Network net = Network.instance();
    private static final ModelAttributeCacheManager instance = new ModelAttributeCacheManager();
    public static final int ENTITY_NET_OR_CKT_DISPLAY_USE_CASE = 0;
    public static final String ENTITY_NET_OR_CKT_DISPLAY_USE_CASE_DBG = "EntityDisplayCache";
    private HashMap<Integer, ModelTimeBasedAttributeCache> caches = new HashMap();
    private static Debug db = null;

    public static ModelAttributeCacheManager instance() {
        return instance;
    }

    public static void invalidateAll(INodeModel iNodeModel) {
        for (ModelTimeBasedAttributeCache modelTimeBasedAttributeCache : ModelAttributeCacheManager.instance.caches.values()) {
            modelTimeBasedAttributeCache.invalidate(iNodeModel);
        }
    }

    private ModelAttributeCacheManager() {
    }

    public void registerCache(int n, ModelTimeBasedAttributeCache modelTimeBasedAttributeCache) {
        this.caches.put(n, modelTimeBasedAttributeCache);
    }

    public ModelTimeBasedAttributeCache lookupCache(int n) {
        ModelTimeBasedAttributeCache modelTimeBasedAttributeCache = this.caches.get(n);
        return modelTimeBasedAttributeCache;
    }

    public ModelTimeBasedAttributeCache unregisterCache(int n) {
        return this.caches.remove(n);
    }

    static {
        ModelTimeBasedAttributeCache modelTimeBasedAttributeCache = new ModelTimeBasedAttributeCache(ATTR_TIMEOUT);
        instance.registerCache(0, modelTimeBasedAttributeCache);
        modelTimeBasedAttributeCache.setName(ENTITY_NET_OR_CKT_DISPLAY_USE_CASE_DBG);
        modelTimeBasedAttributeCache.setDebug(new SDebug(ENTITY_NET_OR_CKT_DISPLAY_USE_CASE_DBG));
        db = new Debug("ModelAttributeCacheManager");
    }

    public static class Debug
    extends SDebug {
        public Debug(String string) {
            super(string);
        }

        public final void dumpDiag() {
            for (ModelTimeBasedAttributeCache modelTimeBasedAttributeCache : instance.caches.values()) {
                modelTimeBasedAttributeCache.getDebug().println(modelTimeBasedAttributeCache.getName());
                modelTimeBasedAttributeCache.dump();
            }
        }

        public final void names() {
            this.println(Integer.toString(instance.caches.size()) + " names");
            for (ModelTimeBasedAttributeCache modelTimeBasedAttributeCache : instance.caches.values()) {
                String string;
                KDebug kDebug = modelTimeBasedAttributeCache.getDebug();
                String string2 = string = kDebug == null ? "" : kDebug.toString();
                if (string.startsWith("*")) {
                    string = string.substring(1);
                }
                this.println("  " + string);
            }
        }

        public final void invalidateNode(String string, int n) {
            for (ModelTimeBasedAttributeCache modelTimeBasedAttributeCache : instance.caches.values()) {
                INetElement iNetElement;
                KDebug kDebug = modelTimeBasedAttributeCache.getDebug();
                String string2 = kDebug == null ? null : kDebug.toString();
                if (string2 == null || !string2.endsWith(string) || (iNetElement = net.findNetElem(n)) == null) continue;
                modelTimeBasedAttributeCache.invalidate(iNetElement.getNodeModel());
            }
        }

        public final void clearAll() {
            for (ModelTimeBasedAttributeCache modelTimeBasedAttributeCache : instance.caches.values()) {
                modelTimeBasedAttributeCache.clear();
            }
        }
    }
}

