/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.CTCUserException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.IChassisModelUpdate;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdate;
import cerent.cms.model.ModelUpdateType;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

public class ModelObserver
extends CmsObservable
implements Observer {
    private static ModelSingletonCollection modelObservers;
    private INodeModel nmd;
    private SDebug db;

    public static synchronized ModelObserver getInstance(INodeModel iNodeModel) throws CTCUserException {
        ModelObserver modelObserver;
        if (modelObservers == null) {
            modelObservers = ModelSingletonCollection.getMSCInstanceByName((String)"ModelObserver");
        }
        if ((modelObserver = (ModelObserver)modelObservers.get((Object)iNodeModel)) == null) {
            modelObserver = new ModelObserver(iNodeModel);
            modelObservers.add((Object)iNodeModel, (Object)modelObserver);
        }
        return modelObserver;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!(observable instanceof Model)) {
            this.db.severe("ERROR: Expected a Model as Observable");
            return;
        }
        if (object instanceof Integer) {
            int n = -1;
            if (observable instanceof Model) {
                n = ((Model)((Object)observable)).getIndex();
            }
            if (object == ModelUpdateType.DELETED) {
                this.unregister((Model)((Object)observable));
            }
            if (this.db.on()) {
                this.db.fine("Received an update From=" + observable.getClass().getName() + ", Type=" + (Integer)object + ", Index=" + n);
            }
            this.setChanged();
            this.notifyObservers(new ModelUpdate((IModel)((Model)((Object)observable)), (Integer)object));
            this.clearChanged();
        } else if (object instanceof Collection) {
            if (this.db.on()) {
                this.db.info("Received a collection update From=" + observable + ", Type= " + object.getClass().getName());
                SDebug.printStackTrace((Throwable)new Exception("Collection update in ModelObserver!"));
            }
        } else if (object instanceof IChassisModelUpdate) {
            int n = ((IChassisModelUpdate)object).getUpdateType();
            if (n == 2) {
                int n2 = ((Model)((Object)observable)).getIndex();
                if (this.db.on()) {
                    this.db.fine("Received an update From=" + observable.getClass().getName() + ", Type=" + 2 + ", Index=" + n2);
                }
                this.setChanged();
                this.notifyObservers(new ModelUpdate((IModel)((Model)((Object)observable)), ModelUpdateType.ADDED));
                this.clearChanged();
            } else {
                this.db.info("ERROR: Received an update From=" + observable + ", Type= UNKNOWN " + object);
            }
        } else {
            this.db.info("ERROR: Received an update From=" + observable + ", Type= UNKNOWN " + object);
        }
    }

    public void modelGettingInited(Model model) {
        this.register(model);
    }

    private void register(Model model) {
        model.addObserver(this);
    }

    private void unregister(Model model) {
        model.deleteObserver(this);
    }

    private ModelObserver(INodeModel iNodeModel) throws CTCUserException {
        if (iNodeModel == null) {
            throw new CTCUserException("The INodeModel is null.");
        }
        this.nmd = iNodeModel;
        this.db = ((Model)iNodeModel).getDebug().getChildDebug("ModelObserver");
    }
}

