/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.blsr;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.ElementModels;
import cerent.cms.model.Feature;
import cerent.cms.model.IBlsrModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.blsr.BlsrRingInfo;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.model.blsr.BlsrSpan;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.util.UObservable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

public class BlsrRingManager {
    private static BlsrRingManager blsrRingManager;
    private List wizardNodes = Collections.synchronizedList(new ArrayList());
    private Set stitchedNodes = Collections.synchronizedSet(new HashSet());
    private Map clairvoyantSpanMap = Collections.synchronizedMap(new HashMap());
    private BlsrCreationObserver createObserver;
    private BlsrRingStateChangeObserver stateChangeObserver;
    private NetElementCreationObserver netElementCreationObserver;
    private NetElementChangeObserver netElementChangeObserver;
    private NetLinkObserver netLinkObserver;
    private BlsrRingCreationNotifier creationNotifier = new BlsrRingCreationNotifier();
    private Set rings = Collections.synchronizedSet(new HashSet());
    private Map sameIdRingMap = Collections.synchronizedMap(new HashMap());
    private Set zombieNodes = Collections.synchronizedSet(new HashSet());
    private Network network;
    private static final String className = "BlsrRingManager";
    private static SDebug db;

    private BlsrRingManager() {
        int n;
        this.createObserver = new BlsrCreationObserver();
        this.stateChangeObserver = new BlsrRingStateChangeObserver();
        this.netElementCreationObserver = new NetElementCreationObserver();
        this.netElementChangeObserver = new NetElementChangeObserver();
        this.netLinkObserver = new NetLinkObserver();
        this.network = Network.instance();
        UObservable.addObserver((Object)((Object)this.network.getNetElementCreationNotifier()), (Object)this.netElementCreationObserver, (String)className);
        UObservable.addObserver((Object)((Object)this.network.getNetLinkCreationNotifier()), (Object)this.netLinkObserver, (String)className);
        NetElement[] netElementArray = this.network.getElements().toArray(new NetElement[0]);
        INetLink[] iNetLinkArray = this.network.getNetLinks().toArray(new INetLink[0]);
        this.wizardNodes.addAll(this.nodesWithFeature(Arrays.asList(netElementArray), Feature.NET_BLSR_WIZ));
        for (n = 0; n < netElementArray.length; ++n) {
            db.fine("[Constructor] " + netElementArray[n].getName() + ".getConnectionState() = " + netElementArray[n].getConnectionState());
            UObservable.addObserver((Object)netElementArray[n], (Object)this.netElementChangeObserver, (String)className);
        }
        for (n = 0; n < iNetLinkArray.length; ++n) {
            INetLink iNetLink = iNetLinkArray[n];
            if (iNetLink.inBLSR() && iNetLink.isSdccLink() && this.network.findReverseLink(iNetLink) != null) {
                db.finest("[Constructor] addObserver for NetLink" + iNetLink);
                UObservable.addObserver((Object)iNetLink, (Object)this.netLinkObserver, (String)className);
                continue;
            }
            db.finest("[Constructor] FYI, the " + iNetLink + " is NOT being Observed!!!");
        }
        this.registerForBlsrEvents(this.wizardNodes);
        this.stitchNodes(this.wizardNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BlsrRingManager instance() {
        if (blsrRingManager != null) return blsrRingManager;
        Class<BlsrRingManager> clazz = BlsrRingManager.class;
        synchronized (BlsrRingManager.class) {
            blsrRingManager = new BlsrRingManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return blsrRingManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized void remove() {
        if (blsrRingManager != null) {
            Class<BlsrRingManager> clazz = BlsrRingManager.class;
            // MONITORENTER : cerent.cms.model.blsr.BlsrRingManager.class
            this.cleanup();
            // MONITOREXIT : clazz
        }
        blsrRingManager = null;
    }

    private synchronized void cleanup() {
        int n;
        UObservable.deleteObserver((Object)((Object)this.network.getNetElementCreationNotifier()), (Object)this.netElementCreationObserver, (String)className);
        UObservable.deleteObserver((Object)((Object)this.network.getNetLinkCreationNotifier()), (Object)this.netLinkObserver, (String)className);
        NetElement[] netElementArray = this.network.getElements().toArray(new NetElement[0]);
        INetLink[] iNetLinkArray = this.network.getNetLinks().toArray(new INetLink[0]);
        for (n = 0; n < netElementArray.length; ++n) {
            db.finest("[Cleanup] " + netElementArray[n].getName() + ".getConnectionState() = " + netElementArray[n].getConnectionState());
            UObservable.deleteObserver((Object)netElementArray[n], (Object)this.netElementChangeObserver, (String)className);
        }
        for (n = 0; n < iNetLinkArray.length; ++n) {
            INetLink iNetLink = iNetLinkArray[n];
            if (!iNetLink.isSdccLink() || !iNetLink.inBLSR() || this.network.findReverseLink(iNetLink) == null) continue;
            UObservable.deleteObserver((Object)iNetLink, (Object)this.netLinkObserver, (String)className);
        }
        this.unregisterForBlsrEvents(this.wizardNodes);
        this.rings.clear();
        this.wizardNodes.clear();
        this.stitchedNodes.clear();
        this.createObserver = null;
        this.stateChangeObserver = null;
        this.netElementCreationObserver = null;
        this.netElementChangeObserver = null;
        this.netLinkObserver = null;
        this.network = null;
    }

    public BlsrRingModel createBlsrRingModel(BlsrRingInfo blsrRingInfo) {
        return this.createBlsrRingModel(blsrRingInfo, null);
    }

    public BlsrRingModel createBlsrRingModel(BlsrRingInfo blsrRingInfo, List list) {
        return this.createBlsrRingModel(blsrRingInfo, list, 5);
    }

    public BlsrRingModel createBlsrRingModelForUpsr2BlsrConversion(BlsrRingInfo blsrRingInfo) {
        return this.createBlsrRingModel(blsrRingInfo, null, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlsrRingModel createBlsrRingModel(BlsrRingInfo blsrRingInfo, List list, int n) {
        BlsrRingModel blsrRingModel = new BlsrRingModel(blsrRingInfo, list, n);
        if (n == 2) {
            BlsrRingManager blsrRingManager = this;
            synchronized (blsrRingManager) {
                this.rings.add(blsrRingModel);
                HashSet<BlsrRingModel> hashSet = this.getBlsrRingModel(blsrRingInfo.getRingName());
                if (hashSet == null || hashSet.size() < 1) {
                    hashSet = new HashSet<BlsrRingModel>();
                }
                hashSet.add(blsrRingModel);
                this.sameIdRingMap.put(blsrRingInfo.getRingName(), hashSet);
                this.sameIdRingMap.put(new Integer(blsrRingInfo.getRingId()), hashSet);
                UObservable.addObserver((Object)blsrRingModel.getStateChangeNotifier(), (Object)this.stateChangeObserver, (String)className);
                db.fine("[createBlsrRingModel] sameIdRings: mapping " + blsrRingInfo.getRingName() + " and " + blsrRingInfo.getRingId());
                db.fine("[createBlsrRingModel] sameIdRings: " + hashSet);
            }
            this.creationNotifier.notifyObservers(blsrRingModel);
        }
        db.fine("[createBlsrRingModel] BlsrRingModel created - Ring ID: " + blsrRingInfo.getRingName());
        return blsrRingModel;
    }

    public Set getBlsrRingModel(Object object) {
        HashSet hashSet = (HashSet)this.sameIdRingMap.get(object);
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        return new HashSet(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlsrRingModel[] getBlsrRingModels(INodeModel iNodeModel) {
        ArrayList<BlsrRingModel> arrayList = new ArrayList<BlsrRingModel>();
        BlsrRingModel blsrRingModel2 = null;
        Set set = this.rings;
        synchronized (set) {
            for (BlsrRingModel blsrRingModel2 : new HashSet(this.rings)) {
                if (!blsrRingModel2.containsNodeModel(iNodeModel)) continue;
                arrayList.add(blsrRingModel2);
            }
        }
        return arrayList.toArray(new BlsrRingModel[0]);
    }

    public BlsrRingModel getBlsrRingModel(NodeModel nodeModel, Object object) {
        BlsrRingModel[] blsrRingModelArray = this.getBlsrRingModels(nodeModel);
        BlsrRingModel blsrRingModel = null;
        for (int i = 0; i < blsrRingModelArray.length; ++i) {
            if (!((String)object).equalsIgnoreCase(blsrRingModelArray[i].getRingName()) && !object.equals(new Integer(blsrRingModelArray[i].getRingId()))) continue;
            blsrRingModel = blsrRingModelArray[i];
            break;
        }
        return blsrRingModel;
    }

    public Set getBlsrRingModels() {
        return new HashSet(this.rings);
    }

    public int get4FBlsrCount(BlsrRingModel blsrRingModel) {
        HashSet<NodeModel> hashSet = new HashSet<NodeModel>();
        BlsrNode[] blsrNodeArray = blsrRingModel.getBlsrNodes();
        for (int i = 0; i < blsrNodeArray.length; ++i) {
            hashSet.add(blsrNodeArray[i].getNodeModel());
        }
        return this.get4FBlsrCount(hashSet);
    }

    public int get4FBlsrCount(Set set) {
        int n = 0;
        HashSet<BlsrRingModel> hashSet = new HashSet<BlsrRingModel>();
        for (NodeModel model : set) {
            hashSet.addAll(Arrays.asList(this.getBlsrRingModels(model)));
        }
        for (BlsrRingModel blsrRingModel : hashSet) {
            if (!blsrRingModel.getBlsrRingInfo().isFourFiber()) continue;
            ++n;
        }
        return n;
    }

    public BlsrRingCreationNotifier getBlsrCreationNotifier() {
        return this.creationNotifier;
    }

    public void queueForRemoval(BlsrNode blsrNode) {
        BlsrRingModel blsrRingModel = this.getBlsrRingModel(blsrNode.getNodeModel(), blsrNode.getBlsrRingInfo().getRingName());
        if (blsrRingModel != null) {
            this.removeZombie(blsrRingModel.getBlsrNode(blsrNode.getNodeModel()));
        } else {
            this.zombieNodes.add(blsrNode);
            db.fine("[queueForRemoval] " + blsrNode + " doesn't have a ring associated with it just yet.  We'll wait.");
        }
    }

    private void removeZombie(BlsrNode blsrNode) {
        try {
            blsrNode.delete();
            db.fine("[removeZombie]" + blsrNode + ": removed because it was a zombie.");
            this.zombieNodes.remove(blsrNode);
        }
        catch (Busy busy) {
            db.fine("[removeZombie] Couldn't remove " + blsrNode + " from the list of offending " + "BlsrNodes. " + (Object)((Object)busy));
        }
        catch (IllegalStateException illegalStateException) {
            db.fine("removeZombie] " + blsrNode + " is NOT provisioned!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stitchNodes(List list) {
        List list2 = list;
        synchronized (list2) {
            Iterator iterator = list.iterator();
            NetElement netElement = null;
            while (iterator.hasNext()) {
                netElement = (NetElement)iterator.next();
                this.stitchNode(netElement);
            }
        }
    }

    private void stitchNode(NetElement netElement) {
        this.stitchNode(netElement.getNodeModel());
    }

    private void stitchNode(INodeModel iNodeModel) {
        if (iNodeModel == null) {
            return;
        }
        if (!iNodeModel.isInited()) {
            return;
        }
        if (this.stitchedNodes.contains(iNodeModel)) {
            return;
        }
        Set set = iNodeModel.getIElementModels().getBlsrElements();
        Iterator iterator = set.iterator();
        db.fine("[stitchNode] " + iNodeModel.getName() + " has " + set.size() + " BlsrModels that need to be stitched.");
        int n = 0;
        while (iterator.hasNext()) {
            IBlsrModel iBlsrModel = (IBlsrModel)iterator.next();
            db.finest("aBlsrModel is: " + iBlsrModel);
            this.stitchBlsrModel(iBlsrModel, iNodeModel);
            ++n;
        }
        if (n > 0) {
            db.fine("[stitchNode] " + iNodeModel.getName() + " added to set of stitched nodes");
            this.stitchedNodes.add(iNodeModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerForBlsrEvents(List list) {
        List list2 = list;
        synchronized (list2) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.registerForBlsrEvents((NetElement)iterator.next());
            }
        }
    }

    private void registerForBlsrEvents(NetElement netElement) {
        ElementModels elementModels = (ElementModels)netElement.getNodeModel().getIElementModels();
        UObservable.addObserver((Object)elementModels.getCreationBlsrNotifier(), (Object)this.createObserver, (String)className);
        UObservable.addObserver((Object)elementModels, (Object)this.createObserver, (String)className);
        db.fine("[registerForBlsrEvents] Added BlsrModel creation observer for node " + netElement.getNodeModel().getName());
    }

    public synchronized void registerBlsrNetLink(INetLink iNetLink) {
        if (iNetLink.isSdccLink() && this.network.findReverseLink(iNetLink) != null) {
            db.fine("[registerNetLink] addObserver for NetLink" + iNetLink);
            UObservable.addObserver((Object)iNetLink, (Object)this.netLinkObserver, (String)className);
        } else {
            db.fine("[registerNetLink] FYI, the " + iNetLink + " is NOT being Observed!!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterForBlsrEvents(List list) {
        List list2 = list;
        synchronized (list2) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.unregisterForBlsrEvents((NetElement)iterator.next());
            }
        }
    }

    private void unregisterForBlsrEvents(NetElement netElement) {
        ElementModels elementModels = (ElementModels)netElement.getNodeModel().getIElementModels();
        UObservable.deleteObserver((Object)elementModels.getCreationBlsrNotifier(), (Object)this.createObserver, (String)className);
        UObservable.deleteObserver((Object)elementModels, (Object)this.createObserver, (String)className);
        db.fine("[unregisterForBlsrEvents] Deleted BlsrModel creation observer for node " + netElement.getNodeModel().getName());
    }

    private List nodesWithFeature(List list, Feature feature) {
        ArrayList<NetElement> arrayList = new ArrayList<NetElement>();
        for (NetElement netElement : new ArrayList(this.network.getElements())) {
            if (!netElement.getNodeModel().provides(feature)) continue;
            arrayList.add(netElement);
        }
        return arrayList;
    }

    public synchronized void stitchBlsrModel(IBlsrModel iBlsrModel, INodeModel iNodeModel) {
        String string = BlsrRingManager.getRingName(iBlsrModel);
        db.fine("[stitchBlsrModel] " + iBlsrModel.getNodeModel() + " has a BLSR named: " + string);
        BlsrNode blsrNode = BlsrNode.provisionedInstance(iBlsrModel, (NodeModel)iNodeModel);
        boolean bl = false;
        HashSet<BlsrRingModel> hashSet = new HashSet<BlsrRingModel>();
        Set set = this.getBlsrRingModel(string);
        boolean bl2 = false;
        db.fine("[stitchBlsrModel] Number of rings with ID " + string + ": " + set.size());
        if (blsrNode.getBlsrRingInfo().getRingSpeed() != 5 && !set.isEmpty()) {
            for (BlsrRingModel blsrRingModel : set) {
                if (blsrRingModel.getBlsrRingInfo().getRingType() != blsrNode.getBlsrRingInfo().getRingType() || blsrRingModel.getBlsrRingInfo().getRingSpeed() != blsrNode.getBlsrRingInfo().getRingSpeed()) {
                    db.fine("[stitchBlsrModel] Ignore BlsrNode: " + blsrNode.getBlsrRingInfo().toString() + "does not match: " + blsrRingModel.getBlsrRingInfo().toString());
                    continue;
                }
                if (blsrRingModel.getState() == 2) {
                    HashSet<BlsrNode> hashSet2 = new HashSet<BlsrNode>(Arrays.asList(blsrRingModel.getBlsrNodes()));
                    Iterator iterator = hashSet2.iterator();
                    db.fine("[stitchBlsrModel] ringTraverse has " + hashSet2.size() + " BlsrNodes");
                    while (iterator.hasNext()) {
                        BlsrNode blsrNode2 = (BlsrNode)iterator.next();
                        if (blsrNode2.getNodeModel() == blsrNode.getNodeModel()) {
                            return;
                        }
                        BlsrSpan[] blsrSpanArray = blsrNode.isDestroyed() || blsrNode2.isDestroyed() ? new BlsrSpan[]{} : this.buildBlsrSpan(blsrNode, blsrNode2);
                        if (blsrSpanArray.length > 0) {
                            blsrRingModel.addBlsrNode(blsrNode);
                            bl = true;
                            hashSet.add(blsrRingModel);
                        }
                        db.fine("[stitchBlsrModel] Connection between " + blsrNode.getNodeModel() + " and " + blsrNode2.getNodeModel() + ": " + (blsrSpanArray.length > 0 ? "found" : "not found"));
                    }
                    if (hashSet.size() <= 1) continue;
                    break;
                }
                if (!blsrRingModel.containsNodeModel(iNodeModel)) continue;
                db.fine("This BLSR had already been stitched!");
                bl2 = true;
            }
        }
        if (!(bl || blsrNode.isDestroyed() || bl2)) {
            db.fine("[stitchBlsrModel] called createBlsrRingModel");
            this.createBlsrRingModel(BlsrRingInfo.unProvisionedDuplicate(new BlsrRingInfo(iBlsrModel)), null, 2).addBlsrNode(blsrNode);
        } else if (hashSet.size() > 1) {
            db.fine("[stitchBlsrModel] called mergeRings");
            this.mergeRings(hashSet);
        }
        if (this.zombieNodes.contains(blsrNode)) {
            this.removeZombie(blsrNode);
        }
    }

    private synchronized void addNode(NetElement netElement) {
        if (netElement.getNodeModel().provides(Feature.NET_BLSR_WIZ) && !this.wizardNodes.contains(netElement)) {
            db.finest("[addNode] Adding NE (" + netElement.getName() + ")");
            this.wizardNodes.add(netElement);
            this.registerForBlsrEvents(netElement);
        }
        this.stitchNode(netElement);
    }

    private synchronized void removeNode(NetElement netElement) {
        if (this.wizardNodes.contains(netElement)) {
            this.unregisterForBlsrEvents(netElement);
            this.wizardNodes.remove(netElement);
            this.stitchedNodes.remove(netElement.getNodeModel());
        }
    }

    public static String getRingName(IBlsrModel iBlsrModel) {
        String string = null;
        if (iBlsrModel.getNodeModel().provides(Feature.BLSR_PATRIOT_EXTENSIONS)) {
            string = iBlsrModel.getBlsrProvision().getRingName();
        } else {
            try {
                string = iBlsrModel.getBlsrProvision().getGlobalRingId() + "";
            }
            catch (UnsupportedOperation unsupportedOperation) {
                SDebug.printStackTrace((Throwable)unsupportedOperation);
            }
        }
        return string;
    }

    synchronized BlsrSpan[] buildBlsrSpan(BlsrNode blsrNode, BlsrNode blsrNode2) {
        BlsrSpan blsrSpan;
        int n;
        ArrayList<BlsrSpan> arrayList = new ArrayList<BlsrSpan>();
        IBlsrModel iBlsrModel = blsrNode.getBlsrModel();
        IBlsrModel iBlsrModel2 = blsrNode2.getBlsrModel();
        String string = BlsrRingManager.getRingName(iBlsrModel);
        String string2 = BlsrRingManager.getRingName(iBlsrModel2);
        db.fine("[buildBlsrSpan] Source ring name (" + string + ") - Dest ring name (" + string2 + ")");
        if (string != null && string.equalsIgnoreCase(string2) && blsrNode.getBlsrRingInfo().getRingType() == blsrNode2.getBlsrRingInfo().getRingType()) {
            n = 0;
            boolean bl = false;
            INetLink iNetLink = null;
            INetLink iNetLink2 = null;
            INetLink iNetLink3 = null;
            INetLink iNetLink4 = null;
            try {
                block12: {
                    ITdmPortModel iTdmPortModel = (ITdmPortModel)iBlsrModel.getEastEntityModel();
                    ITdmPortModel iTdmPortModel2 = (ITdmPortModel)iBlsrModel.getWestEntityModel();
                    ITdmPortModel iTdmPortModel3 = (ITdmPortModel)iBlsrModel2.getEastEntityModel();
                    ITdmPortModel iTdmPortModel4 = (ITdmPortModel)iBlsrModel2.getWestEntityModel();
                    INetElement iNetElement = this.network.findNetElem(iTdmPortModel.getNodeModel().getNodeId());
                    INetElement iNetElement2 = this.network.findNetElem(iTdmPortModel3.getNodeModel().getNodeId());
                    iNetLink = this.network.findNetLinkFromEnt(iNetElement, iTdmPortModel.getEntityIndex(), true);
                    iNetLink2 = this.network.findNetLinkFromEnt(iNetElement2, iTdmPortModel4.getEntityIndex(), true);
                    iNetLink3 = this.network.findNetLinkFromEnt(iNetElement, iTdmPortModel2.getEntityIndex(), true);
                    iNetLink4 = this.network.findNetLinkFromEnt(iNetElement2, iTdmPortModel3.getEntityIndex(), true);
                    n = iNetLink != null && !iNetLink.isDeleted() && iNetLink2 != null && !iNetLink2.isDeleted() && ((Object)iNetLink).equals(this.network.findReverseLink(iNetLink2)) && ((Object)iNetLink2).equals(this.network.findReverseLink(iNetLink)) ? 1 : 0;
                    boolean bl2 = bl = iNetLink3 != null && !iNetLink3.isDeleted() && iNetLink4 != null && !iNetLink4.isDeleted() && ((Object)iNetLink3).equals(this.network.findReverseLink(iNetLink4)) && ((Object)iNetLink4).equals(this.network.findReverseLink(iNetLink3));
                    if (n != 0) {
                        db.fine("[buildBlsrSpan] " + blsrNode.getNodeModel() + " (east) is connected to " + blsrNode2.getNodeModel() + " (west).");
                        try {
                            blsrSpan = new BlsrSpan(iNetLink);
                            blsrSpan.setEastSide(blsrNode);
                            blsrNode.setEastMain(blsrSpan);
                            blsrSpan.setWestSide(blsrNode2);
                            blsrNode2.setWestMain(blsrSpan);
                            arrayList.add(blsrSpan);
                        }
                        catch (InstantiationException instantiationException) {
                            if (!db.on()) break block12;
                            SDebug.printStackTrace((Throwable)instantiationException);
                        }
                    }
                }
                if (bl) {
                    db.fine("[buildBlsrSpan] " + blsrNode.getNodeModel() + " (west) is connected to " + blsrNode2.getNodeModel() + " (east).");
                    try {
                        blsrSpan = new BlsrSpan(iNetLink3);
                        blsrSpan.setWestSide(blsrNode);
                        blsrNode.setWestMain(blsrSpan);
                        blsrSpan.setEastSide(blsrNode2);
                        blsrNode2.setEastMain(blsrSpan);
                        arrayList.add(blsrSpan);
                    }
                    catch (InstantiationException instantiationException) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)instantiationException);
                        }
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.fine("[buildBlsrSpan] " + abstractCmsNoSuchEntityException.toString());
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            blsrSpan = (BlsrSpan)arrayList.get(n);
            this.clairvoyantSpanMap.put(new NetLinkKey(blsrSpan.getOriginalLink()), blsrSpan);
            if (blsrSpan.getReverseLink() != null) {
                this.clairvoyantSpanMap.put(new NetLinkKey(blsrSpan.getReverseLink()), blsrSpan);
                db.fine("reverse link is not null.");
                continue;
            }
            db.fine("The reverse link is null for " + blsrSpan);
        }
        return arrayList.toArray(new BlsrSpan[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlsrRingModel mergeRings(Set set) {
        BlsrRingModel blsrRingModel = null;
        Set set2 = set;
        synchronized (set2) {
            Iterator iterator = set.iterator();
            BlsrRingModel blsrRingModel2 = null;
            db.fine("[mergeRings] Merging " + set.size() + " rings...");
            if (iterator.hasNext()) {
                blsrRingModel = (BlsrRingModel)iterator.next();
                while (iterator.hasNext()) {
                    blsrRingModel2 = (BlsrRingModel)iterator.next();
                    if (blsrRingModel.getBlsrNodes().length >= blsrRingModel2.getBlsrNodes().length) continue;
                    blsrRingModel = blsrRingModel2;
                }
                set.remove(blsrRingModel);
                iterator = set.iterator();
                db.fine("[mergeRings] Master ring has " + blsrRingModel.getBlsrNodes().length + " nodes before merging.");
                while (iterator.hasNext()) {
                    blsrRingModel2 = (BlsrRingModel)iterator.next();
                    Iterator<BlsrNode> iterator2 = new HashSet<BlsrNode>(Arrays.asList(blsrRingModel2.getBlsrNodes())).iterator();
                    db.fine("[mergeRings] Merging " + blsrRingModel2.getBlsrNodes().length + " nodes in ring " + blsrRingModel2);
                    while (iterator2.hasNext()) {
                        BlsrNode blsrNode = iterator2.next();
                        blsrRingModel.addBlsrNode(blsrNode);
                    }
                    db.fine("[mergeRings] Disposing ring: " + blsrRingModel2);
                    blsrRingModel2.destroy();
                    this.rings.remove(blsrRingModel2);
                    Set set3 = this.getBlsrRingModel(blsrRingModel.getRingName());
                    set3.remove(blsrRingModel2);
                    this.sameIdRingMap.put(blsrRingModel.getRingName(), set3);
                    this.sameIdRingMap.put(new Integer(blsrRingModel.getRingId()), set3);
                    db.fine("[mergeRings] sameIdRings: mapping " + blsrRingModel.getRingName() + " and " + blsrRingModel.getRingId());
                    db.fine("[mergeRings] sameIdRings: " + set3);
                }
                db.fine("[mergeRings] Merged ring has " + blsrRingModel.getBlsrNodes().length + " nodes.");
            }
        }
        return blsrRingModel;
    }

    static {
        db = new BRMDebug(className);
    }

    public static class BRMDebug
    extends SDebug {
        public static final String Hdump = "Dumps all of the BlsrRingModels.";

        public BRMDebug(String string) {
            super(string);
        }

        public final void dump() {
            Set set = blsrRingManager.getBlsrRingModels();
            this.println(blsrRingManager + " has " + set.size() + " rings:");
            for (BlsrRingModel blsrRingModel : set) {
                this.println(blsrRingModel.toString());
            }
        }
    }

    class BlsrCreationObserver
    implements Observer,
    IObserver {
        BlsrCreationObserver() {
        }

        @Override
        public void update(Observable observable, Object object) {
            this._update(observable, object);
        }

        public void update(IObservable iObservable, Object object) {
            this._update(iObservable, object);
        }

        private synchronized void _update(Object object, Object object2) {
            if (object instanceof ElementModels) {
                ElementModels elementModels = (ElementModels)object;
                BlsrRingManager.this.stitchNode(elementModels.getNodeModel());
                return;
            }
            Set set = (Set)object2;
            Iterator iterator = set.iterator();
            IBlsrModel iBlsrModel = null;
            NodeModel nodeModel = null;
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator.hasNext()) {
                iBlsrModel = (IBlsrModel)iterator.next();
                if (db.on()) {
                    try {
                        stringBuffer.append("BlsrModel CREATED on node " + iBlsrModel.getWestEntityModel().getNodeModel().getName());
                        stringBuffer.append(" using slots " + iBlsrModel.getWestEntityModel().getSlot() + "W" + "/" + iBlsrModel.getEastEntityModel().getSlot() + "E" + iBlsrModel);
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        stringBuffer.delete(0, stringBuffer.length());
                        stringBuffer.append(abstractCmsNoSuchEntityException.toString());
                    }
                    db.fine("[creationObserver.update] " + stringBuffer.toString());
                    stringBuffer.delete(0, stringBuffer.length());
                }
                nodeModel = (NodeModel)Network.instance().getNodeModel(iBlsrModel.getNodeModel().getNodeId());
                BlsrRingManager.this.stitchBlsrModel(iBlsrModel, nodeModel);
            }
        }
    }

    public class BlsrRingCreationNotifier
    extends UObservable {
        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }

        public void notifyObservers() {
        }
    }

    class BlsrRingStateChangeObserver
    implements Observer,
    IObserver {
        BlsrRingStateChangeObserver() {
        }

        @Override
        public void update(Observable observable, Object object) {
            this._update(observable, object);
        }

        public void update(IObservable iObservable, Object object) {
            this._update(iObservable, object);
        }

        private synchronized void _update(Object object, Object object2) {
            if (!(object2 instanceof BlsrRingModel)) {
                return;
            }
            BlsrRingModel blsrRingModel = (BlsrRingModel)object2;
            int n = blsrRingModel.getState();
            switch (n) {
                case 666: {
                    db.fine("[stateChangeObserver.update] BlsrRingModel DESTROYED - Ring ID: " + (blsrRingModel != null ? blsrRingModel.getRingName() : "null"));
                    Set set = BlsrRingManager.this.getBlsrRingModel(blsrRingModel.getRingName());
                    blsrRingModel.getStateChangeNotifier().deleteObserver(BlsrRingManager.this.stateChangeObserver);
                    BlsrRingManager.this.rings.remove(blsrRingModel);
                    if (set == null) break;
                    set.remove(blsrRingModel);
                    BlsrRingManager.this.sameIdRingMap.put(blsrRingModel.getRingName(), set);
                    BlsrRingManager.this.sameIdRingMap.put(new Integer(blsrRingModel.getRingId()), set);
                    db.fine("[BlsrRingStateObserver.update] sameIdRings: mapping " + blsrRingModel.getRingName() + " and " + blsrRingModel.getRingId());
                    db.fine("[BlsrRingStateObserver.update] sameIdRings: " + set);
                    break;
                }
                default: {
                    db.fine("[stateChangeObserver.update] BlsrRingModel CHANGED - Ring ID: " + blsrRingModel.getRingName());
                }
            }
        }
    }

    class NetElementChangeObserver
    implements Observer,
    IObserver {
        NetElementChangeObserver() {
        }

        @Override
        public void update(Observable observable, Object object) {
            this._update(observable, object);
        }

        public void update(IObservable iObservable, Object object) {
            this._update(iObservable, object);
        }

        private synchronized void _update(Object object, Object object2) {
            if (!(object instanceof NetElement)) {
                return;
            }
            Integer n = (Integer)object2;
            NetElement netElement = (NetElement)object;
            if (netElement.getConnectionState() && !netElement.isDeleted()) {
                db.finest("[NetElementChangeObserver] Adding " + netElement.getName() + "...");
                BlsrRingManager.this.addNode(netElement);
            } else if (n == ModelUpdateType.DELETED || !netElement.getConnectionState()) {
                db.finest("[NetElementChangeObserver] Removing " + netElement.getName() + "...");
                BlsrRingManager.this.removeNode(netElement);
            } else {
                db.fine("[NetElementChangeObserver] doing nothing for " + netElement.getName() + " update type " + n);
            }
        }
    }

    class NetElementCreationObserver
    implements Observer,
    IObserver {
        NetElementCreationObserver() {
        }

        @Override
        public void update(Observable observable, Object object) {
            this._update(observable, object);
        }

        public void update(IObservable iObservable, Object object) {
            this._update(iObservable, object);
        }

        private synchronized void _update(Object object, Object object2) {
            db.finest("[netElementCreationObserver.update] Received update: " + object2);
            if (object2 instanceof NetElement) {
                NetElement netElement = (NetElement)object2;
                UObservable.addObserver((Object)netElement, (Object)BlsrRingManager.this.netElementChangeObserver, (String)BlsrRingManager.className);
                if (netElement.getConnectionState()) {
                    BlsrRingManager.this.addNode(netElement);
                }
                db.finest("[netElementCreationObserver.update] NetElement " + netElement.getName() + ".getConnectionState() = " + netElement.getConnectionState());
            }
        }
    }

    private static final class NetLinkKey {
        public NodeModel srcNm;
        public NodeModel dstNm;
        public int srcEntityIndex;
        public int dstEntityIndex;

        public NetLinkKey(INetLink iNetLink) {
            this.srcNm = (NodeModel)iNetLink.getSrc().getNodeModel();
            this.dstNm = (NodeModel)iNetLink.getDst().getNodeModel();
            this.srcEntityIndex = iNetLink.getSrcEntityIndex();
            this.dstEntityIndex = iNetLink.getDstEntityIndex();
        }

        public int hashCode() {
            return this.srcEntityIndex + this.dstEntityIndex;
        }

        public boolean equals(Object object) {
            if (!(object instanceof NetLinkKey)) {
                return false;
            }
            NetLinkKey netLinkKey = (NetLinkKey)object;
            return this.srcNm.equals(netLinkKey.srcNm) && this.dstNm.equals(netLinkKey.dstNm) && this.srcEntityIndex == netLinkKey.srcEntityIndex && this.dstEntityIndex == netLinkKey.dstEntityIndex;
        }
    }

    class NetLinkObserver
    implements Observer,
    IObserver {
        NetLinkObserver() {
        }

        @Override
        public void update(Observable observable, Object object) {
            this._update(observable, object);
        }

        public void update(IObservable iObservable, Object object) {
            this._update(iObservable, object);
        }

        private synchronized void _update(Object object, Object object2) {
            INetLink iNetLink = null;
            INetLink iNetLink2 = null;
            boolean bl = false;
            if (object2 instanceof INetLink) {
                iNetLink = (INetLink)object2;
            } else if (object instanceof INetLink && object2 == ModelUpdateType.CHANGED) {
                bl = true;
                iNetLink = (INetLink)object;
            }
            if (db.on()) {
                db.println("[NetLinkObserver:_update] called from");
                db.println("for NetLink: " + iNetLink + " and " + object2);
            }
            if (iNetLink != null && iNetLink.isSdccLink() && iNetLink.inBLSR() && (iNetLink2 = BlsrRingManager.this.network.findReverseLink(iNetLink)) != null) {
                BlsrSpan blsrSpan = (BlsrSpan)BlsrRingManager.this.clairvoyantSpanMap.remove(new NetLinkKey(iNetLink));
                if (blsrSpan != null) {
                    if (bl) {
                        blsrSpan.spanDownNotification();
                    } else {
                        db.fine("Destroying the zombie " + blsrSpan);
                        blsrSpan.destroy();
                    }
                }
                if ((blsrSpan = (BlsrSpan)BlsrRingManager.this.clairvoyantSpanMap.remove(new NetLinkKey(iNetLink2))) != null) {
                    if (bl) {
                        blsrSpan.spanDownNotification();
                    } else {
                        db.fine("Destroying the zombie " + blsrSpan);
                        blsrSpan.destroy();
                    }
                }
                this.linkUpdate(iNetLink);
                UObservable.addObserver((Object)iNetLink, (Object)this, (String)BlsrRingManager.className);
                db.fine("[NetLinkUpdate] New DCC net link added: " + iNetLink);
            } else if (iNetLink == null) {
                db.fine("[NetLinkUpdate] Net link not found, was NULL.");
            } else {
                if (!iNetLink.isSdccLink()) {
                    db.fine("[NetLinkUpdate] Non-DCC link found and ignored on: " + iNetLink);
                }
                if (!iNetLink.inBLSR()) {
                    db.fine("[NetLinkUpdate] link is NOT in BLSR on " + iNetLink);
                }
                if (BlsrRingManager.this.network.findReverseLink(iNetLink) != null) {
                    db.fine("[NetLinkUpdate] No Reverse link found on " + iNetLink);
                }
            }
        }

        private synchronized void linkUpdate(INetLink iNetLink) {
            LinkModel linkModel = (LinkModel)iNetLink.getLinkModel();
            String string = linkModel.blsrRingName();
            if (db.isFineEnabled()) {
                db.fine("[linkUpdate] netLink: " + iNetLink + " with ring name: " + string);
            }
            if (!string.equals("")) {
                BlsrSpan blsrSpan;
                boolean bl = false;
                try {
                    db.fine("[linkUpdate] Create new BlsrSpan with observer false.");
                    blsrSpan = new BlsrSpan(iNetLink, false);
                }
                catch (InstantiationException instantiationException) {
                    db.fine(iNetLink.prettyString() + ": one or more sides do not support NET_BLSR_WIZ");
                    return;
                }
                Set set = BlsrRingManager.this.getBlsrRingModel(string);
                Iterator iterator = set.iterator();
                BlsrRingModel blsrRingModel = null;
                while (!bl && iterator.hasNext()) {
                    blsrRingModel = (BlsrRingModel)iterator.next();
                    bl = blsrRingModel.containsBlsrSpan(blsrSpan);
                }
                if (!bl) {
                    NodeModel nodeModel = (NodeModel)iNetLink.getSrc().getNodeModel();
                    NodeModel nodeModel2 = (NodeModel)iNetLink.getDst().getNodeModel();
                    BlsrRingModel blsrRingModel2 = BlsrRingManager.this.getBlsrRingModel(nodeModel, string);
                    BlsrRingModel blsrRingModel3 = BlsrRingManager.this.getBlsrRingModel(nodeModel2, string);
                    db.fine("[linkUpdate] srcRingModel: " + blsrRingModel2);
                    db.fine("[linkUpdate] dstRingModel: " + blsrRingModel3);
                    if (blsrRingModel2 != null && blsrRingModel3 != null) {
                        BlsrSpan[] blsrSpanArray;
                        BlsrNode blsrNode = blsrRingModel2.getBlsrNode(nodeModel);
                        BlsrNode blsrNode2 = blsrRingModel3.getBlsrNode(nodeModel2);
                        if (db.on() && blsrNode == null) {
                            db.println("[linkUpdate] srcBlsrNode is null for " + nodeModel);
                        }
                        if (db.on() && blsrNode2 == null) {
                            db.println("[linkUpdate] dstBlsrNode is null for " + nodeModel2);
                        }
                        if ((blsrSpanArray = BlsrRingManager.this.buildBlsrSpan(blsrNode, blsrNode2)).length > 0) {
                            if (!blsrRingModel2.equals(blsrRingModel3)) {
                                HashSet<BlsrRingModel> hashSet = new HashSet<BlsrRingModel>();
                                hashSet.add(blsrRingModel2);
                                hashSet.add(blsrRingModel3);
                                blsrRingModel2 = BlsrRingManager.this.mergeRings(hashSet);
                            }
                            blsrRingModel2.addDiscoveredBlsrSpans(blsrSpanArray);
                        } else {
                            db.severe("[linkUpdate] no stitching spans for: " + blsrNode + " and " + blsrNode2);
                        }
                    }
                } else {
                    db.fine("[linkUpdate] ringModel: " + blsrRingModel + " already contains span: " + blsrSpan);
                }
            }
        }
    }
}

