/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.blsr;

import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.blsr.BlsrSanityCheckException;

public class BlsrUpgradeException
extends BlsrSanityCheckException {
    private BlsrNode[] upgradeFailures;
    private BlsrNode[] reprovisionFailures;
    private String blsrTerm;

    public BlsrUpgradeException(BlsrNode[] blsrNodeArray, BlsrNode[] blsrNodeArray2, String string) {
        this.upgradeFailures = blsrNodeArray == null ? new BlsrNode[0] : blsrNodeArray;
        this.reprovisionFailures = blsrNodeArray2 == null ? new BlsrNode[0] : blsrNodeArray2;
        this.blsrTerm = string;
    }

    public BlsrNode[] getUpgradeFailures() {
        return this.upgradeFailures;
    }

    public BlsrNode[] getReprovisionFailures() {
        return this.reprovisionFailures;
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("The upgrade to a four-fiber " + this.blsrTerm + " failed on these node(s):\n");
        for (n = 0; n < this.upgradeFailures.length; ++n) {
            if (this.upgradeFailures[n] == null) continue;
            stringBuffer.append("\t" + this.upgradeFailures[n].toString() + "\n");
        }
        if (this.reprovisionFailures != null && this.reprovisionFailures.length > 0) {
            stringBuffer.append("\nThe reprovisioning of the two-fiber " + this.blsrTerm + " failed on these node(s):\n");
            for (n = 0; n < this.reprovisionFailures.length; ++n) {
                if (this.reprovisionFailures[n] == null) continue;
                stringBuffer.append("\t" + this.reprovisionFailures[n].toString() + "\n");
            }
        }
        return stringBuffer.toString();
    }
}

