/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.circuits;

import cerent.cms.model.FramingType;
import cerent.cms.model.HoServerTrailModel;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.IFramingType;
import cerent.cms.model.LoServerTrailModel;
import cerent.cms.model.ServerTrailModel;
import cerent.cms.model.ServerTrailsDirector;
import cerent.cms.model.circuits.SpanRow;
import cerent.cms.model.circuits.SpanRowHoLoComparator;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.CompositeNetLink;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.ServerTrailLink;
import cerent.cms.ui.circuits.SpanCircuitsPane;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.HoLoRange;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import cerent.util.SdhAu3HoNum;
import cerent.util.SdhAu4HoNum;
import cerent.util.gui.row.AbstractRowDataSource;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;

public class SpanDataSource
extends AbstractRowDataSource
implements Observer {
    private final NetCircuitManager ncm = NetCircuitManager.instance();
    private static final HoLoComparator holoComp = HoLoComparator.instance();
    private final Network net = Network.instance();
    private INetLink forwardLink;
    private INetLink reverseLink;
    private List allCircuits = new ArrayList();
    private List circuits = new ArrayList();
    private List spanRows = Collections.synchronizedList(new ArrayList());
    boolean atLeastOneUpsrInPreviousSpanRows = false;
    private SpanCircuitsPane scp;
    private static SDebug db = new SDebug("SpanDataSource");
    private SdsDebug dumpDebug = new SdsDebug("SpanDataSourceDump");

    public SpanDataSource(SpanCircuitsPane spanCircuitsPane) {
        this.ncm.addObserver(this);
        this.scp = spanCircuitsPane;
    }

    public void setNetLink(INetLink iNetLink) {
        this.forwardLink = iNetLink;
        this.reverseLink = this.net.findReverseLink(iNetLink);
        this.update((Observable)((Object)this.ncm), null);
    }

    public void dispose() {
        this.dumpDebug.dispose();
        this.spanRows.clear();
        this.deleteCircuitObservers();
        this.circuits = new ArrayList();
        this.ncm.deleteObserver(this);
    }

    @Override
    public synchronized void update(Observable observable, Object object) {
        if (observable == this.ncm) {
            this.refreshCircuits();
            this.registerWithAllCircuits();
        } else if (observable instanceof INetCircuit) {
            this.refreshCircuits();
        }
    }

    private void registerWithAllCircuits() {
        this.deleteCircuitObservers();
        this.allCircuits = this.ncm.getCircuits();
        for (INetCircuit iNetCircuit : this.allCircuits) {
            iNetCircuit.addObserver(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refreshCircuits() {
        Collection collection;
        AbstractCollection abstractCollection;
        TreeSet treeSet = new TreeSet();
        if (SpanDataSource.db.on) {
            db.println("refreshCircuits: processing forward link");
        }
        this.getLinkCircuits(treeSet, this.forwardLink, null);
        if (SpanDataSource.db.on) {
            db.println("refreshCircuits: processing reverse link");
        }
        this.getLinkCircuits(treeSet, this.reverseLink, null);
        if (!this.scp.supportsMultipleFramingTypes()) {
            treeSet.addAll(this.createUnusedSpanRows(treeSet, this.forwardLink));
        } else {
            TreeSet treeSet2 = new TreeSet();
            abstractCollection = new TreeSet();
            this.divideCircuitSpanRows(treeSet, treeSet2, (Set)((Object)abstractCollection));
            collection = this.calcDummySpanRows((Set)((Object)abstractCollection));
            treeSet2.addAll(collection);
            treeSet2.addAll(this.createUnusedSpanRows(treeSet2, this.forwardLink));
            treeSet2.removeAll(collection);
            treeSet = treeSet2;
        }
        boolean bl = false;
        abstractCollection = new ArrayList(treeSet);
        if (((Object)this.spanRows).equals(abstractCollection)) {
            if (SpanDataSource.db.on) {
                db.println("no change in spanRows, returning");
            }
            collection = this.spanRows;
            synchronized (collection) {
                for (SpanRow spanRow : this.spanRows) {
                    INetCircuitSpan iNetCircuitSpan = spanRow.getSpan();
                    if (iNetCircuitSpan == null || !iNetCircuitSpan.isUpsr()) continue;
                    bl = true;
                    break;
                }
            }
        }
        this.spanRows.clear();
        this.spanRows.addAll(abstractCollection);
        this.circuits = new ArrayList(this.spanRows.size());
        collection = this.spanRows;
        synchronized (collection) {
            for (SpanRow spanRow : this.spanRows) {
                INetCircuitSpan iNetCircuitSpan = spanRow.getSpan();
                if (iNetCircuitSpan != null && iNetCircuitSpan.isUpsr()) {
                    bl = true;
                }
                this.circuits.add(spanRow.circuit);
            }
        }
        this.fireDataChanged(bl);
    }

    private void fireDataChanged(boolean bl) {
        if (this.atLeastOneUpsrInPreviousSpanRows != bl) {
            if (db.on()) {
                db.println("spanRows changed, plus the selector flag will no longer be " + this.atLeastOneUpsrInPreviousSpanRows);
            }
            this.atLeastOneUpsrInPreviousSpanRows = bl;
            this.scp.showUpsrObjects(bl);
            this.fireDataStructureChanged();
        } else {
            if (db.on()) {
                db.println("spanRows changed, but the selector flag will remain " + this.atLeastOneUpsrInPreviousSpanRows);
            }
            this.fireDataSourceChanged();
        }
    }

    private void divideCircuitSpanRows(Set set, Set set2, Set set3) {
        int n = this.scp.getCurrentFramingType();
        for (SpanRow spanRow : set) {
            if (spanRow.getFirstHo().getFramingType() == n) {
                set2.add(spanRow);
                continue;
            }
            set3.add(spanRow);
        }
    }

    private Set calcDummySpanRows(Set set) {
        TreeSet<SpanRow> treeSet = new TreeSet<SpanRow>();
        int n = this.scp.getCurrentFramingType();
        for (SpanRow spanRow : set) {
            SdhAu4HoNum sdhAu4HoNum;
            int n2;
            IHoNum iHoNum = spanRow.getFirstHo();
            IHoNum iHoNum2 = spanRow.getLastHo();
            db.fine("old row = " + spanRow.prettyString());
            if (iHoNum.getFramingType() == 1) {
                for (n2 = iHoNum.getIdlHoNum(); n2 < iHoNum2.getIdlHoNum() + 3; ++n2) {
                    sdhAu4HoNum = HoLoFactory.createSdhAu3HoNum(n2);
                    db.fine("new row with vc3Ho=" + sdhAu4HoNum);
                    treeSet.add(new SpanRow(new HoLoRange((IHoNum)sdhAu4HoNum, (IHoNum)sdhAu4HoNum), null, null));
                }
                continue;
            }
            if (iHoNum.getFramingType() != 2) continue;
            n2 = ((SdhAu3HoNum)iHoNum).getAugNum();
            sdhAu4HoNum = HoLoFactory.createSdhAu4HoNum(n2);
            db.fine("new row with vc4Ho=" + sdhAu4HoNum);
            treeSet.add(new SpanRow(new HoLoRange((IHoNum)sdhAu4HoNum, (IHoNum)sdhAu4HoNum), null, null));
        }
        db.fine("total dummy row number = " + treeSet.size());
        return treeSet;
    }

    public boolean hasAtLeastOneSelector() {
        return this.atLeastOneUpsrInPreviousSpanRows;
    }

    private static void addFoundRows(Set set, Set set2) {
        if (!set2.isEmpty()) {
            for (SpanRow spanRow : set2) {
                set.add(spanRow);
            }
        }
    }

    private Set createUnusedSpanRows(Set set, INetLink iNetLink) {
        return SpanDataSource.createUnusedSpanRows(set, null, iNetLink, this.scp.getCurrentFramingType());
    }

    static Set createUnusedSpanRows(Set set, IHoNum iHoNum) {
        return SpanDataSource.createUnusedSpanRows(set, iHoNum, null, iHoNum.getFramingType());
    }

    private static Set createUnusedSpanRows(Set set, IHoNum iHoNum, INetLink iNetLink, int n) {
        AbstractNetLink abstractNetLink;
        TreeSet treeSet = new TreeSet();
        IHoNum iHoNum2 = null;
        IHoNum iHoNum3 = iHoNum;
        if (iNetLink != null) {
            abstractNetLink = (AbstractNetLink)iNetLink;
            if (holoComp.compare(HoLoFactory.createFirstHoNum(n), abstractNetLink.getFirstValidSrcHo(n)) < 0) {
                iHoNum2 = HoLoFactory.addOffset(abstractNetLink.getFirstValidSrcHo(n), -1);
            }
            iHoNum3 = HoLoFactory.addOffset(abstractNetLink.getLastValidSrcHo(n), 1);
        }
        abstractNetLink = HoLoFactory.createHoLoNum(iHoNum2, null);
        Set set2 = new HashSet();
        if (db.on()) {
            db.fine("total circuit rows=" + set.size());
        }
        for (SpanRow spanRow : set) {
            if (db.on()) {
                db.fine("usedSpanRow=" + spanRow.prettyString() + " " + "prevlastHoLo=" + abstractNetLink.prettyString("-"));
            }
            set2 = spanRow.findUnusedSpanRow((IHoLoNum)abstractNetLink);
            if (db.on()) {
                db.fine("found " + set2.size() + " unused rows");
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    db.fine("unusedSpanRow=" + ((SpanRow)iterator.next()).prettyString());
                }
            }
            treeSet.addAll(set2);
            abstractNetLink = HoLoFactory.createHoLoNum(spanRow.getLast());
        }
        if (iHoNum3 != null && abstractNetLink.getHoNum() != null) {
            set2 = SpanRow.findUnusedSpanRow(iHoNum3, null, (IHoLoNum)abstractNetLink);
            if (db.on()) {
                db.fine("found " + set2.size() + " unused rows");
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    db.fine("unusedSpanRow=" + ((SpanRow)iterator.next()).prettyString());
                }
            }
            treeSet.addAll(set2);
        }
        if (iNetLink instanceof ServerTrailLink && !treeSet.isEmpty()) {
            SpanDataSource.filterSpanRowsForServerTrail(treeSet, iNetLink);
        }
        return treeSet;
    }

    private static void filterSpanRowsForServerTrail(Set set, INetLink iNetLink) {
        if (iNetLink instanceof ServerTrailLink && !set.isEmpty()) {
            Object object;
            Object object2;
            Serializable serializable;
            ServerTrailsDirector serverTrailsDirector = ServerTrailsDirector.instance();
            ServerTrailModel serverTrailModel = serverTrailsDirector.getTrailModelById(((ServerTrailLink)iNetLink).getServerTrailId());
            IHoLoNum iHoLoNum = null;
            IHoLoNum iHoLoNum2 = null;
            if (serverTrailModel instanceof LoServerTrailModel) {
                serializable = (LoServerTrailModel)serverTrailModel;
                object2 = ((LoServerTrailModel)serializable).getSrcTrailStart().getLoAdit().getHo().getStartingHo();
                object = ((LoServerTrailModel)serializable).getSrcTrailStart().getLoNum();
                iHoLoNum = HoLoFactory.createHoLoNum((IHoNum)object2, (ILoNum)object);
                IHoNum iHoNum = ((LoServerTrailModel)serializable).getSrcTrailEnd().getLoAdit().getHo().getStartingHo();
                ILoNum iLoNum = ((LoServerTrailModel)serializable).getSrcTrailEnd().getLoNum();
                iHoLoNum2 = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
            } else {
                serializable = (HoServerTrailModel)serverTrailModel;
                object2 = ((HoServerTrailModel)serializable).getSrcTrailStart().getStartingHo();
                object = ((HoServerTrailModel)serializable).getSrcTrailEnd().getStartingHo();
                iHoLoNum = HoLoFactory.createHoLoNum((IHoNum)object2, null);
                iHoLoNum2 = HoLoFactory.createHoLoNum(object, null);
            }
            serializable = new HashSet();
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (SpanRow)object2.next();
                if (!SpanDataSource.isIntersecting(iHoLoNum, iHoLoNum2, (SpanRow)object)) {
                    object2.remove();
                    continue;
                }
                if (!SpanDataSource.trimSpanRow(iHoLoNum, iHoLoNum2, (SpanRow)object, (Set)((Object)serializable))) continue;
                object2.remove();
            }
            if (!serializable.isEmpty()) {
                set.addAll(serializable);
            }
        }
    }

    private static boolean isIntersecting(IHoLoNum iHoLoNum, IHoLoNum iHoLoNum2, SpanRow spanRow) {
        boolean bl = true;
        IHoLoNum iHoLoNum3 = spanRow.getRange().getFirst();
        IHoLoNum iHoLoNum4 = spanRow.getRange().getLast();
        SpanRowHoLoComparator spanRowHoLoComparator = (SpanRowHoLoComparator)SpanRowHoLoComparator.instance();
        if (spanRowHoLoComparator.compareHoLo(iHoLoNum, iHoLoNum4) > 0 || spanRowHoLoComparator.compareHoLo(iHoLoNum2, iHoLoNum3) < 0) {
            bl = false;
        }
        return bl;
    }

    private static boolean trimSpanRow(IHoLoNum iHoLoNum, IHoLoNum iHoLoNum2, SpanRow spanRow, Set set) {
        boolean bl = false;
        IHoLoNum iHoLoNum3 = spanRow.getRange().getFirst();
        IHoLoNum iHoLoNum4 = spanRow.getRange().getLast();
        SpanRowHoLoComparator spanRowHoLoComparator = (SpanRowHoLoComparator)SpanRowHoLoComparator.instance();
        if (spanRowHoLoComparator.compareHoLo(iHoLoNum2, iHoLoNum4) < 0) {
            SpanRow spanRow2 = new SpanRow(iHoLoNum3, iHoLoNum2, spanRow.getCircuit(), spanRow.getSpan());
            set.add(spanRow2);
            bl = true;
        } else if (spanRowHoLoComparator.compareHoLo(iHoLoNum, iHoLoNum3) > 0) {
            SpanRow spanRow3 = new SpanRow(iHoLoNum, iHoLoNum4, spanRow.getCircuit(), spanRow.getSpan());
            set.add(spanRow3);
            bl = true;
        }
        return bl;
    }

    private void deleteCircuitObservers() {
        for (INetCircuit iNetCircuit : this.allCircuits) {
            iNetCircuit.deleteObserver(this);
        }
    }

    private void getLinkCircuits(Set set, INetLink iNetLink, IHoNum iHoNum) {
        Object object;
        ILoNum iLoNum;
        ILoNum iLoNum2;
        IHoNum iHoNum2;
        IHoNum iHoNum3;
        INetCircuit iNetCircuit;
        List list;
        List list2;
        if (iNetLink == null) {
            return;
        }
        CompositeNetLink compositeNetLink = CompositeNetLink.getCompositeLink(iNetLink);
        if (compositeNetLink != null) {
            list2 = this.ncm.getCircuitSpans(compositeNetLink);
            list = this.ncm.getEndpointsUseLink(compositeNetLink);
        } else {
            list2 = this.ncm.getCircuitSpans(iNetLink);
            list = this.ncm.getEndpointsUseLink(iNetLink);
        }
        for (Object object2 : list2) {
            iNetCircuit = object2.getCircuit();
            if (iNetCircuit.getCircuitTypeObj().isLoCircuitType()) {
                iHoNum2 = iHoNum != null ? (iHoNum3 = iHoNum) : (iHoNum3 = object2.getSrcHoNum());
                iLoNum = iLoNum2 = object2.getLoNum();
            } else {
                iHoNum2 = object2.getSrcHoNum();
                object = FramingType.getFramingType((int)iHoNum2.getFramingType());
                iHoNum3 = SpanDataSource.determineLastHo(iHoNum2, iNetCircuit.getCircuitSizeObj(), object);
                iLoNum2 = null;
                iLoNum = null;
            }
            if (SpanDataSource.db.on) {
                db.println("adding new SpanRow(" + iHoNum2 + ", " + iHoNum3 + ", " + iNetCircuit.getCircuitName() + ")");
            }
            if (!set.add(object = new SpanRow(iHoNum2, iLoNum, iHoNum3, iLoNum2, iNetCircuit, (INetCircuitSpan)object2)) && SpanDataSource.db.on) {
                db.println("last add was a duplicate");
            }
            if (iNetCircuit.getCircuitTypeObj().isTunnelCircuitType()) {
                this.getLinkCircuits(set, iNetCircuit.getLotLink(), iHoNum2);
                this.getLinkCircuits(set, iNetCircuit.getReverseLotLink(), iHoNum2);
            }
            if (!iNetCircuit.getCircuitTypeObj().isLAPCircuitType()) continue;
            for (INetCircuit iNetCircuit2 : this.ncm.getCircuitsUseLAP(iNetCircuit)) {
                INetCircuitSpan iNetCircuitSpan;
                iHoNum2 = iHoNum != null ? (iHoNum3 = iHoNum) : (iHoNum3 = object2.getSrcHoNum());
                iLoNum = iLoNum2 = iNetCircuit2.getLoOverHo();
                if (SpanDataSource.db.on) {
                    db.println("adding new SpanRow(" + iHoNum2 + ", " + iHoNum3 + ", " + iNetCircuit2.getCircuitName() + ")");
                }
                if ((iNetCircuitSpan = iNetCircuit2.getCircuitSpanFromNetLink(iNetCircuit.getLapLink())) == null) {
                    iNetCircuitSpan = iNetCircuit2.getCircuitSpanFromNetLink(iNetCircuit.getReverseLapLink());
                }
                if (set.add(new SpanRow(iHoNum2, iLoNum, iHoNum3, iLoNum2, iNetCircuit2, iNetCircuitSpan)) || !SpanDataSource.db.on) continue;
                db.println("last add was a duplicate");
            }
        }
        for (Object object2 : list) {
            iNetCircuit = this.ncm.getCircuitFromCircuitEnd((INetCircuitEnd)object2);
            if (iNetCircuit == null) {
                if (db.on()) {
                    db.println("No circuit found with cktEnd = " + ((NetCircuitEnd)object2).prettyString());
                }
                return;
            }
            if (iNetCircuit.getCircuitTypeObj().isLoCircuitType()) {
                iHoNum2 = iHoNum != null ? (iHoNum3 = iHoNum) : (iHoNum3 = object2.getHoNum());
                iLoNum = iLoNum2 = object2.getLoNum();
            } else {
                iHoNum2 = object2.getHoNum();
                object = FramingType.getFramingType((int)iHoNum2.getFramingType());
                ICircuitSize iCircuitSize = iNetCircuit.getCircuitSizeObj();
                iHoNum3 = SpanDataSource.determineLastHo(iHoNum2, iCircuitSize, object);
                iLoNum2 = null;
                iLoNum = null;
            }
            if (SpanDataSource.db.on) {
                db.println("adding new SpanRow(" + iHoNum2 + ", " + iHoNum3 + ", " + iNetCircuit.getCircuitName() + ")");
            }
            if (set.add(new SpanRow(iHoNum2, iLoNum, iHoNum3, iLoNum2, iNetCircuit, null)) || !SpanDataSource.db.on) continue;
            db.println("last add was a duplicate");
        }
    }

    private static IHoNum determineLastHo(IHoNum iHoNum, ICircuitSize iCircuitSize, IFramingType iFramingType) {
        int n = iFramingType.getFramingTypeHoPathWidth(iCircuitSize.getHoPathWidth());
        IHoNum iHoNum2 = HoLoFactory.addOffset(iHoNum, n - 1);
        return iHoNum2;
    }

    private static void addEmptySpanRow(Set set, IHoLoNum iHoLoNum, IHoLoNum iHoLoNum2) {
        if (SpanDataSource.db.on) {
            db.println("adding empty SpanRow(" + iHoLoNum + ", " + iHoLoNum2 + ", null, null)");
        }
        set.add(new SpanRow(iHoLoNum, iHoLoNum2, null, null));
    }

    private static int getUsableStsCount(INetLink iNetLink) {
        int n = 1;
        if (iNetLink.getLinkType() == 1 || iNetLink.getLinkType() == 4) {
            switch (iNetLink.getPhysicalType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    n = iNetLink.getPhysicalTypeObj().getStsCapacity();
                }
            }
            if (iNetLink.getProtectionType() == 0) {
                n /= 2;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllObjects() {
        HashSet hashSet;
        List list = this.spanRows;
        synchronized (list) {
            hashSet = new HashSet(this.spanRows);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectAtRow(int n) {
        List list = this.spanRows;
        synchronized (list) {
            if (n >= 0 && n < this.spanRows.size()) {
                return this.spanRows.get(n);
            }
            return null;
        }
    }

    public int getRowCount() {
        return this.spanRows.size();
    }

    public Class getRowObjectClass() {
        return SpanRow.class;
    }

    public class SdsDebug
    extends SDebug {
        SdsDebug(String string) {
            super(string);
        }

        public final void dump() {
            for (INetCircuit iNetCircuit : SpanDataSource.this.circuits) {
                if (iNetCircuit == null) continue;
                iNetCircuit.prettyPrint(db);
            }
        }
    }
}

