/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Feature;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IHoRollModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRollModel;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetRoll;
import cerent.cms.topo.Network;
import cerent.util.IObservable;
import cerent.util.SDebug;

public class HoRoll
extends NetRoll {
    private IHoPathDefModel rollFromPath;
    private IHoPathDefModel rollToPath;
    private IHoPathDefModel rollPath;
    private IHoRollModel rollModel;
    private static final SDebug db = new SDebug("HoRoll");

    @Override
    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    public HoRoll(INodeModel iNodeModel, IHoRollModel iHoRollModel) {
        block9: {
            try {
                this.node = iNodeModel;
                this.ne = Network.instance().getNetElem(iNodeModel.getNodeId());
                this.rollModel = iHoRollModel;
                this.rollFromPath = iHoRollModel.getRollFromPath();
                this.rollToPath = iHoRollModel.getRollToPath();
                this.rollPath = iHoRollModel.getRollPath();
                this.rollMode = iHoRollModel.getRollMode();
                this.rollCktEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.ne, iHoRollModel.getRollPath());
                this.rollFromCktEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.ne, iHoRollModel.getRollFromPath());
                this.rollToCktEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.ne, iHoRollModel.getRollToPath());
                this.connIndex = iHoRollModel.getConnectionIndex();
                this.conn = iNodeModel.provides(Feature.BNR_CONN_RTRV) ? this.getConnection(iNodeModel, this.connIndex) : this.getConnection(iNodeModel, this.rollPath);
                this.rollCircuitSize = NetCircuitManager.instance().connCircuitSize(this.conn);
                this.circuitRollNumber = iHoRollModel.getCircuitRollNumber();
                this.circuitRollMode = this.circuitRollNumber == 0 ? (short)this.rollMode : iHoRollModel.getCircuitRollMode();
                ModelIndirectObservable.instance().addObserver((IObservable)this.rollModel, this);
                this.isRollRefValid = true;
                this.discoverCircuitInfo();
            }
            catch (Exception exception) {
                this.isRollRefValid = false;
                if (this.rollModel != null) {
                    try {
                        ModelIndirectObservable.instance().deleteObserver((IObservable)this.rollModel, this);
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        // empty catch block
                    }
                }
                if (this.rollFromCircuit != null) {
                    this.rollFromCircuit.deleteObserver(this);
                }
                if (this.rollToCircuit != null) {
                    this.rollToCircuit.deleteObserver(this);
                }
                if (this.rfCircuitBirthObserver != null) {
                    NetCircuitManager.instance().deleteObserver(this.rfCircuitBirthObserver);
                }
                if (this.rtCircuitBirthObserver != null) {
                    NetCircuitManager.instance().deleteObserver(this.rtCircuitBirthObserver);
                }
                if (!this.dbgOn()) break block9;
                db.println("Error creating roll");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    protected IConnectionModel getConnection(INodeModel iNodeModel, Object object) throws NoSuchConnection {
        return iNodeModel.getConnectionModels().getHoConnection((IHoPathDefModel)object);
    }

    protected IConnectionModel getConnection(INodeModel iNodeModel, int n) {
        return iNodeModel.getConnectionModels().findHoConnectionModel(n);
    }

    @Override
    public IRollModel getRollModel() {
        return this.rollModel;
    }

    @Override
    public void setRollModel(IRollModel iRollModel) {
        this.rollModel = (IHoRollModel)iRollModel;
        this.setChanged();
    }

    @Override
    public Object getRollFromPath() {
        return this.rollFromPath;
    }

    @Override
    public Object getRollToPath() {
        return this.rollToPath;
    }
}

