/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitId;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.DeleteInstead;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.ILoRollModel;
import cerent.cms.model.IRollModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.LoDefModel;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnectionsFactory;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.LoCcatCircuit;
import cerent.cms.ncp.LoCircuitEnd;
import cerent.cms.ncp.LoCircuitNodeOperator;
import cerent.cms.ncp.LoConnModelSimulator;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.OnewayConnection;
import cerent.cms.topo.INetElement;
import cerent.util.EnumStrings;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class LoCircuitNode
extends NetCircuitNode {
    private static final SDebug db = new SDebug("LoCircuitNode");
    private ILoConnectionModel loConn;
    private boolean yLoNode;
    private LoCircuitNodeOperator operator;

    public LoCircuitNode(INetElement iNetElement, LoCcatCircuit loCcatCircuit) {
        super(iNetElement, loCcatCircuit);
        this.connName = loCcatCircuit.getCircuitName();
        this.cktId = new CircuitId(0, 0);
        this.serviceState = -2;
        this.pathWidth = loCcatCircuit.getCircuitSizeObj().size2widthOfLoCircuit();
        this.operator = new LoCircuitNodeOperator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoCircuitNode(INetElement iNetElement, LoCcatCircuit loCcatCircuit, Object object) throws AbstractCmsObjectNotExistException {
        super(iNetElement, loCcatCircuit, object);
        this.yLoNode = loCcatCircuit.isYCircuit;
        this.connName = this.getConnNameFromNE();
        loCcatCircuit.setChanged();
        this.pathWidth = loCcatCircuit.getCircuitSizeObj().size2widthOfLoCircuit();
        this.operator = new LoCircuitNodeOperator(this);
        Object object2 = this.entitiesLockObject;
        synchronized (object2) {
            this.updateUpsrEntities(true);
        }
    }

    @Override
    protected void sanityCheckConnModel() {
        this.loConn.getConnectionType();
    }

    @Override
    protected int getConnTypeFromConnModel() {
        ILoConnectionModel iLoConnectionModel = this.loConn;
        int n = iLoConnectionModel != null ? iLoConnectionModel.getConnectionType() : 22;
        if (this.dbgOn()) {
            this.debug("getConnTypeFromConnModel: " + this.circuit.getCircuitName() + "::" + this.getName() + "::" + EnumStrings.getString(IConnectionType.class, (int)n));
        }
        return n;
    }

    @Override
    protected void setConnTypeInConnModel(int n) throws ConnectionTypeError, ConnectionInTopologyUpgrade, ConnectionInLoopback, ConnectionInTestAccess, ConnectionInRoll {
        if (this.loConn != null) {
            if (this.dbgOn()) {
                db.println("changing intended type for LO connection");
            }
            this.loConn.changeIntendedType(n);
        }
    }

    @Override
    protected void addOutputToConnModel(NetCircuitEnd netCircuitEnd) throws CTCUserException {
        if (this.loConn != null) {
            ILoDefModel iLoDefModel = (ILoDefModel)((LoCircuitEnd)netCircuitEnd).getPathDef(this.getPathWidth());
            this.loConn.addOutput(iLoDefModel);
        }
    }

    @Override
    protected void addOutputToConnModel(NetCircuitSpan netCircuitSpan) throws CTCUserException {
        if (this.loConn != null) {
            ILoDefModel iLoDefModel = (ILoDefModel)netCircuitSpan.getPathDef(this.getNetElement(), this.getPathWidth());
            this.loConn.addOutput(iLoDefModel);
        }
    }

    @Override
    protected void removeOutputFromConnModel(NetCircuitEnd netCircuitEnd) throws InvalidPath, DeleteInstead, ConnectionTypeError, ObjNotFound, PathInUse, NoMoreLoCapableHo, CTCUserException {
        if (this.loConn != null) {
            ILoDefModel iLoDefModel = (ILoDefModel)((LoCircuitEnd)netCircuitEnd).getPathDef(this.getPathWidth());
            this.loConn.removeOutput(iLoDefModel);
        }
        netCircuitEnd.cleanupLoAditIfOldNe();
    }

    @Override
    protected void removeOutputFromConnModel(NetCircuitSpan netCircuitSpan) throws InvalidPath, DeleteInstead, ConnectionTypeError, ObjNotFound, PathInUse, NoMoreLoCapableHo, CTCUserException {
        if (this.loConn != null) {
            ILoDefModel iLoDefModel = (ILoDefModel)netCircuitSpan.getPathDef(this.getNetElement(), this.getPathWidth());
            this.loConn.removeOutput(iLoDefModel);
        }
        netCircuitSpan.cleanupLoAditIfOldNe(this.getNetElement());
    }

    @Override
    protected Object[] getPathsFromConnModel() {
        ILoConnectionModel iLoConnectionModel = this.loConn;
        if (iLoConnectionModel != null) {
            Object[] objectArray = iLoConnectionModel.getPaths();
            if (objectArray == null) {
                if (this.dbgOn()) {
                    db.println("getPathsFromConnModel() hit object not exist exception");
                }
                return new Object[0];
            }
            if (this.connType == 18 && objectArray.length == 1) {
                LinkedList<ILoDefModel> linkedList = new LinkedList<ILoDefModel>(Arrays.asList(objectArray));
                Iterator iterator = linkedList.iterator();
                ILoDefModel iLoDefModel = (ILoDefModel)iterator.next();
                LoDefModel loDefModel = new LoDefModel(this.getNodeModel(), null, null, iLoDefModel.getLoPathWidth(), iLoDefModel.getPathIdentifier(), 0);
                linkedList.add(0, loDefModel);
                return linkedList.toArray();
            }
            Object[] objectArray2 = objectArray;
            IRollModel iRollModel = this.getRoll();
            if (iRollModel == null) {
                if (this.dbgOn()) {
                    db.println("the connection is NOT involved in the roll");
                }
                return objectArray2;
            }
            if (this.dbgOn()) {
                db.println("the connection is involved in the roll");
            }
            Object[] objectArray3 = new Object[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray3[i] = this.isCompletedRollToPath(objectArray2[i], iRollModel) ? this.getRollFromPath(iRollModel) : objectArray2[i];
            }
            return objectArray3;
        }
        if (this.dbgOn()) {
            db.println("getPathsFromConnModel() hit object not exist exception");
        }
        return new LinkedList().toArray();
    }

    @Override
    protected Object[] getActivePathsFromConnModel() {
        ILoConnectionModel iLoConnectionModel = this.loConn;
        if (iLoConnectionModel != null) {
            return iLoConnectionModel.getActivePaths();
        }
        if (this.dbgOn()) {
            db.println("getActivePathsFromConnModel() hit object not exist exception");
        }
        return new LinkedList().toArray();
    }

    @Override
    protected int getProtectionOpFromConnModel() {
        ILoConnectionModel iLoConnectionModel = this.loConn;
        if (this.loConn != null) {
            return this.loConn.getProtectionOp();
        }
        if (this.dbgOn()) {
            db.println("getProtectionOpFromConnModel() hit object not exist exception");
        }
        return -1;
    }

    @Override
    protected int getReverseProtectionOpFromConnModel() {
        ILoConnectionModel iLoConnectionModel = this.loConn;
        if (iLoConnectionModel != null) {
            return iLoConnectionModel.getReverseProtectionOp();
        }
        if (this.dbgOn()) {
            db.println("getProtectionOpFromConnModel @ Node " + this.getName() + " with connection object deleted");
        }
        return -1;
    }

    @Override
    protected void activate() throws CircuitProvError {
        INetCircuit iNetCircuit = this.circuit.useLAP();
        if (iNetCircuit != null && this.getNetElement().getNodeId() == iNetCircuit.getPrimarySource().getNodeId()) {
            if (this.dbgOn()) {
                db.println("This circuit node is on LAP STS grooming end, no LO cross-connect needs to be created");
            }
            this.setConnectionType(this.findConnType());
            if (this.getConnectionType() == 22) {
                if (this.dbgOn()) {
                    db.println("Warning! createConnection at " + this.getName() + " connection type is unknown");
                }
                throw new CircuitProvError("An invalid connection type exists on " + this.getName() + ".");
            }
            this.setState(1);
            this.setCreateStage(3);
            this.numberOfPaths = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans();
            this.simulateConnection();
            return;
        }
        super.activate();
    }

    @Override
    protected void createSpliceListenersForSourcesAndDrops() {
        if (this.getConn() != null) {
            super.createSpliceListenersForSourcesAndDrops();
        }
    }

    @Override
    protected void createSpliceListener(NetCircuitEnd netCircuitEnd) {
        if (this.getConn() != null) {
            super.createSpliceListener(netCircuitEnd);
        }
    }

    protected NetCircuitSpan findNextBiSpanOnRoute(NetCircuitSpan netCircuitSpan) {
        IEntityModel[] iEntityModelArray = null;
        if (this.loConn != null) {
            iEntityModelArray = this.loConn.getPathEntities();
        }
        return this.findNextBiSpanOnRoute(iEntityModelArray, netCircuitSpan);
    }

    @Override
    public void setConnectionCircuitId(ICircuitId iCircuitId) {
        if (this.dbgOn()) {
            db.println("setting the connection circuit Id at " + this.getName() + " to " + NetCircuit.prettyString(iCircuitId));
        }
        if (this.loConn != null) {
            this.loConn.setCircuitId(iCircuitId);
            this.cktId = iCircuitId;
            if (!NetCircuit.isNullCircuitId(iCircuitId)) {
                this.deregisterNullCircuitConnection(this.getNetElement(), this.loConn);
            }
        }
    }

    @Override
    public ICircuitId getConnectionCircuitId() {
        try {
            if (this.loConn != null) {
                return this.loConn.getCircuitId();
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            return null;
        }
        return null;
    }

    @Override
    public int getUpsrReversionMode() {
        if (this.loConn != null) {
            return this.loConn.getUpsrReversion().getReversionMode();
        }
        return -1;
    }

    @Override
    public IConnectionModel getConn() {
        return this.loConn;
    }

    @Override
    protected void setConn(IConnectionModel iConnectionModel) {
        Object object = null;
        object = iConnectionModel instanceof IHoConnectionModel ? new LoConnModelSimulator((IHoConnectionModel)iConnectionModel, this) : iConnectionModel;
        this.loConn = (ILoConnectionModel)object;
    }

    @Override
    protected Object getRollFromPath(IRollModel iRollModel) {
        ILoRollModel iLoRollModel = (ILoRollModel)iRollModel;
        if (iLoRollModel != null) {
            return iLoRollModel.getRollFromPath();
        }
        return null;
    }

    @Override
    protected Object getRollToPath(IRollModel iRollModel) {
        ILoRollModel iLoRollModel = (ILoRollModel)iRollModel;
        if (iLoRollModel != null) {
            return iLoRollModel.getRollToPath();
        }
        return null;
    }

    @Override
    protected boolean isCompletedRollToPath(Object object, IRollModel iRollModel) {
        ILoRollModel iLoRollModel = (ILoRollModel)iRollModel;
        if (iLoRollModel == null) {
            return false;
        }
        try {
            if (iLoRollModel.getRollFinish() == 3) {
                NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), this.getRollToPath((IRollModel)iLoRollModel));
                NetCircuitEnd netCircuitEnd2 = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), object);
                if (netCircuitEnd2.equals(netCircuitEnd)) {
                    this.rollHasCompleted = true;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    @Override
    protected IRollModel getRoll() {
        ILoRollModel iLoRollModel = null;
        if (this.inRoll()) {
            try {
                iLoRollModel = this.getConn().getNodeModel().getConnectionModels().getLoRollModels(this.getConn().getIndex());
            }
            catch (NoSuchConnection noSuchConnection) {
                iLoRollModel = null;
            }
        }
        return iLoRollModel;
    }

    @Override
    protected boolean completeCheck() {
        if (this.getConn() == null) {
            if (this.dbgOn()) {
                db.println("this is the node on LAP HO grooming end which has no LO cross-connect");
            }
            return true;
        }
        return super.completeCheck();
    }

    @Override
    protected int findConnType() {
        INetCircuit iNetCircuit = this.circuit.useLAP();
        if (iNetCircuit != null && this.getNetElement().getNodeId() == iNetCircuit.getPrimarySource().getNodeId() && this.totalSpans() > 1) {
            if (this.dbgOn()) {
                db.println("One than one span on this LO circuit node of LAP STS grooming end");
            }
            return 22;
        }
        return super.findConnType();
    }

    @Override
    protected void removeActiveEndpoint(NetCircuitSpan netCircuitSpan) {
        if (this.getConn() == null) {
            return;
        }
        super.removeActiveEndpoint(netCircuitSpan);
    }

    protected void simulateConnection() {
        this.simulateConnection(null);
    }

    protected void simulateConnection(INetElement iNetElement, int n, IHoNum iHoNum, ILoNum iLoNum) {
        NetCircuitEnd netCircuitEnd = new NetCircuitEnd(iNetElement.getNodeId(), n, iHoNum, iLoNum, false);
        netCircuitEnd = NetCircuitEndFactory.convertCircuitEnd(this, netCircuitEnd);
        this.simulateConnection(netCircuitEnd);
    }

    protected void simulateConnection(NetCircuitEnd netCircuitEnd) {
        NetCircuitEnd netCircuitEnd2;
        NetCircuitEnd netCircuitEnd3;
        LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
        if (this.numberOfPaths != 2 && this.dbgOn()) {
            this.debug("simulateConnection():ERROR! paths != 2  at " + this.getName());
        }
        if (this.getSources().size() != 0) {
            netCircuitEnd3 = (NetCircuitEnd)this.getSources().get(0);
            netCircuitEnd2 = netCircuitEnd == null ? this.getSpanEndpoint((NetCircuitSpan)this.getOrigSpans().get(0)) : netCircuitEnd;
        } else {
            netCircuitEnd3 = netCircuitEnd == null ? this.getSpanEndpoint((NetCircuitSpan)this.getTermSpans().get(0)) : netCircuitEnd;
            netCircuitEnd2 = (NetCircuitEnd)this.getDrops().get(0);
        }
        linkedList.add(netCircuitEnd3);
        linkedList.add(netCircuitEnd2);
        this.updateConnectionPathEnds(linkedList);
    }

    @Override
    protected void setupConnListOnDiscovery() {
        if (this.circuit.getCktOperation() == 1) {
            return;
        }
        if (this.getConn() == null) {
            if (this.dbgOn()) {
                this.debug("setupConnListOnDiscovery at " + this.getName());
            }
            this.connections.clear();
            if (this.sources.size() + this.drops.size() != 1 || this.getAllSpansList().size() != 1) {
                db.println("setupConnListOnDiscovery: ERROR - invalid LAP connection on " + this.getName());
                return;
            }
            if (this.connType == 0) {
                OnewayConnection onewayConnection = new OnewayConnection("oneway1");
                this.connections.add(onewayConnection);
                if (this.sources.size() > 0) {
                    onewayConnection.addInput(this.sources.get(0));
                    onewayConnection.addOutput(this.getAllSpansList().get(0));
                } else if (this.drops.size() > 0) {
                    onewayConnection.addOutput(this.drops.get(0));
                    onewayConnection.addInput(this.getAllSpansList().get(0));
                }
            } else if (this.connType == 1) {
                OnewayConnection onewayConnection = new OnewayConnection("oneway1");
                this.connections.add(onewayConnection);
                OnewayConnection onewayConnection2 = new OnewayConnection("oneway2");
                this.connections.add(onewayConnection2);
                if (this.sources.size() > 0) {
                    onewayConnection.addInput(this.sources.get(0));
                    onewayConnection.addOutput(this.getAllSpansList().get(0));
                    onewayConnection2.addOutput(this.sources.get(0));
                    onewayConnection2.addInput(this.getAllSpansList().get(0));
                } else if (this.drops.size() > 0) {
                    onewayConnection.addOutput(this.drops.get(0));
                    onewayConnection.addInput(this.getAllSpansList().get(0));
                    onewayConnection2.addInput(this.drops.get(0));
                    onewayConnection2.addOutput(this.getAllSpansList().get(0));
                }
            }
            ConnectionsFactory.prettyPrintConnectionList(db, this.connType, this.connections, this.getName());
        } else {
            super.setupConnListOnDiscovery();
        }
    }

    @Override
    protected String validateConnAdminState(int n) {
        if (this.loConn == null) {
            return null;
        }
        return super.validateConnAdminState(n);
    }

    @Override
    protected void setConnAdminState(int n) throws AdminStateProvisioningError {
        if (this.loConn != null) {
            super.setConnAdminState(n);
        }
    }

    @Override
    public int getAdminState() {
        INetCircuitEnd iNetCircuitEnd;
        INetCircuit iNetCircuit = this.circuit.useLAP();
        if (iNetCircuit != null && (iNetCircuitEnd = iNetCircuit.getPrimarySource()) != null && this.getNetElement().getNodeId() == iNetCircuitEnd.getNodeId()) {
            return iNetCircuit.getSrcCircuitNode().getAdminState();
        }
        return super.getAdminState();
    }

    @Override
    public int getServiceState() {
        INetCircuitEnd iNetCircuitEnd;
        INetCircuit iNetCircuit = this.circuit.useLAP();
        if (iNetCircuit != null && (iNetCircuitEnd = iNetCircuit.getPrimarySource()) != null && this.getNetElement().getNodeId() == iNetCircuitEnd.getNodeId()) {
            return iNetCircuit.getSrcCircuitNode().getServiceState();
        }
        return super.getServiceState();
    }

    @Override
    protected NetCircuitNodeOperator getOperator() {
        return this.operator;
    }

    @Override
    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    @Override
    protected void debug(String string) {
        db.println(string);
    }

    public boolean isYLoNode() {
        return this.yLoNode;
    }
}

