/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AdminStateOpt;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.ConnCreateAttrs;
import cerent.cms.model.ConnectionHasFarendLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.DriNodeTypeOpt;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IDs123LineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IHoUpsrAttributes;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InsufficientBandwidth;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoDefModel;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.model.PathNotSupported;
import cerent.cms.model.SelectorAttrsOpt;
import cerent.cms.model.VcatMemberInvalidState;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.LoCircuitEnd;
import cerent.cms.ncp.LoCircuitNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.TL1ObjectManager;
import cerent.cms.topo.INetElement;
import cerent.util.EnumStrings;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LoCircuitNodeOperator
extends NetCircuitNodeOperator {
    private static final SDebug db = new SDebug("LoCircuitNodeOperator");

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    public LoCircuitNodeOperator(LoCircuitNode loCircuitNode) {
        super(loCircuitNode);
    }

    @Override
    protected void createConnection() throws CircuitProvError {
        ICircuitId iCircuitId = this.node.getCircuitId();
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        if (LoCircuitNodeOperator.dbgOn()) {
            db.println("createConnection(" + this.getName() + ")" + "; connType=" + EnumStrings.getString(IConnectionType.class, (int)this.node.getConnectionType()) + "; cktId=" + NetCcatCircuit.prettyString(iCircuitId));
        }
        try {
            this.createConnection(iCircuitId);
        }
        catch (CTCUserException cTCUserException) {
            if (LoCircuitNodeOperator.dbgOn()) {
                db.println("Exception while creating lo connection at " + this.getName());
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            String string = "A connection cannot be created on " + this.getName() + ".";
            if (cTCUserException instanceof NoMoreLoCapableHo) {
                string = string + "\n" + this.getNoLoCapableHoMessage() + " on " + this.getName();
            } else if (cTCUserException instanceof PathInUse) {
                string = string + "\nThe path is already in use.";
            } else if (cTCUserException instanceof PathNotSupported) {
                string = string + "\nThe path is not supported.";
            } else if (cTCUserException instanceof InsufficientBandwidth) {
                string = string + "\nThe bandwidth is insufficient.";
            } else if (cTCUserException instanceof InvalidState) {
                string = string + "\nThe administrative state is invalid.";
            }
            this.cleanupLoAdits();
            throw new CircuitProvError(string);
        }
        catch (AdminStateProvisioningError adminStateProvisioningError) {
            if (LoCircuitNodeOperator.dbgOn()) {
                db.println("Exception while creating connection at " + this.getName());
                SDebug.printStackTrace((Throwable)adminStateProvisioningError);
            }
            String string = "A connection cannot be created on " + this.getName() + ".";
            string = string + "\n" + adminStateProvisioningError.getMessage();
            this.cleanupLoAdits();
            throw new CircuitProvError(string);
        }
        if (this.getConn() == null) {
            if (LoCircuitNodeOperator.dbgOn()) {
                db.println("Connection Models returned NULL connection ");
            }
            throw new CircuitProvError("An error occurred while creating the connection object on " + this.getName() + ".");
        }
    }

    @Override
    protected void createConn(ICircuitId iCircuitId, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, int n, int n2, ArrayList arrayList4, ArrayList arrayList5) throws CircuitProvError, ConnectionTypeError, ObjNotFound, InvalidState, InvalidPath, PathInUse, CTCUserException, NoMoreLoCapableHo, InsufficientBandwidth, AdminStateProvisioningError {
        this.prettyPrint(arrayList.toArray(new ILoDefModel[0]), "input");
        this.prettyPrint(arrayList2.toArray(new ILoDefModel[0]), "output");
        this.prettyPrint(arrayList3.toArray(new ILoDefModel[0]), "omni");
        ILoDefModel[][] iLoDefModelArrayArray = new ILoDefModel[][]{arrayList.toArray(new ILoDefModel[0]), arrayList2.toArray(new ILoDefModel[0]), arrayList3.toArray(new ILoDefModel[0])};
        int[] nArray = new int[arrayList4.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList4.get(i);
        }
        boolean[] blArray = new boolean[arrayList5.size()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = (Boolean)arrayList5.get(i);
        }
        this.createLoConnOnNE(iCircuitId, iLoDefModelArrayArray, n, n2, nArray, blArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createLoConnOnNE(ICircuitId iCircuitId, ILoDefModel[][] iLoDefModelArray, int n, int n2, int[] nArray, boolean[] blArray) throws CircuitProvError, ConnectionTypeError, ObjNotFound, InvalidPath, PathInUse, CTCUserException, InvalidState, NoMoreLoCapableHo, AdminStateProvisioningError, InsufficientBandwidth {
        ILoDefModel[] iLoDefModelArray2 = iLoDefModelArray[0];
        ILoDefModel[] iLoDefModelArray3 = iLoDefModelArray[1];
        ILoDefModel[] iLoDefModelArray4 = iLoDefModelArray[2];
        ILoDefModel[] iLoDefModelArray5 = null;
        IConnectionModels iConnectionModels = this.node.getNodeModel().getConnectionModels();
        int n3 = this.node.getConnectionType();
        String string = this.node.getConnName();
        if (LoCircuitNodeOperator.dbgOn()) {
            db.println("createLoConnOnNE:connType=" + EnumStrings.getString(IConnectionType.class, (int)n3));
        }
        AdminStateOpt adminStateOpt = new AdminStateOpt();
        adminStateOpt.setAdminState(this.node.getAdminState());
        IHoUpsrAttributes iHoUpsrAttributes = this.node.getUpsrAttributes();
        ConnCreateAttrs connCreateAttrs = new ConnCreateAttrs();
        connCreateAttrs.setCktName(string);
        connCreateAttrs.setAdminStateOpt(adminStateOpt);
        connCreateAttrs.setSelectorAttrsOpt(null);
        DriNodeTypeOpt driNodeTypeOpt = new DriNodeTypeOpt(this.node.driNodeType);
        connCreateAttrs.setDriNodeTypeOpt(driNodeTypeOpt);
        if (!this.node.getNodeModel().provides(Feature.ENHANCED_STATE_MODEL) && 0 != this.node.getAdminState()) {
            db.info("PreOdin node " + this.getName() + " does not support admin state provisioning");
            throw new AdminStateProvisioningError("The node " + this.getName() + " does not support the circuit state " + NetCircuitNode.translateAdminState(this.node.getAdminState()) + ". Use the circuit state " + NetCircuitNode.translateAdminState(0) + " instead.");
        }
        Map map = TL1ObjectManager.instance().getTL1Conns();
        synchronized (map) {
            block30: {
                block39: {
                    block40: {
                        block31: {
                            block41: {
                                block38: {
                                    block37: {
                                        block36: {
                                            block35: {
                                                block34: {
                                                    block33: {
                                                        block32: {
                                                            if (n3 != 0) break block32;
                                                            int n4 = 1 + iLoDefModelArray3.length;
                                                            iLoDefModelArray5 = new ILoDefModel[n4];
                                                            iLoDefModelArray5[0] = iLoDefModelArray2[0];
                                                            System.arraycopy(iLoDefModelArray3, 0, iLoDefModelArray5, 1, iLoDefModelArray3.length);
                                                            break block30;
                                                        }
                                                        if (n3 != 9) break block33;
                                                        int n5 = 1 + iLoDefModelArray3.length;
                                                        iLoDefModelArray5 = new ILoDefModel[n5];
                                                        iLoDefModelArray5[0] = iLoDefModelArray2[0];
                                                        System.arraycopy(iLoDefModelArray3, 0, iLoDefModelArray5, 1, iLoDefModelArray3.length);
                                                        break block30;
                                                    }
                                                    if (n3 != 1) break block34;
                                                    iLoDefModelArray5 = new ILoDefModel[2];
                                                    if (LoCircuitNodeOperator.dbgOn()) {
                                                        db.println("Create LO Connection: createLoTwoWay");
                                                    }
                                                    if (iLoDefModelArray4.length == 2) {
                                                        iLoDefModelArray5[0] = iLoDefModelArray4[0];
                                                        iLoDefModelArray5[1] = iLoDefModelArray4[1];
                                                        break block30;
                                                    } else {
                                                        iLoDefModelArray5[0] = iLoDefModelArray2[0];
                                                        iLoDefModelArray5[1] = iLoDefModelArray3[0];
                                                    }
                                                    break block30;
                                                }
                                                if (n3 != 18) break block35;
                                                iLoDefModelArray5 = new ILoDefModel[1];
                                                if (LoCircuitNodeOperator.dbgOn()) {
                                                    db.println("Create LO Connection: DIAGNOSTIC");
                                                }
                                                iLoDefModelArray5[0] = iLoDefModelArray3[0];
                                                if (!this.node.getNodeModel().provides(Feature.DIAGNOSTIC_CONNECTION)) {
                                                    throw new ConnectionTypeError("The PRBS Generator feature is not supported on " + this.getName() + ".");
                                                }
                                                break block30;
                                            }
                                            if (n3 != 2) break block36;
                                            SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                                            selectorAttrsOpt.setHoUpsrAttributes(iHoUpsrAttributes);
                                            connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                                            iLoDefModelArray5 = new ILoDefModel[3];
                                            if (n == 2) {
                                                iLoDefModelArray5[0] = iLoDefModelArray2[0];
                                                iLoDefModelArray5[1] = iLoDefModelArray2[1];
                                                iLoDefModelArray5[2] = iLoDefModelArray3[0];
                                                break block30;
                                            } else {
                                                if (n2 != 2) {
                                                    if (!LoCircuitNodeOperator.dbgOn()) return;
                                                    db.println("Warning! createLoConnection: bad UPSR case");
                                                    return;
                                                }
                                                iLoDefModelArray5[0] = iLoDefModelArray3[0];
                                                iLoDefModelArray5[1] = iLoDefModelArray3[1];
                                                iLoDefModelArray5[2] = iLoDefModelArray2[0];
                                            }
                                            break block30;
                                        }
                                        if (n3 != 4) break block37;
                                        iLoDefModelArray5 = new ILoDefModel[]{iLoDefModelArray3[0], iLoDefModelArray3[1], iLoDefModelArray2[0]};
                                        break block30;
                                    }
                                    if (n3 != 3) break block38;
                                    SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                                    selectorAttrsOpt.setHoUpsrAttributes(iHoUpsrAttributes);
                                    connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                                    iLoDefModelArray5 = new ILoDefModel[]{iLoDefModelArray2[0], iLoDefModelArray2[1], iLoDefModelArray3[0], iLoDefModelArray3[1]};
                                    break block30;
                                }
                                if (n3 != 6) break block39;
                                SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                                selectorAttrsOpt.setHoUpsrAttributes(iHoUpsrAttributes);
                                connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                                int n6 = 2 + iLoDefModelArray3.length;
                                iLoDefModelArray5 = new ILoDefModel[n6];
                                if (iLoDefModelArray4.length <= 0) break block40;
                                if (iLoDefModelArray4.length != 2) break block41;
                                if (blArray[1] && !blArray[0]) {
                                    iLoDefModelArray5[0] = iLoDefModelArray2[0];
                                    iLoDefModelArray5[1] = iLoDefModelArray4[1];
                                    System.arraycopy(iLoDefModelArray3, 0, iLoDefModelArray5, 2, iLoDefModelArray3.length);
                                    break block31;
                                } else if (blArray[0] && !blArray[1]) {
                                    iLoDefModelArray5[0] = iLoDefModelArray2[0];
                                    iLoDefModelArray5[1] = iLoDefModelArray4[0];
                                    System.arraycopy(iLoDefModelArray3, 0, iLoDefModelArray5, 2, iLoDefModelArray3.length);
                                    break block31;
                                } else {
                                    if (!LoCircuitNodeOperator.dbgOn()) return;
                                    db.println("Error: Both omnispans cannot be in the source ring");
                                    return;
                                }
                            }
                            iLoDefModelArray5[0] = iLoDefModelArray2[0];
                            iLoDefModelArray5[1] = iLoDefModelArray4[0];
                            System.arraycopy(iLoDefModelArray3, 0, iLoDefModelArray5, 2, iLoDefModelArray3.length);
                        }
                        if (LoCircuitNodeOperator.dbgOn()) {
                            db.println("Unidir DRI circuit: UPSR_DC");
                        }
                        break block30;
                    }
                    if (nArray.length == 2 && nArray[0] > nArray[1]) {
                        iLoDefModelArray5[0] = iLoDefModelArray2[1];
                        iLoDefModelArray5[1] = iLoDefModelArray2[0];
                        System.arraycopy(iLoDefModelArray3, 0, iLoDefModelArray5, 2, iLoDefModelArray3.length);
                        break block30;
                    } else {
                        iLoDefModelArray5[0] = iLoDefModelArray2[0];
                        iLoDefModelArray5[1] = iLoDefModelArray2[1];
                        System.arraycopy(iLoDefModelArray3, 0, iLoDefModelArray5, 2, iLoDefModelArray3.length);
                    }
                    break block30;
                }
                if (n3 == 10) {
                    SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                    selectorAttrsOpt.setHoUpsrAttributes(iHoUpsrAttributes);
                    connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                    iLoDefModelArray5 = new ILoDefModel[3];
                    if (LoCircuitNodeOperator.dbgOn()) {
                        db.println("createUpsrDri(), omniSize=" + iLoDefModelArray4.length + " inSize=" + iLoDefModelArray2.length + " outSize=" + iLoDefModelArray3.length);
                    }
                    if (!blArray[0]) {
                        iLoDefModelArray5[0] = iLoDefModelArray3[0];
                        iLoDefModelArray5[1] = iLoDefModelArray4[0];
                        iLoDefModelArray5[2] = iLoDefModelArray2[0];
                    } else {
                        iLoDefModelArray5[0] = iLoDefModelArray2[0];
                        iLoDefModelArray5[1] = iLoDefModelArray4[0];
                        iLoDefModelArray5[2] = iLoDefModelArray3[0];
                    }
                } else {
                    if (n3 != 11) {
                        if (!LoCircuitNodeOperator.dbgOn()) return;
                        db.println("circuit Node: createLoConnection: Unknown connection type " + this.node.getConnectionType());
                        return;
                    }
                    SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                    selectorAttrsOpt.setHoUpsrAttributes(iHoUpsrAttributes);
                    connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                    iLoDefModelArray5 = new ILoDefModel[4];
                    if (LoCircuitNodeOperator.dbgOn()) {
                        db.println("invoking createUpsrIdri()");
                    }
                    if (blArray[1] && !blArray[0]) {
                        iLoDefModelArray5[0] = iLoDefModelArray2[0];
                        iLoDefModelArray5[1] = iLoDefModelArray4[1];
                        iLoDefModelArray5[2] = iLoDefModelArray3[0];
                        iLoDefModelArray5[3] = iLoDefModelArray4[0];
                    } else if (blArray[0] && !blArray[1]) {
                        iLoDefModelArray5[0] = iLoDefModelArray2[0];
                        iLoDefModelArray5[1] = iLoDefModelArray4[0];
                        iLoDefModelArray5[2] = iLoDefModelArray3[0];
                        iLoDefModelArray5[3] = iLoDefModelArray4[1];
                    } else {
                        if (!LoCircuitNodeOperator.dbgOn()) return;
                        db.println("Error: Both omnispans cannot be in the source ring");
                        return;
                    }
                }
            }
            ILoConnectionModel iLoConnectionModel = iConnectionModels.createLoConnection(iCircuitId, n3, iLoDefModelArray5, (IConnCreateAttrs)connCreateAttrs);
            if (iLoConnectionModel == null) return;
            this.node.setConn((IConnectionModel)iLoConnectionModel);
            this.getCircuit();
            if (!NetCcatCircuit.isNullCircuitId(iCircuitId)) return;
            this.node.registerNullCircuitConnection(this.node.getNetElement(), iLoConnectionModel);
            return;
        }
    }

    @Override
    protected void connLocalDestroy(boolean bl) throws Busy, ConnectionInTestAccess, ConnectionInRoll, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup, VcatMemberInvalidState, ConnectionHasFarendLoopback {
        if (bl) {
            ((ILoConnectionModel)this.getConn()).localDestroy(true);
        } else {
            ((ILoConnectionModel)this.getConn()).localDestroy();
        }
        this.cleanupLoAditsIfOldNe();
    }

    protected void cleanupLoAditsIfOldNe() {
        if (!this.node.getNodeModel().provides(Feature.TCCU)) {
            this.cleanupLoAdits();
        }
    }

    @Override
    protected void cleanupLoAdits() {
        int n;
        if (LoCircuitNodeOperator.dbgOn()) {
            db.println("Cleanup LO Adits at " + this.getName());
        }
        List list = this.node.getSources();
        for (n = 0; n < 2; ++n) {
            for (Object object : list) {
                ((LoCircuitEnd)object).cleanupLoAdit();
            }
            list = this.node.getDrops();
        }
        n = 0;
        list = this.node.getInSpans();
        while (n < 3) {
            for (Object object : list) {
                ((NetCircuitSpan)object).cleanupLoAdit(this.node.getNetElement());
            }
            list = ++n == 1 ? this.node.getOutSpans() : this.node.getBiSpans();
        }
    }

    @Override
    protected boolean isDropLinkEndpoint() {
        INetElement iNetElement = this.node.getNetElement();
        Iterator iterator = this.node.getSources().iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                for (NetCircuitSpan netCircuitSpan : this.node.getAllSpans().keySet()) {
                    if (netCircuitEnd.getEntityIndex() != netCircuitSpan.getEntityIndex(iNetElement) || netCircuitSpan.getLink().isLAP()) continue;
                    return true;
                }
            }
            iterator = this.node.getDrops().iterator();
        }
        return false;
    }

    @Override
    protected boolean hasMonitor() {
        ILoConnectionModel iLoConnectionModel;
        if (LoCircuitNodeOperator.dbgOn()) {
            db.println("hasMonitor at " + this.getName());
        }
        if (!this.node.hasConnection()) {
            return false;
        }
        return !this.node.getNetElement().getNodeModel().provides(Feature.NO_MONITORS) && this.node.getNetElement().getNodeModel().provides(Feature.CONN_HAS_MONITOR) && (iLoConnectionModel = (ILoConnectionModel)this.node.getConn()) != null && iLoConnectionModel.hasMonitor();
    }

    @Override
    protected void destroySanityCheck() throws SanityCheckFailed {
        ILoConnectionModel iLoConnectionModel;
        super.destroySanityCheck();
        if (LoCircuitNodeOperator.dbgOn()) {
            db.println("destroy sanity check at " + this.getName());
        }
        if (!this.node.hasConnection()) {
            return;
        }
        if (!this.node.getNetElement().getNodeModel().provides(Feature.NO_MONITORS) && this.node.getNetElement().getNodeModel().provides(Feature.CONN_HAS_MONITOR) && (iLoConnectionModel = (ILoConnectionModel)this.node.getConn()) != null && iLoConnectionModel.hasMonitor()) {
            String string = "The circuit " + this.node.getCircuit().getCircuitName() + " cannot be deleted because one or more " + "monitor circuits are present.\n" + "Delete the monitor circuits and try again.";
            throw new SanityCheckFailed(string);
        }
        if (this.node.getNetElement().getNodeModel().provides(Feature.BERT)) {
            Object object;
            int n;
            List list;
            block28: {
                HashMap hashMap;
                block26: {
                    block25: {
                        iLoConnectionModel = null;
                        try {
                            iLoConnectionModel = (ILoConnectionModel)this.node.getConn();
                        }
                        catch (Exception exception) {
                            if (!LoCircuitNodeOperator.dbgOn()) break block25;
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                    hashMap = null;
                    if (iLoConnectionModel != null) {
                        try {
                            hashMap = iLoConnectionModel.getDs1s();
                        }
                        catch (Exception exception) {
                            if (!LoCircuitNodeOperator.dbgOn()) break block26;
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                }
                if (hashMap != null) {
                    for (Map.Entry entry : hashMap.entrySet()) {
                        list = (List)entry.getValue();
                        if (list == null) continue;
                        int n2 = list.size();
                        for (n = 0; n < n2; ++n) {
                            int n3;
                            block27: {
                                n3 = 0;
                                try {
                                    if (list.get(n) instanceof IDs123LineModel) {
                                        n3 = ((IDs123LineModel)list.get(n)).getBERTMode();
                                    }
                                }
                                catch (Exception exception) {
                                    if (!LoCircuitNodeOperator.dbgOn()) break block27;
                                    SDebug.printStackTrace((Throwable)exception);
                                }
                            }
                            if (n3 != 2) continue;
                            String string = "The circuit " + this.node.getCircuit().getCircuitName() + " cannot be deleted because  " + "BERT is enabled .\n";
                            throw new SanityCheckFailed(string);
                        }
                    }
                }
                object = null;
                try {
                    object = ((ILoConnectionModel)this.node.getConn()).getPortModels();
                }
                catch (Exception exception) {
                    if (!LoCircuitNodeOperator.dbgOn()) break block28;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (object != null) {
                Map.Entry entry;
                entry = object.iterator();
                while (entry.hasNext()) {
                    block30: {
                        block29: {
                            list = null;
                            try {
                                IEntityModel iEntityModel = (IEntityModel)entry.next();
                                IPortModel iPortModel = (IPortModel)iEntityModel;
                                if (iPortModel.getInterfaceModel() instanceof IDs123LineModel) {
                                    list = (IDs123LineModel)iPortModel.getInterfaceModel();
                                }
                            }
                            catch (Exception exception) {
                                if (!LoCircuitNodeOperator.dbgOn()) break block29;
                                SDebug.printStackTrace((Throwable)exception);
                            }
                        }
                        n = 0;
                        try {
                            if (list != null) {
                                n = list.getBERTMode();
                            }
                        }
                        catch (Exception exception) {
                            if (!LoCircuitNodeOperator.dbgOn()) break block30;
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                    if (n != 2) continue;
                    String string = "The circuit " + this.node.getCircuit().getCircuitName() + " cannot be deleted because  " + "BERT is enabled .\n";
                    throw new SanityCheckFailed(string);
                }
            }
        }
    }

    @Override
    protected String prettyString(IPathDefModel iPathDefModel) {
        ILoDefModel iLoDefModel = (ILoDefModel)iPathDefModel;
        short s = 0;
        if (this.node.getNodeModel().provides(Feature.VCAT)) {
            s = iLoDefModel.getPathIdentifier();
        }
        return this.getName() + "::" + Integer.toHexString(iLoDefModel.getPortIndex()) + "::" + LoDefModel.physicalHo(iLoDefModel) + "::" + s;
    }

    private String prettyString(ILoDefModel iLoDefModel) {
        int n = NetCircuitNode.getEntityIndexFromLoDef(this.node.getNodeModel(), iLoDefModel);
        IHoPathDefModel iHoPathDefModel = iLoDefModel.getLoAdit().getHo();
        IHoNum iHoNum = HoPathDefModel.physicalHo(iHoPathDefModel);
        ILoNum iLoNum = iLoDefModel.getLoNum();
        short s = 0;
        if (iHoPathDefModel.getNodeModel().provides(Feature.VCAT)) {
            s = iLoDefModel.getPathIdentifier();
        }
        return this.getName() + "::" + Integer.toHexString(n) + "::" + iHoNum + "::" + iLoNum + "::" + s;
    }

    protected void prettyPrint(ILoDefModel[] iLoDefModelArray, String string) {
        for (int i = 0; i < iLoDefModelArray.length; ++i) {
            if (!LoCircuitNodeOperator.dbgOn()) continue;
            db.println(string + " LoPath #" + i + " " + this.prettyString(iLoDefModelArray[i]));
        }
    }
}

