/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.job.IJobControl;
import cerent.util.job.JobStatus;

class NetCircuitCreateWorker
implements IJobControl {
    NetCircuitNode cktNode;
    private static final SDebug db = new SDebug("NetCircuitCreateWorker");

    public NetCircuitCreateWorker(NetCircuitNode netCircuitNode) {
        this.cktNode = netCircuitNode;
    }

    public JobStatus executeJob() throws Exception {
        try {
            this.cktNode.activate();
        }
        catch (CircuitProvError circuitProvError) {
            if (NetCircuitManager.dbgOn()) {
                db.println("ADD: addWorker for node " + this.cktNode.getName() + " resulted in CircuitProvError!");
            }
            throw new AnnotatedException("A circuit provisioning error occurred.", (Exception)circuitProvError);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            this.cktNode.getOperator().cleanupLoAdits();
            throw new AnnotatedException("An unexpected exception occurred.", exception);
        }
        finally {
            this.cktNode = null;
        }
        return new JobStatus(4);
    }

    public String getName() {
        return "NetCktCreateWorker";
    }

    public void abortJob() {
    }
}

