/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.ICircuitFactoryModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoVcatTermModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoVcatTermModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.ISvlanCircuitModels;
import cerent.cms.model.IVcatTermModel;
import cerent.cms.model.IVcatTermModels;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetworkModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.NetVcatTermination;
import cerent.cms.ncp.TL1ObjectManager;
import cerent.cms.ncp.UpdateEventCollector;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.NetElemComparator;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.util.EventBus;
import cerent.util.IMetrics;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.InetUtil;
import cerent.util.LogLevel;
import cerent.util.PerformanceMetrics;
import cerent.util.SDebug;
import cerent.util.SvlanRange;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;

public class NetCircuitWatchDog
implements IObserver {
    private static final SDebug db = new SDebug("NetCircuitWatchDog");
    public DumpDebug dumpDb;
    private static NetCircuitWatchDog watchDog;
    private NetCircuitSplicer splicer;
    private NetElemComparator netElemComparator;
    private TL1ObjectManager tl1Mgr;
    private boolean enableSvlanCktDiscovery = true;
    private SortedSet cktInfoNodes;
    private SortedSet connNodes;
    private SortedSet<INetElement> svlanConnNodes;
    private SvlanRange[] svlanRange;
    public Object svlanDiscoveryObj = new Object();
    private SortedSet vcatTermNodes;
    private List updatedCircuits;
    private boolean updateCircuitNameMaps = false;
    private SortedSet cktNameMapNodes;
    private IMetrics metrics;

    private NetCircuitWatchDog() {
        this.splicer = NetCircuitSplicer.instance();
        this.netElemComparator = new NetElemComparator();
        this.cktInfoNodes = Collections.synchronizedSortedSet(new TreeSet(this.netElemComparator));
        this.connNodes = Collections.synchronizedSortedSet(new TreeSet(this.netElemComparator));
        this.vcatTermNodes = Collections.synchronizedSortedSet(new TreeSet(this.netElemComparator));
        this.svlanConnNodes = Collections.synchronizedSortedSet(new TreeSet(this.netElemComparator));
        this.tl1Mgr = TL1ObjectManager.instance();
        this.updatedCircuits = new LinkedList();
        this.cktNameMapNodes = Collections.synchronizedSortedSet(new TreeSet(this.netElemComparator));
        this.dumpDb = new DumpDebug("NetCircuitWatchDog");
        Thread thread = new Thread("NetCircuitWatchDog"){

            @Override
            public void run() {
                boolean bl = false;
                NetCircuitWatchDog.this.splicer.initialize();
                while (true) {
                    try {
                        while (true) {
                            1.sleep(5000L);
                            if (!bl) {
                                bl = Network.instance().getEnableCircuitDiscovery();
                                if (!db.on() || !bl) continue;
                                db.println("Starting circuit discovery");
                                continue;
                            }
                            EventBus.instance().notifyEvent((Object)NetCircuitManager.class.toString(), (Object)new Integer(1));
                            PerformanceMetrics performanceMetrics = PerformanceMetrics.getInstance();
                            NetCircuitWatchDog.this.metrics = performanceMetrics.getMetrics("generateCallbacks", IMetrics.circuitDb, LogLevel.FINE);
                            NetCircuitWatchDog.this.generateCallbacks();
                            NetCircuitWatchDog.this.discoverSvlanConnection();
                            NetCircuitWatchDog.this.metrics.stop();
                            NetCircuitWatchDog.this.splicer.generateCallbacks();
                            EventBus.instance().notifyEvent((Object)NetCircuitManager.class.toString(), (Object)new Integer(2));
                        }
                    }
                    catch (Exception exception) {
                        db.fine("Circuit Watch dog thread hit exception");
                        if (!db.isFinestEnabled()) continue;
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                        continue;
                    }
                    catch (Error error) {
                        db.fine("Circuit Watch dog thread hit error");
                        if (!db.isFinestEnabled()) continue;
                        db;
                        SDebug.printStackTrace((Throwable)error);
                        continue;
                    }
                    break;
                }
            }
        };
        thread.setName("CMS CircuitWatchdog");
        thread.start();
    }

    public static synchronized NetCircuitWatchDog instance() {
        if (watchDog == null) {
            if (NetCircuitWatchDog.dbgOn()) {
                NetCircuitWatchDog.debug("Creating a Circuit WatchDog");
            }
            watchDog = new NetCircuitWatchDog();
        }
        return watchDog;
    }

    private void newNetElement(INetElement iNetElement) {
        if (iNetElement != null) {
            this.cktInfoNodes.add(iNetElement);
        }
    }

    public void stopSvlanCktDiscovery() {
        this.enableSvlanCktDiscovery = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSvlanConnections(List<INetElement> list, SvlanRange[] svlanRangeArray) {
        if (svlanRangeArray == null || svlanRangeArray.length == 0) {
            return;
        }
        this.enableSvlanCktDiscovery = true;
        if (NetCircuitWatchDog.dbgOn()) {
            NetCircuitWatchDog.debug("Adding " + list.size() + " NEs to the svlanConnNodes");
            NetCircuitWatchDog.debug("SVLAN ranges are: " + svlanRangeArray.length);
            for (int i = 0; i < svlanRangeArray.length; ++i) {
                NetCircuitWatchDog.debug("- " + svlanRangeArray[i]);
            }
        }
        if (list != null) {
            SortedSet<INetElement> sortedSet = this.svlanConnNodes;
            synchronized (sortedSet) {
                this.svlanConnNodes.addAll(list);
                this.svlanRange = svlanRangeArray;
            }
        }
    }

    public boolean isSvlanDiscoveryInProgress() {
        return !this.svlanConnNodes.isEmpty();
    }

    public void reloadConnections(INetElement iNetElement) {
        if (iNetElement != null) {
            this.connNodes.add(iNetElement);
        }
    }

    public void reloadCircuitInfos(INetElement iNetElement) {
        if (iNetElement != null) {
            this.cktInfoNodes.add(iNetElement);
        }
    }

    public void reloadVcatTerms(INetElement iNetElement) {
        if (iNetElement != null) {
            this.vcatTermNodes.add(iNetElement);
        }
    }

    protected void queueCircuitNameMapUpdate() {
        if (!NetworkModel.isCtcInCtmMode()) {
            this.updateCircuitNameMaps = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueCircuitUpdate(NetCircuit netCircuit, Object object, String string) {
        String string2;
        Object object2;
        if (object instanceof NetCircuitNode) {
            object2 = (NetCircuitNode)object;
            string2 = "NCN " + ((NetCircuitNode)object2).getName() + " ";
        } else if (object instanceof NetVcatTermination) {
            string2 = "NVcatT ";
        } else if (object instanceof NetCcatCircuit) {
            object2 = (NetCcatCircuit)object;
            string2 = "NCcatCkt " + netCircuit.getCircuitName() + " ";
        } else if (object instanceof NetCircuitSpan) {
            string2 = " NCS ";
        } else if (object instanceof NetCircuit) {
            object2 = (NetCircuit)object;
            string2 = "NC " + netCircuit.getCircuitName() + " ";
        } else {
            string2 = "Misc ";
        }
        string2 = string2 + string;
        object2 = this.updatedCircuits;
        synchronized (object2) {
            if (netCircuit != null && !netCircuit.getUpdateEventQueued()) {
                this.updatedCircuits.add(netCircuit);
                netCircuit.setUpdateEventQueued(true);
                if (this.dumpDb.isEventLogEnabled()) {
                    UpdateEventCollector.instance().LogEvent(string2 + " event queued");
                }
            } else if (this.dumpDb.isEventLogEnabled()) {
                UpdateEventCollector.instance().LogEvent(string2 + " event not queued");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCallbacks() {
        Iterator abstractCmsIOException2;
        Object abstractCmsIOException;
        Object object2;
        Object object3;
        INodeModel iNodeModel;
        NetCircuit netCircuit;
        ICircuitModel[] iCircuitModelArray;
        INetElement iNetElement = null;
        NetCircuitManager netCircuitManager = NetCircuitManager.instance();
        LinkedList<INetElement> linkedList = new LinkedList<INetElement>();
        if (netCircuitManager == null) {
            if (NetCircuitWatchDog.dbgOn()) {
                NetCircuitWatchDog.debug("circuit manager is not yet instantiated- returning");
            }
            return;
        }
        while (true) {
            iCircuitModelArray = this.updatedCircuits;
            synchronized (iCircuitModelArray) {
                if (this.updatedCircuits.size() == 0) {
                    break;
                }
                netCircuit = (NetCircuit)this.updatedCircuits.remove(0);
                netCircuit.setUpdateEventQueued(false);
                if (this.dumpDb.isEventLogEnabled()) {
                    UpdateEventCollector.instance().LogEvent(" NCW: " + netCircuit.getCircuitName() + " event dequeued");
                }
            }
            netCircuit.runUpdate();
        }
        while (this.cktInfoNodes.size() != 0) {
            try {
                try {
                    iCircuitModelArray = this.cktInfoNodes;
                    synchronized (iCircuitModelArray) {
                        iNetElement = (INetElement)this.cktInfoNodes.first();
                        this.cktInfoNodes.remove(iNetElement);
                        if (this.dumpDb.isEventLogEnabled()) {
                            UpdateEventCollector.instance().LogEvent("NCW::genCallBack : cktInfoNodes dequeued");
                        }
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (!NetCircuitWatchDog.dbgOn()) break;
                    NetCircuitWatchDog.debug("Somehow the cktInfoNodes list became empty!");
                    break;
                }
                if (iNetElement == null) {
                    if (!NetCircuitWatchDog.dbgOn()) continue;
                    NetCircuitWatchDog.debug("NetElement is null!");
                    continue;
                }
                iNodeModel = iNetElement.getNodeModel();
                if (iNodeModel == null) {
                    if (!NetCircuitWatchDog.dbgOn()) continue;
                    NetCircuitWatchDog.debug(iNetElement.getName() + "NodeModel is null!");
                    continue;
                }
                if (!iNodeModel.isInited()) {
                    if (NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug(iNetElement.getName() + ": node not initialized");
                        NetCircuitWatchDog.debug("putting back in queue");
                    }
                    linkedList.add(iNetElement);
                    continue;
                }
                ICircuitFactoryModel iCircuitFactoryModel = iNodeModel.getCircuitFactoryModel();
                iCircuitModelArray = iCircuitFactoryModel.getCircuits();
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("=================================================");
                    NetCircuitWatchDog.debug("Received " + iCircuitModelArray.length + " circuit(s) from " + iNetElement.getName());
                    NetCircuitWatchDog.debug("=================================================");
                }
                for (int i = 0; i < iCircuitModelArray.length; ++i) {
                    ICircuitId iCircuitId;
                    boolean bl = false;
                    if (iCircuitModelArray[i].getSize() == 31) {
                        boolean bl2 = false;
                        if (NetCircuitWatchDog.dbgOn()) {
                            NetCircuitWatchDog.debug("Found a circuit with size SIZE_OCH_TRAIL...");
                        }
                        if ((object3 = iCircuitModelArray[i].getNodeModel()) != null && object3.getNeType() != null && object3.getNeType().indexOf("crs") != -1) {
                            bl2 = true;
                        }
                        object2 = iCircuitModelArray[i].getDropInfo();
                        int n = object2[0].getDropPoint().getNodeId();
                        String object4 = InetUtil.makeDottedString(n);
                        INetElement iNetElement2 = Network.instance().findNetElemByIp(object4);
                        if (iNetElement2 == null && bl2) {
                            if (!NetCircuitWatchDog.dbgOn()) continue;
                            NetCircuitWatchDog.debug("DST NE null for this crs ochtrail, skipping, will come back later");
                            continue;
                        }
                        if (iNetElement2 != null && iNetElement2.getNodeModel() != null && iNetElement2.getNodeModel().getNeType() != null && iNetElement2.getNodeModel().getNeType().indexOf("crs") != -1) {
                            if (NetCircuitWatchDog.dbgOn()) {
                                NetCircuitWatchDog.debug("crs ochtrail circuit, fix nodeid");
                            }
                            object2[0].getDropPoint().setNodeId(iNetElement2.getNodeId());
                            iCircuitModelArray[i].setSize(19);
                            bl = true;
                        }
                    }
                    try {
                        iCircuitId = iCircuitModelArray[i].getId();
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        continue;
                    }
                    catch (Exception exception) {
                        SDebug.printStackTrace((Throwable)exception);
                        continue;
                    }
                    netCircuit = (NetCircuit)netCircuitManager.getCircuitFromId(iCircuitId);
                    try {
                        if (netCircuit != null) {
                            if (bl && iCircuitModelArray[i].getName().equals("")) {
                                try {
                                    iCircuitModelArray[i].setName(netCircuit.getCircuitName());
                                }
                                catch (InvalidCircuitName invalidCircuitName) {
                                    // empty catch block
                                }
                            }
                            netCircuit.addDiscoveredCircuitInfo(iNodeModel, iCircuitModelArray[i]);
                            netCircuitManager.insertCircuitIfLAP(netCircuit);
                            continue;
                        }
                        NetCircuitFactory.newCircuitFromCircuitInfo(iNodeModel, iCircuitModelArray[i]);
                        continue;
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        if (!NetCircuitWatchDog.dbgOn()) continue;
                        NetCircuitWatchDog.debug("Discovered circuitInfo does not exist.");
                    }
                }
                if (iCircuitModelArray.length != 0 && NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("=================================================");
                    NetCircuitWatchDog.debug("Done processing circuits from " + iNetElement.getName());
                    NetCircuitWatchDog.debug("=================================================");
                }
                this.connNodes.add(iNetElement);
                this.vcatTermNodes.add(iNetElement);
                ModelIndirectObservable.instance().addObserver((IObservable)iCircuitFactoryModel, this);
            }
            catch (AbstractCmsIOException abstractCmsIOException3) {
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug(abstractCmsIOException3.toString() + " exception at node " + (iNetElement != null ? iNetElement.getName() : "UNKNOWN") + ", will try after 6 seconds");
                }
                if (iNetElement == null) continue;
                linkedList.add(iNetElement);
            }
        }
        this.metrics.lap("CircuitModel processing completed");
        if (linkedList.size() != 0) {
            this.cktInfoNodes.addAll(linkedList);
        }
        iCircuitModelArray = new LinkedList();
        LinkedList<INetElement> linkedList2 = new LinkedList<INetElement>();
        while (this.connNodes.size() != 0) {
            try {
                try {
                    abstractCmsIOException = this.connNodes;
                    synchronized (abstractCmsIOException) {
                        iNetElement = (INetElement)this.connNodes.first();
                        this.connNodes.remove(iNetElement);
                        if (this.dumpDb.isEventLogEnabled()) {
                            UpdateEventCollector.instance().LogEvent("NCW::genCallBack: connNodes dequeued");
                        }
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (!NetCircuitWatchDog.dbgOn()) break;
                    NetCircuitWatchDog.debug("Somehow the connNodes list became empty!");
                    break;
                }
                if (iNetElement == null) {
                    if (!NetCircuitWatchDog.dbgOn()) continue;
                    NetCircuitWatchDog.debug("NetElement is null!");
                    continue;
                }
                iNodeModel = iNetElement.getNodeModel();
                if (iNodeModel == null) {
                    if (!NetCircuitWatchDog.dbgOn()) continue;
                    NetCircuitWatchDog.debug(iNetElement.getName() + "NodeModel is null!");
                    continue;
                }
                if (!iNodeModel.isInited()) {
                    if (NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug(iNetElement.getName() + ": node not initialized");
                        NetCircuitWatchDog.debug("putting back in queue");
                    }
                    linkedList2.add(iNetElement);
                    continue;
                }
                IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
                List<IHoConnectionModel> list = Arrays.asList(iConnectionModels.getHoConnectionModels());
                List<ILoConnectionModel> list2 = Arrays.asList(iConnectionModels.getLoConnectionModels());
                List<ILoAditModel> list3 = Arrays.asList(iConnectionModels.getLoAditModels());
                object3 = Arrays.asList(iConnectionModels.getOchncConnectionModels());
                object2 = Arrays.asList(iConnectionModels.getOchccConnectionModels());
                List<IOchTrailAditModel> list4 = Arrays.asList(iConnectionModels.getOchTrailAditModels());
                iCircuitModelArray.add(list);
                iCircuitModelArray.add(list2);
                iCircuitModelArray.add(list3);
                iCircuitModelArray.add(object3);
                iCircuitModelArray.add(object2);
                iCircuitModelArray.add(list4);
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("=================================================");
                    NetCircuitWatchDog.debug("Got " + list.size() + " HO-Conn, " + list2.size() + " LO-Conn, " + list3.size() + " LoAdit(s),");
                    NetCircuitWatchDog.debug("    " + object3.size() + " Ochnc-Conn, " + object2.size() + " OchCC-Conn, " + list4.size() + " OchTrailAdit(s) from " + iNetElement.getName());
                    NetCircuitWatchDog.debug("=================================================");
                }
                this.splicer.synchronizeSpliceListeners();
                for (List list5 : iCircuitModelArray) {
                    this.discoverCircuitFromConnectionList(list5);
                }
                if (iCircuitModelArray.size() != 0 && NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("=================================================");
                    NetCircuitWatchDog.debug("Done processing connections from " + iNetElement.getName());
                    NetCircuitWatchDog.debug("=================================================");
                }
                ModelIndirectObservable.instance().addObserver((IObservable)iConnectionModels, this);
                iCircuitModelArray.clear();
            }
            catch (AbstractCmsIOException abstractCmsIOException4) {
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug(abstractCmsIOException4.toString() + " exception at node " + (iNetElement != null ? iNetElement.getName() : "UNKNOWN") + ", will try connections after 6 seconds");
                }
                if (iNetElement == null) continue;
                linkedList2.add(iNetElement);
            }
        }
        this.metrics.lap("ConnectionModel processing completed");
        if (linkedList2.size() != 0) {
            this.connNodes.addAll(linkedList2);
        }
        abstractCmsIOException = new LinkedList();
        iCircuitModelArray.clear();
        while (this.vcatTermNodes.size() != 0) {
            try {
                try {
                    abstractCmsIOException2 = this.vcatTermNodes;
                    synchronized (abstractCmsIOException2) {
                        iNetElement = (INetElement)this.vcatTermNodes.first();
                        this.vcatTermNodes.remove(iNetElement);
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (!NetCircuitWatchDog.dbgOn()) break;
                    NetCircuitWatchDog.debug("Somehow the vcatTermNodes list became empty!");
                    break;
                }
                if (iNetElement == null) {
                    if (!NetCircuitWatchDog.dbgOn()) continue;
                    NetCircuitWatchDog.debug("NetElement is null!");
                    continue;
                }
                iNodeModel = iNetElement.getNodeModel();
                if (iNodeModel == null) {
                    if (!NetCircuitWatchDog.dbgOn()) continue;
                    NetCircuitWatchDog.debug(iNetElement.getName() + "NodeModel is null!");
                    continue;
                }
                if (!iNodeModel.isInited()) {
                    if (NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug(iNetElement.getName() + ": node not initialized");
                        NetCircuitWatchDog.debug("putting back in queue");
                    }
                    abstractCmsIOException.add((INetElement)iNetElement);
                    continue;
                }
                IVcatTermModels iVcatTermModels = iNodeModel.getVcatTermModels();
                List<IHoVcatTermModel> list = Arrays.asList(iVcatTermModels.getHoVcatTermModels());
                List<ILoVcatTermModel> list6 = Arrays.asList(iVcatTermModels.getLoVcatTermModels());
                iCircuitModelArray.add(list);
                iCircuitModelArray.add(list6);
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("=================================================");
                    NetCircuitWatchDog.debug("Got " + list.size() + " HO-VcatTerm, " + list6.size() + " LO-VcatTerm from " + iNetElement.getName());
                    NetCircuitWatchDog.debug("=================================================");
                }
                for (List list7 : iCircuitModelArray) {
                    this.discoverVCATFromTermList(list7);
                }
                if (iCircuitModelArray.size() != 0 && NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("=================================================");
                    NetCircuitWatchDog.debug("Done processing vcat term from " + iNetElement.getName());
                    NetCircuitWatchDog.debug("=================================================");
                }
                ModelIndirectObservable.instance().addObserver((IObservable)iVcatTermModels, this);
                iCircuitModelArray.clear();
            }
            catch (AbstractCmsIOException abstractCmsIOException5) {
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug(abstractCmsIOException5.toString() + " exception at node " + (iNetElement != null ? iNetElement.getName() : "UNKNOWN") + ", will try after 6 seconds");
                }
                if (iNetElement == null) continue;
                abstractCmsIOException.add((INetElement)iNetElement);
            }
        }
        this.metrics.lap("VcatTermModel processing completed");
        if (abstractCmsIOException.size() != 0) {
            this.vcatTermNodes.addAll(abstractCmsIOException);
        }
        abstractCmsIOException2 = Network.instance();
        Collection collection = ((Network)((Object)abstractCmsIOException2)).getElements();
        if (this.updateCircuitNameMaps) {
            this.updateCircuitNameMaps = false;
            if (NetCircuitWatchDog.dbgOn() && collection.size() > 0) {
                NetCircuitWatchDog.debug("Queuing circuit name map update for " + collection.size() + " nodes ");
            }
            for (Object object : collection) {
                this.cktNameMapNodes.add(object);
            }
        }
        SortedSet sortedSet = this.cktNameMapNodes;
        synchronized (sortedSet) {
            Object object;
            object = this.cktNameMapNodes.iterator();
            while (object.hasNext()) {
                INetElement iNetElement3 = (INetElement)object.next();
                if (!collection.contains(iNetElement3)) {
                    object.remove();
                    continue;
                }
                iNodeModel = iNetElement3.getNodeModel();
                if (iNodeModel.isInited() && netCircuitManager.setNodeCircuitNameMap(iNodeModel)) {
                    object.remove();
                    continue;
                }
                if (!NetCircuitWatchDog.dbgOn()) continue;
                NetCircuitWatchDog.debug("Re-queuing circuit name map update at " + iNetElement3.getName());
                NetCircuitWatchDog.debug("Node not initialized or caught I/O exception");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverSvlanConnection() {
        INetElement iNetElement = null;
        INodeModel iNodeModel = null;
        ISvlanCircuitModels iSvlanCircuitModels = null;
        List list = new LinkedList();
        if (this.svlanConnNodes.size() != 0) {
            SortedSet<INetElement> sortedSet;
            while (this.svlanConnNodes.size() != 0 && this.enableSvlanCktDiscovery) {
                try {
                    try {
                        sortedSet = this.svlanConnNodes;
                        synchronized (sortedSet) {
                            iNetElement = this.svlanConnNodes.first();
                            this.svlanConnNodes.remove(iNetElement);
                            if (this.dumpDb.isEventLogEnabled()) {
                                UpdateEventCollector.instance().LogEvent("NCW::discoverSvlanConnection: svlanConnNodes dequeued");
                            }
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        if (!NetCircuitWatchDog.dbgOn()) break;
                        NetCircuitWatchDog.debug("Somehow the svlanConnNodes list became empty!");
                        break;
                    }
                    if (iNetElement == null) {
                        if (!NetCircuitWatchDog.dbgOn()) continue;
                        NetCircuitWatchDog.debug("NetElement is null!");
                        continue;
                    }
                    iNodeModel = iNetElement.getNodeModel();
                    if (iNodeModel == null) {
                        if (!NetCircuitWatchDog.dbgOn()) continue;
                        NetCircuitWatchDog.debug(iNetElement.getName() + "NodeModel is null!");
                        continue;
                    }
                    if (!iNodeModel.isInited()) {
                        if (!NetCircuitWatchDog.dbgOn()) continue;
                        NetCircuitWatchDog.debug(iNetElement.getName() + ": node not initialized");
                        continue;
                    }
                    iSvlanCircuitModels = iNodeModel.getSvlanCircuitModels();
                    if (iSvlanCircuitModels == null) continue;
                    list = iSvlanCircuitModels.getSvlanConnectionModels(this.svlanRange);
                    if (NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug("================== SVLAN ========================");
                        NetCircuitWatchDog.debug("Got " + list.size() + " SVLAN Conn from " + iNetElement.getName());
                        NetCircuitWatchDog.debug("=================================================");
                    }
                    if (!list.isEmpty()) {
                        this.discoverCircuitFromConnectionList(list);
                    }
                    if (list.size() != 0 && NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug("=================== SVLAN =======================");
                        NetCircuitWatchDog.debug("Done processing connections from " + iNetElement.getName());
                        NetCircuitWatchDog.debug("=================================================");
                    }
                    list.clear();
                }
                catch (Exception exception) {
                    if (!NetCircuitWatchDog.dbgOn()) continue;
                    NetCircuitWatchDog.debug(exception.toString() + " exception at node " + (iNetElement != null ? iNetElement.getName() : "UNKNOWN"));
                }
            }
            if (!this.enableSvlanCktDiscovery) {
                this.svlanConnNodes.clear();
            }
            sortedSet = this.svlanDiscoveryObj;
            synchronized (sortedSet) {
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("svlanDiscoveryObj is notifiyng the end of the process.");
                }
                this.svlanDiscoveryObj.notify();
            }
        }
        this.metrics.lap("ConnectionModel processing completed");
    }

    public void update(IObservable iObservable, Object object) {
        Network network = Network.instance();
        if (iObservable instanceof IConnectionModels) {
            INetElement iNetElement;
            INodeModel iNodeModel = ((IConnectionModels)iObservable).getNodeModel();
            try {
                iNetElement = network.findNetElem(iNodeModel);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                iNetElement = null;
            }
            if (iNetElement == null && NetCircuitWatchDog.dbgOn()) {
                NetCircuitWatchDog.debug("Watchdog unable to find NetElem in update method");
                NetCircuitWatchDog.debug(" Was searching for node with NodeId " + Integer.toHexString(iNodeModel.getNodeId()));
            }
            if (((Integer)object).equals(ModelUpdateType.ADDED)) {
                if (iNetElement != null) {
                    this.connNodes.add(iNetElement);
                    if (this.dumpDb.isEventLogEnabled()) {
                        UpdateEventCollector.instance().LogEvent("NCW::update : " + Integer.toHexString(iNodeModel.getNodeId()) + " added to connNodes");
                    }
                    if (NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug("ConnectionModels changed at " + iNetElement.getName());
                    }
                }
            } else if (((Integer)object).equals(ModelUpdateType.DELETED) && iObservable instanceof IConnectionModels) {
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("Got a deleted message for ConnectionModels");
                }
                if (iNetElement != null) {
                    if (NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug("Queuing circuitNameMap update at " + iNetElement.getName());
                    }
                    this.cktNameMapNodes.add(iNetElement);
                }
            }
        } else if (iObservable instanceof ICircuitFactoryModel) {
            if (((Integer)object).equals(ModelUpdateType.ADDED)) {
                INetElement iNetElement;
                INodeModel iNodeModel = ((ICircuitFactoryModel)iObservable).getNodeModel();
                try {
                    iNetElement = network.findNetElem(iNodeModel);
                    if (iNetElement == null && NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug("Watchdog unable to find NetElem in update method");
                        NetCircuitWatchDog.debug(" Was searching for node with NodeId " + Integer.toHexString(iNodeModel.getNodeId()));
                    }
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    iNetElement = null;
                }
                if (iNetElement != null) {
                    this.cktInfoNodes.add(iNetElement);
                    if (this.dumpDb.isEventLogEnabled()) {
                        UpdateEventCollector.instance().LogEvent("NCW::update : " + Integer.toHexString(iNodeModel.getNodeId()) + " added to cktInfoNodes");
                    }
                    if (NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug("CktFactory changed at " + iNetElement.getName());
                    }
                }
            } else if (((Integer)object).equals(ModelUpdateType.DELETED) && NetCircuitWatchDog.dbgOn()) {
                NetCircuitWatchDog.debug("Got a deleted message for CircuitFactoryModel");
            }
        } else if (iObservable instanceof IVcatTermModels) {
            if (((Integer)object).equals(ModelUpdateType.ADDED)) {
                INetElement iNetElement;
                INodeModel iNodeModel = ((IVcatTermModels)iObservable).getNodeModel();
                try {
                    iNetElement = network.findNetElem(iNodeModel);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    iNetElement = null;
                }
                if (iNetElement == null) {
                    if (NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug("Watchdog unable to find NetElem in update method");
                        NetCircuitWatchDog.debug(" Was searching for node with NodeId " + Integer.toHexString(iNodeModel.getNodeId()));
                    }
                } else {
                    this.vcatTermNodes.add(iNetElement);
                    if (NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug("VcatTermModels changed at " + iNetElement.getName());
                    }
                }
            } else if (((Integer)object).equals(ModelUpdateType.DELETED) && NetCircuitWatchDog.dbgOn()) {
                NetCircuitWatchDog.debug("Got a deleted message for VcatTermModels");
            }
        } else if (iObservable instanceof Network.NetElementCreationNotifier) {
            if (object instanceof NetElement) {
                NetElement netElement = (NetElement)object;
                if (db.on()) {
                    db.println("update: received notification about new NE " + netElement.getHostName());
                }
                if (netElement.getNodeId() == 0 || netElement.getNodeId() == -1) {
                    netElement.addObserver(this);
                } else {
                    this.newNetElement(netElement);
                }
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("Queuing circuitNameMap update at " + netElement.getName());
                }
                this.cktNameMapNodes.add(netElement);
            }
        } else if (iObservable instanceof NetElement && object == ModelUpdateType.CHANGED) {
            NetElement netElement = (NetElement)iObservable;
            if (db.on()) {
                db.println("update: received CHANGED event from NE " + netElement.getHostName());
            }
            if (netElement.getNodeId() != 0 && netElement.getNodeId() != -1) {
                if (db.on()) {
                    db.println("update: NE has valid node ID, adding new NE");
                }
                netElement.deleteObserver(this);
                this.newNetElement(netElement);
            }
        }
    }

    public void discoverCircuitFromConnectionList(List list) {
        INetElement iNetElement = null;
        NetCircuitManager netCircuitManager = NetCircuitManager.instance();
        for (IConnectionModel iConnectionModel : list) {
            INetCircuit iNetCircuit;
            ICircuitId iCircuitId;
            iNetElement = Network.instance().findNetElem(iConnectionModel.getNodeModel());
            try {
                iCircuitId = NetCircuitNode.getConnCircuitId(iConnectionModel);
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                continue;
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                continue;
            }
            if (iCircuitId.getUniquePart().getUniqueId() == 0) {
                if (iConnectionModel instanceof ILoAditModel || iConnectionModel instanceof IOchTrailAditModel) continue;
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("Connection with null connection Id");
                }
                if (this.tl1Mgr.hasTL1Object(iNetElement, iConnectionModel)) {
                    if (!NetCircuitWatchDog.dbgOn()) continue;
                    NetCircuitWatchDog.debug("Already seen-skipping");
                    continue;
                }
            }
            if ((iNetCircuit = netCircuitManager.getCircuitFromId(iCircuitId)) != null && !(iNetCircuit instanceof NetCcatCircuit)) {
                iNetCircuit.addWrongConnObj(iConnectionModel);
                continue;
            }
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iNetCircuit;
            try {
                if (netCcatCircuit != null) {
                    if (NetCircuitWatchDog.dbgOn()) {
                        db.println("adding connection to existing circuit circuit id(in conn) = " + NetCircuit.prettyString(iCircuitId));
                    }
                    netCcatCircuit.addDiscoveredConnection(iNetElement, iConnectionModel);
                    continue;
                }
                if (NetCircuitWatchDog.dbgOn()) {
                    db.println("creating new circuit from conn circuit id(in conn) = " + NetCircuit.prettyString(iCircuitId));
                }
                NetCircuitFactory.newCircuitFromConn(iNetElement, iConnectionModel);
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (!NetCircuitWatchDog.dbgOn()) continue;
                NetCircuitWatchDog.debug("Discovered connection does not exist.");
            }
        }
    }

    public void discoverVCATFromTermList(List list) {
        if (NetCircuitWatchDog.dbgOn()) {
            db.println("Watch Dog : discoverVCATFromTermList.");
        }
        IVcatTermModel iVcatTermModel2 = null;
        NetCircuitManager netCircuitManager = NetCircuitManager.instance();
        for (IVcatTermModel iVcatTermModel2 : list) {
            ICircuitId iCircuitId;
            INetElement iNetElement = Network.instance().findNetElem(iVcatTermModel2.getNodeModel());
            try {
                iCircuitId = iVcatTermModel2.getCircuitId();
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                continue;
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                continue;
            }
            if (iCircuitId.getUniquePart().getUniqueId() == 0) {
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("vcat term with null circuit Id");
                }
                if (this.tl1Mgr.hasTL1Object(iNetElement, iVcatTermModel2)) {
                    if (!NetCircuitWatchDog.dbgOn()) continue;
                    NetCircuitWatchDog.debug("Already seen-skipping");
                    continue;
                }
            }
            NetVcatCircuit netVcatCircuit = (NetVcatCircuit)netCircuitManager.getCircuitFromId(iCircuitId);
            try {
                if (netVcatCircuit != null) {
                    netVcatCircuit.addDiscoveredVcatTerm(iNetElement, iVcatTermModel2);
                    continue;
                }
                NetCircuitFactory.newCircuitFromVcatTerm(iNetElement, iVcatTermModel2);
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (!NetCircuitWatchDog.dbgOn()) continue;
                NetCircuitWatchDog.debug("Discovered vcat term does not exist.");
            }
        }
    }

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    private static void debug(String string) {
        db.println(string);
    }

    public class DumpDebug
    extends SDebug {
        private boolean updateEventLogEnabled;
        public static final String HenableEventLog = "enables update event logging, arg is number of lines in event buffer";
        public static final String HdisableEventLog = "disables update event logging";
        public static final String HdumpEventLog = "dump the update event log";

        public DumpDebug(String string) {
            super(string);
            this.updateEventLogEnabled = false;
        }

        public final void enableEventLog(int n) {
            UpdateEventCollector.EnableUpdateEventCollector(n);
            this.updateEventLogEnabled = true;
        }

        public final boolean isEventLogEnabled() {
            return this.updateEventLogEnabled;
        }

        public final void disableEventLog() {
            if (this.updateEventLogEnabled) {
                UpdateEventCollector.instance().DisableUpdateEventCollector();
            }
            this.updateEventLogEnabled = false;
        }

        public final void dumpEventLog() {
            if (this.updateEventLogEnabled) {
                UpdateEventCollector.instance().DumpEventLog(db);
            }
        }
    }
}

