/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitId;
import cerent.cms.model.CircuitType;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoUpsrAttributes;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.IVcatTermModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.InvalidParms;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.ProvisionError;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnTypeUnsupported;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.Endpoints;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.INetVcatGroup;
import cerent.cms.ncp.INetVcatTermination;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetVcatCircuitOperator;
import cerent.cms.ncp.NetVcatGroup;
import cerent.cms.ncp.NetVcatTermination;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLinkComparator;
import cerent.cms.vlan.NetVlanInfo;
import cerent.util.AnnotatedException;
import cerent.util.IHoLoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NetVcatCircuit
extends NetCircuit {
    private NetVcatGroup forwardVcatGroup = new NetVcatGroup(this);
    private NetVcatGroup reverseVcatGroup = null;
    private RoutePrefs routePrefs;
    private NetVcatCircuitOperator operator = new NetVcatCircuitOperator(this);
    protected List ccat2VcatList = new LinkedList();
    protected List vcat2CcatList = new LinkedList();
    private boolean oVcat = false;
    private static final SDebug db = new SDebug("NetVcatCircuit");

    @Override
    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    @Override
    protected void debug(String string) {
        db.println(string);
    }

    protected NetVcatCircuit(CircuitCreatInfo circuitCreatInfo) {
        super(circuitCreatInfo);
        this.oVcat = circuitCreatInfo.isOVcat();
    }

    protected NetVcatCircuit(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd) {
        this(circuitCreatInfo);
        this.setCktOperation(1);
        this.addSources(circuitCreatInfo, iNetCircuitEnd);
    }

    protected NetVcatCircuit(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
        this(circuitCreatInfo);
        this.setCktOperation(1);
        this.addSources(circuitCreatInfo, iNetCircuitEnd, iNetCircuitEnd2);
    }

    protected NetVcatCircuit(CircuitCreatInfo circuitCreatInfo, INodeModel iNodeModel, ICircuitModel iCircuitModel) throws AbstractCmsObjectNotExistException {
        this(circuitCreatInfo);
        this.initState(4);
        this.addDiscoveredCircuitInfo(iNodeModel, iCircuitModel);
        this.clearChanged();
    }

    protected NetVcatCircuit(CircuitCreatInfo circuitCreatInfo, INetElement iNetElement, Object object) {
        this(circuitCreatInfo);
        ICircuitId iCircuitId = ((IVcatTermModel)object).getCircuitId();
        if (iCircuitId == null) {
            if (this.dbgOn()) {
                db.println("Warning! Unable to get circuit ID");
            }
            return;
        }
        this.updateCircuitId(iCircuitId);
        int n = ((IVcatTermModel)object).getPortIndex();
        CircuitEnd circuitEnd = new CircuitEnd(iNetElement.getNodeId(), n, null, null, false, 0);
        NetCircuitEnd netCircuitEnd = new NetCircuitEnd(iNetElement.getNodeModel(), circuitEnd);
        netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.getCircuitType(), netCircuitEnd);
        this.discoverVcatTerm(netCircuitEnd, object);
        if (this.isCircuitRefValid()) {
            if (!NetVcatCircuit.isNullCircuitId(iCircuitId)) {
                this.initState(4);
            } else {
                if (this.inRoll()) {
                    this.initState(8);
                } else {
                    this.initState(6);
                }
                this.tl1CircuitCompleteCheck();
            }
            this.serviceState = this.deriveServiceState();
            this.setProtType();
        }
        this.clearChanged();
    }

    protected void addSources(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd) {
        if (iNetCircuitEnd != null) {
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(circuitCreatInfo.type(), iNetCircuitEnd);
            this.circuitInfo.setSrcPoint(netCircuitEnd.getCircuitEnd());
            this.setSource(netCircuitEnd);
            NetVcatTermination netVcatTermination = new NetVcatTermination(this, netCircuitEnd, circuitCreatInfo);
            this.forwardVcatGroup.addCreatedVcatTerm(circuitCreatInfo, circuitCreatInfo.forwardMembers(), iNetCircuitEnd, null, netVcatTermination);
            netCircuitEnd.setStage(2);
        }
    }

    protected void addSources(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
        NetCircuitEnd netCircuitEnd;
        NetVcatTermination netVcatTermination = null;
        NetVcatTermination netVcatTermination2 = null;
        if (iNetCircuitEnd != null) {
            netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(circuitCreatInfo.type(), iNetCircuitEnd);
            this.circuitInfo.setSrcPoint(netCircuitEnd.getCircuitEnd());
            this.setSource(netCircuitEnd);
            netVcatTermination = new NetVcatTermination(this, netCircuitEnd, circuitCreatInfo);
            netCircuitEnd.setStage(2);
        }
        if (iNetCircuitEnd2 != null) {
            netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(circuitCreatInfo.type(), iNetCircuitEnd2);
            this.circuitInfo.setSecSrcPoint(netCircuitEnd.getCircuitEnd());
            this.insertSource(netCircuitEnd);
            netVcatTermination2 = new NetVcatTermination(this, netCircuitEnd, circuitCreatInfo);
            netCircuitEnd.setStage(2);
        }
        if (netVcatTermination != null && netVcatTermination2 != null) {
            this.forwardVcatGroup.addCreatedVcatTerm(circuitCreatInfo, circuitCreatInfo.forwardMembers(), iNetCircuitEnd, iNetCircuitEnd2, netVcatTermination, netVcatTermination2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDiscoveredVcatTerm(INetElement iNetElement, Object object) throws AbstractCmsIOException {
        NetVcatCircuit netVcatCircuit = this;
        synchronized (netVcatCircuit) {
            Object object2;
            if (!this.isCircuitRefValid()) {
                return;
            }
            int n = ((IVcatTermModel)object).getPortIndex();
            NetCircuitEnd netCircuitEnd = this.getNetCktEnd(iNetElement, n);
            if (netCircuitEnd == null) {
                object2 = new CircuitEnd(iNetElement.getNodeId(), n, null, null, false, 0);
                netCircuitEnd = new NetCircuitEnd(iNetElement.getNodeModel(), (ICircuitEnd)object2);
                netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.getCircuitType(), netCircuitEnd);
            }
            if ((object2 = (NetVcatTermination)this.getVcatTermFromCktEnd(netCircuitEnd)) != null) {
                if (((NetVcatTermination)object2).deletedEventPending()) {
                    if (this.dbgOn()) {
                        this.debug("Processing vcatTerm delete event for " + this.getCircuitName() + "(" + NetVcatCircuit.prettyString(this.circuitId) + ")" + " at " + iNetElement.getName());
                    }
                    this.disposeVcatTerm((NetVcatTermination)object2, false);
                } else {
                    return;
                }
            }
            if (this.dbgOn()) {
                this.debug("Adding discovered vcat termination to " + this.getCircuitName() + "(" + NetVcatCircuit.prettyString(this.circuitId) + ")" + " at " + iNetElement.getName());
            }
            this.discoverVcatTerm(netCircuitEnd, object);
            if (this.isCircuitRefValid() && !this.completeCheck()) {
                this.setState(4);
            }
        }
        if (!this.isCircuitRefValid()) {
            this.notifyDeleted();
        } else {
            this.notifyChanged();
        }
    }

    private void discoverVcatTerm(NetCircuitEnd netCircuitEnd, Object object) {
        NetVcatTermination netVcatTermination = new NetVcatTermination(this, netCircuitEnd, object);
        if (netVcatTermination.getDirection() == 1) {
            if (!this.circuitInfoActive()) {
                if (this.getSourcesSize() == 0) {
                    this.insertSource(netCircuitEnd);
                    this.updateCircuitSourceInfo();
                } else {
                    this.insertDrop(new NetCircuitDropInfo(netCircuitEnd, 9));
                    this.updateCircuitDropInfo();
                }
            }
            this.forwardVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
        } else if (this.getCircuitDir() == 1) {
            if (!this.circuitInfoActive()) {
                if (this.getSourcesSize() == 0) {
                    this.insertSource(netCircuitEnd);
                    this.updateCircuitSourceInfo();
                } else {
                    this.insertDrop(new NetCircuitDropInfo(netCircuitEnd, 9));
                    this.updateCircuitDropInfo();
                }
            }
            if (this.isSource(netCircuitEnd)) {
                this.forwardVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
                if (this.reverseVcatGroup == null) {
                    this.reverseVcatGroup = new NetVcatGroup(this);
                }
                this.reverseVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
            } else if (this.isDrop(netCircuitEnd)) {
                this.forwardVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
                if (this.reverseVcatGroup == null) {
                    this.reverseVcatGroup = new NetVcatGroup(this);
                }
                this.reverseVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
            } else {
                this.forwardVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
                if (this.reverseVcatGroup == null) {
                    this.reverseVcatGroup = new NetVcatGroup(this);
                }
                this.reverseVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
            }
        } else if (netVcatTermination.getConfiguredNumOfMembers(1) != 0 && netVcatTermination.getConfiguredNumOfMembers(0) == 0) {
            if (!this.circuitInfoActive()) {
                this.insertSource(netCircuitEnd);
                this.updateCircuitSourceInfo();
            }
            this.forwardVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
        } else if (netVcatTermination.getConfiguredNumOfMembers(1) == 0 && netVcatTermination.getConfiguredNumOfMembers(0) != 0) {
            if (!this.circuitInfoActive()) {
                this.insertDrop(new NetCircuitDropInfo(netCircuitEnd, 9));
                this.updateCircuitDropInfo();
            }
            this.forwardVcatGroup.addDiscoveredVcatTerm(netVcatTermination);
        }
        if (!this.circuitInfoActive()) {
            this.setSrcCircuitNode();
        }
    }

    @Override
    public INetVcatGroup getForwardVcatGroup() {
        return this.forwardVcatGroup;
    }

    @Override
    public INetVcatGroup getReverseVcatGroup() {
        return this.reverseVcatGroup;
    }

    @Override
    public int getConfiguredForwardMemberSize() {
        NetVcatTermination netVcatTermination = (NetVcatTermination)this.getVcatTermFromCktEnd(this.getPrimarySource());
        if (netVcatTermination == null) {
            netVcatTermination = (NetVcatTermination)this.getVcatTermFromCktEnd(this.getPrimaryDrop());
        }
        if (netVcatTermination == null) {
            return 0;
        }
        return this.forwardVcatGroup.getConfiguredNumOfMembers(netVcatTermination);
    }

    @Override
    public int getConfiguredReverseMemberSize() {
        NetVcatTermination netVcatTermination = (NetVcatTermination)this.getVcatTermFromCktEnd(this.getPrimarySource());
        if (netVcatTermination == null) {
            netVcatTermination = (NetVcatTermination)this.getVcatTermFromCktEnd(this.getPrimaryDrop());
        }
        if (netVcatTermination == null) {
            return 0;
        }
        return this.reverseVcatGroup.getConfiguredNumOfMembers(netVcatTermination);
    }

    public List getAllMemberCircuits() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.forwardVcatGroup.getAllMemberCircuits());
        if (this.reverseVcatGroup != null) {
            linkedList.addAll(this.reverseVcatGroup.getAllMemberCircuits());
        }
        return linkedList;
    }

    public List getAllVcatTerms() {
        return this.forwardVcatGroup.getAllVcatTerms();
    }

    @Override
    public void setAdminState(int n) throws IncorrectCircuitState, AdminStateProvisioningError {
        LinkedList<NetCcatCircuit> linkedList = new LinkedList<NetCcatCircuit>();
        for (NetCcatCircuit netCcatCircuit : this.getAllMemberCircuits()) {
            if (netCcatCircuit.isMemberInGroup()) {
                netCcatCircuit.setAdminState(n);
                continue;
            }
            linkedList.add(netCcatCircuit);
        }
        for (NetCcatCircuit netCcatCircuit : linkedList) {
            netCcatCircuit.setAdminState(n);
        }
        this.adminState = n;
        this.setChanged();
        this.notifyChanged();
    }

    protected RoutePrefs getRoutePrefs() {
        return this.routePrefs;
    }

    public void setRoutePrefs(RoutePrefs routePrefs) {
        this.routePrefs = routePrefs;
    }

    @Override
    public synchronized void addDrop(INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs) throws AllocFailed, CircuitDropOutstanding, ObjNotFound, SanityCheckFailed, IncorrectCircuitState {
        this.operator.addDrop(iNetCircuitEnd, routePrefs);
    }

    protected void routeCurrentDrop(INetElement iNetElement, RoutePrefs routePrefs, boolean bl) throws SanityCheckFailed, NoRoute, AllocFailed, AbstractCmsIOException {
        this.operator.routeCurrentDrop(iNetElement, routePrefs, bl);
    }

    @Override
    public void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
        this.operator.deleteDrop(iNetCircuitEnd);
    }

    @Override
    public synchronized void destroySanityCheck() throws SanityCheckFailed {
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            ((NetCcatCircuit)iterator.next()).destroySanityCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyCircuit() throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        NetVcatCircuit netVcatCircuit = this;
        synchronized (netVcatCircuit) {
            this.operator.destroyCircuit();
        }
        this.notifyDeleted();
    }

    private void deleteCircuits(INetCircuit[] iNetCircuitArray) throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        this.operator.deleteCircuits(iNetCircuitArray);
    }

    public synchronized void disposeVcatTerm(NetVcatTermination netVcatTermination, boolean bl) {
        if (netVcatTermination == null) {
            if (this.dbgOn()) {
                db.println("disposeVcatTerm: vcat term not known!");
            }
            return;
        }
        if (this.dbgOn()) {
            db.println("Disposing vcat term from " + NetVcatCircuit.prettyString(this.circuitId) + " at Node " + netVcatTermination.getNodeName() + " for circuit " + this.getCircuitName());
        }
        netVcatTermination.dispose();
        this.forwardVcatGroup.removeVcatTermination(netVcatTermination);
        if (this.reverseVcatGroup != null) {
            this.reverseVcatGroup.removeVcatTermination(netVcatTermination);
        }
        if (bl) {
            if (!this.circuitInfoActive()) {
                if (!this.tl1CircuitCompleteCheck()) {
                    this.checkAndUpdateCircuit();
                }
            } else if (!this.completeCheck()) {
                this.checkAndUpdateCircuit();
            }
        }
    }

    @Override
    protected synchronized void dispose() {
        if (this.dbgOn()) {
            db.println("dispose circuit: " + this.getCircuitName());
        }
        super.destroy();
        this.deleteCircuitInfoObserver();
        this.forwardVcatGroup.dispose();
        if (this.reverseVcatGroup != null) {
            this.reverseVcatGroup.dispose();
        }
    }

    @Override
    public synchronized LinkedList sanityCheckSRGs() throws SanityCheckFailed {
        return this.operator.sanityCheckSRGs();
    }

    @Override
    public synchronized void sanityCheckManualRouting() throws SanityCheckFailed {
        this.operator.sanityCheckManualRouting();
    }

    protected List getRefCktLinkInfo(NetCcatCircuit netCcatCircuit) {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        List list = netCcatCircuit.getCircuitSpans();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            linkedList.add(((NetCircuitSpan)iterator.next()).getLink());
        }
        NetLinkComparator netLinkComparator = new NetLinkComparator();
        Collections.sort(linkedList, netLinkComparator);
        return linkedList;
    }

    protected boolean shareCommonFiber(NetCcatCircuit netCcatCircuit, List list) {
        if (netCcatCircuit.isUpsrCircuit()) {
            return false;
        }
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        List list2 = netCcatCircuit.getCircuitSpans();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            linkedList.add(((NetCircuitSpan)iterator.next()).getLink());
        }
        NetLinkComparator netLinkComparator = new NetLinkComparator();
        Collections.sort(linkedList, netLinkComparator);
        Collections.sort(list, netLinkComparator);
        if (list.size() != linkedList.size()) {
            return false;
        }
        Iterator iterator2 = list.iterator();
        Iterator iterator3 = linkedList.iterator();
        while (iterator2.hasNext() && iterator3.hasNext()) {
            INetLink iNetLink = (INetLink)iterator2.next();
            INetLink iNetLink2 = (INetLink)iterator3.next();
            if (iNetLink != null ? iNetLink.physicalLinkEquals(iNetLink2) : iNetLink2 == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void sanityCheck() throws SanityCheckFailed {
        this.operator.sanityCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String string) throws CircuitProvError {
        NetVcatCircuit netVcatCircuit = this;
        synchronized (netVcatCircuit) {
            this.operator.rename(string);
        }
        this.notifyChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void provision() throws NoRoute, ConnTypeUnsupported, SanityCheckFailed, CircuitProvError, AnnotatedException {
        boolean bl;
        NetVcatCircuit netVcatCircuit = this;
        synchronized (netVcatCircuit) {
            bl = this.operator.provision();
        }
        if (bl) {
            this.clearChanged();
            this.ncMgr.notifyChanged(this);
        } else {
            this.notifyChanged();
        }
    }

    @Override
    synchronized boolean completeCheck() {
        if (this.dbgOn()) {
            db.println("completeCheck() for " + this.getCircuitName());
        }
        if (this.inRoll()) {
            this.setState(8);
        }
        if (!this.circuitInfoActive()) {
            if (this.dbgOn()) {
                db.println("Circuit Info is not active");
            }
            return false;
        }
        if (!this.setSrcCircuitNode()) {
            return false;
        }
        if (!this.forwardVcatGroup.completeCheck()) {
            return false;
        }
        if (this.reverseVcatGroup != null && !this.reverseVcatGroup.completeCheck()) {
            return false;
        }
        if (this.inRoll()) {
            return true;
        }
        this.setState(1);
        if (this.dbgOn()) {
            db.println("completeCheck passed. Setting the state to ACTIVE");
        }
        return true;
    }

    protected synchronized boolean tl1CircuitCompleteCheck() {
        if (this.dbgOn()) {
            db.println("tl1CircuitCompleteCheck() for " + this.getCircuitName());
        }
        if (this.circuitInfoActive()) {
            if (this.dbgOn()) {
                db.println("circuit Info is Active : CTC ckt.");
            }
            return false;
        }
        this.initSourcesAndDrops();
        if (!this.forwardVcatGroup.completeCheck()) {
            return false;
        }
        if (this.reverseVcatGroup != null && !this.reverseVcatGroup.completeCheck()) {
            return false;
        }
        if (this.inRoll()) {
            this.setState(8);
        } else {
            try {
                if (this.isTl1Ckt()) {
                    this.setState(5);
                } else {
                    this.setState(4);
                }
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                // empty catch block
            }
        }
        if (this.dbgOn()) {
            db.println("tl1CircuitCompleteCheck passed");
        }
        return true;
    }

    @Override
    protected synchronized void checkAndUpdateCircuit() {
        if (this.dbgOn()) {
            this.debug("calling checkAndUpdateCircuit on " + this.getCircuitName());
        }
        if (this.getAllVcatTerms().size() == 0) {
            if (this.getAllMemberCircuits().size() == 0) {
                if (this.circuitModel == null) {
                    this.finalDispose();
                    return;
                }
            } else {
                this.forwardVcatGroup.convertMemberCircuits();
                if (this.reverseVcatGroup != null) {
                    this.reverseVcatGroup.convertMemberCircuits();
                }
                if (this.circuitModel == null) {
                    this.finalDispose();
                    return;
                }
            }
        }
        if (!this.circuitInfoActive()) {
            this.initSourcesAndDrops();
        }
        if (this.inRoll()) {
            this.setState(8);
        } else if (this.getState() == 5 || this.getState() == 6) {
            this.setState(6);
        } else if (this.getState() != 2 && this.getState() != 0) {
            this.setState(4);
        }
    }

    protected void initSourcesAndDrops() {
        NetCircuitDropInfo netCircuitDropInfo;
        if (this.circuitInfoActive()) {
            return;
        }
        if (this.dbgOn()) {
            db.println("initSourcesAndDrops() called");
        }
        List list = this.getAllVcatTerms();
        List list2 = this.getAllMemberCircuits();
        if (list.size() == 0) {
            return;
        }
        if (list2.size() == 0) {
            int n = this.getSourcesSize() + this.getDropsSize();
            if (n != list.size()) {
                this.setSources(null);
                this.setDrops(null);
                this.setChanged();
                Iterator iterator = list.iterator();
                NetVcatTermination netVcatTermination = (NetVcatTermination)iterator.next();
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)netVcatTermination.getNetCktEnd();
                this.insertSource(netCircuitEnd);
                while (iterator.hasNext()) {
                    netVcatTermination = (NetVcatTermination)iterator.next();
                    NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)netVcatTermination.getNetCktEnd();
                    NetCircuitDropInfo netCircuitDropInfo2 = new NetCircuitDropInfo(netCircuitEnd2, 9);
                    this.insertDrop(netCircuitDropInfo2);
                }
                this.updateCircuitSourceInfo();
                this.updateCircuitDropInfo();
                this.setSrcCircuitNode();
            }
            return;
        }
        NetCircuitEnd netCircuitEnd = null;
        NetCircuitEnd netCircuitEnd3 = null;
        NetCircuitEnd netCircuitEnd4 = null;
        NetCircuitEnd netCircuitEnd5 = null;
        NetCircuitEnd netCircuitEnd6 = null;
        NetCircuitEnd netCircuitEnd7 = null;
        NetCircuitEnd netCircuitEnd8 = null;
        NetCircuitEnd netCircuitEnd9 = null;
        NetVcatTermination netVcatTermination = null;
        NetVcatTermination netVcatTermination2 = null;
        NetVcatTermination netVcatTermination3 = null;
        NetVcatTermination netVcatTermination4 = null;
        NetCcatCircuit netCcatCircuit2 = null;
        NetCircuit netCircuit = null;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            netVcatTermination = null;
            netVcatTermination3 = null;
            netVcatTermination2 = null;
            netVcatTermination4 = null;
            netCcatCircuit2 = (NetCcatCircuit)iterator.next();
            if (netCcatCircuit2.getPrimarySource() != null && netCcatCircuit2.getPrimarySource().getNodeId() != 0) {
                netCircuitEnd = netCcatCircuit2.getTermEndFromCktEnd(netCcatCircuit2.getPrimarySource());
                netVcatTermination = (NetVcatTermination)this.getVcatTermFromCktEnd(netCircuitEnd);
            }
            if (netCcatCircuit2.getSecondarySource() != null && netCcatCircuit2.getSecondarySource().getNodeId() != 0) {
                netCircuitEnd3 = netCcatCircuit2.getTermEndFromCktEnd(netCcatCircuit2.getSecondarySource());
                netVcatTermination2 = (NetVcatTermination)this.getVcatTermFromCktEnd(netCircuitEnd3);
            }
            if (netCcatCircuit2.getPrimaryDrop() != null && netCcatCircuit2.getPrimaryDrop().getNodeId() != 0) {
                netCircuitEnd4 = netCcatCircuit2.getTermEndFromCktEnd(netCcatCircuit2.getPrimaryDrop());
                netVcatTermination3 = (NetVcatTermination)this.getVcatTermFromCktEnd(netCircuitEnd4);
            }
            if (netCcatCircuit2.getSecondaryDrop() != null && netCcatCircuit2.getSecondaryDrop().getNodeId() != 0) {
                netCircuitEnd5 = netCcatCircuit2.getTermEndFromCktEnd(netCcatCircuit2.getSecondaryDrop());
                netVcatTermination4 = (NetVcatTermination)this.getVcatTermFromCktEnd(netCircuitEnd5);
            }
            if (list.size() == 1) {
                if (netVcatTermination != null && netVcatTermination3 == null) {
                    netCircuit = netCcatCircuit2;
                    netCircuitEnd6 = netCircuitEnd;
                    netCircuitEnd8 = null;
                    break;
                }
                if (netVcatTermination == null && netVcatTermination3 != null) {
                    netCircuit = netCcatCircuit2;
                    netCircuitEnd6 = null;
                    netCircuitEnd8 = netCircuitEnd4;
                    break;
                }
            }
            if (list.size() == 2 && NetCircuit.isBackHaulVcatCircuit(this)) {
                netCircuit = netCcatCircuit2;
                if (netVcatTermination != null && netVcatTermination2 != null) {
                    netCircuitEnd6 = netCircuitEnd;
                    netCircuitEnd7 = netCircuitEnd3;
                    netCircuitEnd8 = null;
                    netCircuitEnd9 = null;
                    continue;
                }
                if (netVcatTermination3 == null || netVcatTermination4 == null) continue;
                netCircuitEnd8 = netCircuitEnd4;
                netCircuitEnd9 = netCircuitEnd5;
                netCircuitEnd6 = null;
                netCircuitEnd7 = null;
                continue;
            }
            if (list.size() == 3) {
                if (netVcatTermination != null && netVcatTermination2 != null) {
                    netCircuitEnd6 = netCircuitEnd;
                    netCircuitEnd7 = netCircuitEnd3;
                    netCircuitEnd8 = netCircuitEnd4;
                    netCircuitEnd9 = null;
                }
                if (netVcatTermination3 != null && netVcatTermination4 != null) {
                    netCircuitEnd8 = netCircuitEnd4;
                    netCircuitEnd9 = netCircuitEnd5;
                    netCircuitEnd6 = netCircuitEnd;
                    netCircuitEnd7 = null;
                }
                netCircuit = netCcatCircuit2;
                continue;
            }
            if (list.size() == 4) {
                netCircuit = netCcatCircuit2;
                netCircuitEnd6 = netCircuitEnd;
                netCircuitEnd7 = netCircuitEnd3;
                netCircuitEnd8 = netCircuitEnd4;
                netCircuitEnd9 = netCircuitEnd5;
                continue;
            }
            if (netVcatTermination == null || netVcatTermination3 == null) continue;
            netCircuit = netCcatCircuit2;
            netCircuitEnd6 = netCircuitEnd;
            netCircuitEnd8 = netCircuitEnd4;
            break;
        }
        if (this.dbgOn()) {
            if (netCircuit != null && netCircuitEnd6 != null && netCircuitEnd8 != null) {
                db.println("found a member circuit that matches both src and drop vcat terms: " + netCircuit.getCircuitName());
            } else if (netCircuit != null && netCircuitEnd6 == null && netCircuitEnd8 != null) {
                db.println("found a member circuit matches only drop vcat term (open-ended vcat ckt): " + netCircuit.getCircuitName());
            } else if (netCircuit != null && netCircuitEnd6 != null && netCircuitEnd8 == null) {
                db.println("found a member circuit matches only src vcat term (open-ended vcat ckt): " + netCircuit.getCircuitName());
            } else if (netCircuit == null && netCircuitEnd6 == null && netCircuitEnd8 == null) {
                db.println("didn't find any member circuit matches src or drop vcat termination, exit");
            }
        }
        if (netCircuit == null) {
            return;
        }
        this.setSources(null);
        this.setDrops(null);
        this.setChanged();
        for (NetCcatCircuit netCcatCircuit2 : list2) {
            if (netCcatCircuit2 == netCircuit) continue;
            netCcatCircuit2.initSourcesAndDrops(netCircuitEnd6, netCircuitEnd8);
        }
        if (netCircuitEnd6 != null) {
            this.insertSource(netCircuitEnd6);
        }
        if (netCircuitEnd7 != null) {
            this.insertSource(netCircuitEnd7);
        }
        if (netCircuitEnd8 != null) {
            netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd8, 9);
            this.insertDrop(netCircuitDropInfo);
        }
        if (netCircuitEnd9 != null) {
            netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd9, 9);
            this.insertDrop(netCircuitDropInfo);
        }
        this.updateCircuitSourceInfo();
        this.updateCircuitDropInfo();
        this.setSrcCircuitNode();
    }

    @Override
    protected boolean isTl1Ckt() throws IncorrectCircuitState {
        if (this.circuitInfoActive()) {
            if (this.dbgOn()) {
                this.debug("isTL1Ckt: " + this.getCircuitName() + ": CircuitInfo is ACTIVE !!");
            }
            throw new IncorrectCircuitState("The circuit information has been discovered.");
        }
        CircuitId circuitId = new CircuitId(0, 0);
        CircuitId circuitId2 = new CircuitId(0, 0);
        boolean bl = false;
        boolean bl2 = false;
        for (NetVcatTermination netVcatTermination : this.getAllVcatTerms()) {
            circuitId = netVcatTermination.getCircuitId();
            if (this.dbgOn()) {
                this.debug("isTl1Ckt: For ckt = " + this.getCircuitName() + " ;On node :" + netVcatTermination.getNodeName() + " has cktId = " + NetVcatCircuit.prettyString(circuitId));
            }
            if (NetVcatCircuit.isNullCircuitId(circuitId)) {
                bl2 = true;
                continue;
            }
            if (bl) {
                if (((Object)circuitId).equals(circuitId2)) continue;
                if (this.dbgOn()) {
                    this.debug("isTl1Ckt: " + this.getCircuitName() + " failed:Found two circuitIds " + circuitId2 + " and " + circuitId);
                }
                throw new IncorrectCircuitState("The circuit has multiple circuit IDs.");
            }
            bl = true;
            circuitId2 = circuitId;
        }
        if (this.dbgOn()) {
            this.debug("isTl1Ckt: " + this.getCircuitName() + bl2 + " Non-null cktId = " + NetVcatCircuit.prettyString(circuitId2));
        }
        if (NetVcatCircuit.isNullCircuitId(this.circuitId) && !NetVcatCircuit.isNullCircuitId(circuitId2) || !NetVcatCircuit.isNullCircuitId(this.circuitId) && NetVcatCircuit.isNullCircuitId(circuitId2)) {
            this.ncMgr.removeCircuit(this);
            this.updateCircuitId(circuitId2);
            this.ncMgr.insertCircuit(this, false);
        }
        return bl2;
    }

    public synchronized INetCircuit[] createNewMemberCkts(CircuitCreatInfo circuitCreatInfo) {
        return this.forwardVcatGroup.createMemberCircuit(circuitCreatInfo, circuitCreatInfo.forwardMembers(), this.getPrimarySource(), this.getSecondarySource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNewMemberCkts() throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        NetVcatCircuit netVcatCircuit = this;
        synchronized (netVcatCircuit) {
            this.operator.deleteNewMemberCkts();
        }
        this.notifyChanged();
    }

    public synchronized void addDropForNewMemberCkts() throws AllocFailed, CircuitDropOutstanding, ObjNotFound, SanityCheckFailed, IncorrectCircuitState {
        List list = this.getNewMemberCkts();
        for (NetCcatCircuit netCcatCircuit : list) {
            INetCircuitEnd iNetCircuitEnd = this.getPrimaryDrop();
            db.fine("memberDropHoLo=" + netCcatCircuit.memberDropHoLo);
            if (netCcatCircuit.memberDropHoLo != null) {
                iNetCircuitEnd = NetCircuitEndFactory.createCircuitEnd(netCcatCircuit.getCircuitType(), iNetCircuitEnd);
                iNetCircuitEnd.setHoLoNum(netCcatCircuit.memberDropHoLo);
            }
            netCcatCircuit.addDrop(iNetCircuitEnd, null);
            INetCircuitEnd iNetCircuitEnd2 = this.getSecondaryDrop();
            if (iNetCircuitEnd2 == null) continue;
            db.fine("memberSecDropHoLo=" + netCcatCircuit.memberSecDropHoLo);
            if (netCcatCircuit.memberSecDropHoLo != null) {
                iNetCircuitEnd2 = NetCircuitEndFactory.createCircuitEnd(netCcatCircuit.getCircuitType(), iNetCircuitEnd2);
                iNetCircuitEnd2.setHoLoNum(netCcatCircuit.memberSecDropHoLo);
            }
            netCcatCircuit.addDrop(iNetCircuitEnd2, null);
        }
    }

    public synchronized void deleteDropForNewMemberCkts() throws CircuitDropOutstanding, ObjNotFound, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        this.operator.deleteDropForNewMemberCkts();
    }

    public synchronized void routeNewMemberCkts(RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        this.operator.routeNewMemberCkts(routePrefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provisionNewMemberCkts() throws NoRoute, ConnTypeUnsupported, SanityCheckFailed, CircuitProvError, AnnotatedException {
        NetVcatCircuit netVcatCircuit = this;
        synchronized (netVcatCircuit) {
            this.operator.provisionNewMemberCkts();
        }
        this.notifyChanged();
    }

    public boolean requireForceDeletion(INetCircuit[] iNetCircuitArray) {
        for (int i = 0; i < iNetCircuitArray.length; ++i) {
            if (!((NetCcatCircuit)iNetCircuitArray[i]).requireForceDeletion()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyMemberCkts(INetCircuit[] iNetCircuitArray) throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        NetVcatCircuit netVcatCircuit = this;
        synchronized (netVcatCircuit) {
            this.setCktOperation(7);
            int n = this.getNewMemberCount(iNetCircuitArray);
            this.deleteCircuits(iNetCircuitArray);
            if (this.dbgOn()) {
                db.println("delete old member circuits successful");
            }
            this.decreaseMemberCount(n);
            if (this.dbgOn()) {
                db.println("decrease member count successful");
            }
            this.setCktOperation(0);
            this.setChanged();
        }
        this.notifyChanged();
    }

    protected void increaseMemberCount(int n) throws CircuitProvError {
        String string = null;
        NetVcatTermination netVcatTermination2 = null;
        int n2 = 0;
        try {
            for (NetVcatTermination netVcatTermination2 : this.getAllVcatTerms()) {
                n2 = netVcatTermination2.getConfiguredNumOfMembers(2);
                netVcatTermination2.setConfiguredNumOfMembersOnNE(n2 + n, 2);
            }
        }
        catch (InvalidOperation invalidOperation) {
            if (string == null) {
                string = "The attempt to increase the member count on the node " + netVcatTermination2.getNodeName() + " failed.\n";
            }
            string = string + invalidOperation.getMessage();
        }
        catch (InvalidParms invalidParms) {
            if (string == null) {
                string = "The attempt to increase the member count on the node " + netVcatTermination2.getNodeName() + " failed.\n";
            }
            string = string + invalidParms.getMessage();
        }
        catch (ObjNotFound objNotFound) {
            if (string == null) {
                string = "The attempt to increase the member count on the node " + netVcatTermination2.getNodeName() + " failed.\n";
            }
            string = string + objNotFound.getMessage();
        }
        if (string != null) {
            for (NetVcatTermination netVcatTermination2 : this.getAllVcatTerms()) {
                netVcatTermination2.revertMemberCount();
            }
            if (this.dbgOn()) {
                db.println("revert member count successful");
            }
            throw new CircuitProvError(string);
        }
    }

    private int getNewMemberCount(INetCircuit[] iNetCircuitArray) {
        int n;
        NetVcatTermination netVcatTermination = null;
        NetCcatCircuit netCcatCircuit2 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (NetCcatCircuit netCcatCircuit2 : this.getAllMemberCircuits()) {
            if (netCcatCircuit2.hasNullCircuitId()) {
                ++n4;
                continue;
            }
            ++n3;
        }
        for (n = 0; n < iNetCircuitArray.length; ++n) {
            netCcatCircuit2 = (NetCcatCircuit)iNetCircuitArray[n];
            if (netCcatCircuit2.hasNullCircuitId()) {
                ++n6;
                continue;
            }
            ++n5;
        }
        if (this.dbgOn()) {
            db.println("Total number of CTC members  : " + n3);
            db.println("Deleted number of CTC members: " + n5);
            db.println("Total number of TL1 members  : " + n4);
            db.println("Deleted number of TL1 members: " + n5);
        }
        Iterator iterator = this.getAllVcatTerms().iterator();
        n = 0;
        while (iterator.hasNext()) {
            int n8;
            netVcatTermination = (NetVcatTermination)iterator.next();
            n2 = netVcatTermination.getConfiguredNumOfMembers(2);
            int n9 = n2 - n3;
            ++n;
            if (this.dbgOn()) {
                db.println("TL1 members on Term" + n + "     : " + n9);
            }
            if (n7 >= (n8 = n9 - n6)) continue;
            n7 = n8;
        }
        if (this.dbgOn()) {
            db.println("New number of TL1 members    : " + n7);
        }
        int n10 = n3 - n5 + n7;
        return n10;
    }

    private void decreaseMemberCount(int n) throws DeletionError {
        NetVcatTermination netVcatTermination2 = null;
        String string = null;
        for (NetVcatTermination netVcatTermination2 : this.getAllVcatTerms()) {
            try {
                netVcatTermination2.setConfiguredNumOfMembersOnNE(n, 2);
                netVcatTermination2.setConfiguredNumOfMembers(n, 2);
            }
            catch (InvalidOperation invalidOperation) {
                if (string == null) {
                    string = "The attempt to decrease the member count on the node " + netVcatTermination2.getNodeName() + " failed.\n";
                }
                string = string + invalidOperation.getMessage();
            }
            catch (InvalidParms invalidParms) {
                if (string == null) {
                    string = "The attempt to decrease the member count on the node " + netVcatTermination2.getNodeName() + " failed.\n";
                }
                string = string + invalidParms.getMessage();
            }
            catch (ObjNotFound objNotFound) {
                if (string == null) {
                    string = "The attempt to decrease the member count on the node " + netVcatTermination2.getNodeName() + " failed.\n";
                }
                string = string + objNotFound.getMessage();
            }
        }
        if (string != null) {
            throw new DeletionError(string);
        }
    }

    private List getExistingMemberCkts() {
        LinkedList<NetCcatCircuit> linkedList = new LinkedList<NetCcatCircuit>();
        for (NetCcatCircuit netCcatCircuit : this.getAllMemberCircuits()) {
            if (netCcatCircuit.getState() == 0) continue;
            linkedList.add(netCcatCircuit);
        }
        return linkedList;
    }

    protected List getNewMemberCkts() {
        LinkedList<NetCcatCircuit> linkedList = new LinkedList<NetCcatCircuit>();
        for (NetCcatCircuit netCcatCircuit : this.getAllMemberCircuits()) {
            if (netCcatCircuit.getState() != 0) continue;
            linkedList.add(netCcatCircuit);
        }
        return linkedList;
    }

    protected NetCcatCircuit getLongestRoutedMember() {
        NetCcatCircuit netCcatCircuit = null;
        int n = 0;
        for (NetCcatCircuit netCcatCircuit2 : this.getAllMemberCircuits()) {
            int n2 = netCcatCircuit2.getActiveCircuitSpans().size();
            if (n2 <= n) continue;
            netCcatCircuit = netCcatCircuit2;
            n = n2;
        }
        return netCcatCircuit;
    }

    @Override
    protected List getLinkEndpoints(INetLink iNetLink) {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(((NetCcatCircuit)iterator.next()).getLinkEndpoints(iNetLink));
        }
        return linkedList;
    }

    @Override
    protected boolean usesNetElement(INetElement iNetElement) {
        return this.doesCircuitUseNetElem(iNetElement) || this.doesCircuitUseVcatTerm(iNetElement) || this.hasSourceWithNetElement(iNetElement);
    }

    protected boolean doesCircuitUseVcatTerm(INetElement iNetElement) {
        Iterator iterator = this.getAllVcatTerms().iterator();
        while (iterator.hasNext()) {
            if (!((NetVcatTermination)iterator.next()).getNetElement().equals(iNetElement)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean doesCircuitUseConn(INetElement iNetElement, IConnectionModel iConnectionModel) {
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            if (!((NetCcatCircuit)iterator.next()).doesCircuitUseConn(iNetElement, iConnectionModel)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean doesCircuitUseNetElem(INetElement iNetElement) {
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            if (!((NetCcatCircuit)iterator.next()).doesCircuitUseNetElem(iNetElement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean doesCircuitUseNetLink(INetLink iNetLink) {
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            if (!((NetCcatCircuit)iterator.next()).doesCircuitUseNetLink(iNetLink)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List getCircuitNodes() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(((NetCcatCircuit)iterator.next()).getCircuitNodes());
        }
        return linkedList;
    }

    @Override
    public List getCircuitSpans() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(((NetCcatCircuit)iterator.next()).getCircuitSpans());
        }
        return linkedList;
    }

    @Override
    public INetVcatTermination getVcatTermFromCktEnd(INetCircuitEnd iNetCircuitEnd) {
        return this.forwardVcatGroup.getVcatTermFromCktEnd(iNetCircuitEnd);
    }

    protected NetCircuitEnd getNetCktEnd(INetElement iNetElement, int n) {
        for (NetCircuitEnd netCircuitEnd : this.getCktSources()) {
            if (netCircuitEnd.getNetElement() != iNetElement || netCircuitEnd.getEntityIndex() != n) continue;
            return netCircuitEnd;
        }
        Iterator iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd;
            netCircuitEnd = ((NetCircuitDropInfo)iterator.next()).getNetCktEnd();
            if (netCircuitEnd.getNetElement() != iNetElement || netCircuitEnd.getEntityIndex() != n) continue;
            return netCircuitEnd;
        }
        return null;
    }

    private boolean setSrcCircuitNode() {
        if (this.dbgOn()) {
            db.println("setSrcCircuitNode()");
        }
        if (this.getSourcesSize() == 0) {
            if (this.dbgOn()) {
                db.println("setSrcCircuitNode: source list is empty!");
            }
            return false;
        }
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.getPrimarySource();
        INetElement iNetElement = netCircuitEnd.getNetElement();
        if (iNetElement == null) {
            if (this.dbgOn()) {
                db.println("setSrcCircuitNode: Unable to find NE in the network");
            }
            return false;
        }
        this.srcNodeModel = iNetElement.getNodeModel();
        String string = this.getCircuitNameFromSrcNode();
        this.updateCircuitName(string);
        return true;
    }

    public int getPhysicalRoutingPref() {
        List list = this.getExistingMemberCkts();
        if (list.size() == 0) {
            return 1;
        }
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)list.get(0);
        List list2 = this.getRefCktLinkInfo(netCcatCircuit);
        for (NetCcatCircuit netCcatCircuit2 : list) {
            if (netCcatCircuit2 == netCcatCircuit || this.shareCommonFiber(netCcatCircuit2, list2)) continue;
            return 2;
        }
        return 1;
    }

    protected void setSource(NetCircuitEnd netCircuitEnd) {
        this.insertSource(netCircuitEnd);
        INetElement iNetElement = null;
        try {
            iNetElement = netCircuitEnd.getNetElement();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("i/o exception in NetVcatCircuit/findNetElem");
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            iNetElement = null;
        }
        if (iNetElement == null) {
            if (this.dbgOn()) {
                db.println("Warning: unable to find Net Element in NetVcatCircuit()");
            }
            return;
        }
        this.srcNodeModel = iNetElement.getNodeModel();
    }

    @Override
    public boolean isOpenEndedVcatCircuit() {
        int n = this.forwardVcatGroup.getVcatTermsSize();
        if (this.isOVcat() && this.getState() == 0) {
            return true;
        }
        if ((this.getState() == 4 || this.getState() == 6) && (n == 1 || n == 2 && NetCircuit.isBackHaulVcatCircuit(this))) {
            return true;
        }
        return (this.getState() == 1 || this.getState() == 5) && (n == 1 || n == 2 && NetCircuit.isBackHaulVcatCircuit(this));
    }

    @Override
    public boolean isSplitRoutingAllowed() {
        INetCircuitEnd iNetCircuitEnd = this.getPrimarySource();
        INetCircuitEnd iNetCircuitEnd2 = this.getPrimaryDrop();
        if (this.isOpenEndedVcatCircuit()) {
            return this.supportsSplitRouting(iNetCircuitEnd) || this.supportsSplitRouting(iNetCircuitEnd2);
        }
        return this.supportsSplitRouting(iNetCircuitEnd) && this.supportsSplitRouting(iNetCircuitEnd2);
    }

    private boolean supportsSplitRouting(INetCircuitEnd iNetCircuitEnd) {
        INodeModel iNodeModel;
        boolean bl = false;
        IEntityModel iEntityModel = null;
        if (iNetCircuitEnd != null) {
            try {
                iEntityModel = iNetCircuitEnd.getEntityModel();
            }
            catch (ObjNotFound objNotFound) {
                iEntityModel = null;
            }
        }
        if (iEntityModel != null && iEntityModel instanceof IPortModel && (iNodeModel = iNetCircuitEnd.getNodeModel()) != null && iNodeModel.provides(Feature.VCAT_LCAS)) {
            bl = ((IPortModel)iEntityModel).supportsSplitRouting();
        }
        return bl;
    }

    public boolean isSplitRoutingEnabled() {
        Object object;
        if (!this.isSplitRoutingAllowed()) {
            return false;
        }
        boolean bl = false;
        try {
            IEntityModel iEntityModel = this.getPrimarySource().getEntityModel();
            bl = iEntityModel.getEqType() == 144;
        }
        catch (Exception exception) {
            bl = false;
        }
        boolean bl2 = false;
        try {
            object = this.getPrimaryDrop().getEntityModel();
            bl2 = object.getEqType() == 144;
        }
        catch (Exception exception) {
            bl2 = false;
        }
        if (!bl && !bl2) {
            return true;
        }
        object = (NetVcatTermination)this.getVcatTermFromCktEnd(this.getPrimarySource());
        NetVcatTermination netVcatTermination = (NetVcatTermination)this.getVcatTermFromCktEnd(this.getPrimaryDrop());
        if (this.isOpenEndedVcatCircuit()) {
            if (object != null) {
                if (!bl) {
                    return true;
                }
                return ((NetVcatTermination)object).getExtBuffer();
            }
            if (netVcatTermination != null) {
                if (!bl2) {
                    return true;
                }
                return netVcatTermination.getExtBuffer();
            }
        } else if (object != null && netVcatTermination != null) {
            if (bl && !bl2) {
                return ((NetVcatTermination)object).getExtBuffer();
            }
            if (!bl && bl2) {
                return netVcatTermination.getExtBuffer();
            }
            return ((NetVcatTermination)object).getExtBuffer() && netVcatTermination.getExtBuffer();
        }
        return false;
    }

    @Override
    public void setUpsrSelectorAttributes(IRevertiveBehavior iRevertiveBehavior, short s, short s2, boolean bl) {
        Iterator iterator = this.getNewMemberCkts().iterator();
        while (iterator.hasNext()) {
            ((NetCcatCircuit)iterator.next()).setUpsrSelectorAttributes(iRevertiveBehavior, s, s2, bl);
        }
    }

    @Override
    public IHoUpsrAttributes getUpsrAttributes() {
        List list = this.getExistingMemberCkts();
        if (list.size() == 0) {
            return null;
        }
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)list.get(0);
        return netCcatCircuit.getUpsrAttributes();
    }

    public void setExtBuffer(boolean bl) {
        Iterator iterator = this.getAllVcatTerms().iterator();
        while (iterator.hasNext()) {
            ((NetVcatTermination)iterator.next()).setExtBuffer(bl);
        }
    }

    protected boolean isCommonFiberRouted(NetCcatCircuit netCcatCircuit, List list) {
        for (NetCcatCircuit netCcatCircuit2 : this.getExistingMemberCkts()) {
            if (netCcatCircuit2 == netCcatCircuit || this.shareCommonFiber(netCcatCircuit2, list)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int deriveServiceState() {
        if (this.dbgOn()) {
            this.debug("deriveServiceState(" + this.getCircuitName() + ", " + NetVcatCircuit.prettyString(this.circuitId) + ")");
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = false;
        int n = 0;
        NetVcatCircuit netVcatCircuit = this;
        synchronized (netVcatCircuit) {
            if (this.getState() == 4 || this.getState() == 6) {
                return -1;
            }
            for (NetCcatCircuit netCcatCircuit : this.getAllMemberCircuits()) {
                int n2 = netCcatCircuit.getServiceState();
                if (n2 == -1) {
                    bl = false;
                    continue;
                }
                ++n;
                if (n2 != 0) {
                    bl = false;
                }
                if (n2 == 1 || n2 == 2) {
                    bl3 = false;
                    bl4 = false;
                }
                if (n2 != 5 && n2 != 6) continue;
                bl5 = true;
            }
        }
        if (n == 0) {
            return -1;
        }
        if (bl) {
            return 0;
        }
        if (bl3) {
            return 5;
        }
        if (bl4) {
            return 6;
        }
        if (bl2) {
            if (NetworkModel.instance().getCmsHostModel().getTdmProtocolTypeObj().isSdh() && bl5) {
                return 2;
            }
            return 1;
        }
        return 2;
    }

    @Override
    protected String getCircuitNameFromSrcNode() {
        String string = "";
        NetVcatTermination netVcatTermination = (NetVcatTermination)this.getVcatTermFromCktEnd(this.getPrimarySource());
        if (netVcatTermination != null && netVcatTermination.getNodeModel().provides(Feature.TCCU)) {
            string = netVcatTermination.getVcatName();
        }
        if (string.equals("")) {
            if (this.circuitInfoActive() && this.circuitModel != null) {
                try {
                    string = this.circuitModel.getName();
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    string = this.getCircuitName();
                    return string;
                }
            } else {
                string = "Unknown";
            }
        }
        if (this.dbgOn()) {
            this.debug("getCircuitNameFromSrcNode() returns \"" + string + "\"");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean unify(NetVcatCircuit netVcatCircuit) {
        NetVcatCircuit netVcatCircuit2 = netVcatCircuit;
        synchronized (netVcatCircuit2) {
            if (this.dbgOn()) {
                db.println("Unify two VCAT circuits");
            }
            if (!(NetVcatCircuit.isNullCircuitId(this.circuitId) || NetVcatCircuit.isNullCircuitId(netVcatCircuit.circuitId) || this.circuitId.equals(netVcatCircuit.circuitId))) {
                if (this.dbgOn()) {
                    db.println("Cannot Unify two circuits with different circuit Ids");
                }
                return false;
            }
            for (NetVcatTermination netVcatTermination : netVcatCircuit.getAllVcatTerms()) {
                netVcatTermination.setVcatCircuit(this);
            }
            for (NetCcatCircuit netCcatCircuit : netVcatCircuit.getAllMemberCircuits()) {
                netCcatCircuit.setVcatGroup(this.forwardVcatGroup);
            }
            for (NetVcatTermination netVcatTermination : netVcatCircuit.getAllVcatTerms()) {
                this.forwardVcatGroup.insertVcatTermination(netVcatTermination);
            }
            for (NetCcatCircuit netCcatCircuit : netVcatCircuit.getAllMemberCircuits()) {
                this.forwardVcatGroup.insertMemberCircuit(netCcatCircuit);
            }
            netVcatCircuit.forwardVcatGroup.finalDispose();
            netVcatCircuit.finalDispose();
        }
        return true;
    }

    @Override
    protected boolean circuitInfoActive() {
        return this.circuitInfoActive;
    }

    public boolean inRoll() {
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            if (!((NetCcatCircuit)iterator.next()).inRoll()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void runChildUpdate() {
        Iterator iterator = this.getAllVcatTerms().iterator();
        while (iterator.hasNext()) {
            try {
                ((NetVcatTermination)iterator.next()).runUpdate();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                db.println("AbstractCmsIOException during vcat term update");
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
    }

    @Override
    protected void notifyChanged() {
        Iterator iterator = this.ccat2VcatList.iterator();
        while (iterator.hasNext()) {
            ((NetCcatCircuit)iterator.next()).notifyChanged(false);
        }
        this.ccat2VcatList.clear();
        iterator = this.vcat2CcatList.iterator();
        while (iterator.hasNext()) {
            this.ncMgr.notifyChanged((NetCcatCircuit)iterator.next());
        }
        this.vcat2CcatList.clear();
        if (!this.isCircuitRefValid()) {
            return;
        }
        if (this.hasChanged()) {
            if (this.dbgOn()) {
                this.debug("notifyChanged(" + this.getCircuitName() + ", " + NetVcatCircuit.prettyString(this.circuitId) + ")");
            }
            int n = this.serviceState;
            this.serviceState = this.deriveServiceState();
            if (this.serviceState != n && this.dbgOn()) {
                this.debug("notifyChanged(): serviceState changed from " + this.translateServiceState(n) + " to " + this.translateServiceState(this.serviceState));
            }
            this.setProtType();
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    @Override
    protected void notifyDeleted() {
        if (this.dbgOn()) {
            this.debug("notifyDeleted(" + this.getCircuitName() + ", " + NetVcatCircuit.prettyString(this.circuitId) + ")");
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.DELETED);
    }

    public int getMemberCktType() {
        int n = this.getCircuitType();
        if (n == 10) {
            return 1;
        }
        if (n == 12) {
            return 4;
        }
        if (n == 11) {
            return 2;
        }
        if (n == 13) {
            return 5;
        }
        return CircuitType.UNDEFINED_TYPE;
    }

    @Override
    protected void printChild(SDebug sDebug) {
        if (!sDebug.on()) {
            return;
        }
        sDebug.println("");
        sDebug.println("Vcat Termination(s) :");
        for (NetVcatTermination netVcatTermination : this.getAllVcatTerms()) {
            netVcatTermination.prettyPrint(sDebug);
            sDebug.println("");
        }
        sDebug.println("");
        sDebug.println("Member Circuit(s) :");
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            sDebug.println("~~~~~~~~~~~~~~~~");
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iterator.next();
            netCcatCircuit.prettyPrint(sDebug);
        }
    }

    @Override
    protected void printDeconstructedConnections(SDebug sDebug) {
        if (!sDebug.on()) {
            return;
        }
        sDebug.println("");
        sDebug.println("Vcat Termination(s) :");
        for (NetVcatTermination netVcatTermination : this.getAllVcatTerms()) {
            netVcatTermination.prettyPrint(sDebug);
            sDebug.println("");
        }
        sDebug.println("");
        sDebug.println("Vcat Member Circuit(s) :");
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            sDebug.println("~~~~~~~~~~~~~~~~~~~~~~~~");
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iterator.next();
            netCcatCircuit.printDeconstructedConnections(sDebug);
        }
    }

    @Override
    public void addNetElement(INetElement iNetElement, RoutePrefs routePrefs) throws IncorrectCircuitState {
    }

    @Override
    public void deleteNetElement(INetElement iNetElement) throws ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, DeletionError, SanityCheckFailed {
    }

    @Override
    public void routeNetElement(INetElement iNetElement, RoutePrefs routePrefs) throws SanityCheckFailed, IncorrectCircuitState, CTCUserException, AbstractCmsIOException {
    }

    @Override
    public void routeNetElement(INetElement iNetElement, INetElement iNetElement2, RoutePrefs routePrefs) throws SanityCheckFailed, IncorrectCircuitState, CTCUserException, AbstractCmsIOException {
    }

    @Override
    public boolean isVlanCapable() throws IncorrectCircuitState {
        return false;
    }

    @Override
    public boolean mustDisableStp() throws IncorrectCircuitState {
        return false;
    }

    @Override
    public IVlanModel[] getVlans() {
        return new IVlanModel[0];
    }

    @Override
    public NetVlanInfo[] getNetVlans() {
        return new NetVlanInfo[0];
    }

    @Override
    public void assignVlanSet(IVlanModel[] iVlanModelArray) throws IncorrectCircuitState, SanityCheckFailed {
    }

    @Override
    public void assignVlanSet(NetVlanInfo[] netVlanInfoArray) throws IncorrectCircuitState, SanityCheckFailed {
    }

    @Override
    public void createWithStpEnabled(boolean bl) {
    }

    @Override
    public boolean isStpEnabled() {
        return false;
    }

    @Override
    public INetLink getLotLink() {
        return null;
    }

    @Override
    public INetLink getReverseLotLink() {
        return null;
    }

    @Override
    public INetLink getLapLink() {
        return null;
    }

    @Override
    public INetLink getReverseLapLink() {
        return null;
    }

    @Override
    public List getXmCircuitEnds() {
        return new LinkedList();
    }

    @Override
    public void setXmCircuitEnds(INetCircuitEnd[] iNetCircuitEndArray) {
    }

    @Override
    public void setXmCircuitEnds(IEntityModel[] iEntityModelArray) {
    }

    @Override
    public INetCircuit useLAP() {
        return null;
    }

    @Override
    public List getLoTunnelNodes() {
        return new LinkedList();
    }

    @Override
    public ILoNum getLoOverHo() {
        return null;
    }

    @Override
    public List getCircuitNodeFromNE(INetElement iNetElement) {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            List list = ((NetCcatCircuit)iterator.next()).getCircuitNodeFromNE(iNetElement);
            if (list == null) continue;
            linkedList.addAll(list);
        }
        return linkedList;
    }

    @Override
    public NetCircuitNode getCircuitNodeFromCktEnd(INetCircuitEnd iNetCircuitEnd) {
        NetCircuitNode netCircuitNode = null;
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext() && (netCircuitNode = ((NetCcatCircuit)iterator.next()).getCircuitNodeFromCktEnd(iNetCircuitEnd)) == null) {
        }
        return netCircuitNode;
    }

    @Override
    public INetCircuitSpan getCircuitSpanFromNetLink(INetLink iNetLink) {
        return null;
    }

    @Override
    public void addCircuitSpan(INetLinkSpan iNetLinkSpan) {
    }

    @Override
    public void deleteCircuitSpan(INetLinkSpan iNetLinkSpan) {
    }

    @Override
    public LinkedList getRequiredSpans() {
        return new LinkedList();
    }

    @Override
    public List getActiveCircuitSpans() {
        return new LinkedList();
    }

    @Override
    public List getRoutedCircuitSpans() {
        return new LinkedList();
    }

    @Override
    public INetCircuitNode getSrcCircuitNode() {
        return null;
    }

    @Override
    public int getCircuitSpanNum() {
        List list;
        if (this.getPhysicalRoutingPref() == 1 && !(list = this.getExistingMemberCkts()).isEmpty()) {
            return ((NetCcatCircuit)list.get(0)).getCircuitSpanNum();
        }
        return -1;
    }

    @Override
    public boolean isMemberOfVcat() {
        return false;
    }

    @Override
    public void setMemberPrefs(MemberPrefs memberPrefs) {
    }

    @Override
    public int getMemberNumber() {
        return -1;
    }

    @Override
    public void setMemberNumber(int n) {
    }

    @Override
    public int getMemberStatus(INetCircuitEnd iNetCircuitEnd) {
        return -1;
    }

    @Override
    public void setMemberStatus(INetCircuitEnd iNetCircuitEnd, int n) throws CTCUserException {
    }

    @Override
    public String getFullCircuitName() {
        return null;
    }

    @Override
    protected NetCircuitOperator getOperator() {
        return this.operator;
    }

    @Override
    public boolean isMemberInGroup() {
        return false;
    }

    @Override
    public boolean isUpsr1wayTl1() {
        return false;
    }

    @Override
    public boolean useLink(INetLink iNetLink) {
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            if (!((NetCcatCircuit)iterator.next()).useLink(iNetLink)) continue;
            return true;
        }
        return false;
    }

    public int[] memberDeleteCheck(INetCircuit[] iNetCircuitArray) {
        int[] nArray = null;
        int[] nArray2 = new int[iNetCircuitArray.length];
        int n = 0;
        int n2 = 0;
        if (this.dbgOn()) {
            this.debug("DEL: deleteCheck entered......");
        }
        for (n2 = 0; n2 < iNetCircuitArray.length; ++n2) {
            try {
                iNetCircuitArray[n2].circuitDeleteCheck();
                continue;
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                if (db.on()) {
                    db.println("Incorrect Circuit State");
                }
                nArray2[n++] = n2;
            }
        }
        if (n > 0) {
            nArray = new int[n];
            if (this.dbgOn()) {
                this.debug("DEL: invalid count is " + n);
            }
            for (n2 = 0; n2 < n; ++n2) {
                nArray[n2] = nArray2[n2];
                if (!this.dbgOn()) continue;
                this.debug("DEL: invalid index " + nArray[n2]);
            }
        }
        return nArray;
    }

    public IHoLoNum[] getDropAutoSelectVcatPaths(INodeModel iNodeModel, IEntityModel iEntityModel, IHoLoNum[] iHoLoNumArray, int n) throws ProvisionError {
        IHoLoNum[] iHoLoNumArray2 = new IHoLoNum[]{};
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.getCktSources().iterator().next();
        IEntityModel iEntityModel2 = null;
        if (netCircuitEnd == null) {
            return new IHoLoNum[0];
        }
        try {
            iEntityModel2 = netCircuitEnd.getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            SDebug.printStackTrace((Throwable)objNotFound);
        }
        if (iEntityModel2 == null) {
            return new IHoLoNum[0];
        }
        if (iEntityModel2.getModuleModel() == iEntityModel.getModuleModel() && Endpoints.isCe2Port(iEntityModel)) {
            iHoLoNumArray2 = iHoLoNumArray;
        }
        Endpoints endpoints = Endpoints.instance();
        return endpoints.getAutoSelectVcatPaths(iNodeModel, iEntityModel, this.getCircuitType(), this.getCircuitSize(), n, iHoLoNumArray2);
    }

    @Override
    public synchronized void addOpenVcatDrops(INetCircuitEnd[] iNetCircuitEndArray, RoutePrefs routePrefs) throws AllocFailed, CircuitDropOutstanding, ObjNotFound, SanityCheckFailed, IncorrectCircuitState {
        this.operator.addOpenVcatDrops(iNetCircuitEndArray, routePrefs);
    }

    @Override
    public void deleteOpenVcatDrops(INetCircuitEnd[] iNetCircuitEndArray) throws CircuitDropOutstanding, CannotDeleteLastDrop, ObjNotFound, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
        this.operator.deleteOpenVcatDrops(iNetCircuitEndArray);
    }

    public synchronized void addDropforNewMemberCkts(INetCircuitEnd[] iNetCircuitEndArray) throws AllocFailed, CircuitDropOutstanding, ObjNotFound, SanityCheckFailed, IncorrectCircuitState {
        List list = this.forwardVcatGroup.getMemCkts();
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (iNetCircuitEndArray[n] == null) {
                ++n;
                iterator.next();
                continue;
            }
            ((NetCcatCircuit)iterator.next()).addDrop(iNetCircuitEndArray[n++], null);
        }
    }

    public synchronized void deleteDropForNewMemberCkts(INetCircuitEnd[] iNetCircuitEndArray) throws CircuitDropOutstanding, ObjNotFound, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        this.operator.deleteDropForNewMemberCkts(iNetCircuitEndArray);
    }

    public boolean isOVcat() {
        return this.oVcat;
    }

    public void setOVcat(boolean bl) {
        this.oVcat = bl;
    }

    public synchronized void routeNewMemberCkts(INetCircuitEnd[] iNetCircuitEndArray, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        this.operator.routeNewMemberCkts(iNetCircuitEndArray, routePrefs);
    }

    public synchronized void routeNewMemberCkts(INetCircuitEnd[] iNetCircuitEndArray, INetCircuitEnd[] iNetCircuitEndArray2, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        this.operator.routeNewMemberCkts(iNetCircuitEndArray, iNetCircuitEndArray2, routePrefs);
    }

    @Override
    public List getOpenVcatDrops() {
        LinkedList linkedList = null;
        if (this.isOpenEndedVcatCircuit()) {
            linkedList = new LinkedList();
            List list = this.getAllMemberCircuits();
            for (INetCircuit iNetCircuit : list) {
                linkedList.addAll(iNetCircuit.getDrops());
            }
        }
        return linkedList;
    }

    @Override
    public List getTimeSlotViolations() {
        return this.tsViolations;
    }
}

