/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitId;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.OchncCircuitEnd;
import cerent.cms.ncp.OchncCircuitNodeOperator;
import cerent.cms.ncp.OchncCircuitSpan;
import cerent.cms.ncp.SpliceLinkIndex;
import cerent.cms.ncp.SpliceListener;
import cerent.cms.ncp.SpliceListenerEntry;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.topo.INetElement;
import cerent.util.SDebug;
import java.util.LinkedList;
import java.util.List;

public class OchncCircuitNode
extends NetCircuitNode {
    private static final SDebug db = new SDebug("OchncCircuitNode");
    private IOchncConnectionModel ochncConn;
    protected OchncCircuitNodeOperator operator;
    private boolean isDCNNode = false;

    public OchncCircuitNode(INetElement iNetElement, OchncCircuit ochncCircuit) {
        super(iNetElement, ochncCircuit);
        this.connName = ochncCircuit.getCircuitName();
        this.cktId = new CircuitId(0, 0);
        this.serviceState = -2;
        this.pathWidth = (short)ochncCircuit.getCircuitSize();
        this.operator = new OchncCircuitNodeOperator(this);
    }

    public OchncCircuitNode(INetElement iNetElement, OchncCircuit ochncCircuit, Object object) {
        super(iNetElement, ochncCircuit, object);
        this.ne = iNetElement;
        this.connName = this.getConnNameFromNE();
        ochncCircuit.setChanged();
        this.pathWidth = (short)ochncCircuit.getCircuitSize();
        this.operator = new OchncCircuitNodeOperator(this);
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (iNodeModel.provides(Feature.OCHNC_DCN_CIRCUIT)) {
            IOchncConnectionModel iOchncConnectionModel = (IOchncConnectionModel)object;
            this.isDCNNode = iOchncConnectionModel.isDcnConnection();
        }
    }

    @Override
    protected void setAdminState(int n) {
        if (n == 0) {
            n = 3;
        }
        super.setAdminState(n);
    }

    @Override
    protected void sanityCheckConnModel() {
        this.getConnTypeFromConnModel();
    }

    @Override
    protected int getConnTypeFromConnModel() {
        IOchncConnectionModel iOchncConnectionModel = this.ochncConn;
        if (iOchncConnectionModel != null) {
            return iOchncConnectionModel.getConnectionType();
        }
        return 22;
    }

    @Override
    protected Object[] getPathsFromConnModel() {
        IOchncConnectionModel iOchncConnectionModel = this.ochncConn;
        if (iOchncConnectionModel != null) {
            return iOchncConnectionModel.getPaths();
        }
        if (this.dbgOn()) {
            db.println("getPathsFromConnModel @ Node " + this.getName() + " with connection object deleted");
        }
        return new LinkedList().toArray();
    }

    @Override
    public int totalSpans() {
        return this.inSpans.size() + this.outSpans.size() + this.biSpans.size();
    }

    @Override
    protected int findConnType() {
        if (this.circuit.getCircuitDir() == 1) {
            return this.inSpans.size() + this.sources.size() > 2 && this.outSpans.size() + this.drops.size() > 2 ? 20 : 12;
        }
        return 0;
    }

    @Override
    public void setConnectionCircuitId(ICircuitId iCircuitId) {
        if (this.dbgOn()) {
            db.println("setting the connection circuit Id at " + this.getName() + " to " + NetCircuit.prettyString(iCircuitId));
        }
        ICircuitId iCircuitId2 = this.getConnectionCircuitId();
        if (this.ochncConn != null) {
            this.ochncConn.setCircuitId(iCircuitId);
            this.cktId = iCircuitId;
            if (iCircuitId2 == null || iCircuitId2.getNodeId() == 0 && iCircuitId2.getUniquePart().getUniqueId() == 0) {
                this.deregisterNullCircuitConnection(this.getNetElement(), this.ochncConn);
            }
        }
    }

    @Override
    public NetCircuitEnd getSpanEndpoint(NetCircuitSpan netCircuitSpan) {
        CircuitEnd circuitEnd = new CircuitEnd();
        circuitEnd.setNodeId(this.ne.getNodeId());
        if (netCircuitSpan.isInternalSpan()) {
            circuitEnd.setPortNum(netCircuitSpan.getInternalEntityIndex(this));
        } else {
            circuitEnd.setPortNum(netCircuitSpan.getEntityIndex(this.ne));
        }
        circuitEnd.setDropProt(false);
        return new OchncCircuitEnd(this.ne.getNodeModel(), circuitEnd, ((OchncCircuitSpan)netCircuitSpan).getOptChannel());
    }

    @Override
    protected void activate() throws CircuitProvError {
        super.activate();
        this.numberOfPaths = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans() + (this.isDstCoLocatedCktNode() || this.isSrcCoLocatedCktNode() ? 2 : 0);
    }

    @Override
    public ICircuitId getConnectionCircuitId() {
        if (this.ochncConn != null) {
            return this.ochncConn.getCircuitId();
        }
        if (this.dbgOn()) {
            db.println("getConnectionCircuitId @ Node " + this.getName() + " with connection object deleted");
        }
        return null;
    }

    @Override
    protected boolean isSrcCoLocatedCktNode() {
        return !this.circuit.getSrcInternalSpliceLinkEnds().isEmpty() && ((NetCircuitEnd)this.circuit.getSrcInternalSpliceLinkEnds().get(0)).getNodeId() == this.getNodeModel().getNodeId();
    }

    @Override
    protected boolean isDstCoLocatedCktNode() {
        return !this.circuit.getDstInternalSpliceLinkEnds().isEmpty() && ((NetCircuitEnd)this.circuit.getDstInternalSpliceLinkEnds().get(0)).getNodeId() == this.getNodeModel().getNodeId();
    }

    @Override
    protected List getSrcCoLocatedCktEnds() {
        LinkedList linkedList = new LinkedList();
        if (!this.circuit.getSrcInternalSpliceLinkEnds().isEmpty()) {
            linkedList.add(this.circuit.getSrcInternalSpliceLinkEnds().get(1));
            linkedList.add(this.circuit.getSrcInternalSpliceLinkEnds().get(2));
        }
        return linkedList;
    }

    @Override
    protected List getDstCoLocatedCktEnds() {
        LinkedList linkedList = new LinkedList();
        if (!this.circuit.getDstInternalSpliceLinkEnds().isEmpty()) {
            linkedList.add(this.circuit.getDstInternalSpliceLinkEnds().get(1));
            linkedList.add(this.circuit.getDstInternalSpliceLinkEnds().get(2));
        }
        return linkedList;
    }

    @Override
    protected void setupConnListOnDiscovery() {
        this.connections = new LinkedList();
    }

    @Override
    public IConnectionModel getConn() {
        return this.ochncConn;
    }

    @Override
    protected void setConn(IConnectionModel iConnectionModel) {
        this.ochncConn = (IOchncConnectionModel)iConnectionModel;
    }

    @Override
    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    @Override
    protected void debug(String string) {
        db.println(string);
    }

    @Override
    protected Object[] getActivePathsFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchncCircuitNode -> getActivePathsFromConnModel @ Node " + this.getName());
        }
        return null;
    }

    @Override
    protected int getProtectionOpFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchncCircuitNode -> getProtectionOpFromConnModel @ Node " + this.getName());
        }
        return -1;
    }

    public boolean isDCNNode() {
        return this.isDCNNode;
    }

    @Override
    public boolean isOchncCircuitNode() {
        return true;
    }

    public void setIsDCNNode(boolean bl) {
        this.isDCNNode = bl;
    }

    public boolean isSplitterProtectionNode() {
        return this.getConnectionType() == 20;
    }

    @Override
    protected int getReverseProtectionOpFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchncCircuitNode -> getReverseProtectionOpFromConnModel @ Node " + this.getName());
        }
        return -1;
    }

    @Override
    protected NetCircuitNodeOperator getOperator() {
        return this.operator;
    }

    @Override
    protected boolean completeCheck() {
        int n;
        block4: {
            this.numberOfPaths = this.countNumInputs() + this.countNumOutputs();
            n = 0;
            try {
                n += this.getPathsFromConnModel().length;
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (!this.dbgOn()) break block4;
                db.println("cmpleteCheck: node may have been deleted");
            }
        }
        if (n == this.numberOfPaths) {
            if (this.dbgOn()) {
                db.println("completeCheck passed");
            }
            return true;
        }
        return false;
    }

    @Override
    protected void addSpliceListener(SpliceListenerEntry spliceListenerEntry) {
        INodeModel iNodeModel;
        ICircuitId iCircuitId;
        super.addSpliceListener(spliceListenerEntry);
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (this.dbgOn()) {
            this.debug("Ochnc addSpliceListener(" + spliceListenerEntry.prettyString() + ") at " + this.getName());
        }
        if ((iCircuitId = this.getConnectionCircuitId()) == null) {
            iCircuitId = this.cktId;
        }
        int n = spliceListenerEntry.spliceLinkIndex.entityIndex;
        if (iCircuitId.getUniquePart().getUniqueId() == 0 && OchPortsHelper.isOchPort(iNodeModel = this.getNetElement().getNodeModel(), n) && Feature.provides((INodeModel)iNodeModel, (Feature)Feature.OTU2_XP)) {
            IEntityModel iEntityModel;
            block11: {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                iEntityModel = null;
                try {
                    if (iEntityTableModel != null) {
                        iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block11;
                    db.println("getTunnelEntityIndex: Exception " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
            IEntityModel iEntityModel2 = null;
            if (iEntityModel != null) {
                iEntityModel2 = OchTrailHelper.getColocatedTrunkPort(iEntityModel, spliceListenerEntry.spliceListener.optChannel);
            }
            if (iEntityModel2 != null && iEntityModel2.getModuleModel().getEqType() == 293 && ((IDwdmPortModel)iEntityModel2).getRegenPeerLineModel() != null) {
                int n2 = ((IDwdmPortModel)iEntityModel2).getOptChannel();
                SpliceListener spliceListener = new SpliceListener(null, null, n2, this, true);
                SpliceLinkIndex spliceLinkIndex = new SpliceLinkIndex(spliceListenerEntry.spliceLinkIndex.ne, iEntityModel2.getEntityIndex(), eSpanDirection.ORIGINATING);
                SpliceListenerEntry spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex, spliceListener);
                if (!this.isListenerPresent(spliceListenerEntry2)) {
                    this.addAditListener(spliceListenerEntry2);
                }
                if (!this.isListenerPresent(spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex = new SpliceLinkIndex(spliceListenerEntry.spliceLinkIndex.ne, iEntityModel2.getEntityIndex(), eSpanDirection.TERMINATING), spliceListener))) {
                    this.addAditListener(spliceListenerEntry2);
                }
                if (db.on()) {
                    this.debug("Added 2 listeners for Catinaccio regen: ORIG, TERM");
                }
            }
        }
    }

    private boolean isListenerPresent(SpliceListenerEntry spliceListenerEntry) {
        SpliceListenerEntry spliceListenerEntry22 = null;
        for (SpliceListenerEntry spliceListenerEntry22 : this.spliceListeners) {
            if (spliceListenerEntry.spliceListener.node.ne != spliceListenerEntry22.spliceListener.node.ne || spliceListenerEntry.spliceListener.optChannel != spliceListenerEntry22.spliceListener.optChannel || spliceListenerEntry.spliceLinkIndex.entityIndex != spliceListenerEntry22.spliceLinkIndex.entityIndex || spliceListenerEntry.spliceLinkIndex.direction != spliceListenerEntry22.spliceLinkIndex.direction) continue;
            return true;
        }
        return false;
    }
}

